GET "libhdr"
GET "plotflow.h"

/*
y09  x01
y08               Old stack frame                New stack frame
y07         /-----------^------------\/-------------------^-------------------\
y06       x02--------x04-----x05 ----x07=========-x09-x11-x13 --x14---x16-x18-x20
y05        |          |        \ \    |            | E1| E2|      \ \  | En| E |
y04         x03-----------------x06----x08----------x10-x12--------x15 -x17-x19 x21    x22
             ^                          ^                                        ^
y03          |<------------------------>|                                        |
             |                  k     New P                                      |
y02          |<----------------------------------------------------------------->|
             |                               S 
y01          P
y00
*/

MANIFEST {
  y00 = 10            // bottome edge
  y01 = y00+40        // P
  y02 = y01+60        //   |<--------------S--------->|
  y03 = y02+60        //   |<------k---->|
  y04 = y03+60        // Low edge of the stack
  y05 = y04+cellH/2   // E1  E2  En  E
  y06 = y04+cellH     // Upper edge of the stack
  y07 = y06+15        // Curly brackets
  y08 = y07+40        // Old stack frame        New stack frame
  y09 = y08+40        // Top edge
  
  x00 = 10            // Left edge
  x01 = x00+20        // 
  x02 = x01+20        // Left end of cells
  x03 = x02+cellW/2   // P arrow
  x04 = x03+120
  x05 = x04+70
  x06 = x05+zigzagW
  x07 = x06+40
  x08 = x07+cellW/2
  x09 = x08+70
  x10 = x09+cellW/2
  x11 = x09+cellW
  x12 = x11+cellW/2
  x13 = x11+cellW
  x14 = x13+60
  x15 = x14+zigzagW
  x16 = x15+40
  x17 = x16+cellW/2
  x18 = x16+cellW
  x19 = x18+cellW/2
  x20 = x18+cellW
  x21 = x20+cellW/2
  x22 = x21+40

  width  = x22+3 & -4
  height = y09
}


LET drawdiagram() BE
{
  drawstrcentred((x02+x07)/2, y08, "Old stack frame")
  drawstrcentred((x07+x20)/2, y08, "New stack frame")

  drawcurlyH(x02, y07, x07-x02, 20)
  drawcurlyH(x07, y07, x20-x07, 20)

  moveto(x02, y06); drawto(x05, y06)
  moveto(x06, y06); drawto(x14, y06)
  moveto(x15, y06); drawto(x20, y06)

  
  drawstrcentred(x10, y05, "E1")
  drawstrcentred(x12, y05, "E2")
  drawstrcentred(x17, y05, "En")
  drawstrcentred(x19, y05, "E")
  
  moveto(x02, y04); drawto(x05, y04)
  moveto(x06, y04); drawto(x14, y04)
  moveto(x15, y04); drawto(x20, y04)
  strut(x02,  y04)
  strut(x04,  y04)
  zigzag(x05, y04)
  zigzag(x06, y04)
  strut(x07,  y04)
  strut(x09,  y04)
  strut(x11,  y04)
  strut(x13,  y04)
  zigzag(x14, y04)
  zigzag(x15, y04)
  strut(x16,  y04)
  strut(x18,  y04)
  strut(x20,  y04)
  drawarrow(1, x03, y04-10, 15)
  moveto(x03, y04-15); drawto(x03, y01+15)
  drawarrow(1, x08, y04-15, 15)
  moveto(x08, y04-15); drawto(x08, y03)
  drawarrow(1, x21, y04-15, 15)
  moveto(x21, y04-15); drawto(x21, y02+11)

  drawarrow(2, x03+15, y03, 15)
  moveto(x03+15, y03); drawto(x08-15, y03)
  drawstrcentred((x03+x08)/2, y03-20, "k")
  drawstrcentred( x08,        y03-20, "New P")
  drawarrow(0, x08-15, y03, 15)

  drawarrow(2, x03+15, y02, 15)
  moveto(x03+15, y02); drawto(x21-15, y02)
  drawstrcentred((x03+x21)/2, y02-20, "S")
  drawarrow(0, x21-15, y02, 15)

  drawstrcentred(x03, y01, "P")

}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

