/*
This the program that generates th bmp image of figure f3hamming.
It is converted to .png format using ffmpeg.
*/

GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b" 

// fonts used in this diagram are assumed to be 24x16 and 18x12

//           ------    ------    ------    ------     ------
// y4  ---->| BUF1 |--| TEE1 |->| BUF2 |--| TEE2 |-->| BUF3 | -----
//    |      ------    ------    ------    ------     ------       |
//    |                  |                   |                     |
//    |                  v                   v                     v
//    |                 ----                ----                  ----
// y3 |                | X2 |              | X3 |                | X5 |
//    |                 ----                ----                  ----
//    |                  |                   |                     |
//    |                  |                   v                     v 
//    |                  |                 ------                ------
// y2 |                   --------------->| MER1 |------------->| MER2 |
//    |                                    ------                ------
//    |                                                            |
//    |                                                            |
//    |                          ------                            |
// y1  -------------------------| MAIN |<--------------------------
//                               ------
//    x1       x2        x3        x4        x5         x6         x7 


MANIFEST {
  boxW4by2   = (6*16)/2  // Half size of a 4 character box
  boxW2by2   = (4*16)/2  // Half size of a 2 character box
  boxHby2    = (2*24)/2  // all assuming 24x16 characters.

  boxHsep = 200
  boxVsep = 150
  
  radius = 60         // Radius of round bend corners


  x1 = 10             // Left vertical line
  x2 = x1+boxHsep
  x3 = x2+boxHsep
  x4 = x3+boxHsep
  x5 = x4+boxHsep
  x6 = x5+boxHsep
  x7 = x6+boxHsep
  xsize = x7+boxW4by2+10

  y1 = 60             // Bottom line
  y2 = y1+boxVsep
  y3 = y2+boxVsep
  y4 = y3+boxVsep
    
  ysize = y4+boxHby2+10
}

LET start() = VALOF
{ LET stdout = output()

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  
  selectfont(16)
  charleveloffset := charmidleveloffset

  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

AND drawbox2(x, y, str) BE
{ currpen := penS3
  moveto(x-boxW2by2, y-boxHby2); drawto(x+boxW2by2, y-boxHby2) // Lower edge
  moveto(x-boxW2by2, y+boxHby2); drawto(x+boxW2by2, y+boxHby2) // Upper edge
  moveto(x-boxW2by2, y-boxHby2); drawto(x-boxW2by2, y+boxHby2) // Left  edge
  moveto(x+boxW2by2, y-boxHby2); drawto(x+boxW2by2, y+boxHby2) // Right edge

  drawstrcentred(x, y, str)
}

AND drawbox4(x, y, str) BE
{ currpen := penS3
  moveto(x-boxW4by2, y-boxHby2); drawto(x+boxW4by2, y-boxHby2) // Lower edge
  moveto(x-boxW4by2, y+boxHby2); drawto(x+boxW4by2, y+boxHby2) // Upper edge
  moveto(x-boxW4by2, y-boxHby2); drawto(x-boxW4by2, y+boxHby2) // Left  edge
  moveto(x+boxW4by2, y-boxHby2); drawto(x+boxW4by2, y+boxHby2) // Right edge

  drawstrcentred(x, y, str)
}

AND drawsmallstr(x, y, str) BE
{ selectfont(16)
  charleveloffset := charmidleveloffset
  drawstrcentred(x, y, str)
}

AND drawdiagram() BE
{
  // Draw the boxes

  drawbox4(x2, y4, "BUF1")
  drawbox4(x3, y4, "TEE1")
  drawbox4(x4, y4, "BUF2")
  drawbox4(x5, y4, "TEE2")
  drawbox4(x6, y4, "BUF3")

  drawbox2(x3, y3, "X2")
  drawbox2(x5, y3, "X3")
  drawbox2(x7, y3, "X5")

  drawbox4(x5, y2, "MER1")
  drawbox4(x7, y2, "MER2")

  drawbox4(x4, y1, "MAIN")

  // All straight line edges are drawn in the direction of the flow.
  // Arrow heads are drawn when necessary.
  
  // Draw the horizontal lines at level y1
  moveto(x7-radius, y1); drawto(x4+boxW4by2,   y1)   // bend to MAIN
  drawarrow(2, x4+boxW4by2, y1, 15)                  // Arrow head
  moveto(x1+radius,   y1); drawto(x4-boxW4by2, y1)   // MAIN to bend

  // Draw the horizontal lines at level y2
  moveto(x3+radius,    y2); drawto(x5-boxW4by2, y2)  // bend to MER1
  drawarrow(0, x5-boxW4by2, y2, 15)                  // Arrow head
  moveto(x5+boxW4by2,  y2); drawto(x7-boxW4by2, y2)  // MER1 to MER2
  drawarrow(0, x7-boxW4by2, y2, 15)                  // Arrow head

  // Draw the horizontal lines at level y4
  moveto(x1+radius, y4); drawto(x2-boxW4by2, y4)   // bend to BUF1
  drawarrow(0, x2-boxW4by2, y4, 15)                // Arrow head
  moveto(x2+boxW4by2, y4); drawto(x3-boxW4by2, y4) // Arrow BUF1 to TEE1
  drawarrow(0, x3-boxW4by2, y4, 15)                // Arrow head
  moveto(x3+boxW4by2, y4); drawto(x4-boxW4by2, y4) // Arrow TEE1 to BUF2
  drawarrow(0, x4-boxW4by2, y4, 15)                // Arrow head
  moveto(x4+boxW4by2, y4); drawto(x5-boxW4by2, y4) // Arrow BUF2 to TEE2
  drawarrow(0, x5-boxW4by2, y4, 15)                // Arrow head
  moveto(x5+boxW4by2, y4); drawto(x6-boxW4by2, y4) // TEE2 to BUF3
  drawarrow(0, x6-boxW4by2, y4, 15)                // Arrow head
  moveto(x6+boxW4by2, y4); drawto(x7-radius, y4)   // BUF3 to bend


  // Draw the vertical lines from level y1
  moveto(x1,   y1+radius);  drawto(x1, y4-radius)   // Left vertical line

  // Draw the vertical lines from level y2
  moveto(x7,   y2-boxHby2); drawto(x7, y1+radius)   // From MER2 to bend

  // Draw the vertical lines from level y3
  moveto(x3,   y2+radius);  drawto(x3, y3-boxHby2)  // X2 to bend
  moveto(x5,   y3-boxHby2); drawto(x5, y2+boxHby2)  // X3 to MER1
  drawarrow(3, x5, y2+boxHby2, 15)                  // Arrow head
  moveto(x7,   y3-boxHby2); drawto(x7, y2+boxHby2)  // X5 to MER2
  drawarrow(3, x7, y2+boxHby2, 15)                  // Arrow head
  
  // Draw the vertical lines from level y4
  moveto(x3,   y4-boxHby2); drawto(x3, y3+boxHby2)  // TEE1 to X2
  drawarrow(3, x3, y3+boxHby2, 15)                  // Arrow head
  moveto(x5,   y4-boxHby2); drawto(x5, y3+boxHby2)  // TEE2 to X3
  drawarrow(3, x5, y3+boxHby2, 15)                  // Arrow head
  moveto(x7,   y4-radius);  drawto(x7, y3+boxHby2)  // From bend to X5
  drawarrow(3, x7, y3+boxHby2, 15)                  // Arrow head
  
  // Draw round corners
  rndcorner(1, x1, y4, radius)  // Top left
  rndcorner(0, x7, y4, radius)  // Top left
  rndcorner(2, x3, y2, radius)  // Between X2 and MER1
  rndcorner(2, x1, y1, radius)  // Bottom left
  rndcorner(3, x7, y1, radius)  // Bottom right

  // Draw the small edge labels

  drawsmallstr(x4-boxW4by2-20, y1+20, "c")  // MAIN labels
  drawsmallstr(x4+boxW4by2+20, y1+20, "c")

  drawsmallstr(x2-boxW4by2-20, y4+20, "w")  // BUF1 labels
  drawsmallstr(x2+boxW4by2+20, y4+20, "w")
  drawsmallstr(x4-boxW4by2-20, y4+20, "w")  // BUF2 labels
  drawsmallstr(x4+boxW4by2+20, y4+20, "w")
  drawsmallstr(x6-boxW4by2-20, y4+20, "w")  // BUF3 labels
  drawsmallstr(x6+boxW4by2+20, y4+20, "w")

  drawsmallstr(x3-boxW4by2-20, y4+20, "c")  // TEE1 labels
  drawsmallstr(x3+boxW4by2+20, y4+20, "c")
  drawsmallstr(x3+20, y4-boxHby2-16, "w")
  drawsmallstr(x5-boxW4by2-20, y4+20, "c")  // TEE2 labels
  drawsmallstr(x5+boxW4by2+20, y4+20, "c")
  drawsmallstr(x5+20, y4-boxHby2-16, "w")

  drawsmallstr(x3+20, y3+boxHby2+20, "c")   // X2 labels
  drawsmallstr(x3+20, y3-boxHby2-16, "w")
  drawsmallstr(x5+20, y3+boxHby2+20, "c")   // X3 labels
  drawsmallstr(x5+20, y3-boxHby2-16, "w")
  drawsmallstr(x7+20, y3+boxHby2+20, "c")   // X5 labels
  drawsmallstr(x7+20, y3-boxHby2-16, "w")

  drawsmallstr(x5-boxW4by2-20, y2+20, "c")  // MER1 labels
  drawsmallstr(x5+boxW4by2+20, y2+20, "w")
  drawsmallstr(x5+20, y2+boxHby2+20,  "c")
  drawsmallstr(x7-boxW4by2-20, y2+20, "c")  // MER2 labels
  drawsmallstr(x7+20, y2+boxHby2+20,  "c")
  drawsmallstr(x7+20, y2-boxHby2-16,  "w")

  
  writef("xsize = %n ysize = %n %5.1d mm*n",
          xsize, ysize, 22_0 * xsize / 238)
}

