
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  x01 = 40
  x02 = x01+40
  x03 = x02+wbv
  
  y01  = 30              // DEFAULT
  y02  = y01+dtt         // CASE
  y04  = y02+dtc         // is name
  y03  = y04-dcl         // line
  y05  = y04+dtt         // is call
  y06  = y05+dtt         // :=
  y07  = y06+dcc         // E0
  y08  = y07+dtc         // ,
  y09  = y08+dtc         // SWITCHON
  y10  = y09+dcl         // line
  y11  = y10+dll         // line
  y12  = y11+dtl         // {
  y13  = y12+dcl         // line
  y14  = y13+dll         // UNTIL
  y15  = y14+dtt         // WHILE            
  y16  = y15+dtt         // UNLESS
  y17  = y16+dtt         // IF
  y18  = y17+dll         // DO
  y19  = y18+dcl         // FOR
  y20  = y19+dcl         // line
  //y21  = y20+dtl         // DO
  y22  = y20+dtl         // TEST
  y23  = y22+dtt         // RESULTIS
  y24  = y23+dtt         // GOTO
  y25  = y24+dtt         // SKIP
  y26  = y25+dtt         // FINISH
  y27  = y26+dtt         // RETURN
  y28  = y27+dtt         // ENDCASE
  y29  = y28+dtt         // LOOP
  y30  = y29+dtt         // BREAK

  xay19 = x03+dl3+wbb     // name after FOR
  xby19 = xay19+dl4+wbb   // =
  xcy19 = xby19+dl1+wbb   // E0 
  xdy19 = xcy19+dl2+wbb   // TO 
  xey19 = xdy19+dl2+wbb   // E0 
  xfy19 = xey19+dl2+wbv   // vertical
  xgy19 = xfy19+wvb       // BY 
  xhy19 = xgy19+dl2+wbb   // E0
  xiy19 = xhy19+dl2+wbv   // vertical
  xjy19 = xiy19+wvv       // vertical 
  xky19 = xjy19+wvb       // DO
  xly19 = xky19+dl2+wbv   // vertical
  xmy19 = xly19+wvb       // C 
  xny19 = xmy19+dl2+45   // vertical at right hand side

  xfy30 = xny19           // Right hand vertical
  xey30 = xfy30-dl2-wbv   // E0
  xdy30 = xey30-wvb       // Vertical
  xcy30 = xdy30-dl11-wbv  // REPEATWHILE
  xby30 = xcy30-wvb       // Vertical
  xay30 = xby30-200       // Vertical after BREAK

  xay24 = x03+dl8+wbv     // Vertical after GOTO
  xby24 = xay24+wvb       // E0
  xcy24 = xay30

  xay22 = xby24+dl2+wbv   // Vertical after TEST E0
  xby22 = xay22+wvb       // THEN
  xcy22 = xby22+dl4+wbv   // vertical
  xdy22 = xcy22+wvb       // C
  xey22 = xdy22+dl2+wbb   // ELSE
  xfy22 = xey22+dl4+wbb   // C

  xay12 = xay24+wvv       // Vertical after {
  xby12 = xay12+wvv       // Vertical
  xcy12 = xby12+wvb       // D
  xdy12 = xcy12+dl1+wbv   // Vertical
  xey12 = xdy12+wvb       // ;
  xfy12 = xey12+dl1+wbv   // Vertical
  xgy12 = xfy12+wvv       // Vertical
  xhy12 = xgy12+wbb       // Vertical
  xiy12 = xhy12+wvb       // C
  xjy12 = xiy12+dl1+wbv   // Vertical
  xky12 = xjy12+wvb       // ;
  xly12 = xky12+dl1+wbv       // Vertical
  xmy12 = xly12+wvv       // Vertical
  xny12 = xmy12+wvb       // }
  
  xay09 = xby24           // E0 after SWITCHON
  xby09 = xay09+dl2+wbb   // INTO
  xcy09 = xby09+dl4+wbb   // {

  xay07 = x03+dl2+wbv     // Vertical after E0
  xby07 = xay07+wvb       // ,
  xcy07 = xby07+dl1+wbv   // Vertical
  xdy07 = xcy07+wvb       // E0
  xey07 = xdy07+dl2+wbv   // Vertical after E0
  xfy07 = xey07+wvb       // ,
  xgy07 = xfy07+dl2+wbv   // Vertical
  xhy07 = xgy07+wvb       // E0
  xiy07 = xhy07+dl2+wbv   // Vertical

  xay04 = xby07+dl7+wbv   // Vertical after is name
  xby04 = xay04+wvb       // :
  xcy04 = xby04+dl1+wbv   // Vertical
  xdy04 = xcy04+wvb       // C
  xey04 = xdy04+dl1+wbv   // Vertical


  xay02 = x03+dl7+wbb     // E0 after CASE

  width = (xfy30+53) & #xFFFC
  height = y30+40


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
  
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y30, x01,       x03, xby30-r, "BREAK")
  
  drawtestboxL(y29, x02+r,     x03, xay30-r, "LOOP")
  drawtestboxL(y29, xby30+r, xcy30, xey30,   "REPEATWHILE")
  drawcatboxL (y29, xey30,   xey30, xfy30-r, "E0")

  drawtestboxL(y28, x02+r,     x03, xay30-r, "ENDCASE")
  drawtestboxL(y28, xby30+r, xcy30, xdy30-r, "REPEATUNTIL")

  drawtestboxL(y27, x02+r,     x03, xay30-r, "RETURN")
  drawtestboxL(y27, xby30+r, xcy30, xny19-r, "REPEAT")
  
  drawtestboxL(y26, x02+r,     x03, xay30-r, "FINISH")
  
  drawtestboxL(y25, x02+r,     x03, xay30-r, "SKIP")
  
  drawtestboxL(y24, x02+r,     x03, xby24,   "GOTO")
  drawcatboxL (y24, xby24,   xby24, xcy24-r, "E0")
  
  drawtestboxL(y23, x02+r,     x03, xay24-r, "RESULTIS")
  
  drawtestboxL(y22, x02+r,     x03, xby24,   "TEST")
  drawcatboxL (y22, xby24,   xby24, xby22,   "E0")
  drawtestboxL(y22, xby22,   xby22, xdy22,   "THEN")
  drawcatboxL (y22, xdy22,   xdy22, xey22,   "C")
  drawtestboxL(y22, xey22,   xey22, xfy22,   "ELSE")
  drawcatboxL (y22, xfy22,   xfy22, xny19-r, "C")
  
  drawtestboxL(y19, x02+r,     x03, xay19,   "FOR")
  drawtestboxL(y19, xay19,   xay19, xby19,   "name")
  drawtestboxL(y19, xby19,   xby19, xcy19,   "=")
  drawcatboxL (y19, xcy19,   xcy19, xdy19,   "E0")
  drawtestboxL(y19, xdy19,   xdy19, xey19,   "TO")
  drawcatboxL (y19, xey19,   xey19, xgy19,   "E0")
  drawtestboxL(y19, xgy19,   xgy19, xhy19,   "BY")
  drawcatboxL (y19, xhy19,   xhy19, xky19,   "E0")
  drawtestboxL(y19, xky19,   xky19, xmy19,   "DO")
  drawcatboxL (y19, xmy19,   xmy19, xny19-r, "C")
  
  drawtestboxL(y17, x02+r,     x03, xby24,   "IF")
  drawcatboxL (y17, xby24,   xby24, xiy19-r, "E0")
  
  drawtestboxL(y16, x02+r,     x03, xay24-r, "UNLESS")

  drawtestboxL(y15, x02+r,     x03, xay24-r, "WHILE")

  drawtestboxL(y14, x02+r,     x03, xay24-r, "UNTIL")

  drawtestboxL(y12, x02+r,     x03, xcy12,   "{")
  drawcatboxL (y12, xcy12,   xcy12, xey12,   "D")
  drawtestboxL(y12, xey12,   xey12, xgy12-r, ";")
  drawcatboxL (y12, xhy12+r, xiy12, xky12,   "C")
  drawtestboxL(y12, xky12,   xky12, xny12,   ";")
  drawtestboxL(y12, xny12,   xny12, xny19-r, "}")

  drawtestboxL(y09, x02+r,     x03, xay09,   "SWITCHON")
  drawcatboxL (y09, xay09,   xay09, xby09,   "E0")
  drawtestboxL(y09, xby09,   xby09, xcy09,   "INTO")
  drawtestboxL(y09, xcy09,   xcy09, xly12-r, "{")

  drawtestboxL(y08, xcy07+r, xdy07+(dl2-dl1)/2, xey07-r,  ",")
  drawtestboxL(y08, xgy07+r, xhy07+(dl2-dl1)/2, xiy07-r,  ",")

  drawcatboxL (y07, x02+r,     x03, xby07,   "E0")
  drawtestboxL(y07, xby07,   xby07, xdy07,   ",")
  drawtestboxL(y07, xdy07,   xdy07, xfy07,   "E0")
  drawtestboxL(y07, xfy07,   xfy07, xhy07,   ":=")
  drawcatboxL (y07, xhy07,   xhy07, xny19-r, "E0")

  drawtestboxL(y06, xay07+r, xfy07, xhy07,   ":=")
  drawcatboxL (y06, xhy07,   xhy07, xny19-r, "E0")

  drawtestboxL(y05, xay07+r, xby07, xny19-r, "is call")

  drawtestboxL(y04, xay07+r, xby07, xby04,   "is name")
  drawtestboxL(y04, xby04,   xby04, xdy04,   ":")
  drawcatboxL (y04, xdy04,   xdy04, xny19-r, "C")

  drawtestboxL(y02, x02+r,     x03, xay02,   "CASE")
  drawcatboxL (y02, xay02,   xay02, xay04-r, "E0")

  drawtestboxL(y01, x02+r,     x03, xay04-r, "DEFAULT")

  // Draw the vertical lines
  
  moveto(xby30, y30-r);   drawto(xby30, y26+r)
  moveto(xny19, y30-r);   drawto(xny19, y27+r)

  moveto(x02,   y30-r);   drawto(x02,   y01+r)
  moveto(xay30, y30-r);   drawto(xay30, y24+r)
  moveto(xdy30, y29-r);   drawto(xdy30, y28+r)

  moveto(xay24, y24-r);   drawto(xay24, y23+r)
  moveto(xny19, y24-r);   drawto(xny19, y04+r)

  moveto(xay22, y22-r);   drawto(xay22, y20+r)
  moveto(xcy22, y22-r);   drawto(xcy22, y20+r)

  moveto(xfy19, y19-r);   drawto(xfy19, y18+r)
  moveto(xiy19, y19-r);   drawto(xiy19, y17+r)
  moveto(xjy19, y19-r);   drawto(xjy19, y18+r)
  moveto(xly19, y19-r);   drawto(xly19, y18+r)

  moveto(xay24, y17-r);   drawto(xay24, y14+r)

  moveto(xay12, y13-r);   drawto(xay12, y12+r)
  moveto(xgy12, y13-r);   drawto(xgy12, y12+r)
  moveto(xhy12, y13-r);   drawto(xhy12, y12+r)
  moveto(xmy12, y13-r);   drawto(xmy12, y12+r)

  moveto(xby12, y12-r);   drawto(xby12, y10+r)
  moveto(xdy12, y12-r);   drawto(xdy12, y11+r)
  moveto(xfy12, y12-r);   drawto(xfy12, y11+r)
  moveto(xjy12, y12-r);   drawto(xjy12, y11+r)
  moveto(xly12, y12-r);   drawto(xly12, y09+r)

  moveto(xcy07, y08-r);   drawto(xcy07, y07+r)
  moveto(xey07, y08-r);   drawto(xey07, y07+r)
  moveto(xgy07, y08-r);   drawto(xgy07, y07+r)
  moveto(xiy07, y08-r);   drawto(xiy07, y07+r)

  moveto(xay07, y07-r);   drawto(xay07, y04+r)

  moveto(xay04, y04-r);   drawto(xay04, y01+r)
  moveto(xcy04, y04-r);   drawto(xcy04, y03+r)
  moveto(xey04, y04-r);   drawto(xey04, y03+r)

  // Draw the horizontal lines
  
  moveto(xby30+r, y30); drawto(xny19-r, y30)
  moveto(xby30+r, y26); drawto(xny19,   y26)
  moveto(xcy24+r, y24); drawto(xny19-r, y24)
  moveto(xay22+r, y20); drawto(xcy22-r, y20)

  moveto(xfy19+r, y18); drawto(xiy19-r, y18)
  moveto(xjy19+r, y18); drawto(xly19-r, y18)

  moveto(xay12+r, y13); drawto(xgy12-r, y13)
  moveto(xhy12+r, y13); drawto(xmy12-r, y13)

  moveto(xdy12+r, y11); drawto(xfy12-r, y11)
  moveto(xjy12+r, y11); drawto(xly12-r, y11)

  moveto(xby12+r, y10); drawto(xly12-r, y10)

  moveto(xcy04+r, y03); drawto(xey04-r, y03)

  // Draw the arrow heads
  drawarrow(0, xny19, y26, 20)  // Arrow at bottom right

  // Draw path bends

  rndcorner(0, x02,   y30, r)
  rndcorner(1, xay30, y30, r)
  rndcorner(0, xby30, y30, r)
  rndcorner(1, xby30, y30, r)
  rndcorner(0, xny19, y30, r)

  rndcorner(2, x02,   y29, r)
  rndcorner(3, xay30, y29, r)
  rndcorner(2, xby30, y29, r)
  rndcorner(1, xdy30, y29, r)
  rndcorner(3, xny19, y29, r)

  rndcorner(2, x02,   y28, r)
  rndcorner(3, xay30, y28, r)
  rndcorner(2, xby30, y28, r)
  rndcorner(3, xdy30, y28, r)

  rndcorner(2, x02,   y27, r)
  rndcorner(3, xay30, y27, r)
  rndcorner(2, xby30, y27, r)
  rndcorner(3, xny19, y27, r)

  rndcorner(2, x02,   y26, r)
  rndcorner(3, xay30, y26, r)
  rndcorner(2, xby30, y26, r)

  rndcorner(2, x02,   y25, r)
  rndcorner(3, xay30, y25, r)

  rndcorner(2, x02,   y24, r)
  rndcorner(1, xay24, y24, r)
  rndcorner(3, xcy24, y24, r)
  rndcorner(2, xcy24, y24, r)
  rndcorner(0, xny19, y24, r)

  rndcorner(2, x02,   y23, r)
  rndcorner(3, xay24, y23, r)

  rndcorner(2, x02,   y22, r)
  rndcorner(0, xay22, y22, r)
  rndcorner(1, xcy22, y22, r)
  rndcorner(3, xny19, y22, r)

  rndcorner(2, xay22, y20, r)
  rndcorner(3, xcy22, y20, r)

  rndcorner(2, x02,   y19, r)
  rndcorner(0, xfy19, y19, r)
  rndcorner(1, xiy19, y19, r)
  rndcorner(0, xjy19, y19, r)
  rndcorner(1, xly19, y19, r)
  rndcorner(3, xny19, y19, r)

  rndcorner(2, xfy19, y18, r)
  rndcorner(3, xiy19, y18, r)
  rndcorner(2, xjy19, y18, r)
  rndcorner(3, xly19, y18, r)

  rndcorner(2, x02,   y17, r)
  rndcorner(1, xay24, y17, r)
  rndcorner(3, xiy19, y17, r)

  rndcorner(2, x02,   y16, r)
  rndcorner(3, xay24, y16, r)

  rndcorner(2, x02,   y15, r)
  rndcorner(3, xay24, y15, r)

  rndcorner(2, x02,   y14, r)
  rndcorner(3, xay24, y14, r)

  rndcorner(1, xay12, y13, r)
  rndcorner(0, xgy12, y13, r)
  rndcorner(1, xhy12, y13, r)
  rndcorner(0, xmy12, y13, r)

  rndcorner(2, x02,   y12, r)
  rndcorner(2, xay12, y12, r)
  rndcorner(0, xby12, y12, r)
  rndcorner(0, xdy12, y12, r)
  rndcorner(1, xfy12, y12, r)
  rndcorner(1, xfy12, y12, r)
  rndcorner(3, xgy12, y12, r)
  rndcorner(2, xhy12, y12, r)
  rndcorner(0, xjy12, y12, r)
  rndcorner(1, xly12, y12, r)
  rndcorner(3, xmy12, y12, r)
  rndcorner(3, xny19, y12, r)

  rndcorner(2, xdy12, y11, r)
  rndcorner(3, xfy12, y11, r)
  rndcorner(2, xjy12, y11, r)
  rndcorner(3, xly12, y11, r)

  rndcorner(2, xby12, y10, r)
  rndcorner(3, xly12, y10, r)

  rndcorner(2, x02,   y09, r)
  rndcorner(3, xly12, y09, r)

  rndcorner(1, xcy07, y08, r)
  rndcorner(0, xey07, y08, r)
  rndcorner(1, xgy07, y08, r)
  rndcorner(0, xiy07, y08, r)

  rndcorner(2, x02,   y07, r)
  rndcorner(0, xay07, y07, r)
  rndcorner(2, xcy07, y07, r)
  rndcorner(3, xey07, y07, r)
  rndcorner(2, xgy07, y07, r)
  rndcorner(3, xiy07, y07, r)
  rndcorner(3, xny19, y07, r)

  rndcorner(2, xay07, y06, r)
  rndcorner(3, xny19, y06, r)


  rndcorner(2, xay07, y05, r)
  rndcorner(3, xny19, y05, r)

  rndcorner(2, xay07, y04, r)
  rndcorner(1, xay04, y04, r)
  rndcorner(0, xcy04, y04, r)
  rndcorner(1, xey04, y04, r)
  rndcorner(3, xny19, y04, r)

  rndcorner(2, xcy04, y03, r)
  rndcorner(3, xey04, y03, r)

  rndcorner(2, x02,   y02, r)
  rndcorner(3, xay04, y02, r)


  rndcorner(2, x02,   y01, r)
  rndcorner(3, xay04, y01, r)

writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


