GET "libhdr"
GET "plotflow.h"

/*
y09  x01
y09     x02---x03--x04      x06                      x7
y08      | LG  | b  |        B := A; A := G!b
y07       ----------
y06       ----------
y05      | LG1 | b  |        B := A; A := G!(b+256)
y04       ---------
y03       -------------x05
y02      | LGH |    h   |    B := A; A := G!h
y01       --------------
y00
*/

MANIFEST {
  chW = 16+3
  
  y00 = 10            // bottome edge
  y01 = y00+10        // PC   x        q = ..
  y02 = y01+30        // Low edge of J$
  y03 = y02+cellH/2    // J$   b 
  y04 = y02+cellH     // Top edge of J$
  y05 = y04+cellH/2   // LG1   b
  y06 = y04+cellH     // Top edge of LGH
  y07 = y06+20        // Low edge of LG1 box
  y08 = y07+cellH/2   // LG    b
  y09 = y07+cellH     // Top edge
  
  x01 = 10            // Left edge
  x02 = x01+20        // Left edge of function byte
  x03 = x02+wl3       // Middle of function byte
  x04 = x03+wl3       // Right edge of function byte
  x05 = x04+wl3       // Position of a
  x06 = x05+60        // Right edge of b argument
  x07 = x06+22*chW+20 // Right edge of image

  width  = x07+3 & -4
  height = y09
}


LET drawdiagram() BE
{
  moveto(x02, y09); drawto(x04, y09)

  drawstrcentred((x02+x03)/2, y08, "LG")
  drawstrcentred((x03+x04)/2, y08, "b")
  drawstr(x06, y08, "B := A; A := G!b")

  strut(x02, y07)
  strut(x03, y07)
  strut(x04, y07)
  moveto(x02, y07); drawto(x04, y07)

  moveto(x02, y06); drawto(x04, y06)

  drawstrcentred((x02+x03)/2, y05, "LG1")
  drawstrcentred((x03+x04)/2, y05, "b")
  drawstr(x06, y05, "B := A; A := G!(b+256)")

  strut(x02, y04)
  strut(x03, y04)
  strut(x04, y04)
  moveto(x02, y04); drawto(x04, y04)

  moveto(x02, y03); drawto(x05, y03)

  drawstrcentred((x02+x03)/2, y02, "LGH")
  drawstrcentred((x03+x05)/2, y02, "h")
  drawstr(x06, y02, "B := A; A := G!h")

  strut(x02, y01)
  strut(x03, y01)
  strut(x05, y01)
  moveto(x02, y01); drawto(x05, y01)
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

