GET "libhdr"
GET "plotflow.h"

/*
y09     x02---x03--x04                                  x10            x11
y08       ----------
y07      |  J | a  |                                     dest = x + b
y06       ---------ink.b				 
           ^    ^
           |    |
y05       PC    x
y04  x00-------------------X05 ---------x07------x09-
y03      | J$ | b  |         \ \         |   hh   |      dest = q + hh
y02    -----------------------x06---------x08--------
           ^    ^                          ^
           |    |                          |
y01       PC    x                          q = (x & #xFFFFFFFF) + 2*b
y00
*/

MANIFEST {
  chW = 16+3
  
  y00 = 30            // bottom edge
  y01 = y00+10        // PC   x          q = ...
  y02 = y01+80        // Low edge of J$ box
  y03 = y02+cellH/2   // J$   b         hh
  y04 = y02+cellH     // Top edge of J$ box
  y05 = y04+50        // PC   x          q = ...
  y06 = y05+80        // Low edge of J box
  y07 = y06+cellH/2   // J    a          dest = ...
  y08 = y06+cellH     // Top edge of J box
  y09 = y08+40        // Top edge

  x00 = 10
  x01 = x00+10        // Left edge
  x02 = x01+20        // Left edge of function byte
  x03 = x02+wl3       // Middle of function byte
  x04 = x03+wl3       // Right edge of function byte
  x05 = x04+80        // Zigzag L
  x06 = x05+zigzagW   // Zigzag R
  x07 = x06+70        // Left edge of resolving half word
  x08 = x07+wl3/2     // Position of q arrow
  x09 = x07+2*wl3     // Right edge of resolving half word
  x10 = x09+80        // Position of dest = ...
  x11 = x10+15*chW + 20 // Right edge of image

  width  = x11+3 & -4
  height = y09
}


LET drawdiagram() BE
{
  moveto(x02, y08); drawto(x04, y08)

  drawstrcentred((x02+x03)/2, y07, "J")
  drawstrcentred((x03+x04)/2, y07, "a")
  drawstr(x10, y07, "dest = q + a")

  strut(x02, y06)
  strut(x03, y06)
  strut(x04, y06)
  moveto(x02, y06); drawto(x04, y06)
  drawarrow(1, (x02+x03)/2, y06-10, 15)
  moveto((x02+x03)/2, y06-10); drawto((x02+x03)/2, y05+20)
  drawarrow(1, (x03+x04)/2, y06-10, 15)
  moveto((x03+x04)/2, y06-10); drawto((x03+x04)/2, y05+20)

  drawstrcentred((x02+x03)/2, y05, "PC")
  drawstrcentred((x03+x04)/2, y05, "c")

  moveto(x02, y04); drawto(x05,    y04)
  moveto(x06, y04); drawto(x09+20, y04)

  drawstrcentred((x02+x03)/2, y03, "J$")
  drawstrcentred((x03+x04)/2, y03, "b")
  drawstrcentred((x07+x09)/2, y03, "hh")
  drawstr(x10, y03, "dest = q + hh")

  moveto(x02, y02); drawto(x05,    y02)
  moveto(x06, y02); drawto(x09+20, y02)
  strut(x02,  y02)
  strut(x03,  y02)
  strut(x04,  y02)
  zigzag(x05, y02)
  zigzag(x06, y02)
  strut(x07,  y02)
  strut(x09,  y02)
  drawarrow(1, (x02+x03)/2, y02-10, 15)
  drawarrow(1, (x03+x04)/2, y02-10, 15)
  drawarrow(1,       x08, y02-10, 15)
  moveto((x02+x03)/2, y02-10); drawto((x02+x03)/2, y01+20)
  moveto((x03+x04)/2, y02-10); drawto((x03+x04)/2, y01+20)
  moveto(x08, y02-10); drawto(x08, y01+20)

  drawstrcentred((x02+x03)/2, y01, "PC")
  drawstrcentred((x03+x04)/2, y01, "x")
  drawstr(x08-chW/2, y01, "q = (x & #xFFFFFFFF) + 2**b")
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

