
GET "libhdr"
GET "plotflow.h"

/*
y27  Top edge                    (x2+x75)/2
   x1                                                                             x75
y26--x2----------------------------[<>]--------------------------------------x27-->
     |  x3                                                                   |
y25  |--[jcom]---------------x6--------x7-------------------------x11        |
     |                       |         |  x8                x10   |          |
y24  |--[RETURN]-------------|         |--[REPEATWHILE]--x9-{E0}--|          |
     |                       |         |                 |        |          |
y23  |--[FINISH]-------------|         |--[REPEATUNTIL]--         |          |
     |                       |         |                          |          |
y22  |--[SKIP]---------------|         |--[REPEAT]----------------           |
     |              x4 x5    |         |                                     |
y21  |--[GOTO]---------(E0)--|         x7------------------------------------x27
     |              |        |
y20  |--[RESULTIS]--x4       x6----------------------------------------------x27
     |                                                                       |
     |         x12     x13   x14   x16   x17      x20   x21      x24    x26  |
y19  |--[FOR}--[name]--[=]--(E0)x15[TO]--(E0)-----[BY]--(E0)-----[DO]---(C)--|
     |                           |            | |            | |      |      |
y18  |                            ----------x18 x19--------x22 x23--x25      |
     |                 x80  x81 x82    x83 x84  x85     x86                  |
y18a |--[TEST]---------{E0}-----[THEN]-----(C)--[ELSE]--(C)------------------|
     |                       |          |                                    |
y18b |                        ----------                                     |
     |                    x29      x88      x90                              |
y17  |--[IF UNLESS]-------(EO)-----[DO]-----(C)------------------------------|
     |                 |        |        |                                   |
y16  |--[WHILE UNTIL]-x28       x87------x89                                 |
     |                x34                                    x43             |
y15  |--[{]---------------------------x37--x38---------------[}]-------------x27
     |                 |          x36  |   |          x41  |                 |
y14  |                 |------x35-[;]--|   x38----x40-[;]--|                 |
     |                 |       |       |   |  x39  |       |                 |
y13  |                x34-(D)-x35------     --(C)-x40-----x42                |
     |               x44    x45      x46                     x52             |
y12  |--[SWITCHON]---(E0)---[INTO]---[{]-x47-------------x51-[}]-------------|
     |                                    |          x50  |                  |
y11  |                                    |----------[;]--|                  |
     |                                    |  x48  |       |                  |
y10  |                                   x47-(C)-x49-----x51                 |
y9   |                     x54--[,]--x55                                     |
     |  x3             x53  |        |  x56   x57                            |
y8   !--MATCH EVERY]---[(]-----(E0)-----[)]---(Mlist)------------------------|
     |                                                                       |
y7   |              x60-[,]-x62         x64--[,]-x66                         |
     |       x58 x59 | x61   |  x63      |  x65   |                          |
y6   |--(E0)-----[,]---(E0)-----[assop]-----(E0)-----------------------------|
     !       |                  x66         x67                              |
y5   |       |------------------[assop]-----(E0)-----------------------------|
     |       |   x68                                                         |
y4   |       |---[iscall]----------------------------------------------------|
     |       |                x70     x72                                    |
y3   |      x58--[isname]-x69-[:]-x71-(C)--x73-------------------------------x27
     |             x74     |       |       |
y2   |--[CASE]-----(E0)----|        -------
     |                     |
y1   x2-[DEFAULT]---------x69

y0   Bottom edge
*/

MANIFEST {
y0   = 0
y1   = 20
y2   = y1+hcc
y3   = y2+hcc
y4   = y3+hcc
y5   = y4+hcc
y6   = y5+hcc
y7   = y6+hcc
y8   = y7+hcc
y9   = y8+hcc
y10  = y9+hll
y11  = y10+hcc
y12  = y11+hcc
y13a = y12+hcc
y13  = y13a+hcc
y14  = y13+hcc
y15  = y14+hcc
y16  = y15+hcc
y17  = y16+hcc
y18b = y17+hcc
y18a = y18b+hcc
y18  = y18a+hcc
y19  = y18+hcc
y20  = y19+hcc
y21  = y20+hcc
y22  = y21+hcc
y23  = y22+hcc
y24  = y23+hcc
y25  = y24+hcc
y26  = y25+hcc
y27  = y26+hcc
y28  = y27+hcc
y29  = y28+hcc
y30  = y29+hcc
y31  = y30+hcc
y32  = y31+hcc
y33  = y32+hcc
y34  = y33+hcc
y35  = y34+hcc
y35  = y34+hcc

x0  = 0
x1  = 20
x2  = x1+wcc
x3  = x2+wcc
x4  = x3+wl8+wcc
x5  = x4+wcc
x6  = x5+wl2+wcc
x7  = x6+300
x8  = x7+wcc
x9  = x8+wl11+wcc
x10 = x9+wcc
x11 = x10+wl2+wcc
x12 = x3+wl3+wcl   // [name]
x13 = x12+wl4+wcl  // [=]
x14 = x13+wl1+wcl  // (E0) 
x15 = x14+wl2+wcl  //
x16 = x15+wcl      // [TO]
x17 = x16+wl2+wcl  // (E0)
x18 = x17+wl2+wcl
x19 = x18+wcl
x20 = x19+wcl      // [BY]
x21 = x20+wl2+wcl  // (E0)
x22 = x21+wl2+wcl
x23 = x22+wcl
x24 = x23+wcl      // [DO]
x25 = x24+wl2+wcl
x26 = x25+wcl      // (C)
x27 = x26+wl2+wcc
x28 = x3+wl11+wcc
x29 = x28+wcc
x30 = x23
x31 = x24
x32 = x25
x33 = x26
x34 = x28
x35 = x34+wcc+wl1+wcc
x36 = x35+wcc
x37 = x36+wl1+wcc
x38 = x37+wcc+wcc
x39 = x38+wcc
x40 = x39+wl1+wcc
x41 = x40+wcc
x42 = x41+wl1+wcc
x43 = x42+wcc+wcc
x44 = x3+wl8+wcc
x45 = x44+wl2+wcc
x46 = x45+wl4+wcc
x47 = x38
x48 = x47+wcc
x49 = x48+wl1+wcc
x50 = x49+wcc
x51 = x50+wl1+wcc
x52 = x51+wcc+wcc
x53 = x3+wl11+wcc
x54 = x53+wl1+wcc
x55 = x54+wcc+wl2+wcc
x56 = x55+wcc
x57 = x56+wl1+wcc
x58 = x3+wl2+wcc
x59 = x58+wcc
x60 = x59+wl1+wcc
x61 = x60+wcc
x62 = x61+wl2+wcc
x63 = x62+wcc
x64 = x63+wl5+wcc
x65 = x64+wcc
x66 = x65+wl2+wcc
x67 = x65
x68 = x59
x69 = x68+wl6+wcc
x70 = x69+wcc
x71 = x70+wl1+wcc
x72 = x71+wcc
x73 = x72+wl1+wcc
x74 = x3+wl4+wcc
x75 = x27+50
x80 = x3+wl4+wcc      // (E0)
x81 = x80+wl2+wcc     // 
x82 = x81+wcc         // [THEN]
x83 = x82+wl4+wcc
x84 = x83+wcc         // (C)
x85 = x84+wl1+wcc     // [ELSE]
x86 = x85+wl4+wcc     // (C)
x87 = x29+wl2+wcc     //
x88 = x87+wcc         // [DO]
x89 = x88+wl2+wcc     //
x90 = x89+wcc         // (C)

  width = (x75+53) & -4
  height = y26+60
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  moveto(x1, y26); drawto(x2-r, y26)
  drawtestboxC(y26, x2+r, (x2+x27)/2, x27-r, "<>")
  moveto(x27+r, y26); drawto(x75, y26)
  drawarrow(0, x75, y26, r)
  moveto(x2, y26-r);  drawto(x2, y1+r)
  moveto(x27, y26-r); drawto(x27, y21+r)
  rndcorner(0, x2,  y26, r)
  rndcorner(1, x2,  y26, r)
  rndcorner(0, x27, y26, r)
  rndcorner(1, x27, y26, r)

  drawtestboxL(y25, x2+r, x3, x7-r, "jcom")
  moveto(x7+r, y25); drawto(x11-r, y25)
  moveto(x6,  y25-r); drawto(x6,  y20+r)
  moveto(x7,  y25-r); drawto(x7,  y21+r)
  moveto(x11, y25-r); drawto(x11, y22+r)
  rndcorner(2, x2,  y25, r)
  rndcorner(1, x6,  y25, r)
  rndcorner(0, x7,  y25, r)
  rndcorner(1, x7,  y25, r)
  rndcorner(0, x11, y25, r)

  drawtestboxL(y24, x2+r,   x3,  x6-r,  "RETURN")
  drawtestboxL(y24, x7+r, x8,  x10,   "REPEATWHILE")
  drawtestboxL(y24, x10,  x10, x11-r, "E0")
  moveto(x9, y24-r); drawto(x9, y23+r)
  rndcorner(2, x2,  y24, r)
  rndcorner(3, x6,  y24, r)
  rndcorner(2, x7,  y24, r)
  rndcorner(1, x9,  y24, r)
  rndcorner(3, x11, y24, r)

  drawtestboxL(y23, x2+r, x3, x6-r, "FINISH")
  drawtestboxL(y23, x7, x8, x9-r, "REPEATUNTIL")
  rndcorner(2, x2,    y23, r)
  rndcorner(3, x6,    y23, r)
  rndcorner(3, x9,    y23, r)

  drawtestboxL(y22, x2+r, x3, x6-r,  "SKIP")
  drawtestboxL(y22, x7, x8, x11-r, "REPEAT")
  rndcorner(2, x2,  y22, r)
  rndcorner(3, x6,  y22, r)
  rndcorner(3, x11, y22, r)

  drawtestboxL(y21, x2+r, x3, x5,   "GOTO")
  drawtestboxL(y21, x5, x5, x6-r, "E0")
  moveto(x7+r, y21); drawto(x27-r, y21)
  moveto(x4,  y21-r); drawto(x4,  y20+r)
  moveto(x27, y20-r); drawto(x27, y3+r)
  rndcorner(2, x2,  y21, r)
  rndcorner(1, x4,  y21, r)
  rndcorner(3, x6,  y21, r)
  rndcorner(2, x7,  y21, r)
  rndcorner(3, x27, y21, r)

  drawtestboxL(y20, x2+r, x3, x4-r, "RESULTIS")
  moveto(x6+r, y20); drawto(x27-r, y20)
  rndcorner(2, x2,  y20, r)
  rndcorner(3, x4,  y20, r)
  rndcorner(2, x6,  y20, r)
  rndcorner(0, x27, y20, r)
  
  drawtestboxL(y19, x2+r,  x3,  x12,   "FOR")
  drawtestboxL(y19, x12, x12, x13,   "name")
  drawtestboxL(y19, x13, x13, x14,   "=")
  drawcatboxL (y19, x14, x14, x16,   "E0")
  drawtestboxL(y19, x16, x16, x17,   "TO")
  drawcatboxL (y19, x17, x17, x20,   "E0")
  drawtestboxL(y19, x20, x20, x21,   "BY")
  drawcatboxL (y19, x21, x21, x24,   "E0")
  drawtestboxL(y19, x24, x24, x26,   "DO")
  drawcatboxL (y19, x26, x26, x27-r, "C")
  moveto(x15, y19-r); drawto(x15, y18+r)
  moveto(x18, y19-r); drawto(x18, y18+r)
  moveto(x19, y19-r); drawto(x19, y18+r)
  moveto(x22, y19-r); drawto(x22, y18+r)
  moveto(x23, y19-r); drawto(x23, y18+r)
  moveto(x25, y19-r); drawto(x25, y18+r)
  rndcorner(2, x2,  y19, r)
  rndcorner(0, x15, y19, r)
  rndcorner(1, x18, y19, r)
  rndcorner(0, x19, y19, r)
  rndcorner(1, x22, y19, r)
  rndcorner(0, x23, y19, r)
  rndcorner(1, x25, y19, r)
  rndcorner(3, x27, y19, r)

  moveto(x15+r, y18); drawto(x18-r, y18)
  moveto(x19+r, y18); drawto(x22-r, y18)
  moveto(x23+r, y18); drawto(x25-r, y18)
  rndcorner(2, x15, y18, r)
  rndcorner(3, x18, y18, r)
  rndcorner(2, x19, y18, r)
  rndcorner(3, x22, y18, r)
  rndcorner(2, x23, y18, r)
  rndcorner(3, x25, y18, r)

  drawtestboxL(y18a, x2+r, x3, x80, "TEST")
  drawcatboxL (y18a, x80, x80, x82, "E0")
  drawtestboxL(y18a, x82, x82, x84, "THEN")
  drawcatboxL (y18a, x84, x84, x85, "C")
  drawtestboxL(y18a, x85, x85, x86, "ELSE")
  drawcatboxL (y18a, x86, x86, x27-r, "C")
  rndcorner(2, x2, y18a, r)
  rndcorner(0, x81, y18a, r)
  rndcorner(1, x83, y18a, r)
  rndcorner(3, x27, y18a, r)
  moveto(x81, y18a-r); drawto(x81, y18b+r)
  moveto(x83, y18a-r); drawto(x83, y18b+r)

  moveto(x81+r, y18b); drawto(x83-r, y18b)
  rndcorner(2, x81, y18b, r)
  rndcorner(3, x83, y18b, r)


  drawtestboxL(y17, x2+r, x3, x29, "IF UNLESS")
  drawcatboxL (y17, x29, x29, x88, "E0")
  drawtestboxL(y17, x88, x88, x90, "DO")
  drawcatboxL (y17, x90, x90, x27-r, "C")
  moveto(x28, y17-r); drawto(x28, y16+r)
  moveto(x87, y17-r); drawto(x87, y16+r)
  moveto(x89, y17-r); drawto(x89, y16+r)
  rndcorner(2, x2,  y17, r)
  rndcorner(1, x28, y17, r)
  rndcorner(0, x87, y17, r)
  rndcorner(1, x89, y17, r)
  rndcorner(3, x27, y17, r)

  drawtestboxL(y16, x2+r, x3, x28-r, "WHILE UNTIL")
  moveto(x87+r, y16); drawto(x89-r, y16)
  rndcorner(2, x2 , y16, r)
  rndcorner(3, x28, y16, r)
  rndcorner(2, x87, y16, r)
  rndcorner(3, x89, y16, r)

  drawtestboxL(y15, x2+r, x3, x43, "{")
  drawtestboxL(y15, x43, x43, x27-r, "}")
  moveto(x34, y15-r); drawto(x34, y13a+r)
  moveto(x37, y15-r); drawto(x37, y13+r)
  moveto(x42, y15-r); drawto(x42, y13+r)
  rndcorner(2, x2,  y15, r)
  rndcorner(0, x34, y15, r)
  rndcorner(1, x37, y15, r)
  rndcorner(1, x42, y15, r)
  rndcorner(3, x27, y15, r)

  drawtestboxL(y14, x34+r, x36, x37-r, ";")
  drawtestboxL(y14, x38+r, x41, x42-r,";")
  moveto(x35, y14-r); drawto(x35, y13+r)
  moveto(x38, y14-r); drawto(x38, y13+r)
  moveto(x40, y14-r); drawto(x40, y13+r)
  rndcorner(1, x34, y14, r)
  rndcorner(0, x35, y14, r)
  rndcorner(0, x37, y14, r)
  rndcorner(1, x38, y14, r)
  rndcorner(0, x40, y14, r)
  rndcorner(0, x42, y14, r)

  drawcatboxC(y13, x34+r, (x34+x35)/2, x37-r, "D")
  drawcatboxL(y13, x38+r, x39, x42-r, "C")
  moveto(x38, y13-r); drawto(x38, y13a+r)
  rndcorner(2, x34,  y13, r)
  rndcorner(3, x35,  y13, r)
  rndcorner(3, x37,  y13, r)
  rndcorner(2, x38,  y13, r)
  rndcorner(1, x38,  y13, r)
  rndcorner(3, x40,  y13, r)
  rndcorner(3, x42,  y13, r)

  moveto(x34+r, y13a); drawto(x38-r, y13a)
  rndcorner(2, x34,  y13a, r)
  rndcorner(3, x38,  y13a, r)

  drawtestboxL(y12, x2+r, x3, x44, "SWITCHON")
  drawcatboxL (y12, x44, x44, x45, "E0")
  drawtestboxL(y12, x45, x45, x46, "INTO")
  drawtestboxL(y12, x46, x46, x52, "{")
  drawtestboxL(y12, x52, x52, x27-r, "}")
  moveto(x47, y12-r); drawto(x47, y10+r)
  moveto(x51, y12-r); drawto(x51, y10+r)
  rndcorner(2, x2,  y12, r)
  rndcorner(0, x47, y12, r)
  rndcorner(1, x51, y12, r)
  rndcorner(3, x27, y12, r)

  drawtestboxL(y11, x47+r, x50, x51-r, ";")
  moveto(x49, y11-r); drawto(x49, y10+r)
  rndcorner(1, x47,  y11, r)
  rndcorner(0, x49,  y11, r)
  rndcorner(0, x51,  y11, r)

  drawcatboxL(y10, x47+r, x48, x51-r, "C")
  rndcorner(2, x47,  y10, r)
  rndcorner(3, x49,  y10, r)
  rndcorner(3, x51,  y10, r)

  drawtestboxC(y9, x54+r, (x54+x55)/2, x55-r, ",")
  moveto(x54, y9-r); drawto(x54, y8+r)
  moveto(x55, y9-r); drawto(x55, y8+r)
  rndcorner(1, x54,  y9, r)
  rndcorner(0, x55,  y9, r)

  drawtestboxL(y8, x2+r, x3, x53, "MATCH EVERY")
  drawtestboxL(y8, x53, x53, x54, "(")
  drawcatboxC (y8, x54+r, (x54+x55)/2, x55-r, "E0")
  drawtestboxL(y8, x55, x56, x57, ")")
  drawcatboxL (y8, x57, x57, x27-r, "Mlist")
  rndcorner(2, x2,  y8, r)
  rndcorner(2, x54,  y8, r)
  rndcorner(3, x55,  y8, r)
  rndcorner(3, x27, y8, r)

  drawtestboxC(y7, x60+r, (x60+x62)/2, x62-r,",")
  drawtestboxC(y7, x64+r, (x64+x66)/2, x66-r,",")
  moveto(x60, y7-r); drawto(x60, y6+r)
  moveto(x62, y7-r); drawto(x62, y6+r)
  moveto(x64, y7-r); drawto(x64, y6+r)
  moveto(x66, y7-r); drawto(x66, y6+r)
  rndcorner(1, x60, y7, r)
  rndcorner(0, x62, y7, r)
  rndcorner(1, x64, y7, r)
  rndcorner(0, x66, y7, r)

  drawcatboxL (y6, x2+r, x3, x59, "E0")
  drawtestboxL(y6, x59, x59, x60, ",")
  drawcatboxC (y6, x60, (x60+x62)/2, x63, "E0")
  drawtestboxL(y6, x63, x63, x65, "assop")
  drawcatboxL (y6, x65, x65, x27-r, "E0")
  moveto(x58, y6-r); drawto(x58, y3+r)
  rndcorner(2, x2, y6, r)
  rndcorner(0, x58, y6, r)
  rndcorner(0, x58, y6, r)
  rndcorner(2, x60, y6, r)
  rndcorner(3, x62, y6, r)
  rndcorner(2, x64, y6, r)
  rndcorner(3, x66, y6, r)
  rndcorner(3, x27, y6, r)

  drawtestboxL(y5, x58+r, x63, x65, "assop")
  drawcatboxL (y5, x65, x65, x27-r, "E0")
  rndcorner(2, x58, y5,  r)
  rndcorner(3, x27, y5, r)

  drawtestboxL(y4, x58+r, x68, x27-r, "iscall")
  rndcorner(2, x58, y4,  r)
  rndcorner(3, x27, y4, r)

  drawtestboxL(y3, x58+r, x68, x70,   "isname")
  drawtestboxL(y3, x70,   x70, x72,   ":")
  drawcatboxL (y3, x72,   x72, x27-r, "C")
  moveto(x69, y3-r); drawto(x69, y1+r)
  moveto(x71, y3-r); drawto(x71, y2+r)
  moveto(x73, y3-r); drawto(x73, y2+r)
  rndcorner(2, x58, y3,  r)
  rndcorner(1, x69, y3,  r)
  rndcorner(0, x71, y3,  r)
  rndcorner(1, x73, y3,  r)
  rndcorner(3, x27, y3,  r)

  drawtestboxL(y2, x2+r, x3, x74,   "CASE")
  drawtestboxL(y2, x74, x74, x69-r, "E0")
  moveto(x71+r, y2); drawto(x73-r, y2)
  rndcorner(2, x2,  y2,  r)
  rndcorner(3, x69, y2, r)
  rndcorner(2, x71, y2, r)
  rndcorner(3, x73, y2, r)

  drawtestboxL(y1, x2+r, x3, x69-r, "DEFAULT")
  rndcorner(2, x2 , y1, r)
  rndcorner(3, x69, y1, r)

}


LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

