package trn;

import lib.*;
import err.*;
import tree.*;
import code.*;

public class Trn extends Lib {

    public static String procname = "<unset>";
    public static int resultlab;
    public static int comline;
    public static int labnumber;
    public static int ssp;

    public final static int Statvar  = 1; // Static variables
    public final static int Addr     = 2; // Functions and static vectors
    public final static int Local    = 3; // Local variables
    public final static int Localvec = 4; // Local vectors

    public static void init() {
	Dvec.init();
    }

    public static  void trnerr(String mess) throws Fatalerror {
	writes("Error");
	if(procname!=null) writes(" in "+procname);
	if(comline!=0)  writes(" near line "+comline);
	writes(":   "+mess+"\n");
	Err.errcount++;
	if(Err.errcount >= Err.errmax) Err.fatalerr("Too many errors");
    }


    public void trprog() throws Fatalerror {

	resultlab = -2;
	comline = 1;
	procname = null;
	labnumber = 1;
	ssp = 2;

	Code.outfl(Code.Laddr, 1); ssp++;  // 1 = lab number of start
	Code.outfn(Code.Fnap, 3);  ssp--;
	Code.outf(Code.Halt);

	declstatnames();
	Dvec.checkdistinct(1);
	trdecl();
	Code.resolvelabels();

	writes("Program size: "+(Code.codep-Code.codev)+
               "   Data size: "+(Code.datap-Code.datav)+"\n");
    }

    public void declstatnames() throws Fatalerror {
	writes("Compiler Error #####  Trn.declarestatnames called in "+this+"\n");
    }

    public void trdecl() throws Fatalerror {
	writes("Compiler Error #####  Trn.trdecl called in "+this+"\n");
    }

    public void decldyn() throws Fatalerror {
	writes("Compiler Error #####  Trn.decldyn called in "+this+"\n");
    }

    /** This compiles as the body of a function any expression node
     *  other than than ValofNodes for an optimisation is applied.
     */
    public void fnbody() throws Fatalerror {
	writes("Trn.fnbody called in "+this+"\n");
        load();
	Code.outf(Code.Fnrn);
	ssp--;
    }

    /** This function is overridden by the corresponding method in every
     *  command node and so this version is only called if there is a
     *  compiler error.

     *  @param next specifies what to generate after this node has been
     *              compiled. If next<0 generate a Rtrn instruction,
     *              if next>0 generate Jump next, and
     *              if next=0 generate nothing. 
     */
    public void trcom(int next) throws Fatalerror {
	writes("Compiler Error #####  Trn.trcom("+next+") called in "+
	       this+"\n");
    }

    public static void trnext(int next) throws Fatalerror {
	//writes("Trn.trnext("+next+") called\n");
	if(next<0) Code.outf(Code.Rtrn);
	if(next>0) Code.outfl(Code.Jump, next);
    }

    public void load() throws Fatalerror {
	writes("Compiler Error #####  Trn.load called in "+this+"\n");
    }

    /** This function compiles code to load the value of an expression
     *  whose leadinf operator is monadic.
     */
    public void load(int instr, Tree a) throws Fatalerror {
	a.load();
        Code.outf(instr);
    }

    /** This function compiles code to load the value of an expression
     *  whose leading operator is dyadic.
     */
    public void load(int instr, Tree a, Tree b) throws Fatalerror {
	a.load();
	b.load();
        Code.outf(instr);
	ssp--;
    }

    public void loadlist() throws Fatalerror {
	writes("Compiler Error #####  Trn.loadlist called in "+this+"\n");
    }

    /** This function compiles code to load the left hand value of an
     *  expression.  It is overridden in all the expression nodes that
     *  allow left hand evaluation, namely NameNode, IndNode and VecapNode.
     */
    public void loadlv() throws Fatalerror {
	writes("Compiler Error #####  Trn.loadlv called in "+this+"\n");
    }

    public void plist(String indent, int d) {
	writes("Compiler Error #####  Trn.plist called in "+this+"\n");
    }

    /** This is the default definition of jumpcond.
     *  It is overridden in any node that optimises the default
     *  translation.
     *
     *  jumpcond compiles code to evaluate the current expression
     *  and conditionally jump to label l on the result. If b is true
     *  the jump is made on true, otherwise on false. 
     */
    public void jumpcond(boolean b, int l) throws Fatalerror {
	//writes("Trn.jumpcond called in "+this+"\n");

	// This is the default case for expressions other
	// than True, False, Not, And and Or.
	load();
	Code.outfl(b ? Code.Jt : Code.Jf, l);
	ssp--;
    }

    public void assign(Tree y) throws Fatalerror {
	writes("Compiler Error #####  Trn.assign called in "+this+"\n");
    }

    public static void transname(IdNode x, int p, int l, int v, int a)
	throws Fatalerror {
	Cell cell = Dvec.cellwithname(x);
	int k = cell.k;
	int n = cell.n;
 
	switch(k) {
	default:
	    trnerr("Name '"+x.str+"' not declared");
   
	case Local:
	    Code.outfn(p, n); return;
 
	case Statvar:
	    Code.outfl(l, n); return;
 
	case Localvec:
	    if(v==0) {
		trnerr("Misuse of local vector '+x.str+'");
		v = p;
	    }
	    Code.outfn(v, n);
	    return;

	case Addr:
	    if(a==0) {
		trnerr("Misuse of entry name '"+x.str+"'");
		a = l;
	    }
	    Code.outfl(a, n);
	    return;
	}
    }
 

    /**  The function allocates the next available compile time
     *   label. It generates a fatal error if no more labels are
     *   available.
     *   @return the next available label.
     */
    public static int nextlab() throws Fatalerror {
	if(labnumber>=Code.labmax) Err.fatalerr("More label space needed");
	return ++labnumber;
    }
 }
