package tree;

import lib.*;
import err.*;
import lex.*;
import trn.*;
import code.*;


/** This represents a routine declaration.
 */
public class RtdefNode extends N3n {

    public RtdefNode(Tree a, Tree b, Tree c, int ln) {
	super(a, b, c, ln);
    }

    public void plist(String indent, int n) {
	pl("Rtdef", indent, n);
    }

    public void declstatnames() throws Fatalerror {
	//writes("RtdefNode.declarestatnames called\n");
	IdNode name = (IdNode)a;
	int lab = name==Nametab.namestart ? 1 : nextlab();
	Dvec.addname(name, Addr, lab);
    }

    public void trdecl() throws Fatalerror{
	//writes("RtdefNode.trdecl called\n");
	int e = Dvec.dvece;
	IdNode name = (IdNode)a;
	Cell t = Dvec.cellwithname(name);
	int strlab = nextlab();

	resultlab = -2;
	procname = name.str;

	Code.outstring(strlab, procname);
	Code.outentry(t.n, strlab);
	ssp = 2;
	b.decldyn();  // Declare the formal paramenters
	Dvec.checkdistinct(e);
	Code.outfn(Code.Stack, ssp);
	c.trcom(-1);
	Dvec.undeclare(e);
	procname = "";
    }
}

