package tree;

import lib.*;
import err.*;
import code.*;

public class IfNode extends N2n {

    public IfNode(Tree a, Tree b, int ln) {
	super(a, b, ln);
    }

    public void plist(String indent, int n) {
	pl("If", indent, n);
    }

    public void trcom(int next) throws Fatalerror {
	//writes("IfNode.trcom called\n");
	comline = ln;
	if(next>0) {
	    a.jumpcond(false, next);
	    b.trcom(next);
	} else {
	    int l = nextlab();
	    a.jumpcond(false, l);
	    b.trcom(next);
	    Code.outlab(l);
	    trnext(next);
	}
    }

}
