package tree;

import lib.*;
import err.*;
import lex.*;
import trn.*;
import code.*;

public class IdNode extends Tree {
    // This node represts an identifier and is also used
    // during the recognition of restved words.
    public int tok;   // Holds Name or the token of a reserved word.
    public IdNode link;
    public int hint;  // Either 0 or a subscript into the declaration vector.
    public String str;

    public IdNode(IdNode link, String str) {
	tok = Lex.Name;
	this.link = link;
        hint = 0;
	this.str = str;
    }

    public void plist(String indent, int n) {
	writes(str+"\n");
    }

    public void declstatnames() throws Fatalerror {
	//writes("IdNode.declarestatnames called for "+str+"\n");
	int lab =  nextlab();
	Code.outvar(lab);
	Dvec.addname(this, Statvar, lab);
    }

    public void decldyn() throws Fatalerror {
	//writes("IdNode.decldyn called for "+str+"\n");
	Dvec.addname(this, Local, ++ssp);
    }

    public void assign(Tree y) throws Fatalerror {
	//writes("IdNode.assign called for "+str+"\n");
	y.load();
	transname(this, Code.Sp, Code.Sl, 0, 0);
	ssp--;
    }

    public void load() throws Fatalerror {
	//writes("IdNode.load called for "+str+"\n");
	transname(this, Code.Lp, Code.Ll, Code.Llp, Code.Laddr);
	ssp++;
    }

    public void loadlv() throws Fatalerror {
	//writes("IdNode.loadlv called for "+str+"\n");
	transname(this, Code.Llp, Code.Laddr, 0, 0);
	ssp++;
    }

    public void loadlist() throws Fatalerror {
	//writes("IdNode.loadlist called for "+str+"\n");
	load();
    }
}
