package tree;

import lib.*;
import err.*;
import lex.*;
import trn.*;
import code.*;

/** This represents a function declaration.
 */
public class FndefNode extends N3n {

    public FndefNode(Tree a, Tree b, Tree c, int ln) {
	super(a, b, c, ln);
    }

    public void plist(String indent, int n) {
	pl("Fndef", indent, n);
    }

    public void declstatnames() throws Fatalerror {
	//writes("FndefNode.declarestatnames called\n");
	IdNode name = (IdNode)a;
	int lab = name==Nametab.namestart ? 1 : nextlab();
	Dvec.addname(name, Addr, lab);
    }

    public void trdecl() throws Fatalerror{
	//writes("FndefNode.trdecl called\n");
	int e = Dvec.dvece;
	IdNode name = (IdNode)a;
	Cell t = Dvec.cellwithname(name);
	int strlab = nextlab();

	resultlab = -2;
	procname = name.str;

	Code.outstring(strlab, procname);
	Code.outentry(t.n, strlab);
	ssp = 2;
	b.decldyn();  // Declare the formal paramenters
	Dvec.checkdistinct(e);
	Code.outfn(Code.Stack, ssp);
	c.fnbody();
	Dvec.undeclare(e);
	procname = "";
    }
}

