package tree;

import lib.*;
import err.*;
import code.*;

/** This represents the and operator. 
 */

public class AndNode extends N2 {

    public AndNode(Tree a, Tree b) {
	super(a, b);
    }

    public void load() throws Fatalerror {
	//writes("AndNode.load called\n");
	load(Code.And, a, b);
    }

    public void jumpcond(boolean sw, int l) throws Fatalerror {
	writes("AndNode.jumpcond called\n");
	if(!sw) {
	    a.jumpcond(sw, l);
	    b.jumpcond(sw, l);
	} else {
	    int m = nextlab();
	    a.jumpcond(!sw, m);
	    b.jumpcond(sw,  l);
	    Code.outlab(m);
	}
    }

    public void plist(String indent, int n) {
	pl("And", indent, n);
    }

}

