package syn;

import lib.*;
import err.*;
import args.*;
import tree.*;
import lex.*;
import trn.*;

public class Syn extends Lib {
    // The Parser.
    static Tree nilnode = new NilNode();

    public static void init() {
	//writes("Syn.init called\n");
    }

    public static Tree formtree() throws Fatalerror {
	Tree res=nilnode;

	try {

	    Lex.lex();

	    while(Args.optTokens) {            // For debugging lex.
		if(Lex.token==Lex.Eof)    return res;
		System.out.print("token = "+Lex.token+" "+Lex.opstr(Lex.token));
		if(Lex.token==Lex.Num)
		    System.out.print("        "+  Lex.lexval);
		if(Lex.token==Lex.Name)
		    System.out.print("       "+Nametab.wordnode.str);
		if(Lex.token==Lex.String)
		    System.out.print("     \""+ Lex.charv+"\"");
		newline();
		Lex.lex();
	    }
	    res = rdprog();
	    //if (Lex.token!=Lex.Eof) Err.fatalerr("Incorrect termination");
	} catch (Softerror e) {
	    //System.out.println("\nException Error caught in formtree");
	}

	return res;
    }

    public static void synerr(String mess) throws Fatalerror, Softerror {
	writes("\nError near line "+ Lex.lineno + ": "+mess+"\n");
	Lex.wrchbuf();
	Err.errcount++;
	if(Err.errcount >= Err.errmax) Err.fatalerr("Too many errors");

	// Skip the rest of the input line 
	Lex.skip_to_eol();
	Lex.lex();

	throw new Softerror();
    }
   
    public static void checkfor(int tok, String mess) throws Fatalerror, Softerror {
	if(Lex.token!=tok) synerr(mess);
	Lex.lex();
    }
 
    public static Tree rdprog() throws Fatalerror, Softerror {
	Tree res=nilnode;
	int ln = Lex.lineno;
	switch(Lex.token) {
	default:
	    synerr("Bad outer level declaration\n");

	case Lex.Eof:
	    res = nilnode; break;

	case Lex.Static:
	    {
		Tree d;
		Lex.lex();
		d = new StaticNode(rstatlist(), ln);
		return  new DeclNode(d, rdprog());
	    }

	case Lex.Let:
	    {
		Tree n;
		Tree args;
		Lex.lex();
		n = rname();
		checkfor(Lex.Lparen, "'(' missing");
		if(Lex.token==Lex.Name) args = rnamelist();
		else                    args = nilnode;
		checkfor(Lex.Rparen, "')' missing");
 
		if(Lex.token==Lex.Be) {
		    Tree d = new RtdefNode(n, args, rncom(), ln);
		    return new DeclNode(d, rdprog());
		}
 
		if(Lex.token==Lex.Eq) {
		    Tree d = new FndefNode(n, args, rnexp(0), ln);
		    return new DeclNode(d, rdprog());
		}
 
		synerr("Bad procedure heading");
	    }
	}
	return res;
    }

    public static Tree rdblockbody() throws Fatalerror, Softerror {
	Tree res;
	//jmp_buf *rl = reclabel;

	while(true) {
	    try {
		int op = Lex.token;

		switch(op) {
		default:
		    res = rdseq();
		    break;

		case Lex.Let:
		case Lex.Vec:
		    {
			Tree n;
			Tree e;
			int ln = Lex.lineno;
			Lex.lex();
			n = rname();
			if(op==Lex.Let) {
			    checkfor(Lex.Eq, "Missing '='");
			    e = rexp(0);
			} else {
			    checkfor(Lex.Lsquare, "Missing '['");
			    e = rexp(0);
			    if(!(e instanceof NumNode))
				synerr("Bad 'vec' declaration");
			    checkfor(Lex.Rsquare, "Missing ']'");
			}
			checkfor(Lex.Semicolon, "';' expected");
			if(op==Lex.Let)
			    res = new LetNode(n, e, rdblockbody(), ln);
			else
			    res = new VecNode(n, e, rdblockbody(), ln);
			break;
		    }
		}
	    } catch (Softerror e) {
		continue;
	    }
	    return res;
	}
    }
 
    private static Tree rdseq() throws Fatalerror, Softerror {
	Tree a = rcom();
	if(Lex.token==Lex.Rcurly || Lex.token==Lex.Eof) return a;
	checkfor(Lex.Semicolon, "';' expected");
	return new SeqNode(a, rdseq());
    }

    private static Tree rnamelist() throws Fatalerror, Softerror {
	Tree a = rname();
	if(Lex.token!=Lex.Comma) return a;
	Lex.lex();
	return new CommaNode(a, rnamelist());
    }

    private static Tree rexplist() throws Fatalerror, Softerror {
	Tree a = rexp(0);
	if(Lex.token!=Lex.Comma) return a;
	Lex.lex();
	return new CommaNode(a, rexplist());
    }
 
    private static Tree rstatlist() throws Fatalerror, Softerror {
	Tree a = rname();
	if(Lex.token==Lex.Lsquare) {
	    Tree b = rnexp(0);
	    if(!(b instanceof NumNode)) synerr("Number expected");
	    checkfor(Lex.Rsquare, "']' expected");
	    a = new StatvecNode(a, b);
	}
	if(Lex.token!=Lex.Comma) return a;
	Lex.lex();
	return new CommaNode(a, rstatlist());
    }

    private static Tree rname() throws Fatalerror, Softerror {
	Tree a = Nametab.wordnode;
	checkfor(Lex.Name, "Name expected");
	return a;
    }
 
    private static Tree rbexp() throws Fatalerror, Softerror {
	Tree a;
	int op = Lex.token;
	int ln = Lex.lineno;
 
	switch(op) {
 
	default:
	    synerr("Error in Expression");

	case Lex.Name:
	    a = Nametab.wordnode;
	    Lex.lex();
	    return a;
 
	case Lex.True:
	    Lex.lex();
	    return new TrueNode();

	case Lex.False:
	    Lex.lex();
	    return new FalseNode();

	case Lex.String:
	    a = new StringNode(Lex.charv);
	    Lex.lex();
	    return a;
 
	case Lex.Num:
	    a = new NumNode(Lex.lexval);
	    Lex.lex();
	    return a;
 
	case Lex.Printf:
	case Lex.Sys:
	    Lex.lex();
	    checkfor(Lex.Lparen, "'(' missing");
	    a = rexplist();
	    checkfor(Lex.Rparen, "')' missing");
	    if(op==Lex.Printf) {
		return new PrintfNode(a, ln);
	    } else {
		return new SysNode(a, ln);
	    }

	case Lex.Lparen:
		a = rnexp(0);
		checkfor(Lex.Rparen, "')' missing");
		return a;
 
	case Lex.Valof:
	    return new ValofNode(rncom());
 
	case Lex.Ind:
	    return new IndNode(rnexp(8));

	case Lex.Lv:
	    return new LvNode(rnexp(8));

	case Lex.Add:
	    return rnexp(6);
 
	case Lex.Sub:
	    a = rnexp(6);
	    if(a instanceof NumNode)
		((NumNode)a).k = - ((NumNode)a).k;
	    else
		a = new NegNode(a);
	    return a;
 
	case Lex.Not:
	    return new NotNode(rnexp(3));
	}
    }
 
    private static Tree rnexp(int n) throws Fatalerror, Softerror {
	Lex.lex(); return rexp(n);
    }
 
    private static Tree rexp(int n) throws Fatalerror, Softerror {
	Tree a=rbexp();
	Tree b;
	int p = 0;

	while(true) {
	    int op = Lex.token;
	    int ln = Lex.lineno;
	    switch(op) {
 
	    default:
		return a;
 
	    case Lex.Lparen:
		Lex.lex();
		if(Lex.token!=Lex.Rparen) b = rexplist();
		else b = null;
		checkfor(Lex.Rparen, "')' missing");
		a = new FnapNode(a, b, ln);
		continue;
 
	    case Lex.Lsquare:
		b = rnexp(0);
		checkfor(Lex.Rsquare, "']' missing");
		a = new VecapNode(a, b);
		continue;
 
	    case Lex.Mul:
		if(n>=7) return a;
		a = new MulNode(a, rnexp(7));
		continue;

	    case Lex.Div:
		if(n>=7) return a;
		a = new DivNode(a, rnexp(7));
		continue;

	    case Lex.Mod:
		if(n>=7) return a;
		a = new ModNode(a, rnexp(7));
		continue;

	    case Lex.Add:
		if(n>=6) return a;
		a = new AddNode(a, rnexp(6));
		continue;

	    case Lex.Sub:
		if(n>=6) return a;
		a = new SubNode(a, rnexp(6));
		continue;

	    case Lex.Lsh:
		if(n>=5) return a;
		a = new LshNode(a, rnexp(5));
		continue;

	    case Lex.Rsh:
		if(n>=5) return a;
		a = new RshNode(a, rnexp(5));
		continue;

	    case Lex.Eq:
		if(n>=4) return a;
		a = new EqNode(a, rnexp(4));
		continue;

	    case Lex.Le:
		if(n>=4) return a;
		a = new LeNode(a, rnexp(4));
		continue;

	    case Lex.Lt:
		if(n>=4) return a;
		a = new LtNode(a, rnexp(4));
		continue;

	    case Lex.Ne:
		if(n>=4) return a;
		a = new NeNode(a, rnexp(4));
		continue;

	    case Lex.Ge:
		if(n>=4) return a;
		a = new GeNode(a, rnexp(4));
		continue;

	    case Lex.Gt:
		if(n>=4) return a;
		a = new GtNode(a, rnexp(4));
		continue;

	    case Lex.And:
		if(n>=3) return a;
		a = new AndNode(a, rnexp(3));
		continue;

	    case Lex.Or:
		if(n>=2) return a;
		a = new OrNode(a, rnexp(2));
		continue;

	    case Lex.Xor:
		if(n>=1) return a;
		a = new XorNode(a, rnexp(1));
		continue;
	    }
      	}
    }
  
    private static Tree rcom() throws Fatalerror, Softerror {
	Tree n;
	Tree a;
	Tree b;
	int op = Lex.token;
	int ln = Lex.lineno;
 
	switch(Lex.token) {
	default:
	    synerr("Command expected");
 
	case Lex.Name:case Lex.Num:case Lex.Lparen:case Lex.Ind:
	case Lex.Sys:case Lex.Printf:
	    // All tokens that can start an expression.
	    a = rexp(0);
 
	    if(Lex.token==Lex.Assign) {
		if(! (a instanceof IdNode) &&
                   ! (a instanceof VecapNode)  &&
                   ! (a instanceof IndNode))
		    synerr("Bad assigment statement "+a);
		return new AssignNode(a, rnexp(0), ln);
	    }
 
	    if(a instanceof FnapNode) {
		FnapNode f = (FnapNode)a;
		return new RtapNode(f.a, f.b, f.ln);
	    }
 
	    if(a instanceof SysNode || a instanceof PrintfNode)
		return a;
	    synerr("Error in command");
	    return a;
 
	case Lex.Resultis:
	    return new ResultisNode(rnexp(0), ln);
 
	case Lex.If:
	    a = rnexp(0);
	    checkfor(Lex.Do, "'do' missing");
	    return new IfNode(a, rcom(), ln);
 
	case Lex.Unless:
	    a = rnexp(0);
	    checkfor(Lex.Do, "'do' missing");
	    return new UnlessNode(a, rcom(), ln);
 
	case Lex.While:
	    a = rnexp(0);
	    checkfor(Lex.Do, "'do' missing");
	    return new WhileNode(a, rcom(), ln);
 
	case Lex.Until:
	    a = rnexp(0);
	    checkfor(Lex.Do, "'do' missing");
	    return new UntilNode(a, rcom(), ln);
 
	case Lex.Test:
	    a = rnexp(0);
	    checkfor(Lex.Then, "'then' missing");
	    b = rcom();
	    checkfor(Lex.Else, "'else' missing");
	    return new TestNode(a, b, rcom(), ln);
 
	case Lex.For:
	    Lex.lex();
	    n = rname();
	    checkfor(Lex.Eq, "'=' expected");
	    a = rexp(0);
	    checkfor(Lex.To, "'to' expected");
	    b = rexp(0);
	    checkfor(Lex.Do, "'do' missing");
	    return new ForNode(n, a, b, rcom(), ln);

	case Lex.Return:
	    Lex.lex();
	    return new ReturnNode(ln);
 
	case Lex.Lcurly:
	    Lex.lex();
	    a = rdblockbody();
	    checkfor(Lex.Rcurly, "'}' expected");
	    return a;
	}
    }

    private static Tree rncom() throws Fatalerror, Softerror {
	Lex.lex(); return rcom();
    }
}
