/**

This is intended to be a fully object oriented implementation of VSPL,
using several packages and plenty of object oriented features.
The packages are:

Args       To read and hold the command arguments.
Tree       To represent the parse tree. It contains the class Tree
           which is the super class of all tree nodes.
Lex        The lexical analyser and nametable.
Syn        The syntax analyser.
Trn        The translation phase.
Code       To assemble and then execute the interpretive code.
Lib        This mainly holds input/output functions.

Implemented in Java by Martin Richards (c) March 2006
*/

import lib.*;
import err.*;
import args.*;
import lex.*;
import syn.*;
import trn.*;
import tree.*;
import code.*;

/**
 * This is intended to be a fully object oriented implementation of VSPL,
 * using several packages and plenty of object oriented features.
 */
public class VSPL extends Lib {

/** The is the main function of the VSPL compiler and interpreter.
 *  @param    argv The VSPL command arguments
*/
    public static void main(String[] argv) {
	init_lib();

	try {
	    writes(
              "VSPL (4 Mar 2006) Java Object Oriented Version\n");

	    // Get the VSPL command arguments.
	    Args.getArgs(argv);

	    if(Args.progfilename==null) {
		writes("No source filename given\n");
		return;
	    }

	    selectinput(findinput(Args.progfilename));
	    if(cis==null)
		Err.fatalerr("Trouble with input file "+Args.progfilename);

	    Tree.init();
	    Lex.init();
	    Syn.init();
	    Trn.init();
	    Code.init();

	    // Perform syntax analysis to produce the parse tree.
	    Tree tree = Syn.formtree();

	    if(Args.optTokens) return;

	    if(Args.optTree) {
		writes("Parse Tree\n");
		tree.plist("", 20);
	    }

	    // Translate the parse tree into interpretive code.
	    tree.trprog();

	    // Execute the interpretive code.
	    Code.start_interpreting();

	} catch(Fatalerror e) {
	    writes("Fatal Error: Run aborted");
	}
    }
}
