/*
   The header file for the flex/bison version of VSPL
*/

#define maxint       0x7FFFFFFF
#define nametablesize 541
#define c_tab           9
#define c_newline      10

/* Lexical tokens, parse tree operators and op-codes */

typedef int Tok;
/*
typedef enum Tok {
Num=1, Name, String, True, False,
Valof, Fnap, Lv, Ind, Vecap,
Neg, Not, Mul, Div, Mod, Add, Sub,
Eq, Ne, Le, Ge, Lt, Gt, Lsh, Rsh, And, Or, Xor,
Comma, Fndef, Rtdef, Assign, Rtap, Return,
Test, If, Unless, While, Until, For, Resultis, Seq,
Let, Vec, Static, Statvec, Decl, Var,
Lparen, Rparen, Lsquare, Rsquare, Lcurly, Rcurly,
To, Do, Then, Else, Be, Eof, Semicolon,
Rtrn, Fnrn, Addr, Local, Lab, Data, Jt, Jf, Jump,
Ln, Lp, Llp, Ll, Laddr, Sp, Sl, Stind, Lres,
Entry, Stack, Printf, Sys, Halt
} Tok;
*/

/* Struct definitions for the parse tree */

typedef struct Id   Id;
typedef struct Int  Int;
typedef struct Str  Str;
typedef struct N1   N1;
typedef struct N2   N2;
typedef struct N3   N3;
typedef struct N4   N4;
typedef struct N1n  N1n;
typedef struct N2n  N2n;
typedef struct N3n  N3n;
typedef struct N4n  N4n;
typedef struct N5n  N5n;
typedef struct Cell Cell;

typedef union Tree {
  Id  *I;
  Int *K;
  Str *S;
  N1  *N1;
  N2  *N2;
  N3  *N3;
  N4  *N4;
  N1n *N1n;
  N2n *N2n;
  N3n *N3n;
  N4n *N4n;
  N5n *N5n;
  Cell *Cell;
} Tree;

struct Id  { Tok op; Tree link; char *str; };
struct Int { Tok op; int  k; };
struct Str { Tok op; char *str; };
struct N1  { Tok op; };
struct N2  { Tok op; Tree a; };
struct N3  { Tok op; Tree a; Tree b; };
struct N4  { Tok op; Tree a; Tree b; Tree c; };
struct N1n { Tok op; int ln; };
struct N2n { Tok op; Tree a; int ln; };
struct N3n { Tok op; Tree a; Tree b; int ln; };
struct N4n { Tok op; Tree a; Tree b; Tree c; int ln; };
struct N5n { Tok op; Tree a; Tree b; Tree c; Tree d; int ln; };
struct Cell { Tree name; Tok k; int n; };

extern Tree mkId (Tok op, Tree link, char *str);
extern Tree mkInt(Tok op, int k);
extern Tree mkStr(Tok op, char *str);
extern Tree mkNull();
extern Tree mk1  (Tok op);
extern Tree mk2  (Tok op, Tree a);
extern Tree mk3  (Tok op, Tree a, Tree b);
extern Tree mk4  (Tok op, Tree a, Tree b, Tree c);
extern Tree mk1n (Tok op, int ln);
extern Tree mk2n (Tok op, Tree a, int ln);
extern Tree mk3n (Tok op, Tree a, Tree b, int ln);
extern Tree mk4n (Tok op, Tree a, Tree b, Tree c, int ln);
extern Tree mk5n (Tok op, Tree a, Tree b, Tree c, Tree d, int ln);


/* extern jmp_buf *reclabel, *finlabel; */

extern void fatalerr(char *);
extern void fatalerrs(char *, char *);
extern void synerr(char *);
extern void synerrn(char *, int);
extern void trnerr(char *);
extern void trnerrs(char *, char *);
extern void trnerrn(char *, int);
extern int  errcount, errmax;
extern FILE *progstream, *tostream;


extern int intval;
extern char *charv;
extern char strv[];
extern char *strp, *strt;
extern int chcount, lineno;


extern Tree nametable[];
extern Tree lookupword(char *word);
extern Tree parsetree;

extern void plist(Tree, int, int);




