%{

#include <stdio.h>
#include "vspl.h"
#include "parser.h"

%}

comment      "//".*
delimiter    [ \t]
whitespace   {delimiter}+
uc_letter    [A-Z]
lc_letter    [a-z]
name         {letter}({letter}|{digit}|'_')*
letter       {lc_letter}|{uc_letter}
ascii_char   [^\"\n]
escaped_char \\n|\\\"
digit        [0-9]
number       {digit}+
string_char  {ascii_char}|{escaped_char}
string       \"({string_char})*\"
char_const   \'{string_char}\'

%%

{comment}     /* ignore comments */
{whitespace}  /* ignore white space */ 
{number}      { intval=atoi(yytext); return Num; }

{string}      { int i=1, ch;
                charv = strp;
                while(1) {
                  ch = yytext[i++];
                  if(ch=='"') break;
                  if(ch=='\\') {
                    ch=yytext[i++];
                    if(ch=='n') ch='\n';
                  }
                  *strp++ = ch;
                }
                *strp++ = 0;
                return String;
              }

{char_const}  { intval=yytext[0];
                if(intval=='\\') { intval = yytext[1];
                                   if(intval=='n') intval='\n';
                                 }
                return Num;
              }

"+"           return Add;
"-"           return Sub;
"*"           return Mul;
"/"           return Div;
"%"           return Mod;
"!"           return Ind;
"@"           return Lv;
","           return Comma;
";"           return Semicolon;
"~"           return Not;
"&"           return And;
"|"           return Or;
"="           return Eq;
"~="          return Ne;
"<"           return Lt;
"<="          return Le;
">"           return Gt;
">="          return Ge;
"^"           return Xor;
"<<"          return Lsh;
">>"          return Rsh;
":="          return Assign;
"("           return Lparen;
")"           return Rparen;
"["           return Lsquare;
"]"           return Rsquare;
"{"           return Lcurly;
"}"           return Rcurly;

be            return Be;
do            return Do;
else          return Else;
false         return False;
if            return If;
for           return For;
let           return Let;
mod           return Mod;
printf        return Printf;
resultis      return Resultis;
return        return Return;
static        return Static;
sys           return Sys;
test          return Test;
to            return To;
true          return True;
then          return Then;
valof         return Valof;
vec           return Vec;
unless        return Unless;
until         return Until;
while         return While;

{name}        return Name;

\n            lineno++;

%%

/* Support code */



