
%{
/* This is a preliminary version of the VSPL parser (in Bison).
   The syntax error handling of this parser needs 
   considerable improvement! There are currently 55 shift/reduce
   conflicts and 1 reduce/reduce conflict remaining.
*/

#include <stdio.h>
#include "vspl.h"

extern char *yytext;
%}

%union
{ int i;
  Tree tree;
}

%token  Num
%token  Name
%token  String
%token  True
%token  False
%token  Fnap
%token  Neg
%token  Vecap
%token  Fndef
%token  Rtdef
%token  Assign
%token  Rtap
%token  Return
%token  Test
%token  If
%token  Unless
%token  While
%token  Until
%token  For
%token  Resultis
%token  Seq
%token  Let
%token  Vec
%token  Static
%token  Statvec
%token  Decl
%token  Var
%token  Lparen
%token  Rparen
%token  Lsquare
%token  Rsquare
%token  Lcurly
%token  Rcurly
%token  To
%token  Do
%token  Then
%token  Else
%token  Be
%token  Semicolon
%token  Rtrn
%token  Fnrn
%token  Addr
%token  Local
%token  Lab
%token  Data
%token  Jt
%token  Jf
%token  Jump
%token  Ln
%token  Lp
%token  Llp
%token  Ll
%token  Laddr
%token  Sp
%token  Sl
%token  Stind
%token  Lres
%token  Entry
%token  Stack
%token  Printf
%token  Sys
%token  Halt


%type <tree> program
%type <tree> decl decl_list
%type <tree> name name_list
%type <tree> com com_seq
%type <tree> bexpr expr
%type <tree> expr_list
%type <tree> stat_list
%type <tree> stat_decl
%type <tree> block_body
%type <tree> num

%left Semicolon
%left Assign
%left Comma
%left Xor
%left Or
%left And
%left Not
%left Eq Ne Lt Le Gt Ge
%left Lsh Rsh
%left Add Sub
%left Mul Div Mod
%right Ind Lv Valof
%left Lparen Rparen Lsquare Rsquare

%%

program:

decl_list                 { parsetree = $1; }
;

decl_list:

decl                      { $$ = mk3(Decl, $1, mkNull()); }
|
decl decl_list            { $$ = mk3(Decl, $1, $2); }
;

name:

Name                      { if(strlen(yytext)>255) yyerror("name too long\n");
                            $$ = lookupword(yytext); }
;

num:

Num                       { $$ = mkInt(Num, intval); }
;

name_list:

name                      { $$ = $1; }
|
name Comma name_list      { $$ = mk3(Comma, $1, $3); }
;

decl:

Static { $<i>$ = lineno; } stat_list
                          { $$ = mk2n(Static, $3, $<i>2); }
|
Static error              { yyerror("Bad Static declaration"); }
|
Let name Lparen Rparen Be { $<i>$ = lineno; } com
                          { $$ = mk4n(Rtdef, $2, mkNull(), $7, $<i>6); }
|
Let name Lparen name_list Rparen Be { $<i>$ = lineno; } com 
                          { $$ = mk4n(Rtdef, $2, $4, $8, $<i>7); }
|
Let name Lparen Rparen Eq { $<i>$ = lineno; } expr
                          { $$ = mk4n(Fndef, $2, mkNull(), $7, $<i>6); }
|
Let name Lparen name_list Rparen Eq { $<i>$ = lineno; } expr
                          { $$ = mk4n(Fndef, $2, $4, $8, $<i>7); }
|
Let name Lparen name_list Rparen error { $<i>$ = lineno; } 
                          { yyerror("Bad procedure heading"); }
|
Let name Lparen name_list error { $<i>$ = lineno; } 
                          { yyerror("')' missing"); }
|
Let name error { $<i>$ = lineno; } 
                          { yyerror("'(' missing"); }
|
Let error { yyerror("Bad Let declation"); }
|
error { yyerror("Bad Let declation"); }
;

stat_list:

stat_decl                 { $$ = $1; }
|
stat_decl Comma stat_list { $$ = mk3(Comma, $1, $3); }
|
stat_decl Comma error     { yyerror("Bad Static declaration"); }
;

stat_decl:

name                      { $$ = $1; }
|
name Lsquare num Rsquare  { $$ = mk3(Statvec, $1, $3); }
;

expr_list:

expr                      { $$ = $1; }
| expr Comma expr_list    { $$ = mk3(Comma, $1, $3); }
;

bexpr:

True                      { $$ = mk1(True); }
|
False                     { $$ = mk1(False); }
|
name                      { $$ = $1; }
|
num                       { $$ = $1; }
|
String                    { if(strlen(strv)>255)
                              yyerror("String too long\n");
                            $$ = mkStr(String, charv); }
|
Printf { $<i>$=lineno; } Lparen expr_list Rparen
                          { $$ = mk2n(Printf, $4, $<i>2); }
|
Sys { $<i>$=lineno; } Lparen expr_list Rparen
                          { $$ = mk2n(Sys, $4, $<i>2); }
|
Lparen expr Rparen        { $$ = $2; }
|
Valof com                 { $$ = mk2(Valof, $2); }
|
Ind expr                  { $$ = mk2(Ind, $2); }
|
Lv expr                   { $$ = mk2(Lv, $2); }
|
Add expr                  { $$ = $2; }
|
Sub expr                  { if($2.N2->op==Num) {
                              $2.K->k = - $2.K->k;
                              $$ = $2;
                            } else {
                              $$ = mk2(Neg, $2);
                            }
                          }
|
Not expr                  { $$ = mk2(Not, $2); }
;

expr:

bexpr                             { $$ = $1; }
|
expr Lparen Rparen                { $$ = mk3n(Fnap, $1, mkNull(), lineno); }
|
expr Lparen expr_list Rparen
                                  { $$ = mk3n(Fnap, $1, $3, lineno); }
|
expr Lsquare expr Rsquare
                                  { $$ = mk3(Vecap, $1, $3); }
|
expr Mul expr                     { $$ = mk3(Mul, $1, $3); }
|
expr Div expr                     { $$ = mk3(Div, $1, $3); }
|
expr Mod expr                     { $$ = mk3(Mod, $1, $3); }
|
expr Add expr                     { $$ = mk3(Add, $1, $3); }
|
expr Sub expr                     { $$ = mk3(Sub, $1, $3); }
|
expr Lsh expr                     { $$ = mk3(Lsh, $1, $3); }
|
expr Rsh expr                     { $$ = mk3(Rsh, $1, $3); }
|
expr Eq expr                      { $$ = mk3(Eq, $1, $3); }
|
expr Ne expr                      { $$ = mk3(Ne, $1, $3); }
|
expr Le expr                      { $$ = mk3(Le, $1, $3); }
|
expr Lt expr                      { $$ = mk3(Lt, $1, $3); }
|
expr Ge expr                      { $$ = mk3(Ge, $1, $3); }
|
expr Gt expr                      { $$ = mk3(Gt, $1, $3); }
|
expr And expr                     { $$ = mk3(And, $1, $3); }
|
expr Or expr                      { $$ = mk3(Or, $1, $3); }
|
expr Xor expr                     { $$ = mk3(Xor, $1, $3); }
;

com:

expr Assign {$<i>$=lineno;} expr %prec Semicolon
                                  { $$ = mk3n(Assign, $1, $4, $<i>3 ); }
|
expr %prec Semicolon              { if($1.N1->op==Fnap) $1.N1->op=Rtap;
                                       $$=$1;
                                  }
|
Resultis {$<i>$=lineno;} expr %prec Semicolon
                                  { $$ = mk2n(Resultis, $3, $<i>2); }
|
If {$<i>$=lineno;} expr Do com    { $$ = mk3n(If, $3, $5, $<i>2); }
|
Unless {$<i>$=lineno;} expr Do com
                                  { $$ = mk3n(Unless, $3, $5, $<i>2); }
|
While {$<i>$=lineno;} expr Do com
                                  { $$ = mk3n(While, $3, $5, $<i>2); }
|
Until {$<i>$=lineno;} expr Do com
                                  { $$ = mk3n(Until, $3, $5, $<i>2); }
|
Test {$<i>$=lineno;} expr Then com Else com
                                  { $$ = mk4n(Test, $3, $5, $7, $<i>2); }
|
For {$<i>$=lineno;} name Eq expr To expr Do com
                                  { $$ = mk5n(For, $3, $5, $7, $9, $<i>2); }
|
Return {$<i>$=lineno;}            { $$ = mk1n(Return, $<i>2); }
|
Lcurly block_body Rcurly          { $$ = $2; }
;

block_body:

Let name Eq { $<i>$=lineno; } expr Semicolon block_body
                                  { $$ = mk4n(Let, $2, $5, $7, $<i>4); }
|
Let error                         { yyerror("Bad 'let' declaration"); }
|
Vec name Lsquare num {$<i>$=lineno;} Rsquare Semicolon block_body
                                  { $$ = mk4n(Vec, $2, $4, $8, $<i>2); }
|
Vec name Lsquare num error        { yyerror("Missing ']'"); }
|
Vec name error                    { yyerror("Missing '['"); }
|
Vec error                         { yyerror("Bad vec declaration"); }
|
com_seq                           { $$ = $1; }
;

com_seq:

com                               { $$ = $1; }
|
com Semicolon com_seq             { $$ = mk3(Seq, $1, $3); }
;

  
%%

 /*
 Support routines
 */


int yyerror(char *str) {
  printf("yyerror: %s\n", str);
  return 0;
}
