// This is a VSPL encoding of David Wheeler's tea encryption algorithm

// Martin Richards  5 April 2000

static kt[4], data[1000], DELTA

let MX(z, y, p, e, sum, k) = (z>>5 ^ y<<2) + (z<<4 ^ y>>3)    ^
                             (sum ^ y) + (k[p&3 ^ e] ^ z)


let encrypt(v, n, k) be  // precondition: n>1
{ let sum = DELTA;

  for i = 1 to 6 + 52/n do
  { let e = sum>>2 & 3;
    v[0]     := v[0]     + MX(v[n-1], v[1],       0, e, sum, k);
    for p = 1 to n-2 do
      v[p]   := v[p]     + MX(v[p-1], v[p+1],   p, e, sum, k);
    v[n-1] := v[n-1] + MX(v[n-2], v[0],     n-1, e, sum, k);
    sum := sum + DELTA
  }
}

let decrypt(v, n, k) be // precondition: n>1
{ let sum = (6 + 52/n) * DELTA;
  while sum do
  { let e = sum>>2 & 3;
    let p = n-2;
    v[n-1] := v[n-1] - MX(v[n-2], v[0],     n-1, e, sum, k);
    while p>0 do
    { v[p]   := v[p]     - MX(v[p-1], v[p+1],   p, e, sum, k);
      p := p-1
    };
    v[0]     := v[0]     - MX(v[n-1], v[1],       0, e, sum, k);
    sum := sum - DELTA
  }
}

let start() = valof
{ printf("Testing DJW's tea encryption algorithm\n");
  for i=0 to 1000 do data[i] := i;
  kt[0] := 3;
  kt[1] := 2;
  kt[2] := 1;
  kt[3] := 0;

  DELTA := -1640531527; // #x9e3779b9;

  printf("\nKey Table\n");      pr(kt, 4);

  printf("\nRaw data\n");       pr(data, 32);

  encrypt(data, 1000, kt);

  printf("\nEncrypted data\n"); pr(data, 32);

  decrypt(data, 1000, kt);

  printf("\nDecrypted data\n"); pr(data, 32);

  resultis 0
}

let pr(v, n) be
{ for i=0 to n-1 do { unless i mod 8 do printf("\n");
                      printf(" %8x", v[i])
                    };
  printf("\n")
}



