static ptr, seed

let randno(upb) = valof
{ seed := seed * 2147001325 + 715136305;
  resultis (seed/3 >> 1) mod upb + 1 
}

let shellsort(v, upb) be
{ let m = 1;
  until m>upb do m := m*3 + 1;  // Find first suitable value in the
  m := m/3;                     // series:  1, 4, 13, 40, 121, 364, ...
  while m do
  { for i = m+1 to upb do
    { let vi = v[i];
      let j = i;
      let k = j - m;
      until k<=0 | v[k] < vi do
      { v[j] := v[k];
        j := k;
        k := k - m
      };
      v[j] := vi
    };
    m := m/3
  }
}

let heapify(v, k, i, last) be while true do
{ let j = i+i;  // If there is a son (or two), j = subscript of first.
  let x = k;    // x will hold the larger of the sons if any.

  if j<=last do x := v[j];       // j, x = subscript and key of first son.
  if j< last do
  { let y = v[j+1];              // y = key of the other son.
    if x<y do { x:=y; j := j+1 } // j, x = subscript and key of larger son.
  };

  if k=x | k>=x do
  { v[i] := k;                 // k is not lower than larger son if any.
    return
  };

  v[i] := x;
  i := j
}

let heapsort(v, upb) be
{ let i = upb/2;
  while i>=1 do { heapify(v, v[i], i, upb); i := i-1 };

  i := upb;
  while i>=2 do
  { let k = v[i];
    v[i] := v[1];
    heapify(v, k, 1, i-1);
    i := i-1
  }
}

let quicksort(v, n) be qsort(v+1, v+n)

let pr(l, r) be if false do
{ for i = 0 to r-l do
  { if i mod 10 = 0 do printf("\n");
    printf(" %5d", l[i])
  };
  printf("\n\n")
}

let qsort(l, r) be
{ while l+8<r do
  { let midpt = (l+r)/2;
    // Select a good(ish) median value.
    let val   = middle(!l, !midpt, !r);
    let i = partition(val, l, r);
    // Only use recursion on the smaller partition.
    test i>midpt then { qsort(i, r);   r := i-1 }
                 else { qsort(l, i-1); l := i   }
  };

  for p = l+1 to r do  // Now perform insertion sort.
  { let q= p-1;
    while q>=l & q[0]>q[1] do
    { let t = q[0];
      q[0] := q[1];
      q[1] := t;
      q := q-1
    }
  }
}

let middle(a, b, c) = valof
  test a<b then test b<c then resultis b
                         else test a<c then resultis c
                                       else resultis a
           else test b<c then test a<c then resultis a
                                       else resultis c
                         else resultis b

let partition(median, p, q) = valof while true do
{ while !p < median do p := p+1;
  while !q > median do q := q-1;
  if p>=q do resultis p;
  { let t = !p; !p := !q; !q := t };
  p := p+1;
  q := q-1
}

let start() = valof
{ let upb = 1000;
  vec v[5001];

  try("shell", shellsort, v, upb);
  try("heap",  heapsort,  v, upb);
  try("quick", quicksort, v, upb);

  printf("\nEnd of test\n");
  resultis 0
}

let try(name, sortroutine, v, upb) be
{ printf("\nSetting %d words of data for %s sort\n", upb, name);
  seed := 1;
  for i = 1 to upb do v[i] := randno(9999);
  printf("Entering %s sort routine\n", name);
  sortroutine(v, upb);
  printf("Sorting complete\n");
  test sorted(v, upb)
  then printf("The data is now sorted\n")
  else printf("### ERROR: %s sort does not work\n", name)
}

let sorted(v, n) = valof
{ for i = 1 to n-1 do unless v[i]<=v[i+1] do
  { pr(v+1, v+n);
    resultis false
  };
  resultis true
}





