// Mofidied: 7 Aug 2021

static spacev[1000],   // Space used by mk2 and mk3 for the random tree
       ptr,            // Pointer to the latest tree node created
       seed,           // Used by rnd, the random number generator
       debug           // The debugging level, if zero no debugging output

let rnd(upb) = valof // Return a ransom number in range 1 to upb
{ seed := (seed * 2147001325 + 715136305) >> 1;
  resultis seed mod upb + 1
}

let mk2(a, b) = valof
{ ptr := ptr - 2;
  ptr[0] := a;
  ptr[1] := b;
  if debug>1 do printf("mk2: ptr=%d -> [%d %d]\n", ptr, a, b);
  resultis ptr
}

let mk3(a, b, c) = valof
{ ptr := ptr - 3;
  ptr[0] := a;
  ptr[1] := b;
  ptr[2] := c;
  if debug>1 do printf("mk3: ptr=%d -> [%d %d %d]\n", ptr, a, b, c);
  resultis ptr
}

let randtree(n) = valof
{ // n is the number of arithmetic operators in the resulting tree
  let lno = 0;
  let rno = 0;

  if debug>0 do printf("rantree: n=%d\n", n);
  if n<=0 do resultis mk2(1, rnd(10)-1); // Number 0 to 9

  // n is greater than 0
  lno := rnd(n)-1;        // lno is between 0 and n-1
  rno := n - 1 - lno;     // lno+rno = n-1
  resultis mk3(rnd(4)+1, randtree(lno), randtree(rno))
}

let eval(x) = valof
{ let op = x[0];
  if x=0 do abort(999);
  if debug>2 do printf("\neval: x=%d -> [%d %d %d]\n", x, x[0], x[1], x[2]);
  if debug>3 do abort(3001);

  test op=1
  then { resultis x[1]
       }
  else { let a = eval(x[1]);
         let b = eval(x[2]);

         if op = 2  do resultis a * b;
         if op = 3  do test b=0 then { printf("\nAttempting to evaluate %d/0", a);
                                       printf("  result chosen: %d\n", a);
	                               resultis a
				     }
                                else resultis a / b;
         if op = 4  do resultis a + b;
         if op = 5  do resultis a - b
       };
  printf("Bad exprssion\n");
  resultis 999
}

let prexp(x, prec) be
{ let op = x[0];
  let opstr = "?"; 
  let n = 0;
  if x=0 do
  { printf("nil");
    return
  };
  //printf("prexp: %d %d\n", x, prec);
  if op=1 do { printf("%d", x[1]); return };  // Number 
  if op=2 do { opstr := " * "; n := 4 };     // Mul
  if op=3 do { opstr := " / ";  n := 4 };     // Div
  if op=4 do { opstr := " + ";  n := 2 };     // Add
  if op=5 do { opstr := " - ";  n := 2 };     // Sub
  if n<prec do printf("(");
  prexp(x[1], n);
  printf(opstr);
  prexp(x[2], n+1);
  if n<prec do printf(")")
}

let start() = valof
{ let e = 1234;
  debug := 0;
  ptr := spacev+1000;
  seed := 12345;
  for i = 1 to 10 do
  { e := randtree(4);
    prexp(e, 0);
    printf("   => %d\n", eval(e));
    if debug>0 do
    { printf("Aborting after one iteration since debug = %d\n", debug);
      abort(999)
    }
  };
  resultis 0
}

let abort(n) be
{ printf("abort: n=%d\n", n);
  n := n/0   // Used when debugging
}



