package trn;

import lib.*;
import err.*;
import tree.*;

/** This class maintains the declaration vector of
 *  currently declared identifers.
 */
public class Dvec extends Trn {

    public static Cell[] dvec; ;
    public static int dvece;
    public static int dvect;

    public static void init() {
	dvec = new Cell[1000];
        dvec[0] = null;
        dvece = 1;
        dvect = 1000;
    }

    public static void checkdistinct(int p) throws Fatalerror {
	//writes("Dvec.checkdistinct("+p+") called, dvece="+dvece+"\n");
	int last = dvece-1;
	for(int q=p; q<last; q++) {
	    IdNode n = dvec[q].name;
	    for(int c=q+1; c<=last; c++) {
		if(n.equals(dvec[c].name))
		    trnerr("Name "+n.str+" defined twice");
	    }
	}
    }
 
    public static void addname(IdNode name, int k, int a) throws Fatalerror {
	//writes("Dvec.addname: "+name.str+" k="+k+" a="+a+
	//       " dvece="+dvece+"\n");
	if(dvece>=dvect) { trnerr("More workspace needed"); return; }
	name.hint = dvece; // Remember the declaration
	dvec[dvece++] = new Cell(name, k, a);
    }
 
    public static void undeclare(int e) {
	for(int t=e; t<dvece; t++) {
	    IdNode name = dvec[t].name;
	    name.hint = 0;   // Forget its declaration
	}
	dvece = e;
    }

    public static Cell cellwithname(IdNode n) {
	int t = n.hint;
	if(t!=0) return dvec[t];  // It has been looked up before
	t = dvece;
	do t--; while( t>0 && n==dvec[t].name);
	n.hint = t;  // Associate the name with declaration item
	return dvec[t];
    }


}
