package tree;

import lib.*;
import err.*;
import code.*;

/** This represents the Or operator. 
 */

public class OrNode extends N2 {

    public OrNode(Tree a, Tree b) {
	super(a, b);
    }

    public void load() throws Fatalerror {
	//writes("OrNode.load called\n");
	load(Code.Or, a, b);
    }

    public void jumpcond(boolean sw, int l) throws Fatalerror {
	writes("OrNode.jumpcond called\n");
	if(sw) {
	    a.jumpcond(sw, l);
	    b.jumpcond(sw, l);
	} else {
	    int m = nextlab();
	    a.jumpcond(!sw, m);
	    b.jumpcond(sw,  l);
	    Code.outlab(m);
	}
    }

    public void plist(String indent, int n) {
	pl("Or", indent, n);
    }
}

