SECTION "mksine"

GET "libhdr"

MANIFEST {
  mono=1; stereo=2
}

GLOBAL
{ sintab:200
  sysout
  wavout

  mode
  bits_per_sample
  sample_rate
  msecs
  samples
  bytes_per_sample
  bytes_per_second
  data_bytes
}

LET initsintab() BE
{ LET y, ydot = 0, 1_000_000_000

  FOR i = 0 TO 16383 DO
  { LET yval = (y+500)/1000
    //IF i MOD #xFF = 0 DO
    //{ sawritef("sintab!%i6  y=%i9*n", i, y)
    // abort(1000)
    //}
    sintab!i         :=  yval
    sintab!(32767-i) :=  yval 
    sintab!(32768+i) := -yval 
    sintab!(65535-i) := -yval 
    ydot := ydot - muldiv(y,    95874, 1_000_000_000)
    y    := y    + muldiv(ydot, 95874, 1_000_000_000)
  }
}

LET start() = VALOF
{ LET args = VEC 50
  LET wavfile = "sine.wav"
  LET riffhdr = VEC 10
  sysout := output()

  sintab := getvec(65535) // sintab elements are between
                          // -1_000_000_000 and 1_000_000_000

  UNLESS sintab DO 
  { writes("Not enough space*n")
    RESULTIS 20
  }

  IF rdargs("TO/K,MSECS/N", args, 50)=0 DO
  { writes("Bad arguments for MKWAV*n")
    RESULTIS 20
  }

  mode := mono         // or stereo
  bits_per_sample:=16  // or 8
  sample_rate := 44100 // or 22050  or 11025
  msecs:=5000

  IF args!0 DO wavfile := args!0       // TO
  IF args!1 DO msecs := !(args!1)      // MSECS

  samples := sample_rate*msecs/1000 & -16
  bytes_per_sample := bits_per_sample/8 * mode
  bytes_per_second := sample_rate * bytes_per_sample
  data_bytes :=  samples * bytes_per_sample

  writef("*nmsecs=%n*n", msecs)
  writef("sample rate = %n %s*n", sample_rate, mode=mono->"mono","stereo")
  writef("samples=%n*n", samples)

  wavout := findoutput(wavfile)

  UNLESS wavout DO
  { writef("Unable to open file %s*n", args!0)
    RESULTIS 20
  }

  writef("calling initsintab*n")
  initsintab()

  riffhdr!0  := #x46464952     // R I F F
  riffhdr!1  := data_bytes+36  // size
  riffhdr!2  := #x45564157     // W A V E
  riffhdr!3  := #x20746D66     // f m t
  riffhdr!4  := 16             //
  riffhdr!5  := mode<<16 | 1   // 
  riffhdr!6  := sample_rate    // samples per second
  riffhdr!7  := bytes_per_second
  riffhdr!8  := bits_per_sample<<16 | bytes_per_sample
  riffhdr!9  := #x61746164     // d a t a
//  riffhdr!10 := data_bytes
  riffhdr!10 := -1
   
  selectoutput(wavout)

  FOR i = 0 TO 43 DO wrch(riffhdr%i)

  FOR i = 1 TO samples DO wr2(f(i))
//  FOR i = 1 TO 200 DO wr2(f(i))

  endwrite()
  selectoutput(sysout)
  writef("File %s written*n", wavfile)
  freevec(sintab)
  RESULTIS 0   
}

AND sin(x) = sintab!(x & #xFFFF)

AND f(t) = VALOF
{ LET s = muldiv(t, 65536, 44100)
  LET x = s*440
  //LET amp = muldiv(sin(x), t, samples)
  LET amp = muldiv(sin(x), 10_000, 1_000_000)
//sawritef("sample %i6  s=%i6  amp = %i6*n", t, s, amp)
  IF amp> 32767 DO amp :=  32767
  IF amp<-32767 DO amp := -32767
  RESULTIS amp
}

AND wr2(val) BE { wrch(val); wrch(val>>8)  }





