// This is a program to generate data for CDs to demonstrate
// that the human ear is non linear, ie it can hear sounds that
// have no spectral energy.

SECTION "mkcd"

GET "libhdr"

MANIFEST { 
mono=1; stereo=2
}

GLOBAL
{ sysout:ug
  wavout
  genfn
  genco1           // The generation coroutine
  genco2           // The generation coroutine
  fun1
  fun2

  mode             // mono or stereo
  bits_per_sample  // 16 or 8
  sample_rate      // 44100, 22050  or 11025
  secs             // eg 60 ie 1 minute
  samples
  bytes_per_sample
  bytes_per_second
  data_bytes
  sintab
}

LET initsintab() BE
{ LET y, ydot = 0, 1_000_000_000

  FOR i = 0 TO 16383 DO
  { LET yval = (y+500)/1000
    sintab!i         :=  yval
    sintab!(32767-i) :=  yval 
    sintab!(32768+i) := -yval 
    sintab!(65535-i) := -yval 
    ydot := ydot - muldiv(y,    95874, 1_000_000_000)
    y    := y    + muldiv(ydot, 95874, 1_000_000_000)
  }
}

AND sin(x) = sintab!(x & #xFFFF)

LET start() = VALOF
{ LET args = VEC 50
  LET riffhdr = VEC 10
  LET toname = "cd.wav"
  LET freq = 5_000
  LET amplitude = 5000

  sysout := output()
  genco1 := 0
  genco2 := 0

  sintab := getvec(65535)

  UNLESS sintab DO 
  { writes("Not enough space*n")
    RESULTIS 20
  }

  initsintab()

  IF rdargs("FREQ/N,AMP/N,SECS/N,TO/K,A/S,B/S", args, 50)=0 DO
  { writes("Bad arguments for MKCD*n")
    RESULTIS 20
  }

  secs := 60             // Default is 1 minute

  IF args!0 DO freq      := !(args!0)  // FREQ
  IF args!1 DO amplitude := !(args!1)  // AMP
  IF args!2 DO secs      := !(args!2)  // SECS
  IF args!3 DO toname    := args!3     // TO

//  mode := mono          // mono or stereo
  mode := stereo         // mono or stereo
  bits_per_sample := 16  // or 8
  sample_rate := 44100   // or 22050  or 11025
  samples := sample_rate*secs & -16
  bytes_per_sample := bits_per_sample/8 * mode
  bytes_per_second := sample_rate * bytes_per_sample
  data_bytes :=  samples * bytes_per_sample

writef("start: freq=%n amplitude=%n*n", freq, amplitude)
  genco1 := initco(funsin, 500, freq, amplitude)
  genco2 := initco(funsin, 500, freq+440, amplitude)

  UNLESS genco1 & genco2 DO
  { writef("Unable to create genco1 or genco2*n")
    GOTO fin
  }

//FOR i = 0 TO 100 DO
//{ LET x = callco(genco1)
//}
//GOTO fin

  writef("Data_bytes = %n*n", data_bytes)

  wavout := findoutput(toname)

  UNLESS wavout DO
  { writef("Unable to open file %s*n", toname)
    RESULTIS 20
  }

  riffhdr!0  := #x46464952     // R I F F
  riffhdr!1  := data_bytes+36  // size
  riffhdr!2  := #x45564157     // W A V E
  riffhdr!3  := #x20746D66     // f m t
  riffhdr!4  := 16             //
  riffhdr!5  := mode<<16 | 1   // 
  riffhdr!6  := sample_rate    // samples per second
  riffhdr!7  := bytes_per_second
  riffhdr!8  := bits_per_sample<<16 | bytes_per_sample
  riffhdr!9  := #x61746164     // d a t a
  riffhdr!10 := data_bytes
   
  selectoutput(wavout)
  FOR i = 0 TO 43 DO wrch(riffhdr%i)

  FOR i = 1 TO samples DO
  { wr2(callco(genco1))
    //wr2(callco(genco1)+callco(genco2))
    IF mode=stereo DO wr2(callco(genco2))
  }

  endwrite()
  selectoutput(sysout)
  writef("File %s written*n", toname)

fin:
  IF genco1 DO deleteco(genco1)
  IF genco2 DO deleteco(genco2)
  RESULTIS 0   
}

AND funsin(args) = VALOF
// This is the body of a coroutine to generate a sine wave
// of given frequency and amplitude.
{ LET freq = args!0
  LET amp  = args!1
  LET t = 0

writef("funsin: freq=%n amp=%n*n", freq, amp)

  { LET p = muldiv(t, freq*#x10000, 44100) & #xFFFF
    LET a = sin(p)
    LET x = muldiv(amp, a, 1_000_000)
//writef("funsin: %i5: a=%i9  x=%i9*n", t, a, x)
    cowait(x)
    t := t+1
  } REPEAT
}

AND fun1a(args) = VALOF
// This is the body of a coroutine to generate a square wave
// of given frequency and amplitude.
{ LET freq = args!0
  LET amp  = args!1
  LET x    = 0
  LET xmax = sample_rate/2  // Typically 44100/2

writef("fun1: freq=%n amp=%n*n", freq, amp)
  { // Calculate and return next sample
    x := x + freq
    IF x>xmax DO x := x - sample_rate
    cowait(x>=0 -> amp, -amp)     
  } REPEAT

}

AND fun2(args) = VALOF
// This is the body of a coroutine to generate a square wave
// of given frequency and amplitude.
{ LET freq = args!0
  LET amp  = args!1
  LET x    = 0
  LET xmax = sample_rate/2  // Typically 44100/2

writef("fun2: freq=%n amp=%n*n", freq, amp)
  { // Calculate and return next sample
    x := x + freq
    IF x>xmax DO x := x - sample_rate
    cowait(x>=0 -> amp, -amp)     
  } REPEAT

}

AND wr2(val) BE { wrch(val); wrch(val>>8)  }





