SECTION "sndlib"

GET "libhdr"
GET "sndlib.h"

LET initsnd(filename) = VALOF // Name of .wav file
                              // Returns TRUE if ok
{ bytes_per_sample := bits/8 * mode
  byte_rate := bytes_per_sample * rate

  wavout := findoutput(filename)

  UNLESS wavout RESULTIS 0

  selectoutput(wavout)

  riffhdr()

  // Choose the sample function
  TEST mode=mono
  THEN TEST bits=8
       THEN wrsample := wr8mono
       ELSE wrsample := wr16mono
  ELSE TEST bits=8
       THEN wrsample := wr8stereo
       ELSE wrsample := wr16stereo

  RESULTIS TRUE
}

AND riffhdr() BE
{ writes("RIFF")        //  0: R I F F
  wr4(36+0)             //  4: size of this file - 8
  writes("WAVE")        //  8: W A V E
  writes("fmt ")        // 12: f m t
  wr4(16)               // 16: fmt subchunk size is 16
  wr2(1)                // 20: 1 = linear quantisation
  wr2(mode)             // 22: 1 = mono, 2=stereo
  wr4(rate)             // 24: samples per second
  wr4(byte_rate)        // 28: bytes per second
  wr2(bytes_per_sample) // 32: bits/8 * mode  = 1, 2 or 4
  wr2(bits)             // 34: bits per sample  = 8 or 16
  writes("data")        // 36: d a t a
  //wr4(byte_rate * 1)    // 40: number of bytes of data or zero
  wr4(-1)    // 40: number of bytes of data or -1
  datasize := 0
  sawritef("RIFF hdr written*n")
}

AND endsnd() BE
{ UNTIL datasize >= byte_rate DO wrsample(0, 0)
  endstream(wavout)
}

// Function to write a sample to the .wav file

// Samples are assumed to be supplied as signed 16-bit integers.


AND wr8mono(a) BE
{ a := muldiv(a, 100, 1_000_000)
  IF datasize>byte_rate DO riffhdr()
  // Check sample in range
  chksample8(a)
  binwrch(a + 128)
  datasize := datasize + bytes_per_sample
}

AND wr8stereo(a, b) BE
{ a := muldiv(a, 100, 1_000_000)
  b := muldiv(b, 100, 1_000_000)
  IF datasize>byte_rate DO riffhdr()
  // Check sample in range
  chksample8(a)
  chksample8(b)
  binwrch(a + 128)
  binwrch(b + 128)
  datasize := datasize + bytes_per_sample
}

AND wr16mono(a) BE
{ a := muldiv(a, 20_000, 1_000_000)
  IF datasize>byte_rate DO riffhdr()
  // Check sample in range
  chksample16(a)
  binwrch(a); binwrch(a>>8)
  datasize := datasize + bytes_per_sample
}

AND wr16stereo(a, b) BE
{ a := muldiv(a, 20_000, 1_000_000)
  b := muldiv(b, 20_000, 1_000_000)
  IF datasize>byte_rate DO riffhdr()
  // Check sample in range
  chksample16(a)
  chksample16(b)
  binwrch(a); binwrch(a>>8)
  binwrch(b); binwrch(b>>8)
  datasize := datasize + bytes_per_sample
}

AND chksample8(a) BE
{ //sawritef("chksample8: %i6*n", a)
  UNLESS -#x80 <= a <= #x7F DO
  { sawritef("Sample %x8 out of range*n", a)
    abort(1000)
  }
}

AND chksample16(a) BE
{ //sawritef("chksample16: %i6*n", a)
  UNLESS -#x8000 <= a <= #x7FFF DO
  { sawritef("Sample %x8 out of range*n", a)
    abort(1000)
  }
}

AND wr2(w) BE
{ LET s = @w
  binwrch(s%0)
  binwrch(s%1)
}

AND wr4(w) BE
{ LET s = @w
  binwrch(s%0)
  binwrch(s%1)
  binwrch(s%2)
  binwrch(s%3)
}
