//############# UNDER DEVELOPMENT ################################

// This is a program that uses discrete event simulation technigues
// to generate sound wave represent as a sequence of 16-bit
// samples, typically in .wav format.

// Designed and implemented by Martin Richards (c) December 2006 

SECTION "simgen"

GET "libhdr"

GLOBAL {
  // There are typically 44100 ticks per second of simulated
  // tick time. Once per tick a new sound sample is generated.
  tpriq:ug    // The vector holding the tick priority queue
  tpriqupb    // The upper bound of the tick priority queue
  tpriqn      // Number of items in the tick priority queue

  // There are 1000 milli-beat ticks per second and the number
  // of beats per second it the tempo (which can change with time).
  // At the end of a beat and note may start or change or stop.
  bpriq       // The vector holding the beat priority queue
  bpriqupb    // The upper bound of the beat priority queue
  bpriqn      // Number of items in the beat priority queue

  stopco     // The stop coroutine
  cov        // Vector of work coroutines

  covupb     // Number of work coroutines

  // Just in case we ever need a random number generator
  ranv       // A vector used by the random number generator
  rani; ranj // subscripts of ranv

  simticktime   // Simulated tick time. One tick is typically 1/44100 seconds
  simbeattime   // Simulated beat time. If the tempo is one beat per second
                // there will be 1000 beat ticks per second.
  tickstoptime  // Tick time to stop the simulation.
                // The program also stops if there are more events
                // in either event queue.

  tracing

// Functions
  rnd
  initrnd
  closernd

  prtickq
  inserttickevent
  uptickheap
  downtickheap
  gettickevent
  waitfortick
  prtickwaitq

  prbeatq
  insertbeatevent
  upbeatheap
  downbeatheap
  getbeatevent
  waitforbeat
  prbeatwaitq

  stopcofn
  workcofn // A work coroutine can do any job depending on how it was
           // started.
}

// ################### Random number generator #######################

// The following random number generator is based on one give
// in Knuth: The art of programming, vol 2, p 26.
LET rnd(n) = VALOF
{ LET val = (ranv!rani + ranv!ranj) & #x_FFF_FFFF
  ranv!rani := val
  rani := (rani + 1) MOD 55
  ranj := (ranj + 1) MOD 55
  RESULTIS val MOD n
}

AND initrnd(seed) = VALOF
{ LET a, b = #x_234_5678+seed, #x_536_2781
  ranv := getvec(54)
  UNLESS ranv RESULTIS FALSE
  FOR i = 0 TO 54 DO
  { LET t = (a+b) & #x_FFF_FFFF
    a := b
    b := t
    ranv!i := t
  }
  rani, ranj := 55-55, 55-24  // ie: 0, 31
  RESULTIS TRUE
}

AND closernd() BE IF ranv DO freevec(ranv)

// ################### Priority Queue functions ######################

AND prq() BE
{ FOR i = 1 TO tpriqn DO writef(" %i4", tpriq!i!0)
//^0
  newline()
}

AND insertevent(event) BE
{ tpriqn := tpriqn+1        // Increment number of events
  //writef("insertevent: at time: %n  co=%n*n", event!0, event!1)
  upheap(event, tpriqn)
}

AND upheap(event, i) BE
{ LET eventtime = event!0
//writef("upheap: eventtime=%n i=%n*n", eventtime, i)

  { LET p = i/2          // Parent of i
    UNLESS p & eventtime < tpriq!p!0 DO
    { tpriq!i := event
//prq()
      RETURN
    }
    tpriq!i := tpriq!p     // Demote the parent
//prq()
    i := p
  } REPEAT
}

AND downheap(event, i) BE
{ LET j, min = 2*i, ? // j is left child, if present
//writef("downheap: eventtime=%n i=%n*n", event!0, i)
//prq()
  IF j > tpriqn DO
  { upheap(event, i)
    RETURN
  }
  min := tpriq!j!0
  // Look at other child, if it exists
  IF j<tpriqn & min>tpriq!(j+1)!0 DO j := j+1
  // promote earlier child
  tpriq!i := tpriq!j
  i := j
} REPEAT

AND getevent() = VALOF
{ LET event = tpriq!1      // Get the earliest event
  LET last  = tpriq!tpriqn  // Get the event at the end of the heap
//writef("getevent: tpriq:")
//prq()
  UNLESS tpriqn>0 RESULTIS 0 // No events in the priority queue
//               ^0
  tpriqn := tpriqn-1        // Decrement the heap size
  downheap(last, 1)       // Re-insert last event
  RESULTIS event
}

AND waitfor(ticks) BE
{ // Make an event item into the priority queue
  LET eventtime, co = simticktime+ticks, currco
//writef("waitfor: simticktime=%n ticks=%n*n", simticktime, ticks)
  insertevent(@eventtime) // Insert into the priority queue
  cowait()                // Wait for the specified number of ticks
}

// ######################## Coroutine Bodies ##########################

AND stopcofn(arg) = VALOF
{ waitfor(tickstoptime)
  IF tracing DO
    writef("%i8: Stop time reached*n", simticktime)
  RESULTIS 0
}
 
AND workcofn(covupb) = VALOF
{ 
}
// ######################### Main Program ############################

LET start() = VALOF
{ LET seed = 0
  LET argv = VEC 50

  UNLESS rdargs("-n,-s,-r,-t/S", argv, 50) DO
  { writef("Bad arguments for simgen*n")
    RESULTIS 0
  }

  covupb, tickstoptime := 500, 1_000_000

  IF argv!0 & string.to.number(argv!0) DO covupb    := result2 // -k
  IF argv!1 & string.to.number(argv!1) DO tickstoptime := result2 // -s
  IF argv!2 & string.to.number(argv!2) DO seed     := result2 // -r
  tracing := argv!3                                           // -t

  writef("*nsimgen entered*n*n")
  writef("Stop time:           %n*n", tickstoptime)
  newline()

  UNLESS initrnd(seed) DO
  { writef("Can't initialise the random number generator*n")
    RESULTIS 0
  }

IF FALSE DO
  FOR i = 1 TO 100 DO // Test the random number generator
  { writef(" %i4", rnd(10000))
    IF i MOD 10 = 0 DO newline()
  }

  stopco := 0

  tpriq, bpriq, cov := getvec(covupb+1), getvec(covupb+1), getvec(covupb)
  UNLESS tpriq & bpriq & cov DO  
  { writef("More space needed*n")
    GOTO ret
  }

  FOR i = 1 TO covupb DO cov!i := 0
  tpriqn := 0  // Number of events in the tick priority queue
  bpriqn := 0  // Number of events in the tick priority queue

  simticktime := 0 // Simulated time

  IF tracing DO writef("%i8: Starting simulation*n", simticktime)

  // Create and start the stop coroutine
  stopco := createco(stopcofn, 200)

  IF stopco DO callco(stopco)

  // Create and start the message coroutines
  FOR i = 1 TO covupb DO
  { LET co = createco(workcofn, 200)
    IF co DO callco(co, i)
    cov!i := co
  }

  // Run the event loop

  { LET event = getevent()      // Get the earliest event
    UNLESS event BREAK
    simticktime := event!0          // Set the simulated time
    IF simticktime > tickstoptime BREAK
    callco(event!1)
  } REPEAT

  IF tracing DO writef("*nSimulation stopped*n*n")

ret:
  FOR i = covupb TO 1 BY -1 IF cov!i DO deleteco(cov!i)
  IF cov    DO freevec(cov)
  IF tpriq  DO freevec(tpriq)
  IF bpriq  DO freevec(bpriq)
  IF stopco DO deleteco(stopco)
  closernd()
  RESULTIS 0

fail:
  writef("Unable to initialise the simulator*n")
  GOTO ret
}

MANIFEST { 
mono=1; stereo=2
mode = mono         // or stereo
bits_per_sample=16  // or 8
sample_rate = 44100 // or 22050  or 11025
msecs=5000
samples = sample_rate*msecs/1000 & -16
bytes_per_sample = bits_per_sample/8 * mode
bytes_per_second = sample_rate * bytes_per_sample
data_bytes =  samples * bytes_per_sample
}

GLOBAL
{ sintab:200
  sysout:201
  wavout:202
}

LET initsintab() BE
{ LET y, ydot = 0, 1_000_000_000

  FOR i = 0 TO 16383 DO
  { LET yval = (y+500)/1000
    sintab!i         :=  yval
    sintab!(32767-i) :=  yval 
    sintab!(32768+i) := -yval 
    sintab!(65535-i) := -yval 
    ydot := ydot - muldiv(y,    95874, 1_000_000_000)
    y    := y    + muldiv(ydot, 95874, 1_000_000_000)
  }
}

LET start() = VALOF
{ LET args = VEC 50
  LET riffhdr = VEC 10
  sysout := output()

  sintab := getvec(65535)

  UNLESS sintab DO 
  { writes("Not enough space*n")
    RESULTIS 20
  }

  IF rdargs("TO/K", args, 50)=0 DO
  { writes("Bad arguments for MKWAV*n")
    RESULTIS 20
  }

  UNLESS args!0 DO args!0 := "junk.wav"

  wavout := findoutput(args!0)

  UNLESS wavout DO
  { writef("Unable to open file %s*n", args!0)
    RESULTIS 20
  }

  initsintab()

  riffhdr!0  := #x46464952     // R I F F
  riffhdr!1  := data_bytes+36  // size
  riffhdr!2  := #x45564157     // W A V E
  riffhdr!3  := #x20746D66     // f m t
  riffhdr!4  := 16             //
  riffhdr!5  := mode<<16 | 1   // 
  riffhdr!6  := sample_rate    // samples per second
  riffhdr!7  := bytes_per_second
  riffhdr!8  := bits_per_sample<<16 | bytes_per_sample
  riffhdr!9  := #x61746164     // d a t a
  riffhdr!10 := data_bytes
   
  selectoutput(wavout)
  FOR i = 0 TO 43 DO wrch(riffhdr%i)

  FOR i = 1 TO samples DO wr2(f(i))

  UNLESS wavout=sysout DO endwrite()
  selectoutput(sysout)
  writef("File %s written*n", args!0)
  freevec(sintab)
  RESULTIS 0   
}

AND sin(x) = sintab!(x & #xFFFF)

AND f(t) = VALOF
{ LET s = muldiv(t, 65536, sample_rate)
  LET amp = mix(s, 440/2, TABLE      12,  // Number of harmonics
                             500000*0,  // Fundamental
                             100000*0,  // 2
                              80000*0,  // 3
                             700000*1,  // 4
                             400000*1,  // 5
                             400000*0,  // 6
                             400000*1,  // 7
                             400000*1,  // 8
                                  0*0,  // 9
                                  0*0,  // 10
                             100000*0,  // 11
                                  0*0   // 12
               )
  LET vol = envelope(s,     0,     0,
                        28000, 15000,
                        40000,  9000,
                        60000,  9000,
                       390000,     0)

// 15000          *
// 14000          | \
// 13000         |    \
// 12000         |      \
// 11000        |         \
// 10000        |           \
//  9000       |              *-------------------*
//  8000       |                                   \
//  7000      |                                     \
//  6000      |                                      \
//  5000     |                                        \
//  5000     |                                         \
//  4000    |                                           \
//  3000    |                                            \
//  2000   |                                              \
//  1000   |                                               \
//     0  *                                                 *
//                  11111111112222222222333333333344444444445
//        012345678901234567890123456789012345678901234567890
  RESULTIS muldiv(amp, vol, 1000000)
}

AND envelope(t, t0, v0, t1, v1, t2, v2, t3, v3, t4, v4) = VALOF
{ LET v, dt, dv = 0, 0, 0
  //RESULTIS 20000
  TEST t<t2
  THEN TEST t<t1
       THEN IF t>=t0 DO t, v, dt, dv := t-t0, v0, t1-t0, v1-v0
       ELSE             t, v, dt, dv := t-t1, v1, t2-t1, v2-v1
  ELSE TEST t<t3
       THEN             t, v, dt, dv := t-t2, v2, t3-t2, v3-v2
       ELSE IF t<t4  DO t, v, dt, dv := t-t3, v3, t4-t3, v4-v3
  IF dt=0 RESULTIS 0
  RESULTIS v + muldiv(t, dv, dt)
}

AND mix(s, f, v) = VALOF
{ LET amp = 0
  LET x = s*f & #xFFFF
  FOR i = 1 TO v!0 DO
    amp := amp + muldiv(sin(i*x), v!i, 500_000)
//   IF amp> 32767 DO amp :=  32767
//   IF amp<-32767 DO amp := -32767
  RESULTIS amp
}

AND wr2(val) BE { wrch(val); wrch(val>>8)  }
