#include <stdio.h>

// Twelth root of 2 -- the relation between semitones
#define r12_2  1.059463094359

int main() {
  double v[13];
  int i, oct;
  double octfac = 1.0/16.0;

  printf("\nTable of equal temperament note frequencies\n\n");

  v[0] = 440.0;
  for (i=1; i<=12; i++)
    v[i] = v[i-1] * r12_2;

  printf("     a        bes      b        c        des      d        ees "
         "     e        f        ges      g        aes      a\n\n");

  for (oct=1; oct<=8; oct++) {
    for (i=0; i<=12; i++) {
      printf(" %8.2f", v[i]*octfac);
    }
    printf("\n\n");
    octfac *= 2.0;
  }

  printf("\n");

  return 0;
}
