GET "libhdr"

GLOBAL {
  stdin:ug
  stdout
  dataname
  datastream
  buf
  sampco
  upb
  cycles
  K; A; B
  plotting
}

LET start() = VALOF
{ LET argv = VEC 50

  UNLESS rdargs("upb/n,cycles/n,k/n,a/n,b/n,plot/s", argv, 50) DO
  { writef("Bad args*n")
    GOTO fin
  }

  dataname := "plot/num.data"
  datastream := 0
  buf := 0
  upb := 100
  cycles := 20
  K, A, B := 10, 90, 20
  plotting := FALSE

  IF argv!0 DO upb    := !(argv!0)    // UPB
  IF argv!1 DO cycles := !(argv!1)    // cycles
  IF argv!2 DO K      := !(argv!2)    // K
  IF argv!3 DO A      := !(argv!3)    // A
  IF argv!4 DO B      := !(argv!4)    // B
  IF argv!5 DO plotting := TRUE       // PLOT

  IF plotting DO
  { // Generate files plot/eg1.gp and num.data
    // for use by gnuplot
    LET gpname = "plot/eg1.gp"
    LET gpstream = findoutput(gpname)
    UNLESS gpstream DO
    { writef("Trouble with file: %s*n", gpname)
      GOTO fin
    }
    selectoutput(gpstream)
    
    writes("set terminal latex*n")
    writes("set output *"eg1.tex*"*n")

    writes("unset key*n")
    writes("set size 7/5.,6/3.*n")
    writes("set pointsize 0.1*n")
    writes("set format xy *"$%g$*"*n")
    writef("set title *"Cycles=%n K=%n A=%n B=%n*"*n",
            cycles, K, A, B)
    writef("set cntrparam cubicspline*n")
    writef("plot [0:%n] [-200:2000] *"../%s*" with linespoints 1 12*n",
            upb, dataname)
    endstream(gpstream)

    datastream := findoutput("plot/num.data")
    UNLESS gpstream DO
    { writef("Trouble with file: %s*n", "plot/num.data")
      GOTO fin
    }
  }

  IF datastream DO selectoutput(datastream)

  buf := getvec(upb)
  UNLESS buf DO
  { writef("more space needed*n")
    GOTO fin
  }

  newline()
  FOR h = 1 TO upb DO
  { // 2h is the number of samples in a cycle
    LET res = 0
    LET lim = cycles*upb
    LET v = getvec(K)

    LET sampco = initco(sqwavfn, 300, h, 1000_000)
    FOR i = 1 TO K DO v!i := callco(sampco)

    UNLESS sampco DO
    { writef("more space needed*n")
      GOTO fin
    }

    FOR i = 1 TO upb DO buf!i := 0

/*
    FOR c = 1 TO cycles FOR p = 1 TO upb DO
    { LET val = 0
      FOR i = 1 TO K DO val := val + v!i
      val := val/K
      buf!p := buf!p + val
      FOR i = 1 TO K-1 DO v!i := v!(i+1)
      v!K := callco(sampco)
    }

    FOR i = 1 TO upb DO buf!i := buf!i / cycles
*/

    FOR c = 1 TO cycles FOR p = 1 TO upb DO
    { LET val = 0
      FOR i = 1 TO K DO val := val + v!i
      val := val/K
      buf!p := (A*buf!p + B*val) / 100
      FOR i = 1 TO K-1 DO v!i := v!(i+1)
      v!K := callco(sampco)
    }

    res := findamp(0, buf, upb)

    //IF h=upb/10 DO
    //{ FOR i = 1 TO upb DO
    //  { IF (i-1) MOD 5 = 0 DO writef("*n%i4: ", i)
    //    writef(" %9.3d", buf!i)
    //  }
    //  newline()
    //} 
    IF upb<100 | (h-1) MOD (upb/100) = 0 | h=upb DO
      writef("%i4 %8.3d*n", h, res)
    //IF h=upb/10 DO
    //  abort(1000)
    freevec(v)
  } 

fin:
  IF buf DO freevec(buf)
  IF datastream DO endstream(datastream)
  RESULTIS 0
}

AND sqwavfn(args) = VALOF
{ LET h   = args!0
  LET amp = args!1

  // Generate a squawav of period 2h, amplitude amp.
  { FOR i = 1 TO h DO cowait(amp)
    FOR i = 1 TO h DO cowait(-amp)
  } REPEAT
}

AND findamp1(n, buf, upb) = VALOF
{ LET sum, avg, amp = 0, 0, 0
  FOR i = 1 TO upb DO sum := sum+buf!i
  avg := sum / upb
//writef("%i3: avg=%9.3d*n", h, avg)
  FOR i = 1 TO upb DO
  { LET x = buf!i - avg

//writef("%i3: val=%9.3d  x=%9.3d*n", i, buf!i, x)

    TEST i<=upb/2 THEN amp := amp + x
                  ELSE amp := amp - x
  }
  RESULTIS amp/upb
}

// The following function is used in recogs.b
AND findamp(n, buf, upb) = VALOF TEST (upb & 1) = 0
THEN { // upb is even
       LET h = upb/2            // upb = h+h 
       LET s1, s2 = 0, 0        // The left and right sums.
       LET p, q = buf+1, buf+h+1
       LET m, r = 0, p
       LET a, b = ?, ?
       LET lim = buf+upb

       // Initialise the left and right sums.
       WHILE q<=lim DO
       { s1, s2 := s1+!p, s2+!q
         p, q := p+1, q+1
       }
       p, q := buf+1, buf+h+1

       { IF m<s1-s2 DO m, r := s1-s2, p
         IF m<s2-s1 DO m, r := s2-s1, q
//writef("p=%i2 q=%i2 s1=%i4 s2=%i4 m=%i4 r=%i2*n", p-buf, q-buf, s1, s2, m, r-buf)
         IF q>=lim BREAK
         a, b := !p, !q
         s1, s2 := s1+b-a, s2+a-b
         p, q := p+1, q+1
       } REPEAT

       result2 := 1000*(r-buf)  // ddd.ddd scaled phase
       RESULTIS (m + h)/upb     // rounded average amplitude
     }
ELSE { // upb is odd
       LET h = upb/2 + 1        // upb = h+h-1 
       LET s1, s2 = 0, 0        // Left and right sums
       LET p, q = buf+1, buf+h
       LET m, r = 0, p
       LET lim = buf+upb
       LET a, b = !p, !q

       // Initialise s1 and s2
       WHILE q<lim DO
       { q := q+1
         s1, s2 := s1+!p, s2+!q
         p := p+1
       }
       p, q := buf+1, buf+h

       { IF m<s2-s1 DO m, r := s2-s1, q
//writef("p=%i2 q=%i2 s1=%i4 s2=%i4 m=%i4 r=%i2*n", p-buf, q-buf, s1, s2, m, r-buf)
         IF q>=lim BREAK
         q := q+1
         a := !p
         s1 := s1+b-a
         IF m<s1-s2 DO m, r := s1-s2, p
//writef("p=%i2 q=%i2 s1=%i4 s2=%i4 m=%i4 r=%i2*n", p-buf, q-buf, s1, s2, m, r-buf)
         p := p+1
         b := !q
         s2 := s2+a-b
       } REPEAT

       result2 := 1000*(r-buf)  // ddd.ddd scaled phase
       RESULTIS (m + h)/upb     // rounded average amplitude
     }

