module Co (Co, yield, call, foreach, foreach_io)

where

-- a co-routine is a procedure that either returns a value or yields 
data Co b a = 
	Result a 
	| Yield (Co b a) b
 
instance Monad (Co b) where
	(>>=) c f = case c of
		Result x -> f x
		Yield c2 res -> Yield (c2 >>= f) res

	(>>) c1 c2 = case c1 of
		Result _ -> c2
		Yield c res ->Yield (c >> c2) res
	
	return x = Result x

yield :: a -> Co a ()
yield res = Yield (return ()) res 

-- call :: Co a b -> Co a (Maybe (Co a b,a))
call cotop = case cotop of
	Result _ -> return Nothing
	Yield co res -> 
		return (Just (co,res))

foreach :: Co a () -> (a -> Co b ()) -> Co b () 
foreach cotop f = 
	call cotop >>= \ res ->
	case res of
	Nothing -> return ()
	Just (next,x) -> f x >> foreach next f

foreach_io :: Co a () -> (a -> IO ()) -> IO () 
foreach_io cotop f = 
	call cotop >>= \ res ->
	case res of
	Nothing -> return ()
	Just (next,x) -> f x >> foreach_io next f
	
