// cobench.c
// Jeremy Singer
// 13 Mar 04
// Modified by Martin Richards 21/6/04


#include "cortn.c"


int tracing = 0;

coval coread(cortn *ptr)
{
  cortn cptr = *ptr;
  if (cptr != NULL) {
    *ptr = NULL;
    return resumeco(cptr, (coval)currco);
  }
  else {
    *ptr = currco;
    return cowait((coval)0);
  }
}
    

void cowrite(cortn *ptr, coval val) {
  cortn cptr = *ptr;
  if (cptr != NULL) {
    *ptr = 0;
    callco(cptr, val);
  }
  else {
    *ptr = currco;
    callco(cowait((coval)0).c, val);
  }
}

cortn kill_co;

void die() { resumeco(kill_co, (coval)0); }

coval sourcefn(coval nextco) {
  int i;  // loop counter
  int k = cowait((coval)0).i;
  cortn channel = NULL;
  cortn *out_chan_ptr = &channel;
  callco(nextco.c, (coval)out_chan_ptr);
  
  if (tracing) printf("sourcefn: co=%d out_chan_ptr=%d k=%d\n\n",
		      (int)currco, (int)out_chan_ptr, k);

  for (i=1; i <= k; i++)
  { if(tracing) printf("sourcefn: co=%d sending number %d\n", currco, i);
    cowrite(out_chan_ptr, (coval)i);  // JDS31 - abusing types!!!
  }
  if(tracing) printf("sourcefn: co=%d sending number %d\n", currco, 0);
  cowrite(out_chan_ptr, (coval)0);
  if(tracing) printf("sourcefn: co=%d dying\n", currco);
  die();
  return (coval)0;
}

coval copyfn(coval nextco)
{
  cortn channel = NULL;
  cortn *in_chan_ptr = cowait((coval)0).p;
  cortn *out_chan_ptr = &channel;
  callco(nextco.c, (coval)out_chan_ptr);
  
  if(tracing) printf("copyfn:   co=%d in_chan_ptr=%d out_chan_ptr=%d\n",
                        currco, in_chan_ptr, out_chan_ptr);



  while (1) {
    coval val = coread(in_chan_ptr);
    if(tracing) printf("copyfn:   co=%d copying number %d\n", currco, val);
    cowrite(out_chan_ptr, val);
    if (val.i == 0) break;
  }

  if(tracing) printf("copyfn:   co=%d dying\n", currco);
  die();
  return (coval)0;
}

coval sinkfn(coval in_chan_ptr)
{ if(tracing) printf("sinkfn:   co=%d in_chan_ptr=%d\n", currco, in_chan_ptr);

  while (1) {
    coval val = coread(in_chan_ptr.p);
    if(tracing) printf("sinkfn:   co=%d recving number %d\n", currco, val);
    if (val.i == 0) break;
  }

  if(tracing) printf("sinkfn:   co=%d dying\n", currco);

  die();
  return (coval)0;
}


// two global vars - params for benchmark test

int k;
int n;

coval rootfn(coval);

int main(int argc, char *argv[])
{
  int i;

  k = 10000;
  n = 500;
  
  for(i=1; i<argc; i++) {
    if     (strcmp(argv[i], "-k")==0)  k = atoi(argv[++i]);
    else if(strcmp(argv[i], "-n")==0)  n = atoi(argv[++i]);
    else if(strcmp(argv[i], "-t")==0)  tracing = 1;
    else { printf("Bad arguments\n"); exit(0); }
  }
  printf("Cobench sending %d numbers via %d copy coroutines\n", k, n);

  currco = 0;
  startrootco(rootfn);

  return 0;
}


coval rootfn(coval x)
{
  cortn cptr = createco(sinkfn, 2000);
  kill_co = createco((cofn)deleteco, 150);

  cortn source_co;

  int i;
  for (i = 0; i < n; i++) {
    cortn co = createco(copyfn, 2000);
    callco(co, (coval)cptr);
    cptr = co;
  }

  source_co = createco(sourcefn, 2000);
  callco(source_co, (coval)cptr);

  if(tracing) printf("All coroutines created\n");

  callco(source_co, (coval)k);  // tell sourceco to send k numbers

  printf("Cobench done\n");

  return (coval)0;
}



