// This program creates the file g/glmanifests.h for use by BCPL
// programs using OpenGL. It creates a dummy version if neither
// forLinuxGL nor forLinuxSDFGL is defined.

// Implemented by Martin Richards (c) May 2020

#include <stdio.h>



#if defined(forLinuxGL) || defined(forLinuxSDLGL)
#include <GL/gl.h>

void w(const char *str, int val) { // const needed to keep g++ happy.
  printf("%s = %d\n", str, val);
}

int main() {
  printf("// This file was created by sysc/mkglmanifests.c\n\n");
  printf("MANIFEST {\n");

  w("GL_VERTEX_ARRAY", GL_VERTEX_ARRAY);
  w("GL_VERTEX_SHADER", GL_VERTEX_SHADER);
  w("GL_DEPTH_TEST",GL_DEPTH_TEST);
  w("GL_LESS", GL_LESS);

  w("GL_POINTS",         GL_POINTS);
  w("GL_LINES",          GL_LINES);
  w("GL_LINE_STRIP",     GL_LINE_STRIP);
  w("GL_LINE_LOOP",      GL_LINE_LOOP);
  w("GL_TRIANGLES",      GL_TRIANGLES);
  w("GL_TRIANGLE_STRIP", GL_TRIANGLE_STRIP);
  w("GL_TRIANGLE_FAN",   GL_TRIANGLE_FAN);

  w("GL_COLOR_BUFFER_BIT",   GL_COLOR_BUFFER_BIT);
  w("GL_DEPTH_BUFFER_BIT",   GL_DEPTH_BUFFER_BIT);

  w("GL_BLEND",   GL_BLEND);
  w("GL_SRC_ALPHA", GL_SRC_ALPHA);
  w("GL_ONE_MINUS_SRC_ALPHA", GL_ONE_MINUS_SRC_ALPHA);

  printf("}\n");
  return 0;
}

#else
int main() {
  printf("// This is a dummy version of g/glmanifests.h\n\n");
  return 0;
}

#endif
