/* Program to compute tables relating to the AES algorithm
   Implemented in BCPL by Martin Richards (c) June 2001
*/

GET "libhdr"

LET start() = VALOF
{ writes("*nInversion table:*n")
  FOR b = 0 TO 255 DO
  { IF b REM 16 = 0 DO newline()
    IF b REM 4 = 0 DO wrch(' ')
    writef("%x2", inv(b))
  }
  newline()
  writes("*nSubstitution table:*n")
  FOR b = 0 TO 255 DO
  { IF b REM 16 = 0 DO newline()
    IF b REM 4 = 0 DO wrch(' ')
    writef("%x2", sub(b))
  }
  newline()
  writes("*nInverse Substitution table:*n")
  FOR b = 0 TO 255 DO
  { IF b REM 16 = 0 DO newline()
    IF b REM 4 = 0 DO wrch(' ')
    writef("%x2", invsub(b))
  }
  newline()
  RESULTIS 0
}

AND fwd_affine(b) = VALOF
{ LET w = b & 255
  w := w NEQV w<<1 NEQV w<<2 NEQV w<<3 NEQV w<<4
  RESULTIS (#x63 NEQV w NEQV w>>8) & 255
}

AND inv_affine(b) = VALOF
{ LET w = b & 255
  w := w<<1 NEQV w<<3 NEQV w<<6
  RESULTIS (#x05 NEQV w NEQV w>>8) & 255
}

AND mul(a, b) = VALOF
{ LET res = 0
  WHILE a DO
  { IF (a&1)>0 DO res := res NEQV b
    b := FFmulX(b)
    a := a>>1
  }
  RESULTIS res
}

AND FFmulX(b) = b<<1 NEQV (b>127 -> #x11b, 0)

AND inv(b) = VALOF
{ FOR i = 0 TO 255 IF mul(i, b) = 1 RESULTIS i
  RESULTIS 0
}

AND sub(b) = fwd_affine(inv(b))

AND invsub(b) = inv(inv_affine(b))

/* Output:

Inversion table:

 00018DF6 CB527BD1 E84F29C0 B0E1E5C7
 74B4AA4B 992B605F 583FFDCC FF40EEB2
 3A6E5AF1 554DA8C9 C10A9815 3044A2C2
 2C45926C F3396642 F235206F 77BB5919
 1DFE3767 2D31F569 A764AB13 5425E909
 ED5C05CA 4C2487BF 183E22F0 51EC6117
 165EAFD3 49A63643 F44791DF 3393213B
 79B79785 10B5BA3C B670D006 A1FA8182
 837E7F80 9673BE56 9B9E95D9 F702B9A4
 DE6A326D D88A8472 2A149F88 F9DC899A
 FB7C2EC3 8FB86548 26C8124A CEE7D262
 0CE01FEF 11757871 A58E763D BDBC8657
 0B282FA3 DAD4E40F A9275304 1BFCACE6
 7A07AE63 C5DBE2EA 948BC4D5 9DF8906B
 B10DD6EB C60ECFAD 084ED7E3 5D501EB3
 5B233834 6846038C DD9C7DA0 CD1A411C

Substitution table:

 637C777B F26B6FC5 3001672B FED7AB76
 CA82C97D FA5947F0 ADD4A2AF 9CA472C0
 B7FD9326 363FF7CC 34A5E5F1 71D83115
 04C723C3 1896059A 071280E2 EB27B275
 09832C1A 1B6E5AA0 523BD6B3 29E32F84
 53D100ED 20FCB15B 6ACBBE39 4A4C58CF
 D0EFAAFB 434D3385 45F9027F 503C9FA8
 51A3408F 929D38F5 BCB6DA21 10FFF3D2
 CD0C13EC 5F974417 C4A77E3D 645D1973
 60814FDC 222A9088 46EEB814 DE5E0BDB
 E0323A0A 4906245C C2D3AC62 9195E479
 E7C8376D 8DD54EA9 6C56F4EA 657AAE08
 BA78252E 1CA6B4C6 E8DD741F 4BBD8B8A
 703EB566 4803F60E 613557B9 86C11D9E
 E1F89811 69D98E94 9B1E87E9 CE5528DF
 8CA1890D BFE64268 41992D0F B054BB16

Inverse Substitution table:

 52096AD5 3036A538 BF40A39E 81F3D7FB
 7CE33982 9B2FFF87 348E4344 C4DEE9CB
 547B9432 A6C2233D EE4C950B 42FAC34E
 082EA166 28D924B2 765BA249 6D8BD125
 72F8F664 86689816 D4A45CCC 5D65B692
 6C704850 FDEDB9DA 5E154657 A78D9D84
 90D8AB00 8CBCD30A F7E45805 B8B34506
 D02C1E8F CA3F0F02 C1AFBD03 01138A6B
 3A911141 4F67DCEA 97F2CFCE F0B4E673
 96AC7422 E7AD3585 E2F937E8 1C75DF6E
 47F11A71 1D29C589 6FB7620E AA18BE1B
 FC563E4B C6D27920 9ADBC0FE 78CD5AF4
 1FDDA833 8807C731 B1121059 2780EC5F
 60517FA9 19B54A0D 2DE57A9F 93C99CEF
 A0E03B4D AE2AF5B0 C8EBBB3C 83539961
 172B047E BA77D626 E1691463 55210C7D
*/
