/*
This program draws the 100x100x100 3D cube representing the optimum
playing strategy for the pig dice game. It reads the data in
cubepic.txt that was generated by running pigstrategy followed by
prepcubepic..

Implemented by Martin Richards (c) March 2014

History

12/09/2019
Modified to use the new BCPL sdl library. No changes were needed.

*/

GET "libhdr"
GET "sdl.h"
GET "sdl.b"          // Insert the library source code
.
GET "libhdr"
GET "sdl.h"

MANIFEST {
  One = 1_000000     // Direction cosines scaling factor
                     // ie 6 decimal digits after the decimal point.
  databytes = 50000
  datavupb = databytes/bytesperword
}

GLOBAL {
  done:ug
  plotall
  p1x; p1y; p2x; p2y; tx; ty
  ox; oy
  playcount  // Number of positions in the cube where PLAY is the best strategy
  stdin
  stdout
  datastream
  datav      // Byte vector holding the cube data
}

LET plotaxes() BE
{ setcolour(maprgb(255,0,0))
  moveto(ox, oy)
  drawby(100*p1x, 100*p1y)
  moveto(ox+100*tx, oy+100*ty)
  drawby(100*p1x, 100*p1y)
  //moveto(ox+100*p2x, oy+100*p2y)
  //drawby(100*p1x, 100*p1y)
  moveto(ox+100*(p2x+tx), oy+100*(p2y+ty))
  drawby(100*p1x, 100*p1y)

  setcolour(maprgb(  0, 255,0))
  moveto(ox, oy)
  drawby(100*p2x, 100*p2y)
  moveto(ox+100*tx, oy+100*ty)
  drawby(100*p2x, 100*p2y)
  moveto(ox+100*p1x, oy+100*p1y)
  drawby(100*p2x, 100*p2y)
  moveto(ox+100*(p1x+tx), oy+100*(p1y+ty))
  drawby(100*p2x, 100*p2y)

  setcolour(maprgb(0,0,180))
  moveto(ox, oy)
  drawby(100*tx, 100*ty)
  moveto(ox+100*p1x, oy+100*p1y)
  drawby(100*tx, 100*ty)
  moveto(ox+100*p2x, oy+100*p2y)
  drawby(100*tx, 100*ty)
  moveto(ox+100*(p1x+p2x), oy+100*(p1y+p2y))
  drawby(100*tx, 100*ty)
}

LET plotcube() BE
{ LET op, my, ts = ?, ?, ?
  LET p = 0
  LET k = 0
  IF p1x < k DO k := p1x
  IF p2x < k DO k := p2x
  IF p1x+p2x < k DO k := p1x+p2x
  ox, oy := 20 - 100*k, 5

  plotaxes()
//abort(1001)


FOR i = 0 TO 99 FOR j = 0 TO 99 DO
  { LET incts = ?
    op := datav%p; p := p+1
    my := datav%p; p := p+1
    ts := 0

    WHILE ts<100 DO
    { incts := datav%p; p := p+1
      plotcolumn(op, my, ts, incts) // Plot PLAY column
      ts := ts + incts
      IF ts>=100 BREAK
      incts := datav%p; p := p+1
                                    // Don't plot HOLD column
      ts := ts + incts
    }

    plotaxes()

    IF j=99 DO updatescreen()
  }
}

AND plotcolumn(op, my, lo, h) BE IF lo=0 | plotall DO
{ // The columns are drawn from furthest to nearest and from right to left
  // so that hidden surfaces are removed. 
  LET x0 = ox + my*p1x + op*p2x + lo*tx  //   +------+
  LET y0 = oy + my*p1y + op*p2y + lo*ty  //   |\     |\
  LET x1, y1 = x0+p1x, y0+p1y            //   | x------x
  LET x2, y2 = x0+p2x, y0+p2y            //   | |    | |
  LET x3, y3 = x0+p1x+p2x, y0+p1y+p2y    //   | |    | |
                                         //   | |    | |
  LET tx0, ty0 = x0+h*tx, y0+h*ty        //   | |    | |
  LET tx1, ty1 = x1+h*tx, y1+h*ty        //   1-|----2 |
  LET tx2, ty2 = x2+h*tx, y2+h*ty        //    \|     \|
  LET tx3, ty3 = x3+h*tx, y3+h*ty        //     0----- 3

  LET t = lo+h
  LET r = ABS(t-15)*4
  LET g = ABS(t-30)*6
  LET b = ABS(t-50)*4

  IF ((lo+h) & 1)=0 DO r, g, b := r + 25, g + 25, b + 30

  IF r>255 DO r := 255
  IF g>255 DO g := 255
  IF b>255 DO b := 255

  playcount := playcount+h

  // Draw top
  setcolour(maprgb(255-g,b,r))
  drawquad(tx0,ty0, tx1,ty1, tx3,ty3, tx2,ty2)

  // Draw left side
  TEST TRUE | (my & 1)=0
  THEN setcolour(maprgb(60,60,60))
  ELSE setcolour(maprgb(70,70,70))
  drawquad(tx0,ty0, x0,y0, x2,y2, tx2,ty2)

  // Draw front
  TEST TRUE | (op & 1)=0
  THEN setcolour(maprgb(90,90-op/4,90))
  ELSE setcolour(maprgb(99,99,99))
  drawquad(tx0,ty0, x0,y0, x1,y1, tx1,ty1)

  updatescreen()
}


AND plotscreen() BE
{ fillsurf(maprgb(90, 70,255))
  plotcube()
}


AND processevents() BE WHILE getevent() SWITCHON eventtype INTO
{ DEFAULT:
    LOOP

  CASE sdle_quit:
    writef("QUIT*n");
    done := TRUE
    LOOP
}

LET start() = VALOF
{ LET argv = VEC 50

  UNLESS rdargs("a/n,b/n,c/n,d/n,e/n,f/n", argv, 50) DO
  { writef("Bad arguments for plotpigcube*n")
    RESULTIS 0
  }

  p1x, p1y :=  5, 1
  p2x, p2y := -2, 2
  tx,  ty  :=  0, 4

  IF argv!0 DO p1x := !(argv!0)   // a/n
  IF argv!1 DO p1y := !(argv!1)   // b/n
  IF argv!2 DO p2x := !(argv!2)   // c/n
  IF argv!3 DO p2y := !(argv!3)   // d/n
  IF argv!4 DO tx  := !(argv!4)   // e/n
  IF argv!5 DO ty  := !(argv!5)   // f/n

  plotall := TRUE

  stdin  := input()
  stdout := output()

  datav := getvec(datavupb)
  UNLESS datav DO
  { writef("*nMore memory needed*n")
    RESULTIS 0
  }

  datastream := findinput("cubepic.txt")
  UNLESS datastream DO
  { writef("Unable to open file: cubepic.txt*n")
    GOTO fin
  }

  selectinput(datastream)

  FOR i = 0 TO databytes-1 DO
  { LET byte = readn()
    IF result2<0 DO
    { writef("Number of data bytes = %n*n", i)
      BREAK
    }
    datav%i := byte
  }

  endstream(datastream)
  selectinput(stdin)

  initsdl()
  mkscreen("Pig Dice Game Strategy Cube", 750, 710)

  done := FALSE
  playcount := 0

  plotscreen()
  updatescreen()

  writef("playcount=%n*n", playcount)

  UNTIL done DO
  { processevents()
    sdldelay(10)
  }

  writef("*nQuitting*n")
  sdldelay(1_000)
  closesdl()

fin:
  IF datav DO freevec(datav)
  RESULTIS 0
}


