/*
This will be an sial to ARM translator based on sial-386.

Implemented by Martin Richards (c) February 2012

19/12/2011
UNDER DEVELOPMENT
*/

SECTION "sial-arm"

GET "libhdr"

GET "sial.h"

GLOBAL {
sialin: ug
asmout; stdin; stdout

rdf; rdp; rdg; rdk; rdw; rdl; rdc
rdcode

pval; gval; kval; wval; lval; mval

scan
cvf; cvfp; cvfg; cvfk; cvfw; cvfl

sectname
modletter
charv
labnumber

// To hold register name strings
 r0; r1; r2; r3; ra; rb; rc; r7; r8; r9; rp; rg; r12; sp; lr; ip
}

LET start() = VALOF
{ LET argv = VEC 20
  LET v    = VEC 20
  LET cv   = VEC 256/bytesperword

  r0, r1, r2, r3  :=  "r0", "r1", "r2", "r3"
  ra, rb, rc      :=  "ra", "rb", "rc"
  r7, r8, r9      :=  "r7", "r8", "r9"
  rp, rg          :=  "rp", "rg"
  r12, sp, lr, ip :=  "r12", "sp", "lr", "ip" 

/*
genLoadK(ra, 4)
genLoadK(ra, -4)
genLoadK(rb, 255)
genLoadK(rb, 256)
genLoadK(rb, 257)
newline()
writef("*nTesting genLdrStr*n")
genLdrStr("ldr", ra, rp, 12)
genLdrStr("ldr", ra, rp, -12)
genLdrStr("ldr", ra, rp, 255)
genLdrStr("str", ra, rg, 256)
genLdrStr("str", ra, rg, 257)
genLdrStr("str", ra, rg, -257)
newline()
RESULTIS 0
*/
  sectname := v
  sectname%0 := 0
  modletter := 'A'
  charv := cv
  labnumber := 0

  asmout := 0
  stdout := output()
  IF rdargs("FROM,TO/K", argv, 20)=0 DO
  { writes("Bad args for sial-arm*n")
    RESULTIS 20
  }
  UNLESS argv!0 DO argv!0 := "prog.sial"
  UNLESS argv!1 DO argv!1 := "prog.s"
  sialin := findinput(argv!0)
  IF sialin=0 DO
  { writef("Trouble with file %s*n", argv!0)
    RESULTIS 20
  }
  asmout := findoutput(argv!1)
   
  IF asmout=0 DO
  { writef("Trouble with file %s*n", argv!1)
    RESULTIS 20
  }
   
  writef("Converting %s to %s*n", argv!0, argv!1)
  selectinput(sialin)
  selectoutput(asmout)

  writef("@ Code generated by sial-arm*n*n")

  writef(" ra .req r4*n")
  writef(" rb .req r5*n")
  writef(" rc .req r6*n")
  writef(" rp .req r10*n")
  writef(" rg .req r11*n")

  writef(" .global divrem*n")

  writef(" .align 2*n")

  scan()
  endread()
  UNLESS asmout=stdout DO endwrite()
  selectoutput(stdout)
  writef("Conversion complete*n")
  RESULTIS 0
}

AND nextlab() = VALOF
{ labnumber := labnumber+1
  RESULTIS labnumber
}

// Argument may be of form Ln
AND rdcode(let) = VALOF
{ LET a, ch, neg = 0, ?, FALSE

  ch := rdch() REPEATWHILE ch='*s' | ch='*n'

  IF ch=endstreamch RESULTIS -1

  UNLESS ch=let DO error("Bad item, looking for %c found %c*n", let, ch)

  ch := rdch()

  IF ch='-' DO { neg := TRUE; ch := rdch() }

  WHILE '0'<=ch<='9' DO { a := 10*a + ch - '0'; ch := rdch()  }

  RESULTIS neg -> -a, a
}

AND rdf() = rdcode('F')
AND rdp() = VALOF { pval := rdcode('P'); RESULTIS pval }
AND rdg() = VALOF { gval := rdcode('G'); RESULTIS gval }
AND rdk() = VALOF { kval := rdcode('K'); RESULTIS kval }
AND rdw() = VALOF { wval := rdcode('W'); RESULTIS wval }
AND rdl() = VALOF { lval := rdcode('L'); RESULTIS lval }
AND rdm() = VALOF { mval := rdcode('M'); RESULTIS mval }
AND rdc() = rdcode('C')

AND error(mess, a, b, c) BE
{ LET out = output()
  UNLESS out=stdout DO
  { selectoutput(stdout)
    writef(mess, a, b, c)
    selectoutput(out)
  }
  writef(mess, a, b, c)
}

AND scan() BE
{ LET op = rdf()

  SWITCHON op INTO

  { DEFAULT:       error("@ Bad op %n*n", op); LOOP

    CASE -1:       RETURN
      
    CASE f_lp:     cvfp("LP") // a := P!n
                   genLdrStr("ldr", ra, rp, 4*pval)
                   ENDCASE
    CASE f_lg:     cvfg("LG") // a := G!n
                   genLdrStr("ldr", ra, rg, 4*gval)
                   ENDCASE
    CASE f_ll:     cvfl("LL") // a := !Ln
                   writef("*n ldr ra, =L%c%n", modletter, lval)
                   writef("*n ldr ra, [ra]")
                   ENDCASE

    CASE f_llp:    cvfp("LLP") // a := @ P!n
                   genAddK(ra, rp, 4*pval)
                   writef("*n mov ra, ra, lsr #2")
                   ENDCASE
    CASE f_llg:    cvfg("LLG") // a := @ G!n
                   genAddK(ra, rg, 4*gval)
                   writef("*n mov ra, ra, lsr #2")
                   ENDCASE
    CASE f_lll:    cvfl("LLL") // a := @ !Ln
                   writef("*n ldr ra, =L%c%n", modletter, lval)
                   writef("*n mov ra, ra, lsr #2")
                   ENDCASE
    CASE f_lf:     cvfl("LF") // a := byte address of Ln
                   writef("*n ldr ra, =L%c%n", modletter, lval)
                   ENDCASE
    CASE f_lw:     cvfm("LW")
                   writef("*n ldr ra, =M%c%n", modletter, mval)
                   writef("*n ldr ra, [ra]")
                   ENDCASE

    CASE f_l:      cvfk("L") // a := n
                   genLoadK(ra, kval)
                   ENDCASE
    CASE f_lm:     cvfk("LM") // a := -n
                   genLoadK(ra, -kval)
                   ENDCASE

    CASE f_sp:     cvfp("SP") // P!n := a
                   genLdrStr("str", ra, rp, 4*pval)
                   ENDCASE
    CASE f_sg:     cvfg("SG") // G!n := a
                   genLdrStr("str", ra, rg, 4*gval)
                   ENDCASE
    CASE f_sl:     cvfl("SL") // !Ln := a
                   writef("*n ldr r1, =L%c%n", modletter, lval)
                   writef("*n str ra, [r1]")
                   ENDCASE

    CASE f_ap:     cvfp("AP") // a := a + P!n
                   genLdrStr("ldr", r1, rp, 4*pval)
                   writef("*n add ra, ra, r1")
                   ENDCASE
    CASE f_ag:     cvfg("AG") // a := a + G!n
                   genLdrStr("ldr", r1, rg, 4*gval)
                   writef("*n add ra, ra, r1")
                   ENDCASE
    CASE f_a:      cvfk("A") // a := a + n
                   genAddK(ra, ra, kval)
                   ENDCASE
    CASE f_s:      cvfk("S")  // a := a - n
                   genAddK(ra, ra, -kval)
                   ENDCASE

    CASE f_lkp:    cvfkp("LKP") // a := P!n!k
                   genLdrStr("ldr", ra, rp, 4*pval)
                   genLoadK(r1, 4*kval)
                   writef("*n ldr ra, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_lkg:    cvfkg("LKG") // a := G!n!k
                   genLdrStr("ldr", ra, rg, 4*gval)
                   genLoadK(r1, 4*kval)
                   writef("*n ldr ra, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_rv:     cvf("RV")  // a := ! a
                   writef("*n add r1, ra, ra")
                   writef("*n ldr ra, [r1, r1]")
                   ENDCASE
    CASE f_rvp:    cvfp("RVP") // a := P!n!a
                   genLdrStr("ldr", r1, rp, 4*pval)
                   writef("*n mov r1, r1, lsl #2")
                   writef("*n ldr ra, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_rvk:    cvfk("RVK") // a := a!k
                   genLoadK(r1, 4*kval)
                   writef("*n ldr ra, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_st:     cvf("ST") // !a := b
                   writef("*n mov r1, #0")
                   writef("*n str rb, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_stp:    cvfp("STP") // P!n!a := b
                   genLdrStr("ldr", r1, rp, 4*pval)
                   writef("*n mov r2, ra, lsl #2")
                   writef("*n str rb, [r2, r1, lsl #2]")
                   ENDCASE
    CASE f_stk:    cvfk("STK") // a!k := b
                   genLoadK(r1, 4*kval)
                   writef("*n str rb, [r1, ra, lsl #2]")
                   ENDCASE
    CASE f_stkp:   cvfkp("STKP")  // P!n!k := a
                   genLdrStr("ldr", r1, rp, 4*pval)
                   genLoadK(r2, 4*kval)
                   writef("*n str ra, [r2, r1, lsl #2]")
                   ENDCASE
    CASE f_skg:    cvfkg("SKG") // G!n!k := a
                   genLdrStr("ldr", r1, rg, 4*gval)
                   genLoadK(r2, 4*kval)
                   writef("*n str ra, [r2, r1, lsl #2]")
                   ENDCASE
    CASE f_xst:    cvf("XST") // !b := a
                   writef("*n mov r1, #0")
                   writef("*n str ra, [r1, rb, lsl #2]")
                   ENDCASE

    CASE f_k:      cvfp("K") // Call  a(b,...) incrementing P by n
                 { LET lab =nextlab()
                   genAddK(r2, rp, 4*pval)         // NP = P + 4*pval
                   writef("*n mov r1, ra")         // r1 = a  -- the entry address
                   writef("*n mov ra, rb")         // a := b
                   //writef("*n mov lr, pc")
                   writef("*n ldr lr, =KL%c%n", modletter, lab)
                   writef("*n mov pc, r1")
                   writef("*n .ltorg")
                   writef("*nKL%c%n:", modletter,lab)
                 }
                   ENDCASE
    CASE f_kpg:    cvfpg("KPG") // Call Gg(a,...) incrementing P by n
                 { LET lab =nextlab()
                   genLdrStr("ldr", r1, rg, 4*gval)
                   genAddK(r2, rp, 4*pval)
                   //writef("*n mov lr, pc")
                   writef("*n ldr lr, =KL%c%n", modletter, lab)
                   writef("*n mov pc, r1")
                   writef("*n .ltorg")
                   writef("*nKL%c%n:", modletter,lab)
                 }
                   ENDCASE

    CASE f_neg:    cvf("NEG") // a := - a
                   writef("*n rsb ra, ra, #0") 
                   ENDCASE
    CASE f_not:    cvf("NOT") // a := ~ a
                   writef("*n mvn ra, ra") 
                   ENDCASE
    CASE f_abs:    cvf("ABS") // a := ABS a
                   writef("*n cmp ra, #0")
                   writef("*n rsblt ra, ra, #0")
                   ENDCASE

    CASE f_xdiv:   cvf("XDIV") // a := a / b; c := ?
                   writef("*n mov r0, rb")
                   writef("*n mov r1, ra")
                   writef("*n ldr r2, [pc]")
                   writef("*n mov pc, pc")
                   writef("*n .long divrem")
                   writef("*n mov lr, pc")
                   writef("*n mov pc, r2")
                   writef("*n mov ra, r0")
                   ENDCASE
    CASE f_xrem:   cvf("XREM") // a := a REM b; c := ?
                   writef("*n mov r0, rb")
                   writef("*n mov r1, ra")
                   writef("*n ldr r2, [pc]")
                   writef("*n mov pc, pc")
                   writef("*n .long divrem")
                   writef("*n mov lr, pc")
                   writef("*n mov pc, r2")
                   writef("*n mov ra, r1")
                   ENDCASE
    CASE f_xsub:   cvf("XSUB") // a := a - b
                   writef("*n sub ra, ra, rb")
                   ENDCASE

    CASE f_mul:    cvf("MUL") // a := b * a; c := ?
                   writef("*n mul ra, rb, ra")
                   ENDCASE
    CASE f_div:    cvf("DIV")  // a := b / a; c := ?
                   writef("*n mov r0, ra")
                   writef("*n mov r1, rb")
                   writef("*n ldr r2, [pc]")
                   writef("*n mov pc, pc")
                   writef("*n .long divrem")
                   writef("*n mov lr, pc")
                   writef("*n mov pc, r2")
                   writef("*n mov ra, r0")
                   ENDCASE
    CASE f_rem:    cvf("REM") // a := b REM a; c := ?
                   writef("*n mov r0, ra")
                   writef("*n mov r1, rb")
                   writef("*n ldr r2, [pc]")
                   writef("*n mov pc, pc")
                   writef("*n .long divrem")
                   writef("*n mov lr, pc")
                   writef("*n mov pc, r2")
                   writef("*n mov ra, r1")
                   ENDCASE
    CASE f_add:    cvf("ADD") // a := b + a
                   writef("*n add ra, rb, ra")
                   ENDCASE
    CASE f_sub:    cvf("SUB") // a := b - a
                   writef("*n sub ra, rb, ra")
                   ENDCASE

    CASE f_eq:     cvf("EQ") // a := b = a
                   writef("*n cmp rb, ra")
                   writef("*n mvneq ra, #0")
                   writef("*n movne ra, #0")
                   ENDCASE
    CASE f_ne:     cvf("NE") // a := b ~= a
                   writef("*n subs ra, ra, rb")
                   writef("*n mvnne ra, #0")
                   ENDCASE
    CASE f_ls:     cvf("LS") // a := b < a
                   writef("*n cmp rb, ra")
                   writef("*n mvnlt ra, #0")
                   writef("*n movge ra, #0")
                   ENDCASE
    CASE f_gr:     cvf("GR") // a := b > a
                   writef("*n cmp rb, ra")
                   writef("*n mvngt ra, #0")
                   writef("*n movle ra, #0")
                   ENDCASE
    CASE f_le:     cvf("LE") // a := b <= a
                   writef("*n cmp rb, ra")
                   writef("*n mvnle ra, #0")
                   writef("*n movgt ra, #0")
                   ENDCASE
    CASE f_ge:     cvf("GE") // a := b >= a
                   writef("*n cmp rb, ra")
                   writef("*n mvnge ra, #0")
                   writef("*n movlt ra, #0")
                   ENDCASE

    CASE f_eq0:    cvf("EQ") // a := a = 0
                   writef("*n cmp ra, #0")
                   writef("*n mvneq ra, #0")
                   writef("*n movne ra, #0")
                   ENDCASE
    CASE f_ne0:    cvf("NE") // a := a ~= 0
                   writef("*n cmp ra, #0")
                   writef("*n mvnne ra, #0")
                   ENDCASE
    CASE f_ls0:    cvf("LS") // a := a < 0
                   writef("*n cmp ra, #0")
                   writef("*n mvnlt ra, #0")
                   writef("*n movge ra, #0")
                   ENDCASE
    CASE f_gr0:    cvf("GR") // a := a > 0
                   writef("*n cmp ra, #0")
                   writef("*n mvngt ra, #0")
                   writef("*n movle ra, #0")
                   ENDCASE
    CASE f_le0:    cvf("LE") // a := a <= 0
                   writef("*n cmp ra, #0")
                   writef("*n mvnle ra, #0")
                   writef("*n movgt ra, #0")
                   ENDCASE
    CASE f_ge0:    cvf("GE") // a := a >= 0
                   writef("*n cmp ra, #0")
                   writef("*n mvnge ra, #0")
                   writef("*n movlt ra, #0")
                   ENDCASE

    CASE f_lsh:    cvf("LSH") // a := b << a; b := ?
                   writef("*n cmp ra, #31")
                   writef("*n movhi rb, #0")
                   writef("*n mov ra, rb, lsl ra")
                   ENDCASE
    CASE f_rsh:    cvf("RSH") // a := b >> a; b := ?
                   writef("*n cmp ra, #31")
                   writef("*n movhi rb, #0")
                   writef("*n mov ra, rb, lsr ra")
                   ENDCASE
    CASE f_and:    cvf("AND") // a := b & a 
                   writef("*n and ra, rb, ra") 
                   ENDCASE
    CASE f_or:     cvf("OR") // a := b | a 
                   writef("*n orr ra, rb, ra") 
                   ENDCASE
    CASE f_xor:    cvf("XOR") // a := b NEQV a
                   writef("*n eor ra, rb, ra") 
                   ENDCASE
    CASE f_eqv:    cvf("EQV") // a := b EQV a 
                   writef("*n eor ra, rb, ra") 
                   writef("*n mvn ra, ra") 
                   ENDCASE

    CASE f_gbyt:   cvf("GBYT") // a := b % a
                   writef("*n ldrb ra, [ra, rb, lsl #2]") 
                   ENDCASE
    CASE f_xgbyt:  cvf("XGBYT") // a := a % b 
                   writef("*n ldrb ra, [rb, ra, lsl #2]") 
                   ENDCASE
    CASE f_pbyt:   cvf("PBYT") // b % a := c
                   writef("*n strb rc, [ra, rb, lsl #2]") 
                   ENDCASE
    CASE f_xpbyt:  cvf("XPBYT") // a % b := c 
                   writef("*n strb rc, [rb, ra, lsl #2]") 
                   ENDCASE

// swb       Kn Ld K1 L1 ... Kn Ln   Binary chop switch, Ld default
    CASE f_swb:    cvswb()
                   ENDCASE

// swl       Kn Ld L1 ... Ln         Label vector switch, Ld default
    CASE f_swl:    cvswl()
                   ENDCASE

    CASE f_xch:    cvf("XCH") // swap a and b
                   writef("*n mov r1, ra")
                   writef("*n mov ra, rb")
                   writef("*n mov rb, r1")
                   ENDCASE
    CASE f_atb:    cvf("ATB") // b := a
                   writef("*n mov rb, ra")
                   ENDCASE
    CASE f_atc:    cvf("ATC") // c := a
                   writef("*n mov rc, ra")
                   ENDCASE
    CASE f_bta:    cvf("BTA") // a := b
                   writef("*n mov ra, rb")
                   ENDCASE
    CASE f_btc:    cvf("BTC") // c := b
                   writef("*n mov rc, rb")
                   ENDCASE
    CASE f_atblp:  cvfp("ATBLP") // b := a; a := P!n
                   writef("*n mov rb, ra")
                   genLdrStr("ldr", ra, rp, 4*pval)
                   ENDCASE
    CASE f_atblg:  cvfg("ATBLG") // b := a; a := G!n
                   writef("*n mov rb, ra")
                   genLdrStr("ldr", ra, rg, 4*gval)
                   ENDCASE
    CASE f_atbl:   cvfk("ATBL") // b := a; a := k
                   writef("*n mov rb, ra")
                   genLoadK(ra, kval)
                   ENDCASE

    CASE f_j:      cvfl("J") // jump to Ln
                   writef("*n b L%c%n", modletter, lval)
                   writef("*n .ltorg*n")
                   ENDCASE
    CASE f_rtn:    cvf("RTN") // procedure return
                   writef("*n ldmia rp, {rp, pc}")
                   writef("*n .ltorg*n")
                   ENDCASE
    CASE f_goto:   cvf("GOTO") // jump to a
                   writef("*n mov pc, ra")
                   writef("*n .ltorg*n")
                   ENDCASE

    CASE f_res:    cvf("RES")   // <res> := A
                                // <res> is already in A
                                // nothing to do
                   ENDCASE

    CASE f_ldres:  cvf("LSRES") // A := <res>
                                // A and B already set properly
                   ENDCASE

    CASE f_ikp:    cvfkp("IKP") // a := P!n + k; P!n := a
                   genLdrStr("ldr", ra, rp, 4*pval)
                   genAddK(ra, ra, kval)
                   genLdrStr("str", ra, rp, 4*pval)
                   ENDCASE
    CASE f_ikg:    cvfkg("IKG") // a := G!n + k; G!n := a
                   genLdrStr("ldr", ra, rg, 4*gval)
                   genAddK(ra, ra, kval)
                   genLdrStr("str", ra, rg, 4*gval)
                   ENDCASE
    CASE f_ikl:    cvfkl("IKL") // a := !Ln + k; !Ln := a
                   writef("*n ldr r1, =L%c%n", modletter, lval)
                   writef("*n ldr ra, [r1]")
                   genAddK(ra, ra, kval)
                   writef("*n str ra, [r1]")
                   ENDCASE
    CASE f_ip:     cvfp("IP") // a := P!n + a; P!n := a
                   genLdrStr("ldr", r1, rp, 4*pval)
                   writef("*n add ra, r1, ra")
                   genLdrStr("str", ra, rp, 4*pval)
                   ENDCASE
    CASE f_ig:     cvfg("IG") // a := G!n + a; G!n := a
                   genLdrStr("ldr", r1, rg, 4*gval)
                   writef("*n add ra, r1, ra")
                   genLdrStr("str", ra, rg, 4*gval)
                   ENDCASE
    CASE f_il:     cvfl("IL") // a := !Ln + a; !Ln := a
                   writef("*n ldr r0, =L%c%n", modletter, lval)
                   writef("*n ldr r1, [r0]")
                   writef("*n add ra, ra, r1")
                   writef("*n str ra, [r0]")
                   ENDCASE

    CASE f_jeq:    cvfl("JEQ") // Jump to Ln if b = a
                   writef("*n cmp rb, ra")
                   writef("*n beq L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jne:    cvfl("JNE") // Jump to Ln if b ~= a
                   writef("*n cmp rb, ra")
                   writef("*n bne L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jls:    cvfl("JLS") // Jump to Ln if b < a
                   writef("*n cmp rb, ra")
                   writef("*n blt L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jgr:    cvfl("JGR") // Jump to Ln if b > a
                   writef("*n cmp rb, ra")
                   writef("*n bgt L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jle:    cvfl("JLE") // Jump to Ln if b <= a
                   writef("*n cmp rb, ra")
                   writef("*n ble L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jge:    cvfl("JGE") // Jump to Ln if b >= a
                   writef("*n cmp rb, ra")
                   writef("*n bge L%c%n", modletter, lval)
                   ENDCASE

    CASE f_jeq0:   cvfl("JEQ0") // Jump to Ln if a = 0
                   writef("*n cmp ra, #0")
                   writef("*n beq L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jne0:   cvfl("JNE0") // Jump to Ln if a ~= 0
                   writef("*n cmp ra, #0")
                   writef("*n bne L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jls0:   cvfl("JLS0") // Jump to Ln if a < 0
                   writef("*n cmp ra, #0")
                   writef("*n blt L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jgr0:   cvfl("JGR0") // Jump to Ln if a > 0
                   writef("*n cmp ra, #0")
                   writef("*n bgt L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jle0:   cvfl("JLE0") // Jump to Ln if a <= 0
                   writef("*n cmp ra, #0")
                   writef("*n ble L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jge0:   cvfl("JGE0") // Jump to Ln if a >= 0
                   writef("*n cmp ra, #0")
                   writef("*n bge L%c%n", modletter, lval)
                   ENDCASE
    CASE f_jge0m:  cvfm("JGE0M") // Jump to Mn if a >= 0
                   writef("*n cmp ra, #0")
                   writef("*n bge M%c%n", modletter, mval)
                   ENDCASE

    // The following five opcodes are never generated by
    // the BCPL compiler
    CASE f_brk:    cvf("BRK") // Breakpoint instruction
                   writef("*n@ unimplemented")
                   ENDCASE
    CASE f_nop:    cvf("NOP") // No operation
                   ENDCASE
    CASE f_chgco:  cvf("CHGCO") // Change coroutine
                   writef("*n@ unimplemented")
                   ENDCASE
    CASE f_mdiv:   cvf("MDIV") // a := Muldiv(P!3, P!4, P!5) 
                   writef("*n@ unimplemented")
                   ENDCASE
    CASE f_sys:    cvf("SYS") // System function
                   writef("*n@ unimplemented")
                   ENDCASE

    CASE f_section:  cvfs("SECTION") // Name of section
                     FOR i = 0 TO charv%0 DO sectname%i := charv%i
                     ENDCASE
    CASE f_modstart: cvf("MODSTART") // Start of module  
                     sectname%0 := 0
                     ENDCASE
    CASE f_modend:   cvf("MODEND") // End of module 
                     modletter := modletter+1
                     ENDCASE
    CASE f_global:   cvglobal() // Global initialisation data
                     ENDCASE
    CASE f_string:   cvstring() // String constant
                     ENDCASE
    CASE f_const:    cvconst() // Large integer constant
                     ENDCASE

    CASE f_static:   cvstatic() // Static variable or table
                     ENDCASE
    CASE f_mlab:     cvfm("MLAB") // Destination of jge0m
                     writef("*nM%c%n:", modletter, mval)
                     ENDCASE
    CASE f_lab:      cvfl("LAB") // Program label
                     writef("*nL%c%n:", modletter, lval)
                     ENDCASE
    CASE f_lstr:     cvfm("LSTR") // a := Mn   (pointer to string)
                     writef("*n ldr ra, =M%c%n", modletter, mval)
                     writef("*n mov ra, ra, lsr #2")
                     ENDCASE
    CASE f_entry:    cventry() // Start of a function
                     ENDCASE

    CASE f_float:    cvf("FLOAT")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fix:      cvf("FIX")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fabs:     cvf("FABS")
                     writef("*n# unimplemented")
                     ENDCASE

    CASE f_fmul:     cvf("FMUL")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fdiv:     cvf("FDIV")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fadd:     cvf("FADD")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fsub:     cvf("FSUB")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fneg:     cvf("FNEG")
                     writef("*n# unimplemented")
                     ENDCASE

    CASE f_feq:      cvf("FEQ")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fne:      cvf("FNE")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fls:      cvf("FLS")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fgr:      cvf("FGR")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fle:      cvf("FLE")
                     writef("*n# unimplemented")
                     ENDCASE
    CASE f_fge:      cvf("FGE")
                     writef("*n# unimplemented")
                     ENDCASE
  }

  newline()
} REPEAT

AND opsize(k) = VALOF
{ // Returns the number of instructions needed to compute k out of 8-bit pieces
  LET s = 0
  UNLESS k RESULTIS 1
  WHILE k DO
  { // Find next 8-bit piece
    WHILE (k&3)=0 DO k := k>>2
    k, s := k>>8, s+1
  }
  RESULTIS s
}

AND genAddK(r, s, k) BE
{ // Generate code for: Rr := Rs + k
  LET opstr, sh = "add", 0
  LET neg, addch = FALSE, '+'

  IF k=0 DO
  { IF r=s RETURN
    writef("*n mov %s,%s", r, s)
    RETURN
  }
 
  IF opsize(-k)<opsize(k) DO opstr, k := "sub", -k

  WHILE (k&3)=0 DO k, sh := k>>2, sh+2

  writef("*n %s %s, %s, #%n @ %x8", // add or sub
          opstr, r, s, (k&#xFF)<<sh, (k&#xFF)<<sh)

  k, sh := k>>8, sh+8

  WHILE k DO
  { WHILE (k&3)=0 DO k, sh := k>>2, sh+2

    writef("*n %s %s, %s, #%n @ %x8",  // add or sub
            opstr, r, r, (k&#xFF)<<sh, (k&#xFF)<<sh)
    k, sh := k>>8, sh+8
  }
}

AND genOpRRK(opstr, rd, rn, k) BE
{ // Generate code for: Rr := Rs op k
  // opstr is a data processing operation such as add or sub
  // Generate f rd,rn,#k
  // or       f rn,r0,#k' preceeded by instructions to set r0 to rn+k-k'
  LET sh = 0
  LET r = rn
  LET k8 = ?

  UNLESS opsize(k)=1 DO
  { genAddK(r0, rn, k)
    r := r0
  }

  WHILE (k&3)=0 DO k, sh := k>>2, sh+2

  k8 := (k & #xFF)<<sh
  k, sh := k>>8, sh+8

  WHILE k DO
  { WHILE (k&3)=0 DO k, sh := k>>2, sh+2

    writef("*n %s %s, %s, #%n @ %x8",  // add or sub
            opstr, r, r, (k&#xFF)<<sh, (k&#xFF)<<sh)
    k, sh := k>>8, sh+8
  }

  writef("*n %s %s, %s,#%n @ %x8",
          opstr, rd, r, k8, k8)
}

AND genLoadK(r, k) BE
{ LET op1str, op2str, sh = "mov", "orr", 0

  IF opsize(~k)<opsize(k) DO op1str, op2str, k := "mvn", "bic", ~k

//writef("*n*ngenLoadK: r=%n k=%n*n", r, k)

  IF k WHILE (k&3)=0 DO k, sh := k>>2, sh+2

  writef("*n %s %s, #%n @ %x8", // mov or mvn
          op1str, r, (k&#xFF)<<sh, (k&#xFF)<<sh)

  k, sh := k>>8, sh+8

  WHILE k DO
  { WHILE (k&3)=0 DO k, sh := k>>2, sh+2

    writef("*n %s %s, %s, #%n @ %x8",  // orr or bic
            op2str, r, r, (k&#xFF)<<sh, (k&#xFF)<<sh)
    k, sh := k>>8, sh+8
  }
}

AND genLdrStr(opstr, rd, rn, k) BE
{ // opstr is "ldr" or "str"
  // Good for loading and storing locals and globals
  // If k is to large it uses register r0
  LET r, sh = rn, sh
  LET addstr = "add"
  LET plusch = '+'

  LET k12 = ?

  IF k<0 DO
  { k := -k
    addstr, plusch := "sub", '-'
  }

  k12 := k & #xFFF
  k, sh := k>>12, sh+12

  WHILE k DO
  { WHILE (k&3)=0 DO k, sh := k>>2, sh+2
    writef("*n %s r0, %s, #%n @ #%x8", addstr, r, (k & #xFF)<<sh, (k & #xFF)<<sh)
    r := 0
    k, sh := k>>8, sh+8
  }

  writef("*n %s %s, [%s, #%c%n] @ %x8", opstr, rd, r, plusch, k12, k12)
}

AND genCmpRK(r, k) BE
{ // This generates code to equivalent to cmp r, #k
  // If k is to large it uses register r0
  LET opstr, sh = "cmp", 0
  LET neg, addch = FALSE, '+'

  IF opsize(k)=1 DO
  { writef("*n cmp %s, #%n @ %x8", r, k, k)
    RETURN
  }

  IF opsize(-k)=1 DO
  { writef("*n cmn %s, #%n @ %x8", r, -k, -k)
    RETURN
  }

  genLoadK(r1, k)

  writef("*n cmp %s, r1", r)
}

AND cvf(s)   BE writef("@ %s", s)
AND cvfp(s)  BE writef("@ %t7 P%n", s, rdp())
AND cvfkp(s) BE writef("@ %t7 K%n P%n", s, rdk(), rdp())
AND cvfg(s)  BE writef("@ %t7 G%n", s, rdg())
AND cvfkg(s) BE writef("@ %t7 K%n G%n", s, rdk(), rdg())
AND cvfkl(s) BE writef("@ %t7 K%n L%n", s, rdk(), rdl())
AND cvfpg(s) BE writef("@ %t7 P%n G%n", s, rdp(), rdg())
AND cvfk(s)  BE writef("@ %t7 K%n", s, rdk())
AND cvfw(s)  BE writef("@ %t7 W%n", s, rdw())
AND cvfl(s)  BE writef("@ %t7 L%n", s, rdl())
AND cvfm(s)  BE writef("@ %t7 M%n", s, rdm())

AND cvswl() BE
{ LET n    = rdk()
  LET dlab = rdl()
  writef("@ SWL K%n L%n", n, dlab)
  genCmpRK(ra, n)
  writef("*n ldrlo pc, [pc, ra, lsl #2]")
  writef("*n b L%c%n", modletter, dlab)

  FOR i = 1 TO n DO
  { LET l = rdl()
    writef("*n .long L%c%n", modletter, l)
  }

  writef("*n .ltorg")
}

AND cvswb() BE
{ LET n    = rdk()
  LET dlab = rdl()
  writef("@ SWB K%n L%n", n, dlab)
  FOR i = 1 TO n DO 
  { LET k = rdk()
    LET l = rdl()
    writef("*n@ K%n L%n", k, l)
    genCmpRK(ra, k)
    writef("*n beq L%c%n", modletter, l)
  }
  writef("*n b L%c%n", modletter, dlab)
  writef("*n .ltorg")
}

AND cvglobal() BE
{ LET n = rdk()
  writef("@ GLOBAL K%n*n", n)
  IF sectname%0=0 FOR i = 0 TO 4 DO sectname%i := "prog"%i
  writef("*n .global %s*n", sectname)
  writef("%s:*n", sectname)
  writef("*n@ On entry r0 points to the Global vector")
  FOR i = 1 TO n DO
  { LET g = rdg()
    LET n = rdl()
    writef("*n@ G%n L%n", g, n)
    //writef("*n adrl r1, L%c%n", modletter, n)
    writef("*n ldr r1, =L%c%n", modletter, n)
    genLdrStr("str", r1, r0, 4*gval)
  }
  writef("*n@ G%n", rdg())
  writef("*n mov pc, lr*n")
  writef("*n .ltorg*n")
}

AND rdchars() = VALOF
{ LET n = rdk()
  charv%0 := n
  FOR i = 1 TO n DO charv%i := rdc()
  RESULTIS n
}

AND cvstring() BE
{ // Place strings in the data (read/write) section
  LET lab = rdm()
  LET n = rdchars()
  writef("@ STRING  M%n K%n", lab, n)
  FOR i = 1 TO n DO writef(" C%n", charv%i)
  writef("*n .data")
  writef("*nM%c%n:", modletter, lab)
  FOR i = 0 TO ((n+4)&-4)-1 DO // Round up to a multiple of 4
  { TEST i MOD 4 = 0
    THEN writef("*n .byte ")
    ELSE writef(",")
    TEST i>n THEN writef("%3i", 0)
             ELSE writef("%3i", charv%i)
  }
  writef("*n .text")
}

AND cvconst() BE
{ // Place constants in the text (read only) section
  LET lab = rdm()
  LET w = rdw()
  writef("@ CONST   M%n W%n", lab, w)
  writef("*nM%c%n:", modletter, lab)
  writef("*n .long %n", w)
}

AND cvstatic() BE
{ // Place STATIC variables in the data (read/write) section
  LET lab = rdl()
  LET n = rdk()
  writef("@ STATIC  L%n K%n", lab, n)
  writef("*n .data")
  writef("*nL%c%n:", modletter, lab)
  FOR i = 1 TO n DO { writef("*n@ W%n", rdw())
                      writef("*n .long %n", wval)
                    }
  writef("*n .text")
}

AND cvfs(s) BE
{ LET n = rdchars()
  writef("@ %t7 K%n", s, n)
  FOR i = 1 TO n DO writef(" C%n", charv%i)
}

AND cventry() BE
{ // On entry
  // r1 = <entry address>
  // r2 = <new P pointer>
  // r4 = <first arg>
  // r10 = <old P pointer>
  LET n = rdchars()
  LET op = rdf()
  LET lab = rdl()
  writef("*n@ Entry to: %s*n", charv)
  writef("@ %t7 K%n", "ENTRY", n)
  FOR i = 1 TO n DO writef(" C%n", charv%i)
  newline()
  TEST op=f_lab THEN writef("@ LAB     L%n*n", lab)
                ELSE writef("@ Bad op F%n L%n*n", op, lab)
  writef("*nL%c%n:", modletter, lab)
  writef("*n stmia r2!, {r10,lr}")  // NP!0, NP!1 := P, <return> 
  writef("*n stmia r2, {r1,ra}")    // NP!2, NP!3  := r1, r4  -- <entry>, <arg1>
  writef("*n sub rp, r2, #8")        // P    := NP
  // P -> [<old P>, <return addr>, <entry addr>, <first arg>, ... ]
}
