package tree;

import lib.*;
import err.*;
import code.*;

/** This represents an string constant.
 */
public class StringNode extends Tree {

    public String str;

    public StringNode(String str) {
	this.str = str;
    }

    public void load() throws Fatalerror {
	//writes("StringNode.load called for "+str+"\n");
	int strlab = nextlab();
	Code.outstring(strlab, str);
	Code.outfl(Code.Laddr, strlab);
	ssp++;
    }

    public void loadlist() throws Fatalerror {
	//writes("StringNode.loadist called for "+str+"\n");
	load();
    }

    public void plist(String indent, int n) {
	writes("\""+str+"\""+"\n");
    }
}

