package lib;

import java.io.*;
import err.*;

public class Lib {

    public static final int maxint = 0x7FFFFFFF;
    public static final int c_eof = -1;
    public static final int c_tab =  9;
    public static final int c_newline = 10;

    public static DataInputStream cis;
    public static DataOutputStream cos;

    public static void init_lib() {
	selectinput(new DataInputStream(System.in));
	selectoutput(new DataOutputStream(System.out));
    }

    public static DataInputStream findinput(String name)
    {
	try {
	    return new DataInputStream(new FileInputStream(name));
	} catch(IOException e) {
	    return null;
	}
    }

    public static DataOutputStream findoutput(String name)
    {
	try {
	    return new DataOutputStream(new FileOutputStream(name));
	} catch(IOException e) {
	    return null;
	}
    }

    public static void selectinput(DataInputStream stream) {
	cis = stream;
    }

    public static void selectoutput(DataOutputStream stream) {
	cos = stream;
    }

    public static int rdch() {
	try {
	    return cis.read();
	} catch(IOException e) {
	    return c_eof;
	}
    }

    public static void wrch(int ch) {
	try {
	    cos.write((char)ch);
	} catch(IOException e) {
	}
    }

    public static void wrch(char ch) {
	try {
	    cos.write(ch);
	} catch(IOException e) {
	}
    }


    public static void endread() {
	try {
	    cis.close();
	    cis = null;
	} catch(IOException e) {
	}
    }

    public static void endwrite() {
	try {
	    cos.close();
	    cos = null;
	} catch(IOException e) {
	}
    }

    public static void wrd(int n, int d) {
        if(n<0) d--;
        if (n<1000000000 && d>=10) wrch(' ');
        if (n<100000000 && d>=9) wrch(' ');
        if (n<10000000 && d>=8) wrch(' ');
        if (n<1000000 && d>=7) wrch(' ');
        if (n<100000 && d>=6) wrch(' ');
        if (n<10000 && d>=5) wrch(' ');
        if (n<1000 && d>=4) wrch(' ');
        if (n<100 && d>=3) wrch(' ');
        if (n<10 && d>=2) wrch(' ');
        if(n<0) { wrch('-'); n = -n; }
        wrpn(n);
    }

    private static void wrpn(int n) {
	if (n>9) wrpn(n/10);
	wrch((char)('0'+(n%10)));
    }

    public static void wrx(int n, int d) {
        if (n>>>28 == 0 && d>=8) wrch(' ');
        if (n>>>24 == 0 && d>=7) wrch(' ');
        if (n>>>20 == 0 && d>=6) wrch(' ');
        if (n>>>16 == 0 && d>=5) wrch(' ');
        if (n>>>12 == 0 && d>=4) wrch(' ');
        if (n>>> 8 == 0 && d>=3) wrch(' ');
        if (n>>> 4 == 0 && d>=2) wrch(' ');
        wrhex(n);
    }

    private static void wrhex(int n) {
	int dig = n & 15;
	if (n>>>4 != 0) wrhex(n>>>4);
	wrch((char)((0<=dig && dig<=9) ? '0'+dig : 'A'+dig-10));
    }

    public static void writet(String s, int n) {
	int len = s.length();
	for(int i=0; i<len; i++) wrch(s.charAt(i));
	for(int i=len+1; i<=n; i++) wrch(' ');
    }

    public static void writes(String s) {
	writet(s, 0);
    }

    public static void newline() {
	wrch('\n');
    }
}
