package lex;

import tree.*;

public class Nametab {
    final static int tablesize = 541;
    public static IdNode wordnode = null;
    public static IdNode namestart = null;

    static IdNode[] table;

    public static void init() {
	table = new IdNode[tablesize];
	for (int i=0; i<tablesize; i++) table[i] = null;
        declsyswords();
    }

    public static int lookup(String word) {
	int p = 0;
	int len = word.length();
	int hashval = 0;

	for(int i=0; i<len; i++)
	    hashval = (13*hashval + word.charAt(i)) & 0xFFFFFF;
	hashval %= tablesize;
	wordnode = table[hashval];

	while(wordnode!=null && !wordnode.str.equals(word))
	    wordnode = wordnode.link;

	if(wordnode==null) {
	    wordnode = new IdNode(table[hashval], word);
	    table[hashval] = wordnode;
	}
	//System.out.println("Nametab.lookup: "+word+
        //                   " hashval="+hashval+
        //                   " tok="+wordnode.tok);
	return wordnode.tok;
    }


    private static void dsw(String word, int tok) {
	lookup(word);
	wordnode.tok = tok;
    }
 
    private static void declsyswords() {
	dsw("be", Lex.Be);              dsw("do", Lex.Do);
	dsw("else", Lex.Else);	        dsw("false", Lex.False);
        dsw("if", Lex.If);      	dsw("for", Lex.For);
        dsw("let", Lex.Let);    	dsw("mod", Lex.Mod);
        dsw("printf", Lex.Printf);	dsw("resultis", Lex.Resultis);
        dsw("return", Lex.Return);	dsw("static", Lex.Static);
	dsw("sys", Lex.Sys);    	dsw("test", Lex.Test);
        dsw("to", Lex.To);      	dsw("true", Lex.True);
        dsw("then", Lex.Then);  	dsw("valof", Lex.Valof);
	dsw("vec", Lex.Vec);    	dsw("unless", Lex.Unless);
        dsw("until", Lex.Until);	dsw("while", Lex.While);
	lookup("start");
	namestart = wordnode;
    }
}
