// This is a test program for the VSPL compiler and interpreter.
// It is based on cmpltest.b.

// Last updated by Martin Richards (c) 9 Aug 2021

// For the initial tests the ONLY free variable of this program is: sys
// used in the implementation of wrc.

static f, g, h,
       testno, failcount,
       testcount, quiet,
       bitsperword, msb, allones,
       on64, // true if running on a 64-bit system 
       
       a, b, c, v, w, minus1

let ts(x) be
{ let a = 0;
  let w = valof
  while true do
  { a := a+1;
    if a>10 do resultis 123;
    a := a+12
  };

  a := 101
}

let wrc(ch) be printf("%c", ch)

let getbyte(s, i) = valof
{ let w = s[i/4];
  let sh = (i mod 4) * 8;
  resultis (w >> sh) & 255
}

let putbyte(s, i, b) be
{ let w = s[i/4];
  let sh = (i mod 4) * 8;
  let x = ((w >> sh) ^ b) & 255;
  s[i/4] := w ^ (x << sh)      // Note that a ^ a ^ b is equal to b
}

let wrs(s) be
{ let i = 0;
  while true do
  { let ch = getbyte(s,i);
    if ch=0 do return;
    wrc(ch);
    i := i+1
  }
}

let nl() be wrc('\n')

let wrd(n, d) be //wrx(n,8)

{ vec t[30];
  let i = 0;
  let k = -n;
  if n<0 do { d := d-1; k := n };
  t[i] := -(k mod 10);
  i := i+1;
  k := k/10;
  until k=0 do
  { t[i] := -(k mod 10);
    i := i+1;
    k := k/10
  };
  for j = i+1 to d do wrc(' ');
  if n<0 do wrc('-');
  for j = 1 to i do wrc(t[i-j]+'0')
}

let wrn(n) be wrd(n, 0)

let wrx(n, d) be
{ let x = n & 15;
  if d>1 do wrx(n>>4, d-1);
  test x>9
  then wrc('A' + x - 10)
  else wrc('0' + x)
}

let t(x, y) = valof
{ testcount := testcount + 1;
  unless quiet & x=y do 
  { wrd(testno, 4);
    wrs("         ");
    test on64 then wrd(x, 21)
              else wrd(x, 13);
    wrc('(');
    test on64 then wrx(x, 16)
              else wrx(x,  8);
    wrs(")    ");
    test on64 then wrd(y, 21)
              else wrd(y, 13);
    wrc('(');
    test on64 then wrx(y, 16)
              else wrx(y,  8);
    wrs(")");

    test x=y
    then { wrs(" OK")
         }
    else { wrs(" FAILED");
           failcount := failcount + 1
         };
    nl()
  };
  testno := testno + 1;
  resultis y
}

let t1(a,b,c,d,e,f,g) = t(a+b+c+d+e+f, g)

let start(parm) = valof
{ let ww = 65;
  vec v1[201];
  vec v2[201];
//  sys(2,1);
//abort(101);
  a := 10;
  b := 11;
  c := 12;
  w := 15;
  minus1 := -1;

  if false do
  { // Test the basic output functions.
    wrc('X'); wrc('Y'); wrc('Z'); nl();
    wrc('T'); nl();
    wrs("ABCD\n");
    wrs("PQRS\n");
    wrx(7*256+15*16 + 15 , 4); nl();
    wrd(1234, 6); nl();
    wrs("ABCD\n");
    resultis 0
  };
  
  wrs("\nVSPL tester running on a ");
  bitsperword := 1;
  msb := 1;
  allones := 1;
  until (msb<<1)=0 do
  { bitsperword := bitsperword+1;
    msb := msb<<1;
    allones := allones<<1 | 1
  };
  on64 := bitsperword=64; // =true if running on a 64-bit system
  test getbyte(@ww, 0)=65
  then wrs("little")
  else wrs("big");
  wrs(" ender machine\n");

  wrs("The VCPL word is ");
  wrd(bitsperword, 0);
  wrs(" bits long\n\n");

  tester(0, 1, 2, v1, v2);

  if false do
  { let n = 1;   // special test for the << and >> operators
    for i = -5 to 40 do printf(" 1 <<%2d = %8x\n", i, 1<<i);
    for i = -5 to 40 do printf("msb>>%2d = %8x\n", i, msb>>i);
    n := -2;
    printf(" #A <<%2d = %2x\n", n, #A<<n);
    printf(" #A >>%2d = %2x\n", n, #A>>n)
  };
    
  resultis 0
}

let tx(x, y) = valof { let z = x=y; resultis y }

let abort(n) be
{ printf("\nabort: n=%d\n", n);
  n := n/0   // Used when debugging
}

// As a debugging technique, try replacing
//
//       t(a+b+c, 33);        // 1
// by
//       sys(2,1); // Turn on instruction tracing
//       tx(a+b+c, 33);       // tx just tests it arguments for equality
//       abort(1000);


let chk(p) be
{ wrs("p="); wrd(p, 0); wrs(" !p="); wrd(!p, 0); nl();
  abort(8787)
}

let tester(x, y, z, v1, v2) be
{ let n0 = 0;
  let n1 = 1;
  let n2 = 2;
  let n3 = 3;
  let n4 = 4;
  let n5 = 5;
  let n6 = 6;
  let n7 = 7;
  let n8 = 8;
  let n9 = 9;

//wrs("\nVCPL System tester entered\n");

//  FIRST INITIALIZE CERTAIN VARIABLES

  f := 100;
  g := 101;
  h := 102;
  testno := 0;
  testcount := 0;
  failcount := 0;
  v := v1;
  w := v2;

  for i = 0 to 200 do
  { v[i] := 1000+i;
    w[i] := 10000+i
  };
  quiet := true;
  //quiet := false;

//  TEST SIMPLE VARIABLES AND EXPRESSIONS

  testno := 1;

  t(a+b+c, 33);        // 1
  t(f+g+h, 303);
  t(x+y+z, 3);

  t(123+321-400, 44);  // 4
  t(x=0, true);
  t(y=0, false);
  t(!(@y+x), 1);
  t(!(@b+x), 11);
  t(!(@g+x), 101);

  x := 5;
  a := 15;
  f := 105;
  t(x, 5);            // 10
  t(a, 15);
  t(f, 105);

  v[1] := 1234;
  v[2] := 5678;
  t(v[1], 1234);       // 13
  t(v[z], 5678);

  t(x*a, 75);         //  15
  t(1*x+2*y+3*z+f*4,433);
  t(x*a+a*x, 150);

  testno := 18;

  t(100/(a-a+2), 50); //  18
  t(a/x, 3);
  t(a/-x, -3);
  t((-a)/x, -3);
  t((-a)/(-x), 3);

  testno := 23;
  t((a+a)/a, 2);
  t((a*x)/(x*a), 1);

  testno := 25;
  t((a+b)*(x+y)*123/(6*123), 26);
  t(n7 mod 2, 1);      //  26
  t(f mod 100, 5);
  t(a mod x, 0);

  t(-f, -105);       //  29

  f := 105;
  t(f = 105, true);   // 30
  t(f~= 105, false);
  t(f < 105, false);
  t(f>= 105, true);
  t(f > 105, false);
  t(f<= 105, true);

  f := 104;
  t(f = 105, false);  // 36
  t(f~= 105, true);
  t(f < 105, true);
  t(f>= 105, false);
  t(f > 105, false);
  t(f<= 105, true);

  f := 0;
  t(f = 0, true);    // 42
  t(f~= 0, false);
  t(f < 0, false);
  t(f>= 0, true);
  t(f > 0, false);
  t(f<= 0, true);

  f := 1;
  t(f = 0, false);   // 48
  t(f~= 0, true);
  t(f < 0, false);
  t(f>= 0, true);
  t(f > 0, true);
  t(f<= 0, false);

  testno := 60;

  { let yes = true;
    let no  = false;

    testno := 70;

    t(#C & #A, #8);             //  70
    t(#C | #A, #E);
    t(#C ^ #A, #6);

    t(~yes, no);                // 75
    t(~no, yes)
  };

  testno := 80;
  f := 105;
  t(-f, -105);               // 80
  t(!v, 1000);               // 81
  t(v[0], 1000);
  t(v[1], 1234);
  t(v[!v-998], 5678);

  testno := 90;

  t(!w, 10000);              // 90
  t(w[0], 10000);
  t(0[w], 10000);
  t(1[w], 10001);
  t(w[1], 10001); 
  t(!(w+200), 10200);

  a := true;
  b := false;

  if a do x := 16;
  t(x, 16);                  // 96
  x := 16;

  if b do x := 15;
  t(x, 16);                  // 97
  x := 15;

  a := valof resultis 11;
  t(a, 11);                  // 98

  testno := 100;  // TEST SIMULATED STACK ROUTINES
if false do
  { vec v1[1];
    v1[0] := -1;
    v1[1] := -2;
    { vec v2[10];
      for i = 0 to 10 do v2[i] := -i;
      t(v2[5], -5)            //  101
    };
    t(v1[1], -2)              //  102
  };

  x := x + t(x,15, t(f, 105), t(a, 11)) - 15;   // 103-105
  t(x, 15);                                     // 106

  x := x+1;
  t(x, 16);   // 107
  x := x-1;
  t(x, 15);   // 108
  x := x+7;
  t(x,22);    // 109
  x := x-22;
  t(x, 0);    // 110
  x := x+15;
  t(x, 15);   // 111
  x := x + f;
  t(x, 120);  // 112
  x := 1;

  testno := 130;
  f := 105;
  test f  = 105 then g := 1 else g := 2; t(g, 1);  // 130
  test f ~= 105 then g := 1 else g := 2; t(g, 2);
  test f  < 105 then g := 1 else g := 2; t(g, 2);
  test f >= 105 then g := 1 else g := 2; t(g, 1);
  test f  > 105 then g := 1 else g := 2; t(g, 2);
  test f <= 105 then g := 1 else g := 2; t(g, 1);

  testno := 136;
  f := 104;
  test f  = 105 then g := 1 else g := 2; t(g, 2);  // 136
  test f ~= 105 then g := 1 else g := 2; t(g, 1);
  test f  < 105 then g := 1 else g := 2; t(g, 1);
  test f >= 105 then g := 1 else g := 2; t(g, 2);
  test f  > 105 then g := 1 else g := 2; t(g, 2);
  test f <= 105 then g := 1 else g := 2; t(g, 1);

  testno := 142;
  f := 0;
  test f  = 105 then g := 1 else g := 2; t(g, 2);  // 142
  test f ~= 105 then g := 1 else g := 2; t(g, 1);
  test f  < 105 then g := 1 else g := 2; t(g, 1);
  test f >= 105 then g := 1 else g := 2; t(g, 2);
  test f  > 105 then g := 1 else g := 2; t(g, 2);
  test f <= 105 then g := 1 else g := 2; t(g, 1);

  f := 1;
  test f  = 0 then g := 1 else g := 2; t(g, 2);  // 148
  test f ~= 0 then g := 1 else g := 2; t(g, 1);
  test f  < 0 then g := 1 else g := 2; t(g, 2);
  test f >= 0 then g := 1 else g := 2; t(g, 1);
  test f  > 0 then g := 1 else g := 2; t(g, 1);
  test f <= 0 then g := 1 else g := 2; t(g, 2);

  testno := 250;  // TEST FUNCTION CALLING
  t1(1,2,3,4,5,6, 21);
  t1(t(1,1), t(2,2), t(3,3), t(4,4), t(5,5), t(6,6),
     t(21,21));
//sys(2,1);
  t1(valof resultis 1,
     valof resultis 2,
     valof resultis 3,
     valof resultis 4,
     valof resultis 5,
     valof resultis 6,
     21);
//abort(2222);
  t1(valof resultis 1,
     t(2,2),
     valof resultis 3,
     t(4,4),
     valof resultis 5,
     t(6,6),
     21);
  t1( 1, t(2,2), valof resultis 3,
      4, t(5,5), valof resultis 6,
      21);
  t1(!v,v[0],v[200],!w,w[0],w[200], 2*1000+1200+2*10000+10200);
  (t1+(x+x)/x-2)(1,1,1,1,1,1,6);

  testno := 300;  // TEST EXPRESSION OPERATORS

  f := 105;
  t((2+3)+f+6,116);
  t(f+2+3+6,116);
  t(6+3+2+f, 116);
  t(f-104, 1);
  test(x+2)=(x+2)  then t(99,99) else t(98,99);
  test f<f+1       then t(21,21) else t(22,21);
  test f>f+1       then t(31,32) else t(32,32);
  test f<=105      then t(41,41) else t(42,41);
  test f>=105      then t(51,51) else t(52,51);

  testno := 400;  // TEST REGISTER ALLOCATION ETC.

  x := 0;
  y := 1;
  z := 2;
  t(x, 0);
  t(y, 1);
  t(z, 2);
  f := 101;
  g := 102;
  h := 103;
  a := 11;
  b := 12;
  c := 13;
  t(x+1,1);
  t(f+1, 102);
  t(a+1, 12);
  t(!(@a*2/2+f-101),11);
  a := @f;
  t(!a, 101);
  b := @g;
  a := @b;
  t(!!a, 102);
  w[0] := @w[1];
  w[1] := @h;
  t(z*y+(w[0])[0][0]-2, 103);
  t(z*y+w[1][0]-2, 103);
  t(t(123,123),t(123,123));

  testno := 500; // test 16 and 32  bit cintcode operands

  x := 100;
  t(x*x, 10000);               // LH
  t(x*x*x*x, 100000000);       // LW
  t(x*x+10000, 20000);         // AH
  t(x*x+100000000, 100010000); // AW
  t(x*x-10000, 0);             // SH
  t(x*x-100000000, -99990000); // AW

  testno := 600;

  locals(103,104,105,106,107,108,109,110,111,112,113,114,115,116,117);

  testno := 700;

  a := 1;
  b := msb;
  c :=  allones;
  t(a<<0, 1);
  t(a<<1, 2);
  t(a<<2, 4);
  t(a<<bitsperword-1, msb);
  t(a<<bitsperword,     0);
  t(a<<bitsperword+1,   0);

  t(a>>0, 1);
  t(b>>bitsperword-1, 1);
  t(c>>bitsperword-1, 1);
  t(b>>bitsperword,   0);
  t(c>>bitsperword,   0);

  testno := 800;
  a :=  20;
  b := -30;
  c :=   0;

  testno := 803;

  v[0] := 1001;
  t(v[0], 1001);

  testno := 804;

  v[1] := 1002;
  t(v[1], 1002);

  testno := 805;

  v[2] := 1003;
  t(v[2], 1003);

  testno := 806;

  v[3] := 1004;
  t(v[3], 1004);

  testno := 807;

  v[4] := 1005;
  t(v[4], 1005);
  w[0] := 2001;
  t(w[0], 2001);
  w[1] := 2002;
  t(w[1], 2002);
  w[2] := 2003;
  t(w[2], 2003);
  w[3] := 2004;
  t(w[3], 2004);
  w[4] := 2005;
  t(w[4], 2005);


  putbyte(w, 0, 21);
  t(getbyte(w, 0), 21);  // 813
  putbyte(w, 1, 22);
  t(getbyte(w, 1), 22);
  putbyte(w, 2, 23);
  t(getbyte(w, 2), 23);
  putbyte(w, 3, 3);
  t(getbyte(w, 3), 3); // compiles xpbyt instruction  816

  a := 10;
  b := a<<5;
  putbyte(w, 4, a);
  t(getbyte(w, 4), 10); //                             817

  a := 100;
  b := 101;
  g := 300;
  a := a+1;
  t(a, 101); //                             818
  a := a+b;
  t(a, 202); //                             819
  g := g+b;
  t(g, 401);

  g := 8;
  b := 3;
  a := g mod b;
  t(a, 2);

  g := 20;
  b := 12;
  a := g - b;
  t(a, 8);

  testno := 3100;

  t(minus1, -1);
  nl();
  wrn(testcount);
  wrs(" TESTS COMPLETED, ");
  wrn(failcount);
  wrs(" FAILURE(S)\n")
}


let locals(p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17) be
{ t(p3, 103);
  t(p4, 104);
  t(p5, 105);
  t(p6, 106);
  t(p7, 107);
  t(p8, 108);
  t(p9, 109);
  t(p10,110);
  t(p11,111);
  t(p12,112);
  t(p13,113);
  t(p14,114);
  t(p15,115);
  t(p16,116);
  t(p17,117)
}
