static
  sys_findinput,
  sys_findoutput,
  sys_selectinput,
  sys_selectoutput,
  sys_input,
  sys_output,
  sys_rdch,
  sys_wrch,
  sys_endread,
  sys_endwrite,

  ch

let initstatics() be
{ sys_findinput    := 4;
  sys_findoutput   := 5;
  sys_selectinput  := 6;
  sys_selectoutput := 7;
  sys_input        := 8;
  sys_output       := 9;
  sys_rdch         := 10;
  sys_wrch         := 11;
  sys_endread      := 12;
  sys_endwrite     := 13
}

let start() be
{ let progfile = "iotst.vs";
  let tofilename = "junk";
  let dummy = initstatics();
  let instream = 0;
  let outstream = 0;
  let stdin  = sys(sys_input);
  let stdout = sys(sys_output);
  
  printf("iotst entered\n");

  printf("progfile=%s\n", progfile);
  instream := sys(sys_findinput, progfile);
  sys(sys_selectinput, instream);

  printf("tofilename=%s\n", tofilename);
  outstream := sys(sys_findoutput, tofilename);
  sys(sys_selectoutput, outstream);

  ch := sys(sys_rdch);
  while ch>0 do
  { sys(sys_wrch, ch);
    ch := sys(sys_rdch)
  };
  sys(sys_endread);
  sys(sys_endwrite);
  sys(sys_selectinput, stdin);
  sys(sys_selectoutput, stdout);
  printf("File %s copied to %s\n", progfile, tofilename);
  printf("\nEnd of test\n");
  return
}
