
//############# UNDER DEVELOPMENT ################################
//############# NOT YET WORKING   ################################

/*
This will be a Java translation from BCPL of the new version of the
Tcobench Benchmark.  See the file tcobench.pdf available via my home
page (www.cl.cam.ac.uk/users/mr10) for details.

Implemented  by Martin Richards (c) December 2015

Change History

01/10/15 Implementation started.


This Java version of the tcobench benchmark program attempts to follow
the logic of the BCPL version as closely as possible. It uses
coroutines implemented by callco, resumeco and cowait, defined as
methods in the abstract class Task. The functions qpkt and taskwait
are also defined in this class. Sub-classes of Task are use different
constructors to model both Tripos tasks and BCPL coroutines.

The class Globals holds environment values, such as climax and
tracing.  The variable g is present in every task and coroutine
allowing them to use expressions such as g.climax and g.tracing. Once
initialised these values remain constant and so can be accessed
without using synchronisation features. Declaring all variables in
Globals as volatile may be safer but less efficient.

Tasks and coroutines are not created using createtask or creatco as in
the BCPL, but use new and start typically as follows.

  g.clock = new Clock("Clock", g, 10);
  g.clock.start();

or

  loggerco = new Loggerco("Logger", t);
  loggerco.parent = this; 
  loggerco.value = null;
  t.currco = echoco; 
  loggerco.start();

These both create and start Java threads. The run method defined in
Task causes new tasks to be left waiting in taskwait for a startup
packet, and non root coroutines to be left in the call of cowait in
the coroutine main loop.

  while (!dying) c = fn(cowait(c));

For coroutines, t is the owning task. This is assigned to the instance
variable t allowing convenient access to fields of the owning task
such as t.wkq or t.currco. Such values are analogous to BCPL global
variables of the owning task. Note that each task has its own work
queue and current coroutine and these must be accessible to the
methods qpkt, taskwait, callco, resumeco and cowait that are all
method of class Task.

When a new coroutine is created t.currco is the creating coroutine and
so is the initial parent of the newly created coroutine. Coroutine
threads have the same priority as the owning task. The class
representing a non-root coroutine should be a sub-class of class Task
giving direct access to methods such as qpkt, taskwait, callco and
cowait. They should not be sub-classes of the owning task's class.

The clock device is implemented as a high priority task that models
the Tripos clock device as closely as possible. It uses a priority
queue based on the heap structure used in heapsort.

The Java classes that model the Tripos tasks are: Controller, Clock,
Stats, Bounce, Printer, Client, Server and Multiplexor.  The classes
modelling coroutines are: Workerco, Loggerco, Mpxrdco, Mpxwrco and
Echoco. Coroutines belonging to a task can only be created by
coroutines belonging to the same task. The root coroutine is created
when the task was created, and is initially suspended in taskwait()
waiting for its startup packet. All other coroutines belonging to a
task are suspended in callco, resumeco or cowait except for the
current coroutine whose thread is held in t.currco. The variable t
always points to the instance variables of the owning task.
*/

//**********************************************************************
//*************************** Tcobench *********************************
//**********************************************************************

public class Tcobench implements Manifests {
    // This is the main class of the tcobench benchmark program.
    // Its static method main is the first to be entered.

    static String coName = "Tcobench";

    public static void main(String[] args)
    {
	// Global variables accessible to all tasks and coroutines
	// in the benchmark.
	Globals g = new Globals();

	g.startmsecs = System.currentTimeMillis(); // Needed by nowmsecs()

	System.out.println("\n###### THIS PROGRAM IS UNDER DEVEOPMENT ######\n");

	System.out.println("Thread and Coroutine Benchmark");
	System.out.println("Implemented in Java using coroutines\n");

	// Read the Tcobench parameters and place them in the instance of
	// class Globals accessible via g.
	g.rdargs(args);

	// Create the Controller task
	g.controller = new Controller("Controller", g, Thread.MAX_PRIORITY-1);
	//if (g.tracing) System.out.println(coName+": Creating task "+g.controller.coName);

        //System.out.println(coName+": Giving the controller it startup pkt");

	// We would like to perform:
	//    qpkt(new Pkt(null, g.controller, act_startcontroller));
	// but this cannot be done from a static context, so we do it
	// by ad hoc means.

	g.controller.wkq = new Pkt(null, g.controller, act_startcontroller);
	g.controller.currco = null; // No valid current coroutine yet.
                                    // This will be the parent of the
                                    // Controller coroutine.
        //System.out.println(coName+": Starting task "+g.controller.coName);
	g.controller.start();

	// Note that unwait can be used to resume the execution of taskwait
	// as well as suspended coroutines since it is just a synchronized
	// method that calls notifyAll().

	// The controller will find it has its startup packet in wkq
	// and so will immediately return with it from its initial call of
	// taskwait(). The startup packet will then be given to the 
	// controller's fn method. Returning from fn will cause run to
	// return and this caused the controller to die.

	//System.out.println(coName+": Wait for the Controller to finish\n");

        // Wait for the controller to finish
	try { g.controller.join(); }
	catch(Exception e) {}

	System.out.println(coName+": Controller has finished");

	System.out.println("Tcobench has finished");

        return;
    }

    public Object fn(Object x) {
	System.out.println(coName+": fn called");
	return null;
    }
}

//**********************************************************************
//**************************** Cortn ***********************************
//**********************************************************************


abstract class Cortn extends Thread implements Manifests {
    // All sub-classes of Cortn must define its main function fn.

    // This is a simple class that just defines a few variables
    // that belong to coroutines.

    // All coroutines have names held in coName
    String coName;
    public Globals g;      // The global parameters, accessible to all
                           // coroutines.

    Task t;   // The task that owns this coroutine. It used
              // by methods such as callco, and cowait defined
              // in this class.
              // Note the r points to the same set of instance
              // variables but is declared in each coroutine class
              // with the appropriated type.

    // Each coroutine has a parent field which may be null.
    public Cortn parent; // This coroutine's parent.
    Object value;        // The value passed to this coroutine.
    boolean isroot;      // =true for root coroutines
    boolean dying;       // =true if this coroutine is dying.

    // Classes defining BCPL style tasks are sub-classes of Task
    // which is itself a sub-class of Cortn. The constructor
    // for such a class creates and instance with a given name,
    // a pointer to its globals, and its thread priority.
    // The resulting thread runs as the root coroutine of the task.

    // Non-root coroutines are implemented as sub-classes of Cortn
    // and have constructors that specified the coroutine name and
    // the pointer to the instance variables of the owning BCPL
    // style task.

    public Cortn(String name, Globals g, int pri) {
	// This is used by the constructor in class Task when
	// creating a Tripos style task.
        isroot = true;          // This is a non-root coroutine
	coName = name;
	setPriority(pri);       // Same priority as its owning task.
	this.g = g;

	// When the thread is started it enters run() defined in
	// class Task, not the version of run() defined in this
	// class.
    }

    public Cortn(String name, Task t) {
	// This is used by the constructors in non-root coroutines.
	// Task r is the owning task. The code that starts this
	// coroutine sets the parent field and changes t.currco.
	// It then calls start, immediately followed by currcowait().
	// This should leave the coroutine suspended in cowait() of
	// the coroutine's main loop (defined in run).

        isroot = false;         // This is a non-root coroutine
	coName = name;
	setPriority(t.pri);     // Same priority as its owning task.
	this.g = t.g;
        this.t = t;             // Task t owns this coroutine. It is
                                // used by callco, cowait etc.
	dying = false;
	//System.out.println(coName+": Coroutine created t="+t);

	// parent and t.currco are set by the calling coroutine.
    }

    public void run() {
	//System.out.println(coName+": Coroutine thread entered for the first time");
	Object c = null; // Dummy value.

	//System.out.println(coName+": parent="+parent.coName);

	// Enter the standard coroutine loop.
	while (!dying) {
	    //System.out.println(coName+": c="+((Integer)c).toString());
	    //System.out.println(coName+": Calling cowait(c)");
	    c = cowait(c);
	    //System.out.println(coName+": Calling fn(c)");
	    c = fn(c);
	    //System.out.println(coName+": fn returned "+c);
	}

	System.out.println(coName+": Dying");
	return;
    }

    abstract public Object fn(Object x);

    // Conventional coroutine API

    // Their implementation is subtle so some explanation is given here.

    // BCPL style coroutines each have their own runtime stack and so
    // in Java they must be threads. Every coroutine has a corresponding
    // a class. Those that define BCPL style tasks are sub-classes
    // of the class Task which in turn is a sub-class of Cortn. When such
    // a task starts it runs are the root coroutine and has direct access
    // all the Tripos style variables such as wkq, currco and parent,
    // and can also call qpkt, taskwait, callco, resumeco and cowait
    // directly. Classes for non-root coroutines are not sub-classes of
    // Task but are just sub-classes of Cortn. They can access the
    // variables of the owning task indirectly using t of type Task.
    // For specific Tcobench coroutines such as workerco there is another
    // pointer r declared with an appropriate type in its own coroutine
    // class. For instance, in class Workerco there is the declaration
    // Server r. This is initialised to point to the same set of
    // instance variables as t but has a type that allows access to
    // variables of the BCPL style task that owns the coroutine. So, for
    // example, a worker can access its server number using r.srvno.
    // Within a non-root coroutine functions such as qpkt and callco can
    // be accessed using t, as in t.qpkt. The same function can also be
    // accessed by r.qpkt, but this is not recommended since qpkt is
    // a method defined in Task. 

    // For convenience, every coroutine has a variable g giving access
    // to all the Tcobench parameters such as g.climax and g.tracing.
    // Pointers to all the Tcobench tasks are held in the Globals class.
    // So, for instances, the instance variables of the Stats task are
    // accessible to any coroutine using g.stats.

    // Only one of the coroutines of a Tripos task can be executing at
    // any one time. All the others will be in the body of the
    // synchronized method currcoWait(), probably suspended in the
    // call wait() waiting for currco==this to become true. Note that
    // currcowait and unwait are declared in class Cortn.

    // When a coroutine transfers control to another coroutine
    // target.parent is set appropriately and t.currco is set to the
    // target coroutine. The value to be passed to the target is set
    // in target.value. These assignments are performed by callco,
    // as defined below. It then releases the target thread by the call
    // of notifyAll() in target.unwait(). Since unwait is a synchronized
    // method the variables parent, currco and value will have been
    // flushed to their associated memory locations, ready to be read
    // by the target coroutine. 

    public Object callco(Cortn target, Object arg) {
	// This will simultaneously wakeup the target coroutine
	// and suspend the current coroutine.
	// Note that there is no need for this method to be
	// synchronized, since no other coroutine belonging to
	// the current task will be running, so parent, value and
	// currco will not be changed by other threads.
	target.parent = this;
	target.value = arg;
	//System.out.println(coName+" callco t="+t);
	t.currco = target;

	//System.out.println(coName+
	//		   ": callco -- target "+target.coName+
	//		   " target.parent="+target.parent.coName);

	// Transfer control to the target coroutine.
	// unwait is synchronized so parent, value and currco wiil
	// be written out to main memory.
	target.unwait();

	// Wait until we are again the current coroutine,
	// ie until t.currco==this.
	currcoWait();

	//System.out.println(coName+
	//		   ": callco -- Resumed execution with value "+value);
	return value;
    }

    public Object resumeco(Cortn target, Object arg) {
	Cortn p = parent;   // Ensure that resumeco can resume itself
	parent = null;     // ie when target==currco
	target.parent = p;
	target.value = arg;
	t.currco = target;

	//System.out.println(coName+": resumeco called => "+target.coName);

	// Transfer control to the target coroutine.
	target.unwait();

	// Wait until we are again the current coroutine,
	// ie until t.currco==this.
	currcoWait();

	return value;
    }

    public Object cowait(Object arg) {
	if ( t.currco.parent==null)
	    System.out.println(coName+
			       ": ERROR: current parent is null #################\n");

	Cortn from = t.currco;
	Cortn to = from.parent;

	//System.out.println(coName+": from="+from.coName);
	//System.out.println(coName+": Setting to="+to.coName);
	//System.out.println(coName+": Setting from.parent=null");
	//System.out.println(coName+": Setting r="+to.coName);
	//System.out.println(coName+": Setting to.value="+arg);
	//System.out.println(coName+": Setting t.currco="+to.coName);
	//System.out.println(coName+": Calling to.unwait()");

	from.parent = null;
	to.value = arg;
	t.currco = to;

	//System.out.println(coName+": cowait giving control to "+target.coName);

	// Transfer control to the target coroutine.
	to.unwait();

	//System.out.println(coName+": cowait calling from.currcoWait()");

	// The from coroutine will now wait until it becomes the
	// current coroutine.
	from.currcoWait();

	return value;
    }

    // Internal support functions, currcowait and unwait, which must be
    // in this class since they synchronize on the coroutine thread.

    public synchronized void currcoWait() {
	try {
	    while (t.currco!=this) {
		//System.out.println(coName+
		//		   ": currcoWait -- r.currco!=this, so call wait()");
		wait();
	    }
	    //System.out.println(coName+
	    //		       ": currcoWait -- r.currco==this, so return");
	}
	catch(Exception e) {}
    }

    public synchronized void unwait() {
	// Release all this object's threads.
	// Note that there may be threads other than the waiting
	// coroutine, so notify() alone is not sufficient.
	// If in doubt, try it.
	//System.out.println(coName+
	//		   ": unwait -- calling notifyAll");
	notifyAll();
    }

    public void delayco(int msecs) {
	t.sndpkt(new Pkt(null, g.clock, act_clock, 0, 0, msecs));
    }

    public static String strz(int n, int d) {
	String res = "";
        if(n<0) {
	    d--;
            n = -n;
	    res = res + "-";
	}
        if (n<10000000 && d>=8) res = res + "0";
        if (n<1000000 && d>=7) res = res + "0";
        if (n<100000 && d>=6) res = res + "0";
        if (n<10000 && d>=5) res = res + "0";
        if (n<1000 && d>=4) res = res + "0";
        if (n<100 && d>=3) res = res + "0";
        if (n<10 && d>=2) res = res + "0";
	return res + n;
    }

    public static String strn(int n, int d) {
	String res = "";
        if(n<0) d--;
        if (n<10000000 && d>=8) res = res + " ";
        if (n<1000000 && d>=7) res = res + " ";
        if (n<100000 && d>=6) res = res + " ";
        if (n<10000 && d>=5) res = res + " ";
        if (n<1000 && d>=4) res = res + " ";
        if (n<100 && d>=3) res = res + " ";
        if (n<10 && d>=2) res = res + " ";
	return res + n;
    }

    public static void wrz(int n, int d) {
        if(n<0) {
	    d--;
            n = -n;
            System.out.print("-");
	}
        if (n<10000000 && d>=8) System.out.print("0");
        if (n<1000000 && d>=7) System.out.print("0");
        if (n<100000 && d>=6) System.out.print("0");
        if (n<10000 && d>=5) System.out.print("0");
        if (n<1000 && d>=4) System.out.print("0");
        if (n<100 && d>=3) System.out.print("0");
        if (n<10 && d>=2) System.out.print("0");
        System.out.print(""+n);
    }

    public static void wrn(int n, int d) {
        if(n<0) d--;
        if (n<10000000 && d>=8) System.out.print(" ");
        if (n<1000000 && d>=7) System.out.print(" ");
        if (n<100000 && d>=6) System.out.print(" ");
        if (n<10000 && d>=5) System.out.print(" ");
        if (n<1000 && d>=4) System.out.print(" ");
        if (n<100 && d>=3) System.out.print(" ");
        if (n<10 && d>=2) System.out.print(" ");
        System.out.print(""+n);
    }

    public static String reqstr(char flag, char modech,
			 int srvno, int mpxno, int chnno, int data) {
	// Return a string such as " nRS02M04C01: 7845"
	return " "+flag+modech+
	    "S"+strz(srvno,2)+"M"+strz(mpxno,2)+
	    "C"+strz(chnno,2)+":"+strz(data,4);
    }

    public static String reqstr(char flag, char modech,
				int clino, int srvno, int mpxno, int chnno, int data) {
	// Return a string such as "RC02 nRS02M04C01: 7845"
	return ""+modech+"C"+strz(clino,2)+
               " "+flag+modech+
	       "S"+strz(srvno,2)+"M"+strz(mpxno,2)+
	       "C"+strz(chnno,2)+":"+strz(data,4);
    }


    public int nowmsecs() {
	// Return msecs since start of the current run.
	return (int)(System.currentTimeMillis()-g.startmsecs);
    }

    public void wrtime(String mess) {
	java.util.Date date = new java.util.Date();
	System.out.println(mess+"  "+date);
    }

    public void realdelay(int msecs) {
	try {
	    sleep(msecs);
	} catch(Exception e) {}
    }
}

//**********************************************************************
//**************************** Task ************************************
//**********************************************************************


abstract class Task extends Cortn {
    // All sub-classes of Task must define the task's or
    // coroutine's main function fn.

    // This class provides all the usual functionality of Tripos,
    // including qpkt, taskwait and the coroutine functions callco,
    // resumeco and cowait, plus many others such as wrx and wrn.

    // Its sub-classes are either tasks or coroutines depending on
    // which constructor is used. Each task has a root coroutine and
    // possibly many non-root coroutines that all run with the same
    // priority as the root.

    // A non-root coroutine can access the variables of the task
    // to which it belongs using expressions such as t.currco.

    // The following variables are directly accessible to all Tcobench tasks
    // and are accessible via t by all coroutines.

    // Variables, such as clinno, that particular to individual Tcobench
    // tasks are declared in their own classes and are accessible via r,
    // declared in each Tcobench class that needs it.

    public int pri;        // The priority of the task and all its coroutines
    public int result2=0;

    // Variables used by gomultievent.
    // They are declared in Task since they are shared by the coroutines
    // belonging to a task. For convenience, gomultievent is declared in
    // class Cortn so is directly accessible to all coroutines.
    public boolean mainco_ready;
    public boolean multi_done;
    Pktlist pktlist = null;   // List of packet-coroutine pairs.


    // There is one work queue shared by all coroutines belonging to
    // each Tripos style class.
    public Pkt wkq=null;   // Used if this thread models a task


    // There is one current coroutine per Tripos style class. It is
    // shared by all coroutines belonging to the task. For convenience
    // callco, resumeco and cowait are declared in class Cortn so can
    // be accessed directly from anywhere.
    public Cortn currco;        // The current coroutine of this task,
                                // normally accessed by t.currco.
                                // Each task has a current coroutine
                                // so it is declared in class Task
                                // and not class Cortn.
                                // Within a task only one coroutine
                                // (the current coroutine) can have
                                // control. All the others will be
                                // suspended in callco, resumeco or
                                // cowait.
                                // Note that parent is declared in
                                // class Cortn.

    // The root coroutine of a task is created when the task is created.
    // All other coroutines belonging to a task are created by coroutines
    // belonging to that task.

    public Task(String name, Globals g, int pri) {
	// This contructor is called by a subclass of Task to 
	// create a new task thread and its root coroutine.
	// When this thread is started it will suspend itself
	// in taskwait() waiting for the task's first packet
	// which it will then give to fn. On return from fn
	// the task will die.
	super(name, g, pri);
	this.pri = pri;   // Remember the priority for use by
                          // coroutines belonging to this task.
	// This is a Tripos style task and its root coroutine.
	// We must set t to point to itself since it is needed
	// by callco, etc which are defined in class Cortn.
	t = this;

	// parent and currco are set by the coroutine that starts this
	// thread.

	//System.out.println(coName+": Task and root coroutine created");
	//System.out.println(coName+": but not yet started");
    }

    public abstract Object fn(Object arg);
    // fn is the body of either the root coroutine of a task or
    // the body of a non root coroutine belonging to a task.

    // Normally run will be defined in all the sub-classes of Task.

    public void run() {
        // This is called when the thread first starts. Returning
        // from run causes the thread to die.

	//System.out.println(coName+": Thread started");
	//if (parent!=null)
	//    System.out.println(coName+": parent="+parent.coName);

	//System.out.println(coName+": Root coroutine thread started");
	// This thread models the root coroutine of a Tripos task.

	// Wait for the startup packet then give it to fn.

	//System.out.println(coName+": Calling taskwait() for its startup packet");
	Pkt startuppkt = taskwait();
	//System.out.print(coName+": Received startup pkt from "+startuppkt.task.coName);
	//System.out.println(coName+": New task calling fn(startuppkt)");
	fn(startuppkt);
	// Returned from fn causes the thread to die.
	//System.out.println(coName+": This task returned from fn and is now dying");
    }

    // Locking on a Tripos style task allows qpkt and taskwait
    // exclusive access the task's work queue wkq. A task should
    // only modify the fields of a packet when it owns the packet.
    // It does not own the packet after calling qpkt until it is
    // returned as the result of taskwait. qpkt and taskwait are
    // not synchronized and are declared in class Cortn, but putpkt
    // is synchronized on its task object so is delared in class
    // Task.

    public synchronized boolean putpkt(Pkt pkt, Task from) {
	//System.out.println("\n"+coName+": Got lock on this thread");

	// This runs in the thread corresponding to the current task,
	// but has a lock on the destination task's thread and so
	// can modify the detination task's wkq without interference
	// from other tasks.

	// This is the normal version of putpkt, but for the Clock task
	// it is overridden by a special one that processes packets in
	// a different way.

	// Note that wkq is the work queue of the destination task.
	// If wkq was previously null, a call of notifyAll is required
	// since the task may be suspended in wait() in the body of
	// taskwait.

	String fromName = from==null ? "null"
                                     : from.coName; // Name of the task

	//System.out.println(coName+": putpkt type="+pkt.type+" arg1="+pkt.arg1);
	//System.out.println(coName+
	//		   ": putpkt appending pkt from "+fromName+" this task's wkq");

	pkt.task = from; // Fill in the return task field.
	pkt.link = null;

	// Append the packet onto the end of the destination task's wkq.

	if (wkq==null) {
	    //System.out.println(coName+": putpkt wkq was null");
	    wkq = pkt; // Make a unit list.
	    //System.out.println(coName+": putpkt calling notifyAll()"+
	    //		   " since wkq was previously null");
	    notifyAll();
	} else {
	    //System.out.println(coName+
	    //		       ": appending pkt to end of non null wkq");
	    Pkt p = wkq;
	    // Find the end of the work queue.
	    while(p.link!=null) {
	    //	System.out.println(coName+
	    //			   ": Skip over wkq pkt from "+p.task.coName);
		p = p.link;
	    }
	    p.link = pkt; // Place the packet at the end.
	}
	//System.out.println(coName+": Releasing the lock on this thread\n");
	return true;
    }

    public boolean qpkt(Pkt pkt) {
	//System.out.println(coName+
        //                   ": qpkt to "+pkt.task.coName+
        //                   " type "+pkt.type);
	// putpkt is a synchronized method that gains the lock on
	// the target thread.
	return pkt.task.putpkt(pkt, this);
    }

    public synchronized Pkt taskwait() {
	// This must be synchronized on the BCPL style task object since
	// it contains wait() and also manipulates wkq.

	//System.out.println("\n"+coName+": Got lock on this thread");
	// No other threads will be currently manipulating this task's wkq.

	try {
	    while (wkq==null) {
		// We need the while loop since spurious wakeups might happen.
  	        //System.out.println(coName+
		//		   ": taskwait: calling wait() since wkq is null");
		wait();
  	        //System.out.println(coName+
		//		   ": taskwait: woken up");
	    }
	    //System.out.println(coName+
	    //          ": taskwait: wkq non empty");
	}
	catch(Exception e) {
	    System.out.println(coName+
			       ": taskwait: exception e="+e.toString());
	}

	// There is as least one packet in wkq.
	Pkt pkt = wkq;
	wkq = wkq.link;
	//if (pkt.task!=null) 
	    //System.out.println(coName+
	    //		       ": taskwait() received pkt from "+pkt.task.coName+
	    //		       " type="+pkt.type);

	//System.out.println(coName+": Released lock on this thread\n");
	return pkt;
    }

    public int sendpkt(Pkt pkt) {
	//System.out.println(coName+": sendpkt calling qpkt\n");
	//System.out.println(coName+": dest="+pkt.task.coName);
	//System.out.println(coName+": currco="+t.currco);
	//System.out.println(coName+": currco="+t.currco.coName);
	qpkt(pkt);
	Pkt p = taskwait();
	if (p!=pkt) {
	    System.out.println(coName+": System error in sendpkt");
	    result2 = 0;
	    return 0;
	}
	result2 = pkt.res2;
	return pkt.res1;
    }

    public int sndpkt(Pkt pkt) {

	if (isroot) {
	    System.out.println(coName+": Can't sndpkt from a root coroutine");

	}
	if (!qpkt(pkt)) {
	    System.out.println(coName+": sndpkt  -- qpkt failure");

	}
	while (true) {
	    Pkt p = (Pkt)cowait(null);
	    if (p==pkt) {
		System.out.println(coName+": sndpkt received the wrong pkt");
		continue;
	    }
	    break;
	}
	result2 = pkt.res2;
	return pkt.res1;
    }

    public Cortn findpkt(Pkt pkt) {
	Pktlist p = pktlist;

	if (p==null) return null; // pktlist was empty

	if (p.pkt==pkt) {
	    // The first item in pktlist matches.
	    Cortn cptr = p.cptr;
	    // Dequeue the first element of pktlist
	    pktlist = p.link;
	    return cptr;
	}

	while (true) {
	    Pktlist q = p.link;

	    if (q==null) return null; // No matching item found.

	    // Test an item q in pktlist other than the first.
	    if (q.pkt == pkt) {
		Cortn cptr = q.cptr;
		// Remove item q from pktlist
		p.link = q.link;
		return cptr;
	    }
	    p = q;
	}
    }

    public void gomultievent(Cortn mainco) {
	Pkt queue = null;

	//System.out.println(coName+": gomultievent entered");

	// Create an empty pktlist.
	pktlist = null;
	multi_done = false;   // =true when it is time to return
                              // to single event mode.

	mainco_ready = true;  // =true when mainco is ready to process
                              // packets. If false, packets are appended
                              // to queue by gomultievent and given to
                              // mainco later.

	//System.out.println(coName+": gomultievent calling callco(mainco,null)");
	callco(mainco, null); // Startup servermainco
	//System.out.println(coName+": returned from callco(mainco,null)");

	// mainco has completed its initialisation.
	//System.out.println(coName+": gomultievent entering its multi-event loop");

	while( !multi_done) {
	    // Start of the multi-event loop.
	    //System.out.println(coName+": gomultievent calling taskwait()");
	    Pkt pkt = taskwait();
	    //System.out.println(coName+": gomultievent got pkt from "+
	    //	       pkt.task.coName);
	    Cortn cptr = findpkt(pkt);

	    if (cptr!=null) {
		// cptr is the multi-event coroutine waiting for this
		// packet.
		//System.out.println(coName+": gomultievent giving pkt to "+cptr.coName);
		callco(cptr, pkt); // Give pkt to this coroutine.
	    } else {
		if (!mainco_ready) {
		    // This packet does not belong to a multi-event
		    // coroutine and mainco is busy, so append it
		    // onto the end of queue and wait for another
		    // packet.
		    // Note that this code is only obeyed is mainco
		    // is suspended waiting for a particular packet.
		    // as in a call of delayco(). In Tcobench this
		    // never happens.

		    pkt.link = null;
		    if (queue==null) {
			queue = pkt;
		    } else {
			Pkt p = queue;
			while (p.link!=null) p = p.link;
			p.link = pkt;
		    }
		    System.out.println(coName+": gomultievent put pkt in queue");
		    continue;
		}

		// This packet does not belong to a multi-event
		// coroutine and mainco is not busy, so give it
		// to mainco.
		//System.out.println(coName+": gomultievent calling callco(mainco, pkt)");
		callco(mainco, pkt);
		//System.out.println(coName+": gomultievent mainco processed pkt");
	    }

	    // try to deal with the packets in queue.
	    while (queue!=null && mainco_ready) {
		Pkt p = queue;
		queue = queue.link;
		p.link = null;
		System.out.println(coName+": gomultievent dequeued pkt from queue");
		System.out.println(coName+":     then calling callco(mainco, p)");
		callco(mainco, p); // Give it to mainco.
	    }
	} // End of while (!multi_done) loop.
    }

    public void delaytask(int msecs) {
	sendpkt(new Pkt(null, g.clock, act_clock, 0, 0, msecs));
    }
}


//**********************************************************************
//************************** Manifests *********************************
//**********************************************************************

interface Manifests {
    // Packet types

    public final static int act_startcontroller = 100;
    public final static int act_startclock      = 101;
    public final static int act_startstats      = 102;
    public final static int act_startbounce     = 103;
    public final static int act_startrdclient   = 104;
    public final static int act_startwrclient   = 105;
    public final static int act_startrdserver   = 106;
    public final static int act_startwrserver   = 107;
    public final static int act_startmpx        = 108;
    public final static int act_startprinter    = 110;
    public final static int act_clock           = 111;
    public final static int act_bounce          = 112;
    public final static int act_print           = 113;
    public final static int act_read            = 114;
    public final static int act_write           = 115;
    public final static int act_sync            = 116;
    public final static int act_rddone          = 117;
    public final static int act_wrdone          = 118;
    public final static int act_die             = 119;

    public final static int act_calibrate       = 120;
    public final static int act_run             = 121;

    public final static int act_addstats        = 122;
    public final static int act_prstats         = 123;

    public final static int act_quickbounce     = 124;
}

//**********************************************************************
//*************************** Globals **********************************
//**********************************************************************

class Globals {
    // Global parameters and constants accessible to every coroutine of
    // every task.

    // There is one instance of this class and every task can refer to it
    // using g. So the global (shared) variables are normally accessed by
    // g.<name> as in g.loopmax

    // Global variables that change dynamically must be updated using
    // synchronised methods.

    public int     loopmax;
    public int     climax;
    public int     srvmax;
    public int     workmax;
    public int     mpxmax;
    public int     chnmax;
    public int     chnbufsize;
    public int     delaymsecs;
    public int     delayticks;
    public int     maxcountdiff;

    public int     requestvupb;

    public boolean tracing = true;

    long startmsecs = 0;

    // Global tasks
    public Controller controller;
    public Clock clock;
    public Stats stats;
    public Bounce bounce;
    public Printer printer;

    public Client rdclientv[];
    public Client wrclientv[];
    public Server rdserverv[];
    public Server wrserverv[];
    public Multiplexor mpxv[];


    public Globals() {};

    public void rdargs(String[] args) {
	try {
	    // Default settings
	    loopmax    = 2;
	    climax     = 20;
	    srvmax     = 15;
	    workmax    = 14;
	    mpxmax     = 10;
	    chnmax     = 10;
	    delaymsecs = 500;

            maxcountdiff = 5;

	    tracing    = false;

	    for (int i = 0; i < args.length; i++) {
	        //System.out.println("arg["+i+"] = " + args[i]);

		if (args[i].equals("-t")) {
		    tracing = true;
		    continue;
		}

		if (args[i].equals("-x")) {
                    // Alternate setting of the parameters
		    loopmax    =   1;
		    climax     =   2;
		    srvmax     =   2;
		    workmax    =   3;
		    mpxmax     =   2;
		    chnmax     =   3;

		    loopmax    =   1;
		    climax     =   1;
		    srvmax     =   1;
		    workmax    =   1;
		    mpxmax     =   1;
		    chnmax     =   1;
		    continue;
		}

		if (args[i].equals("-y")) {
                    // Alternate setting of the parameters
		    loopmax    =   2;
		    climax     =   5;
		    srvmax     =   3;
		    workmax    =   3;
		    mpxmax     =   2;
		    chnmax     =   3;
		    continue;
		}

		if (args[i].equals("-z")) {
                    // Alternate setting of the parameters
		    loopmax    =   3;
		    climax     =  10;
		    srvmax     =   4;
		    workmax    =   7;
		    mpxmax     =   3;
		    chnmax     =   4;
		    continue;
		}

		if (args[i].equals("-k")) {
		    loopmax = Integer.parseInt(args[++i]);
		    continue;
		}
		
		if (args[i].equals("-n")) {
		    climax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-s")) {
		    srvmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-w")) {
		    workmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-m")) {
		    mpxmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-c")) {
		    chnmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-b")) {
		    chnbufsize = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-d")) {
		    delaymsecs = Integer.parseInt(args[++i]);
		    continue;
		}

	    }
	} 
	catch (NumberFormatException e) {
	    System.err.println("Integer argument expected");
	}

	requestvupb = srvmax*mpxmax*chnmax;

        if(chnbufsize==0) {
	    // Set the channel buffer size to about one tenth of the
            // number of values sent to each channel on each iteration
            chnbufsize = (climax*srvmax)/10 + 5;
        }

	System.out.println("loopmax    = "+Task.strn(loopmax,4)+" (k)");
	System.out.println("climax     = "+Task.strn(climax,4)+" (n)");
	System.out.println("srvmax     = "+Task.strn(srvmax,4)+" (s)");
	System.out.println("workmax    = "+Task.strn(workmax,4)+" (w)");
	System.out.println("mpxmax     = "+Task.strn(mpxmax,4)+" (m)");
	System.out.println("chnmax     = "+Task.strn(chnmax,4)+" (c)");
	System.out.println("chnbufsize = "+Task.strn(chnbufsize,4)+" (b)");
	System.out.println("delaymsecs = "+Task.strn(delaymsecs,4)+" (d)\n");

	System.out.println("Requests per schedule = "+Task.strn(requestvupb,4));
	System.out.println("maxcountdiff          = "+Task.strn(maxcountdiff,4)+"\n");
    }
}

//**********************************************************************
//*************************** Controller *******************************
//**********************************************************************

class Controller extends Task {
    ///task
    // This models the Controller task

    Controller r;

    public Controller(String name, Globals g, int pri) {
	// This constructor is used to create the Controller task
	// and its root coroutine. The Controller task has no
	// other coroutines.
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }

    public Object fn(Object arg) {
	// This is the main function of the root coroutine of
        // the Controller.
	// arg is the startup packet and it will not be returned to
	// the main program.

	Pkt startuppkt = (Pkt)arg;
	//System.out.println(coName+": Startup pkt received,");

	// Create and start all the tcobench tasks but do not send them
        // startup packets yet.

	// Allocate the vectors
	g.rdclientv = new Client[g.climax+1];
	g.wrclientv = new Client[g.climax+1];
	g.rdserverv = new Server[g.srvmax+1];
	g.wrserverv = new Server[g.srvmax+1];
	g.mpxv      = new Multiplexor[g.mpxmax+1];

	//System.out.println(coName+": Creating Clock task");
	g.clock = new Clock("Clock", g, 10);
	//System.out.println(coName+": Starting task "+g.clock.coName);
        g.clock.start();

	//realdelay(2000);

	// Send a startup packet to the Clock task that models the
	// Tripos Clock device. It should now be suspended in taskwait()
	// waiting for its startup packet.

	//System.out.println(coName+": Sending startup pkt to task "+g.clock.coName);

	sendpkt(new Pkt(null, g.clock, act_startclock));

	//System.out.println(coName+": The clock startup packet has been returned\n");

	if (true) { // Change to if (true) to test the clock task.
	    // Test the clock device
	    Rnd r = new Rnd(500);

	    System.out.println("\n"+coName+": Testing the Clock task\n");

	    for(int i = 1; i<=20; i++) {
		int k1 = 7;
		int k2 = 20-k1+1;
		if (i<=k2) {
		    int delay = 200 + r.next(1000);
		    qpkt(new Pkt(null, g.clock, act_clock,
				 0, 0,
				 delay, i));
		    wrn(nowmsecs(), 5);
		    System.out.print(" "); wrn(i, 2);
		    System.out.print(": delay for "); wrn(delay, 5);
		    System.out.print(" until "); wrn(delay+nowmsecs(), 5);
		    System.out.print(" sent\n");
		}
		if (i>=k1) {
		    Pkt p = taskwait();
		    int delay = p.arg1;
		    wrn(nowmsecs(), 5);
		    System.out.print(" "); wrn(p.arg2, 2);
		    System.out.print(": delay="); wrn(delay,5);
		    System.out.print(" done\n");
		}
	    }

	    System.out.println("\nEnd of Clock test\n");

	    //System.out.println("Sleeping for 1 second\n");
	    //realdelay(1000);
	
	} // End of while(true) loop

	//System.out.println(coName+": Creating the Stats task");
	g.stats = new Stats("Stats", g, 9);
        g.stats.start();

	//System.out.println("\n"+coName+": Creating the other Tcobench tasks\n");

	//System.out.println(coName+": Creating and starting the Bounce task");
	g.bounce = new Bounce("Bounce", g, 1);
        g.bounce.start();

	//System.out.println(coName+": Creating and starting the Printer task");
	g.printer = new Printer("Printer", g, 2);
        g.printer.start();

	for (int i=1; i<=g.climax; i++) {
	    g.rdclientv[i] = new Client("RC"+strz(i,2), g, 3);
	    g.rdclientv[i].start();
	}
	for (int i=1; i<=g.climax; i++) {
	    g.wrclientv[i] = new Client("WC"+strz(i,2), g, 3);
	    g.wrclientv[i].start();
	}

	for (int i=1; i<=g.srvmax; i++) {
	    g.rdserverv[i] = new Server("RS"+strz(i,2), g, 4);
	    g.rdserverv[i].start();
	}
	for (int i=1; i<=g.srvmax; i++) {
	    g.wrserverv[i] = new Server("WS"+strz(i,2), g, 4);
	    g.wrserverv[i].start();
	}

	for (int i=1; i<=g.mpxmax; i++) {
	    g.mpxv[i] = new Multiplexor("M"+strz(i,2), g, 5);
	    g.mpxv[i].start();
	}

	// Send startup packets to all the tcobench tasks.

	// Send a startup packet to the Stats task.
	// This must not happen until the Clock and Bounce tasks have been
	// created but not yet given their startup packets.

	//System.out.println("\n"+coName+": Sending startup pkt to the Stats task");
	sendpkt(new Pkt(null, g.stats, act_startstats));
	//System.out.println(coName+": The Stats startup packet has been returned\n");

	//System.out.println(coName+": Calling g.stats.incallco()");
	g.stats.inccallco();

	// Send a startup packet to the Bounce task.

	System.out.println("\n"+coName+": All Tcobench tasks have been created\n");

	System.out.println(coName+
			   ": Sending startup packets to all remaining Tcobench tasks\n");

	//System.out.println(coName+": Sending startup pkt to the Bounce task");
	sendpkt(new Pkt(null, g.bounce, act_startbounce));
	//System.out.println(coName+": The Bounce startup packet has been returned\n");

	//System.out.println(coName+": Sending startup pkt to the Printer task");
	sendpkt(new Pkt(null, g.printer, act_startprinter));
	//System.out.println(coName+": The Printer startup packet has been returned\n");

	for (int mpxno=1; mpxno<=g.mpxmax; mpxno++) {
	    sendpkt(new Pkt(null, g.mpxv[mpxno], act_startmpx, 0, 0, mpxno));
	}

	for (int svrno=1; svrno<=g.srvmax; svrno++) {
	    sendpkt(new Pkt(null, g.rdserverv[svrno], act_startrdserver, 0, 0, svrno));
	}
	for (int svrno=1; svrno<=g.srvmax; svrno++) {
	    sendpkt(new Pkt(null, g.wrserverv[svrno], act_startwrserver, 0, 0, svrno));
	}

	for (int clino=1; clino<=g.climax; clino++) {
	    sendpkt(new Pkt(null, g.rdclientv[clino], act_startrdclient, 0, 0, clino));
	}
	for (int clino=1; clino<=g.climax; clino++) {
	    sendpkt(new Pkt(null, g.wrclientv[clino], act_startwrclient, 0, 0, clino));
	}

	//System.out.println("Sleeping for 1 second\n");
	//realdelay(1000);

	if (true) {
	    Pkt bpkt = new Pkt(null, g.bounce, act_quickbounce);
	    int startmsecs = nowmsecs();
	    int cycles = 10000;
	    //System.out.println(coName+": Test qpkt-taskwait bounce rate, cycles="+cycles+"\n");
	    for (int i=1; i<=cycles; i++) {
		//System.out.println(i+" Sending a bounce packet");
		qpkt(bpkt);
		//System.out.println(i+" Wait for reply");
		taskwait();
	    }
	    int diff = nowmsecs() - startmsecs;
	    System.out.println("\n"+coName+": "+
			       (cycles*1000/diff)+" qpkt-taskwait bounces per second\n");
	}

	//System.out.println("\n"+coName+
	//		   ": Sending a calibrate packet to the Stats task\n");
	sendpkt(new Pkt(null, g.stats, act_calibrate));

	//System.out.println(coName+": Calibrate packet returned from Stats task\n");

	System.out.println(coName+": Start  time = "+nowmsecs()+" msecs\n");


	System.out.println("\n"+coName+": Sending run packet to the Stats task\n");
	sendpkt(new Pkt(null,g.stats,act_run));

	// Only gets here when all the clients have complete all their schedules.

	System.out.println(coName+": Finish time = "+nowmsecs()+" msecs\n");

	//System.out.println(coName+": Sleeping for 1 second");
	//realdelay(1000);

	g.stats.incqpkt();
	g.stats.prstats();

	//System.out.println("\n"+coName+": Sending die packets to all tasks\n");


	for (int mpxno=1; mpxno<=g.mpxmax; mpxno++) {
	    sendpkt(new Pkt(null, g.mpxv[mpxno], act_die));
	    System.out.println(coName+
			       ": Wait for a Multiplexor task "+g.mpxv[mpxno]+" to finish"
			       );
	    try { g.mpxv[mpxno].join(); }
	    catch(Exception e) {}
	    System.out.println(coName+": Task "+g.mpxv[mpxno]+" task has finished");
	}

	for (int srvno=1; srvno<=g.srvmax; srvno++) {
	    sendpkt(new Pkt(null, g.rdserverv[srvno], act_die));
	    //System.out.println(coName+": Wait for a server task to finish");
	    // Wait for the clock task to finish
	    try { g.rdserverv[srvno].join(); }
	    catch(Exception e) {}
	    System.out.println(coName+": The RD"+strz(srvno,2)+" task has finished");
	}
	for (int srvno=1; srvno<=g.srvmax; srvno++) {
	    sendpkt(new Pkt(null, g.wrserverv[srvno], act_die));
	    //System.out.println(coName+": Wait for a server task to finish");
	    // Wait for the clock task to finish
	    try { g.wrserverv[srvno].join(); }
	    catch(Exception e) {}
	    System.out.println(coName+": The WS"+strz(srvno,2)+" task has finished");
	}

	for (int clino=1; clino<=g.climax; clino++) {
	    sendpkt(new Pkt(null, g.rdclientv[clino], act_die));
	    //System.out.println(coName+": Wait for a client task to finish");
	    try { g.rdclientv[clino].join(); }
	    catch(Exception e) {}
	    System.out.println(coName+": The RC"+strz(clino,2)+" task has finished");
	}
	for (int clino=1; clino<=g.climax; clino++) {
	    sendpkt(new Pkt(null, g.wrclientv[clino], act_die));
	    //System.out.println(coName+": Wait for a client task to finish");
	    try { g.wrclientv[clino].join(); }
	    catch(Exception e) {}
	    System.out.println(coName+": The WC"+strz(clino,2)+" task has finished");
	}

	System.out.println("\n"+coName+": Sending die pkt to Printer task");
	qpkt(new Pkt(null, g.printer,
		     act_die));
	taskwait();
	//System.out.println(coName+": Die pkt returned from Printer task");

	//System.out.println(coName+": Wait for the Printer task to finish");
        // Wait for the printer task to finish
	try { g.printer.join(); }
	catch(Exception e) {}
	System.out.println(coName+": The Printer task has finished");


	System.out.println("\n"+coName+": Sending die pkt to Bounce task");
	qpkt(new Pkt(null, g.bounce,
		     act_die));
	taskwait();
	//System.out.println(coName+": Die pkt returned from Bounce task");

	//System.out.println(coName+": Wait for the Bounce task to finish");
        // Wait for the bounce task to finish
	try { g.bounce.join(); }
	catch(Exception e) {}
	System.out.println(coName+": The Bounce task has finished");


	System.out.println("\n"+coName+": Sending die pkt to Stats task");
	qpkt(new Pkt(null, g.stats,
		     act_die));
	taskwait();
	//System.out.println(coName+": Die pkt returned from Stats task");

	//System.out.println(coName+": Wait for the Stats task to finish");
        // Wait for the stats task to finish
	try { g.stats.join(); }
	catch(Exception e) {}
	System.out.println(coName+": The Stats task has finished");


	System.out.println("\n"+coName+": Sending die pkt to Clock task");
	qpkt(new Pkt(null, g.clock,
		     act_die));
	taskwait();
	//System.out.println(coName+": Die pkt returned from clock task");

	//System.out.println(coName+": Wait for the Clock task to finish");
        // Wait for the clock task to finish
	try { g.clock.join(); }
	catch(Exception e) {}
	System.out.println(coName+": The Clock task has finished");



        return null;
    }
}

//**********************************************************************
//*************************** Stats ************************************
//**********************************************************************

class Stats extends Task {

    // This class holds the statistics counters and the method (prstats)
    // to output them. It controls the synchronisation of the clients
    // involving sync, rddone and wrdone packets. It also estimates the
    // CPU usage by repeatedly bouncing packets off the Bounce task.

    Stats r;

    // Statistics counters
    public int c_qpkt=0;
    public int c_taskwait=0;
    public int c_callco=0;
    public int c_resumeco=0;
    public int c_cowait=0;
    public int c_condwait=0;
    public int c_notify=0;
    public int c_notifyAll=0;
    public int c_inc=0;
    public int c_incwait=0;
    public int c_lock=0;
    public int c_lockw=0;
    public int c_delaylong=0;
    public int c_bounce=0;
    public int c_print=0;
    public int c_logger=0;
    public int c_readfail=0;
    public int c_sendfail=0;
    public int c_rdchecksum=0;
    public int c_wrchecksum=0;

    public int c_rdcount=0;
    public int c_wrcount=0;

    Pkt synclist = null;
    int synclistlen = 0;
    Pkt donelist = null;
    int donelistlen = 0;

    Pkt calibratepkt = null;
    Pkt runpkt = null;
    Pkt diepkt = null;
    Boolean alldone = false;
    int bounces = 0;
    int bouncesmax = 1;         // To avaiod division by zero
    Boolean bouncing = false;
    Boolean clocking = false;
    Pkt clockpkt = null;
    Pkt bouncepkt = null;
    public int utilisationv[];
    int cycle = 0;

    // This task has no non root coroutines, so only has a
    // task constructor.

    public Stats(String name, Globals g, int pri) {
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }

    public Object fn(Object arg) {
	// This is the main function of the root coroutine of
        // the stats task. It must not recive its startup
	// packet until the Clock and Bounce tasks have been
	// created (but not given their statup packets.
	Pkt startuppkt = (Pkt)arg;

	//System.out.println(coName+": Startup packet received");

        clockpkt = new Pkt(null, g.clock, act_clock,
                                 0,0,          // res1 res2
		                 100);         // 100 msecs delay

        bouncepkt = new Pkt(null, g.bounce, act_bounce);

	utilisationv = new int[10];
        for (int i=0; i<=9; i++) utilisationv[i] = 0;
        cycle = 1;

	//System.out.println(coName+": Returning the startup packet to task "
        //                         +startuppkt.task.coName);
	//c_qpkt++;
        qpkt(startuppkt); // Return the startup packet.

	//System.out.println(coName+": Entering its main loop");

        while (true) {
	    Pkt pkt = taskwait();

	    switch (pkt.type) {
	    default:
		System.out.println(coName+
				   ": Unexpected packet received from "+pkt.task.coName);
		qpkt(pkt); // Return this unexpected packet.
		continue;

	    case act_calibrate:
		calibratepkt = pkt;
		//System.out.println(coName+
		//		   ": calibrate packet received from "+pkt.task.coName);
		//System.out.println(coName+
		//		   ": synclistlen="+synclistlen+
		//		   " 2*climax="+ 2*g.climax);

		// Only perform calibration when all read and write clients
		// are ready to perform their first schedules.
		if (synclistlen != g.climax+g.climax)
		    continue;

		// All clients are ready to start their first schedules.
		calibrate();
		//System.out.println(coName+
		//		   ": Return the calibrate packet to task "+
		//		   calibratepkt.task.coName);
		qpkt(calibratepkt); // Return the calibrate packet to the controller.
		calibratepkt = null;
		continue;

	    case act_run:
		// act_run will not be received until after calibration has
		// been completed, and that will only happen when all clients
		// are ready to start their schedules.
		//System.out.println(coName+
		//		   ": act_run packet received from "+
		//		   pkt.task.coName);
		runpkt = pkt; // Remember the run packet so that it can be
                              // returned at the end.

		// clocking and bouncing should both be false.

		if (clocking)
		    System.out.println(coName+
				       ": ERROR: clocking should be false");

		if (bouncing)
		    System.out.println(coName+
				       ": ERROR: bouncing should be false");

		// Start the clock
		qpkt(clockpkt);
		clocking = true;

		// Start bouncing
		qpkt(bouncepkt);
		bouncing = true;
		// Fall through to allow case act_sync to release
		// all the clients.

	    case act_sync:
		if (pkt.type==act_sync) {
		    // Request from a client to start the next schedule.
		    // It is returned when all clients have sent sync packets.
		    pkt.link = synclist;
		    synclist = pkt;
		    synclistlen++;
		    //if (g.tracing) {
		    //	System.out.println(coName+
		    //			   ": sync packet received from "+
		    //			   pkt.task.coName);
		    //}
		}

		//System.out.println(coName+
		//		   ": synclistlen="+synclistlen+
                //                   "     climax*2="+2*g.climax);

		if (synclistlen != g.climax+g.climax) continue;

		System.out.println(coName+
				   ": All sync packet received");

		if (calibratepkt!=null) {
		    //System.out.println(coName+
		    //	       ": and calibrate packet received, so call calibrate");

		    calibrate();
		    //System.out.println(coName+
		    //	       ": Return the calibrate packet to task "+
		    //		       calibratepkt.task.coName);
		    qpkt(calibratepkt);
		    calibratepkt = null;
		    // The act_run packet has not yet been received.
		    continue;
		}

		// The controller only sends the run packet after
		// calibration has been completed.

		if (runpkt!=null) {
		    // The run packet and all sync packets have been received
		    // so return the sync packets to theirmclients.
		    Pkt p = synclist;

		    //if (g.tracing) {
		    System.out.println(coName+
				       ": Releasing all client");
		    cycle++;
		    //}
		    synclist = null;
		    synclistlen = 0;
		    while (p!=null) {
			pkt = p;
			p = p.link;
			pkt.link = null;
			qpkt(pkt);
		    }
		}

		// We must still be waiting for more sync packets or
		// a run packet.
		continue;

	    case act_clock:
		// Keep clocking until alldone is true
		if (!alldone) {
		    int u;
		    qpkt(pkt);

		    // Even after calibration bouncesmax may still increase.
		    if (bouncesmax < bounces) bouncesmax = bounces;

		    u = 999 * (bouncesmax-bounces) / bouncesmax / 100;
		    // 0 <= u <= 9

		    utilisationv[u]++;
		    bounces = 0;
		    continue;
		}

		// alldone is true
		clocking = false;
		// Do not send the packet to the clock
		continue;

	    case act_bounce:
		//System.out.println(coName+": bounce pkt received");
		if (clocking) {
		    // Still in a time perios so bounce again
		    qpkt(pkt);
		    continue;
		}

		// clocking is false so the end of the final period
		// has been reached. This only happens when a clock packet
		// has been received when alldon is true.

		// We have just received the first bounce packet
		// after the end of the final time period. It is therefore
		// time to return the run packet to the controller.

		bouncing = false;
		qpkt(runpkt);
		continue;

	    case act_rddone:
	    case act_wrdone:
		// A client has finished all its schedules.

		if (pkt.type==act_rddone) {
		    if (g.tracing) {
			System.out.println(coName+
					   ": rddone packet received from "+
					   pkt.task.coName);
		    }
		} else {
		    if (g.tracing) {
			System.out.println(coName+
					   ": wrdone packet received from "+
					   pkt.task.coName);

		    }
		}

		pkt.link = donelist;
		donelist = pkt;
		donelistlen++;
		if( donelistlen == g.climax+g.climax) {
		    // All the rddone and wrdone packets have been received
		    // so return them to their clients.
		    Pkt p = donelist;
		    donelist = null;
		    donelistlen = 0;

		    while (p!=null) {
			pkt = p;
			p = p.link;
			pkt.link = null;
			qpkt(pkt);
		    }

		    alldone = true;
		    if (g.tracing) {
			System.out.println(coName+
					   ": alldone set to true");
		    }
		}
		continue;

	    case act_die:
		//System.out.println(coName+": die pkt received");
		g.stats.incqpkt();
		qpkt(pkt);
		return null;     // Cause the thread to die
	    }
	}
    }

    public void calibrate() {
	int cycles = 10;
	System.out.println(coName+": Calibrating the bounce counter");

	bounces = 0;        // Start clocking
	clocking = true;
	qpkt(clockpkt);

	bouncing = true;    // Start bouncing
	qpkt(bouncepkt);

	while (clocking || bouncing) {
	    Pkt pkt= taskwait();

	    switch (pkt.type) {
	    default:
		System.out.println(coName+": Unexpected packet from "+
				   pkt.task.coName);
		continue;

	    case act_clock:
		clocking = false;
		if (bouncesmax==0) bounces = 0; // ignore first time period
		if (bouncesmax<bounces) bouncesmax = bounces;
		//System.out.println(coName+
                //                   ": cycles="+cycles+
                //                   " Clock pkt received, bounces="+bounces+
                //                   " bouncesmax="+bouncesmax);
		bounces = 0;
		cycles--;
		if (cycles>0) {
		    // Start another 100 msecs time period.
		    qpkt(clockpkt);
		}
		continue;

	    case act_bounce:
		//System.out.println(coName+": Bounce pkt received "+bounces);
		bounces++;
		bouncing = false;
		if (cycles==0) break; // Both clock and bounce packets are back
		qpkt(bouncepkt);
		bouncing = true;
		continue;
	    }

	}

	//
	System.out.println("\n"+coName+": bouncesmax = "+bouncesmax+"\n");
    }

    public synchronized void incqpkt()       { c_qpkt++; }
    public synchronized void inctaskwait()   { c_taskwait++; }
    public synchronized void inccallco()     { c_callco++; }
    public synchronized void incresumeco()   { c_resumeco++; }
    public synchronized void inccowait()     { c_cowait++; }
    public synchronized void inccondwait()   { c_condwait++; }
    public synchronized void incnotify()     { c_notify++; }
    public synchronized void incnotifyAll()  { c_notifyAll++; }
    public synchronized void incinc()        { c_inc++; }
    public synchronized void incincwait()    { c_incwait++; }
    public synchronized void inclock()       { c_lock++; }
    public synchronized void inclockw()      { c_lockw++; }
    public synchronized void incdelaylong()  { c_delaylong++; }
    public synchronized void incbounce()     { c_bounce++; }
    public synchronized void incprint()      { c_print++; }
    public synchronized void inclogger()     { c_logger++; }
    public synchronized void increadfail()   { c_readfail++; }
    public synchronized void incsendfail()   { c_sendfail++; }
    public synchronized void incrdchecksum() { c_rdchecksum++; }
    public synchronized void incwrchecksum() { c_wrchecksum++; }
    public synchronized void incrdcount()    { c_rdcount++; }
    public synchronized void incwrcount()    { c_wrcount++; }

    public synchronized void prstats() {
	System.out.println("\n");
		
	System.out.println("Number of calls of qpkt:      "+Task.strn(c_callco,9));
	System.out.println("Number of calls of taskwait:  "+Task.strn(c_taskwait,9));
	System.out.println("Number of calls of callco:    "+Task.strn(c_callco,9));
	System.out.println("Number of calls of resumeco:  "+Task.strn(c_resumeco,9));
	System.out.println("Number of calls of condwait:  "+Task.strn(c_condwait,9));
	System.out.println("Number of calls of notify:    "+Task.strn(c_notify,9));
	System.out.println("Number of calls of notifyAll: "+Task.strn(c_notifyAll,9));
	System.out.println("Number of increments:         "+Task.strn(c_inc,9));
	System.out.println("    increment had to wait:    "+Task.strn(c_incwait,9));
	System.out.println("Number of calls of lock:      "+Task.strn(c_lock,9));
	System.out.println("    lock had to wait:         "+Task.strn(c_lockw,9));
	System.out.println("Number of "+Task.strn(g.delaymsecs,4)+
			   " msec delays:   "+Task.strn(c_delaylong,9));
	System.out.println("Print task counter:           "+Task.strn(c_print,9));
	System.out.println("Calls to logger:              "+Task.strn(c_print,9));
	System.out.println("Send fail count:              "+Task.strn(c_sendfail,9));
	System.out.println("Read fail count:              "+Task.strn(c_readfail,9));
	System.out.println("Bounce task counter:          "+Task.strn(c_bounce,9));
	System.out.println("Read checksum:                "+Task.strn(c_rdchecksum,9));
	System.out.println("Write checksum:               "+Task.strn(c_wrchecksum,9));
	System.out.println("Read count:                   "+Task.strn(c_rdcount,9));
	System.out.println("Write count:                  "+Task.strn(c_wrcount,9));
	System.out.println("");

	int total = 0;
	for(int i = 0; i<=9; i++) total += utilisationv[i];
	if (total==0) total++;

        System.out.println(
          "     Approximate CPU utilisation over "+total+" periods of 100 msecs"
        );
        System.out.println("   0-10% 10-20% 20-30% 30-40% 40-50% 50-60%"+
                           " 60-70% 70-80% 80-90% >90%");
	for(int i = 0; i<=9; i++) {
	    Task.wrn(utilisationv[i], 5);
            System.out.print("  ");
	}
	System.out.println("\n");
    }
}

//**********************************************************************
//*************************** Pktlist **********************************
//**********************************************************************

class Pktlist {
    // This hold nodes in a list that maps packets to coroutines
    // used in gomultievent.
    public Pktlist link;
    public Pkt pkt;
    public Cortn cptr;

    public Pktlist(Pktlist link, Pkt pkt, Cortn cptr) {
	this.link = link;
	this.pkt = pkt;
	this.cptr = cptr;
    }
}

//**********************************************************************
//*************************** Tasklist *********************************
//**********************************************************************

class Tasklist {
    // This holds a list of tasks (typically coroutine).

    public Tasklist next;
    public Cortn cptr;

    public Tasklist(Tasklist next, Cortn cptr) {
	this.next = next;
	this.cptr = cptr;
    }
}

//**********************************************************************
//***************************** Pkt ************************************
//**********************************************************************

class Pkt {
    // Used in Cintpos-style task to task communication
    public Pkt  link;
    public Task task;
    public int  type;
    public int  res1;
    public int  res2;
    public int  arg1;
    public int  arg2;
    public int  arg3;
    public int  arg4;
    public int  arg5;
    public int  arg6;

    public Pkt(Pkt link, Task task, int type) {
	this.link = link;
	this.task = task;
	this.type = type;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3, int arg4) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
	this.arg4 = arg4;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3, int arg4, int arg5) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
	this.arg4 = arg4;
	this.arg5 = arg5;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
	this.arg4 = arg4;
	this.arg5 = arg5;
	this.arg6 = arg6;
    }
}

//**********************************************************************
//**************************** OccamChannel ****************************
//**********************************************************************

class OccamChannel {
    // This class models an Occam channel. The values that are passed
    // through the channel are always integers.

    String chnName;
    Task t;              // To allow access to t.callco etc

    public OccamChannel(String name, Task t) {
	chnName = name;  // Typical name: RS03loggerin
	this.t = t;
    }

    Cortn cptr; // The channel word.

    // Remember that when only one of the coroutines belonging to
    // a task can have control. Control is passed from one
    // conroutine to another using synchronized methods so if
    // one coroutine writes to cptr it will be written out to
    // memory before another coroutine tries to read it. There
    // is thus no need to declare cptr as volatile. There is
    // also no need to make coread and cowrite synchronized.

    Object coread() {
	if (cptr!=null) {
	    return t.resumeco(cptr, t.currco);
	}

	cptr = t.currco;
	return t.cowait();
    }

    public void cowrite(int x) {
	Cortn reader = cptr;

	if (reader!=null) {
	    // reader points to a reader coroutine that is ready
	    // to read data from this channel, so clear the
	    // channel word.
	    cptr = null;
	    // and fall throug to send the data to the reader.
	} else {
	    // The reader coroutine is not yet ready to read.
	    // So tell it the identity of the writer
	    // coroutine.
	    cptr = this;
	    // and wait for the reader coroutine to send us
	    // its identity
	    reader = t.cowait(null);
	    // and then fall through to send the data.
	}
	t.callco(reader, new Integer(x));
    }

    public void wrpn(int x) {
	if (x!=0) {
	    wrpn(x>>>1);
	    cowrite(x&1);
	}
    }

    public int getloggerval() {
	int res = 0;

	while (true) {
	    int dig = coread();
	    if (dig<0) return res;
	    res = 2*res+dig;
	}
    }

    public synchronized void pr() {
	if (cptr==null) {
	    System.out.println(chnName+": channel is idle");
	} else {
	    System.out.println(chnName+": channel points to "+cptr.coName);
	}
    }
}

//**********************************************************************
//***************************** Lock ***********************************
//**********************************************************************

class Lock {
    Tasklist colist;
    boolean locked = false;

    public Lock() {
	colist = null;
    }

    public synchronized void lock(Task cptr) {
	// Usage: eg loggerlock.lock(this);
	if (locked) {
	    Tasklist node = new Tasklist(null, cptr);

	    if (colist==null) {
		// It was locked by just one coroutine,
		// so make a unit list.
		colist = node;
	    } else {
		// Append the lock node to the end of the list.
		Tasklist p = colist;
		while (p.next!=null) p = p.next;
		p.next = node;
	    }
	    cptr.cowait(null); // Suspend until released by unlock().
	    // We now own the lock.
	    return;
	}
	// We can obtain the lock.
	locked = true;
	return;
    }

    public synchronized void unlock(Task t) {
	// Usage: eg loggerlock.unlock(this);

	if (!locked) {
	    System.out.println(t.coName+
			       ": Attempt to free a lock that was not locked");
	    return;
	}
	if (colist!=null) {
	    Cortn cptr = colist.cptr;
	    colist = colist.next;
	    t.callco(cptr, null);
	    return;
	}
	locked = false;
	return;
    }
}


//**********************************************************************
//**************************** Clock ***********************************
//**********************************************************************

class Clock extends Task {
    ///task
    // An instance of this class models the Tripos clock device.

    Clock r;

    // Once started it receives act_clock packets and returns them to
    // the sender about arg1 msecs later. It will commit suicide when
    // given an act_die packet.

    // The public variable waiting is only true when the task is waiting
    // in a call of wait. It may be waiting because the priority queue
    // is empty, or it may be waiting for the time to release the next
    // packet from the priority queue. In either case qpkt should call
    // notifyAll to wakeup the wait() call when another packet is sent
    // to the clock task.

    // The arg1 field of a clock packet holds the delay time in msecs,
    // and the res1 field is set to the real wakeup time. These packets
    // are held in a priority queue implemented using the heap structure
    // typically used in heap sort. Each packet in the queue is held in
    // an element of heapv. The number of packets in the queue is heapn
    // and there is the constraint that the res1 field of the packet
    // in heapv[i]  is less than or equal to the res1 fields belonging to
    // packets heapv[2*i] and heapv[2*i+1], if they exist. This guarantees
    // that the packet in heapv[1] is the earliest to be released.

    // Normally the clock task is suspended in a call of wait waiting
    // for a clock packet to arrive. When one comes, it sets the res1
    // field and increments heapn. It it then inserts the packet at
    // position heapn and successively promotes it using upheap until
    // the heap constraint is satisfied, before re-entering the call
    // of wait. The argument of wait is the number of msecs until the
    // earliest packet should be released and if this time period
    // expires before another clock packet arrives, the packet in
    // heapv[1] is released and replaced by the packet in heapv[heapn],
    // if any. The packet in heapv[1] is then successively demoted using
    // downheap until its res1 less than or equal to the res1 fields
    // belonging to packets heapv[2*i] and heapv[2*i+1], if they exist,
    // where i is the current position of the packet. This mechanism
    // assures that both upheap and downheap are reasonably efficient.

    public boolean waiting;
    public Pkt heapv[];
    public Pkt diepkt = null;
    public int heapn;    // Number of packets in the heap
    public int heapnmax; // Current size of the heap

    public Clock(String name, Globals g, int pri) {
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }

    public Object fn(Object arg) {
	int delaymsecs;
	Pkt startuppkt = (Pkt) arg;
	Pkt clockpkt = null;
	diepkt = null;
        //System.out.println(coName+" : fn entered, pkt type="+strn(startuppkt.type,3));

        heapnmax = 10;  // Initial heap size.
	heapv = new Pkt[heapnmax+1];
	heapn = 0;     // Nothing in the heap yet.
	waiting = false;

	//synchronized (g.stats) { g.stats.c_qpkt++; }

        //System.out.println(coName+": Returning the startup packet to the "+startuppkt.task.coName);
        //System.out.println("Clock: Initialised");

	qpkt(startuppkt); // Return the startup packet to the controller.

        while(true) {
	    // This is running in the clock thread.

	    // Wait until the earliest packet is the priority queue
	    // can be released or until a die packet is received
	    // from the controller.

	    int now = nowmsecs();

	    //System.out.print("Clock: heapn="+strn(heapn,3));
	    //System.out.print(" now="+strn(now,6));
	    //if (heapn>0) {
	    //    System.out.print(" res1="+strn(heapv[1].res1,6));
	    //}
	    //System.out.println("");
	    while (heapn>0 && now>=heapv[1].res1) {
		// Release the packet in heapv[1]
		qpkt(heapv[1]);
		if (heapn>1) heapv[1] = heapv[heapn];
		heapn--;
		downheap(); // Demote the new packet in heapv[1]
		// See if there are more packets to release.
	    }

	    if (diepkt!=null) {
		// Release all clock packets now, return the die packet
		// to the controller and then die.
		//System.out.println("Clock: Clock is dying");
		if (heapn!=0)
		    System.out.println("Clock: ERROR Clock priority queue is not empty");

		//System.out.println(coName+": Returning the die packet to the controller");
		qpkt(diepkt);

		//System.out.println(coName+": Returning from fn to die");
		return null;
	    }

	    try {
		waiting = true;
		if (heapn>0) {
		    int dt = heapv[1].res1 - now;
		    // Wait for timeout or notify
		    //System.out.println(coName+": Calling wait("+dt+")");
		    wait(dt);
		} else {
		    //System.out.println(coName+": Calling wait() for the next clock pkt");
		    // Wait for notify
		    wait();
		}
		waiting = false;
	    } catch(Exception e) {}
	    // Go back to the start of the while(true) loop
	}
    }

    public synchronized boolean putpkt(Pkt pkt, Task from) {
	//System.out.println("\n"+coName+": Got lock on this thread");

	// This clock version overrides putpkt in class Task.

	// It is running in a client thread (not the clock thread).

	pkt.task = from;        // Set the return task field.
	pkt.link = null;

	// This is called in the destination task (the clock),
	// It puts the packet into the priority queue then calls
	// notifyAll to wakeup the clock thread.

	if (pkt.type==act_die) {
	    //System.out.println("Clock: Die packet received");
	    diepkt = pkt;
	    if (waiting) notifyAll();
	    //System.out.println(coName+": Releasing lock on this thread\n");
	    return true;
	}

	if (pkt.type==act_startclock) {
	    //System.out.println(coName+": Startup packet received");

	    // Append the packet onto the end of this task's wkq.
	    // It is always the first packet so wkq=null.

	    wkq = pkt; // Make a unit list.
	    //System.out.println(coName+": putpkt calling notifyAll()"+
	    //		   " since wkq was previously null");
	    notifyAll();

	    //System.out.println(coName+": Releasing lock on thread\n");
	    return true;
	}

	if (pkt.type!=act_clock) {
	    System.out.println(coName+": Unexpected packet, type = "+pkt.type);
	    qpkt(pkt);
	    System.out.println(coName+": Releasing lock on this thread\n");
	    return true;
	}

	pkt.res1 = pkt.arg1 + nowmsecs(); // Time to release.

	if ( heapn==heapnmax) {
	    //System.out.println(coName+": About to increase heap size from "+heapnmax);
	    //prheap();
	    // The heap is full, so we must enlarge it.
	    int newnmax = heapnmax*3/2 + 1;
	    Pkt newheapv[] = new Pkt[newnmax+1];
	    for(int i = 1; i<=heapn; i++) newheapv[i] = heapv[i];
	    heapnmax = newnmax;
	    heapv = newheapv;
	    //System.out.println(coName+": New heap size "+heapnmax);
	    //prheap();
	}

	heapn++;
	heapv[heapn] = pkt;
	upheap();

	if (waiting) notifyAll();
	//System.out.println(coName+": Releasing lock on this thread\n");
	return true;
    }

    private void upheap() {
	int p = heapn;
	Pkt pkt = heapv[p];
	int msecs = pkt.res1;

	while (p>1) {
	    int q = p/2; // The parent of p.
	    if (heapv[q].res1 <= msecs) break;
	    // Promote the packet
	    heapv[p] = heapv[q];
	    p = q;
	}
	heapv[p] = pkt;
	//prheap();
    }

    private void downheap() {
	int p = 1;
	Pkt pkt = heapv[1];
	// p points to a vacant position in the heap,
	// initially location 1.
	int msecs = pkt.res1; // Release time of pkt.

	while (true) {
	    int q = p+p; // Position of left child
	    if (q > heapn) break; // No children
	    // There is at least one child.
            if (q < heapn) {
		// There are two children, choose the earlier.
		if( heapv[q].res1 > heapv[q+1].res1) q++;
	    }
	    // q is the position of the earlier child.
	    if (msecs <= heapv[q].res1) break; // Do not promote.

	    // Promote the earlier child.
	    heapv[p] = heapv[q];
	    p = q;
	}
	heapv[p] = pkt;
	//prheap();
    }

    public synchronized void prheap() {
	if (heapn==0) {
	    System.out.println("\nThe priority queue is empty");
	} else {
	    System.out.println("\nThe priority queue:");
	}
	for(int i=1; i<=heapn; i++) {
	    Pkt pkt = heapv[i];
	    String pname = pkt.task==null ? "<null>" : pkt.task.coName;
	    System.out.println(strn(1,2)+
			       "  "+strn(pkt.arg2,2)+
			       "   res1: "+strn(pkt.res1,6)+
			       " arg1: "+strn(pkt.arg1,6)+
			       " from: "+pname);
	}
	System.out.println("");
    }
}

//**********************************************************************
//**************************** Bounce **********************************
//**********************************************************************

class Bounce extends Task {
    ///task

    Bounce r;

    public Bounce(String name, Globals g, int pri) {
	// This constructor is used to create the Bounce task and its root coroutine.
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }

    public Object fn(Object arg) {
        //System.out.println(coName+": fn entered");
        Pkt startuppkt = (Pkt) arg;
	int count = 0;

	// Create and start the echo coroutine.
	//System.out.println(coName+": calling new(Echoco, this)");
	Echoco echoco = new Echoco("Echoco", this);
	// Transfer control to echoco leaving it suspended in its main loop:

	echoco.parent = this; 
	echoco.value = null;
	currco = echoco; 

	//System.out.println(coName+": calling echoco.start()");
	echoco.start();

	//System.out.println(coName+": Coroutine "+echoco.coName+" created and thread started");

	// Wait until this coroutine is the current coroutine.
	currcoWait();

	if (true) { // =true to test callco and cowait
	    int cycles = 10000;
	    System.out.println("\n"+coName+": Calling callco and cowait "+cycles+" times");
	    int start_time = nowmsecs();

	    for (int i=1; i<=cycles; i++) {
		//System.out.println(coName+
		//		   ": "+strn(i,5)+" Calling callco(echoco,"+i+")");
		callco(echoco, (Object)(new Integer(i)));
	    }

	    int diff = nowmsecs() - start_time;
	    if (diff==0) diff=1; // To avoid overflow.
	    System.out.println("\n"+coName+
			       ": Time taken "+diff+ " msecs"+
			       " giving "+((cycles*1000)/diff)+
			       " callco-cowait bounces per second\n");
	}

	//System.out.println(coName+
	//		   ": Returning the startup packet to "+
	//		   startuppkt.task.coName+"\n");
        qpkt(startuppkt); // Return the startup packet

	System.out.println(coName+": Ready");

        while(true) {
	    Pkt pkt = taskwait();
	    switch (pkt.type) {
	    default:
		System.out.println(coName+
				   ": unexpected packet received from "+
                                   pkt.task.coName+
                                   " type "+pkt.type);
		continue;

	    case act_bounce:
		count++;
		//System.out.println(coName+": bounce pkt received");
                for(int i=1; i<=10; i++) callco(echoco, null);
		qpkt(pkt);
		continue;

	    case act_quickbounce:
		// For calibrating the qpkt-taskwait bounce rate.
		//System.out.println(coName+": quick bounce pkt received");
		qpkt(pkt);
		continue;

	    case act_die:
		//System.out.println(coName+": die pkt received");
		//System.out.println(coName+": Set echoco.dying to true");
		echoco.dying = true;
		//System.out.println(coName+": Calling callco(echoco, null)");
		callco(echoco, null);
		//System.out.println(coName+": Return the die packet to the Controller");
		pkt.res1 = count;
		qpkt(pkt);

		return null;     // Cause this thread to die
	    }
	}
    }
}

//**********************************************************************
//*************************** Echoco ***********************************
//**********************************************************************

class Echoco extends Cortn {
    ///coroutine
    // This is the echo coroutine only used in by the Bounce task. Its
    // purpose is to maintain a reasonably high coroutine change to
    // thread change ratio.

    Globals g;
    Bounce r;            // Pointer to the owning task's variables.
    boolean dying=false; // When =true this coroutine will die.

    public Echoco(String name, Bounce r) {
	// Create a non-root coroutine belonging to the Bounce
	// task r. By convention r is given the type of the
	// owning task. This allows indirect access to all the
	// Bounce task's instance variables such as t.currco,
	// and methods such as r.qpkt and r.callco that are
	// declared in class Task which is the superclass
	// of Bounce.
	super(name, r);
	coName = name;      // Set the coroutine's name.
	this.r = r;
        System.out.println(coName+": Coroutine created");

	// When this coroutine is started, it will enter run defined
	// class Cortn which contains the standard non-root
	// coroutine main loop. The parent variable will already
	// be set appropriately and t.currco will point to its
	// this coroutine's instance variables. This coroutine
	// will thus immediately suspend itself in cowait(c) of
	// the coroutine main loop. When callco is called the
	// value will be passed as the argument of fn. A return from
	// fn will cause cowait(c) to be called again.
    }

    public Object fn(Object x) {
	//System.out.println(coName+": received value "+((Integer)x).intValue());

	while (!r.dying) x = cowait(x);

	return x;
    }
}


//**********************************************************************
//*************************** Printer **********************************
//**********************************************************************

class Printer extends Task {
    ///task

    Printer r;

    public Printer(String name, Globals g, int pri) {
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }
        
    public Object fn(Object c) {
        //System.out.println(coName+": fn entered");
        Pkt startuppkt = (Pkt) c;
	//int count = 0;
	Pkt pkt = null;

	Pkt delaypkt = new Pkt(null, g.clock, act_clock,
			       0,0,  // res1 res2
			       10);  // 10 msecs delay

	Pkt q = null;  // List of pending print packets while delaying
	Pkt printpkt = null;  // Current print packet, if any.

        //System.out.println(coName+
	//		   ": Returning the startup packet to "+
	//		   startuppkt.task.coName);
        qpkt(startuppkt); // Return the startup packet

        //System.out.println(coName+": Entering main loop");

	while (true) {
	    // Start of printer event loop
	    if (q!=null) {
		// Dequeue a pending print packet.
		pkt = q;
		q = q.link;
		pkt.link = null;
		if (g.tracing)
		    System.out.println(coName+": Packet extracted from q");
	    } else {
		// Wait for a print or die packet.
		pkt = taskwait();
		if (g.tracing)
		    System.out.println(coName+": taskwait returned a packet");
	    }

	    switch (pkt.type) {
	    default:
		System.out.println(coName+
				   ": Unexpected packet received from "+
				   pkt.task.coName);
		continue;

	    case act_print:
		{   char modech = (char) pkt.arg1;
		    int serno = pkt.arg2;

		    if (g.tracing) {
			System.out.println(coName+
					   ": act_print packet received from "+
					   pkt.task.coName);
		    }

		    printpkt = pkt;
		    if (g.tracing) {
			System.out.println(coName+
					   ": Sending delay packet to Clock");
		    }

		    qpkt(delaypkt);

		    while (true) {
			// Wait for the delay pkt to return.
			pkt = taskwait();
			if (pkt==delaypkt) break;

			// Insert the non delaypkt in q
			pkt.link = q;
			q = pkt;
		    }

		    // The delay has now ended, so return the print
		    // packet and process another (possibly pending)
		    // request.

		    qpkt(printpkt);
		    printpkt = null;
		    continue;
		}

	    case act_die:
		if (g.tracing) {
		    System.out.println(coName+": Die packet received");
		    System.out.println(coName+": Return the die packet to task "+
				       pkt.task.coName);
		    System.out.println(coName+": This task is now dying");
		}
		break;     // Cause the thread to die

	    }
	}
    }
}


//**********************************************************************
//**************************** Client **********************************
//**********************************************************************

class Client extends Task {
    ///task

    Client r;

    public Client(String name, Globals g, int pri) {
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }
        
    public Object fn(Object arg) {
        //System.out.println(coName+": fn entered");
        Pkt startuppkt = (Pkt) arg;
	Server serverv[]; // This will hold the vector of read or write servers
	                  // for this client.
	Request requestv[] = new Request[g.requestvupb+1];
	char modech;
	int clino = startuppkt.arg1;

	if (startuppkt.type==act_startrdclient) {
	    modech = 'R';
	    serverv = g.rdserverv;
	} else {
	    modech = 'W';
	    serverv = g.wrserverv;
	}

	Rnd rnd = new Rnd(clino+100*modech);

	if (false) { // Test the random number generator.
	    for (int i=1; i<=50; i++) {
		int x = rnd.next(9999);
		System.out.print(" "+strn(x,5));
		if (i %10 == 0) System.out.println("");
	    }
	    realdelay(1000);
	}

	System.out.println(coName+": Initialised");
        qpkt(startuppkt); // Return the startup packet

	for (int count = 1; count<=g.loopmax; count++) {
	    int pos = 0;
	    int rqstvupb = g.requestvupb;
	    int clidelayitem = 0; // This will be the subscript of requestv of
                                  // the request to delay in the client.
	    int srvdelayitem = 0; // This will be the subscript of requestv of
                                  // the request to delay in the its server.
	    int mpxdelayitem = 0; // This will be the subscript of requestv of
                                  // the request to delay in its multiplexor.

	    // This client will not create its next schedule until all other
	    // read and write clients are ready to do the same. This is achieved
	    // by sending a sync packet to the Stats task which is only returned
	    // when all client sync packets have been received.

	    sendpkt(new Pkt(null, g.stats, act_sync));

	    System.out.println("\n"+coName+": Creating and processing schedule "+count);


	// Create a list of requests.

	// Choose three distinct requests to cause real time delays.

	    if (g.requestvupb>=3) {
		while (true) {
		    clidelayitem = rnd.next(g.requestvupb);
		    srvdelayitem = rnd.next(g.requestvupb);
		    if (clidelayitem!=srvdelayitem) break;
		}
		while (true) {
		    mpxdelayitem = rnd.next(g.requestvupb);
		    if (mpxdelayitem!=clidelayitem ||
			mpxdelayitem!=srvdelayitem) break;
		}
	    }

	for (int srvno=1; srvno<=g.srvmax; srvno++)
	    for (int mpxno=1; mpxno<=g.mpxmax; mpxno++)
		for (int chnno=1; chnno<=g.chnmax; chnno++) {
		    int data = 0;
		    if (modech=='W') data = rnd.next(9999); // Range 1 to 9999
		    char flag = 'n';
		    pos++;
		    if (pos==clidelayitem) flag = 'c'; // Client delay
		    if (pos==srvdelayitem) flag = 's'; // Server delay
		    if (pos==mpxdelayitem) flag = 'm'; // Multiplexor delay
		    requestv[pos] = new Request(flag, srvno, mpxno,
						chnno, data);
		}

	if (g.tracing || true) {
	    System.out.println("\n"+coName+": Schedule of requests");
	    for (int i=1; i<=g.requestvupb;i++) {
		Request req = requestv[i];
		char flag = req.flag;
		int srvno = req.srvno;
		int mpxno = req.mpxno;
		int chnno = req.chnno;
		int data = req.data;
		System.out.print(" "+flag+modech+
				 "S"+strz(srvno,2)+
				 "M"+strz(mpxno,2)+
				 "C"+strz(chnno,2)+
				 ":"+strz(data,4));


		if (i%5==0) System.out.println(""); 
	    }
	    System.out.println("");
	}

	//System.out.println("\n"+coName+": Starting next schedule ");

	while (rqstvupb>0) {
	    int i = rnd.next(rqstvupb);
	    Request req = requestv[i];
	    int data = req.data;
	    char flag = req.flag;
	    int srvno = req.srvno;
	    int mpxno = req.mpxno;
	    int chnno = req.chnno;

	    if (modech=='R') {
		// Code for a read client
		if (g.tracing) {
		    System.out.println("RC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Sending read request to server");
		}
		data = sendpkt(new Pkt(null,serverv[srvno],act_read,
				       flag,clino,srvno,mpxno,chnno,data));
		if (g.tracing) {
		    System.out.println("RC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Packet returned from server");
		}

		if (data==0) {
		    // Read was not successful since its channel buffer
		    // was empty.

		    if (g.tracing) {
			System.out.print("RC"+strz(clino,2)+
					 "  "+flag+modech+
					 "S"+strz(srvno,2)+
					 "M"+strz(mpxno,2)+
					 "C"+strz(chnno,2)+
					 ":"+strz(data,4)+
					 " Read failed");
		    }

		    //c_readfail++;

		    // Delay for 200 msecs to give other tasks a chance to run,
		    // hopefully allowing write clients to put more data in
		    // the channel buffers.
		    delaytask(200);

		    continue; // try sending another random item from the schedule.
		}

		// The read request was successful.

		if (g.tracing) {
		    System.out.println("RC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Read was successful");
		    System.out.println(coName+"Realdelay(2000)\n");
		    realdelay(2000);

		    //g.c_rdchecksum = (g.rdchecksum+data) % 1000000;
		    //g.c_rdcount++;
		}
	    } else {
		// Code for a write client
		if (g.tracing) {
		    System.out.println("WC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Sending write request to server");
		}
		int rc = sendpkt(new Pkt(null,serverv[srvno],act_write,
					 flag,clino,srvno,mpxno,chnno,data));
		if (g.tracing) {
		    System.out.println("WC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Packet returned from server");
		}

		if (rc==0) {
		    // Write was not successful since its channel buffer
		    // was full.

		    if (g.tracing) {
			System.out.println("WC"+strz(clino,2)+
					   "  "+flag+modech+
					   "S"+strz(srvno,2)+
					   "M"+strz(mpxno,2)+
					   "C"+strz(chnno,2)+
					   ":"+strz(data,4)+
					   " Send failed");
		    }

		    //g.c_sendfail++;

		    // Delay for 20 msecs to give other tasks a chance to run,
		    // hopefully allowing read clients to remove data from
		    // the channel buffers.
		    delaytask(20);

		    continue; // try sending another random request from the schedule.
		}

		// The write request was successful in that the data was
		// written by the specified multiplexor in the specified
		// channel buffer. The data may not have been read yet by
		// a read client.

		if (g.tracing) {
		    System.out.println("WC"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Data sent");
		    System.out.println(coName+"Realdelay(2000)\n");
		    realdelay(2000);

		    //g.c_wrchecksum = (g.c_wrchecksum+data) % 1000000;
		    //g.c_wrcount++;
		}
	    }

	    // The read or write request has been successfully processed.

	    // Delay for delaymsecs if a client delay is specified.

	    if (flag=='c') {
		if (g.tracing) {
		    System.out.println(coName+" "+
				       modech+"C"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Client delay");
		}
		//c_delaylong++;
		delaytask(g.delaymsecs);
		if (g.tracing) {
		    System.out.println(coName+" "+
				       modech+"C"+strz(clino,2)+
				       "  "+flag+modech+
				       "S"+strz(srvno,2)+
				       "M"+strz(mpxno,2)+
				       "C"+strz(chnno,2)+
				       ":"+strz(data,4)+
				       " Client delay ended");
		}

		// remove the read or write request from the schedule.
		requestv[i] = requestv[rqstvupb];
		rqstvupb--;

		//Process another request from the schedule.
	    }
	    // Create and perform the next schedule.
	}
	}

	// tell the Stats task that this client has finished its
	// final schedule.

	if (modech=='R') {
	    if (g.tracing) {
		System.out.println(coName+" "+
				   modech+"C"+strz(clino,2)+
				   " Sending act_rddone to the Stats task");
		sendpkt(new Pkt(null, g.stats, act_rddone));
	    }
	} else {
	    if (g.tracing) {
		System.out.println(coName+" "+
				   modech+"C"+strz(clino,2)+
				   " Sending act_wrdone to the Stats task");
		sendpkt(new Pkt(null, g.stats, act_wrdone));
	    }
	}

	// Wait for the act_die packet from the controller.
	if (g.tracing) {
	    System.out.println(coName+" "+
			       modech+"C"+strz(clino,2)+
			       " Waiting for die packet from the controller");
	}

	//c_taskwait++;
	Pkt pkt = taskwait();
	if (pkt.type!=act_die) {
	    System.out.println(coName+" "+
			       modech+"C"+strz(clino,2)+
			       " System error -- act_die packet expected");
	} else {
	    if (g.tracing) {
		System.out.println(coName+" "+
				   modech+"C"+strz(clino,2)+
				   " Die packet received");
	    }
	}

	//c_qpkt++;
	qpkt(pkt);

	if (g.tracing) {
	    System.out.println(coName+" "+
			       modech+"C"+strz(clino,2)+
			       " Client dying");
	}

	return null;
    }
}

class Request {
    char flag;    // n=no delay c=client delay, s=server delay, m=multiplexor delay
    int srvno;
    int mpxno;
    int chnno;
    int data;    // Non zero if a write request

    public Request(char flag, int srvno, int mpxno, int chnno, int data) {
	this.flag = flag;
	this.srvno = srvno;
	this.mpxno = mpxno;
	this.chnno = chnno;
	this.data = data;
    }
}

//**********************************************************************
//**************************** Server **********************************
//**********************************************************************

class Server extends Task {
    ///task


    Server r;

    // This class is used to model read and write servers which
    // run in multievent mode using gomultievent defined in Task.

    public Pkt startuppkt = null;
    public Pkt diepkt = null;   // Set non null when a die pkt is received.
    public Pkt serverq = null;
    public int srvno;
    public char modech;
    public OccamChannel loggerin = null;
    public OccamChannel loggerout = null;
    public Loggerlock loggerlock = null;
    public Loggerco loggerco = null;

    public Condvar countcondvar = null;
    public Condvar pktcondvar = null;

    public Workerco wrkcov[] = null; // Vector of worker coroutines.
    public int countv[] = null; // Vector of work counts.

    public int minwrkcount = 0; // Count of the least busy worker.

    public int busycount = 0;  // Count of worker coroutines that are busy.
                        // A worker is busy when it is processing a
	                // request packet. It is not busy when waiting
                        // countcondvar or pktcondvar.


    public Server(String name, Globals g, int pri) {
	// This constructor is used to create a server tasks and their
	// root coroutine.
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }
        
    public Object fn(Object arg) {
	// This is the main function of a Server's root coroutine.

	// Method fn is overridden by classes representing non-root
	// server coroutines.

        //System.out.println(coName+": started");

	// arg is the startup packet which has a type field holding
	// either act_startrdserver or act_startwrserver.
	// In ether cas the arg1 field holds the server number.
	int count = 0;

        startuppkt = (Pkt) arg; // For use by servermainco

	srvno = startuppkt.arg1;

	modech = startuppkt.type==act_startrdserver ? 'R' : 'W';

	//if (g.tracing) {
	//    System.out.println(coName+": Server started, srvno="+srvno);
	//}

	Rnd rnd = new Rnd(srvno+100*modech);

	Servermainco servermainco = 
	    new Servermainco(coName+"mainco",    // This server's main coroutine
			     this);  // Task
	// Start servermainco leaving it suspended in main loop:
	// while(!dying) c = fn(cowait());
	//if (g.tracing) {
	//    System.out.println(coName+": Calling servermainco.start()");
	//    System.out.println(coName+":   to leave it in cowait() in the loop");
	//    System.out.println(coName+":   while (!dying)c=fn(cowait(c));");
	//    System.out.println(coName+":   fn will be given the argument null.;");
	//}

	// Give initial control to servermainco. It should immediately
	// return control to this task, leaving it suspended in cowait(c).
	servermainco.parent = this;
	currco = servermainco;
	servermainco.start();

	//if (g.tracing) {
	//  System.out.println(coName+
	//		       ": Calling currcoWait(), currco="+currco.coName);
	//}
	// Wait for servermainco to enter its while(!dying) c = fn(cowait(c)) loop.
	currcoWait();

	//System.out.println(coName+": Calling gomultievent(servermainco)");
	gomultievent(servermainco);
	//System.out.println(coName+": Returned from gomultievent(servermainco)");

	// On return from gomultievent, the diepkt will be set.

	//qpkt(diepkt);

	if (g.tracing)
	    System.out.println(coName+": Returning to DEAD state");

	return null;
    }
}

//**********************************************************************
//*************************** Servermainco *****************************
//**********************************************************************

class Servermainco extends Cortn {
    ///coroutine
    // This is the main coroutine of a read or write server.
    // It creates the worker coroutines and the logger, then
    // processes requests from client before being closed down
    // by a die packet from the Controller.

    Server r; // This supercedes Task r delared in class Cortn.

    public Servermainco(String name, Server r) {
	// This constructor create a non-root coroutine belonging to
	// a server task. The only possible coroutines are workers or
	// loggers.
	super(name, r);
	this.r = r;
	System.out.println(coName+": Coroutine created");
    }

    public Object fn(Object x) {
	// This is the main function of servermainco given control
	// by gomultievent. It is the main coroutine of a Server task.
	// x  will be null and fn will not return.

	//System.out.println(coName+": servermainco Coroutine entered, srvno="+r.srvno);

	r.diepkt = null;

	r.wrkcov = new Workerco[g.workmax+1]; // Vector of worker coroutines.
	r.countv = new int[g.workmax+1];      // Vector of work counts.

	for (int i=1; i<=g.workmax; i++) {
	    r.wrkcov[i] = null;
	    r.countv[i] = 0;
	}

	r.minwrkcount = 0;

	r.busycount = 0;  // Count of worker coroutines that are busy.
                          // A worker is busy when it is processing a
	                  // request packet. It is not busy when waiting
                          // countcondvar or pktcondvar.

	r.loggerlock = new Loggerlock();

	r.loggerin = new Channel();
	r.loggerout = new Channel();

	r.loggerco = new Loggerco(coName+"log", r);
	// Start loggerco leaving it susprnded in main loop:
	// while(!dying) c = fn(cowait());

	r.loggerco.parent = this; 
	r.loggerco.value = null;
	t.currco = r.loggerco;

	r.loggerco.start();

	// Wait for it to enter its while(!dying) c = fn(cowait()) loop.
	currcoWait();

	//if (g.tracing) {
	//    System.out.println(coName+": Coroutine "+r.loggerco.coName+" created");
	//}

	for (int wrkno = 1; wrkno<=g.workmax; wrkno++) {
	    Workerco cptr = new Workerco(coName+"W"+strz(wrkno,2), r);
	    r.wrkcov[wrkno] = cptr;

	    // Give control to the newly created worker coroutine,
	    // telling it its worker number.
	    cptr.parent = this;
	    cptr.value = new Integer(wrkno);
	    r.currco = cptr;

            cptr.start();

	    // Wait for it to enter its while(!dying) c = fn(cowait()) loop.
	    currcoWait();
	    //if (g.tracing) {
	    //    System.out.println(cptr.coName+": Worker coroutine "+cptr.coName+" ready");
	    //}
	}

	//if (g.tracing) {
	//  System.out.println(coName+
	//		       ": Returning startup packet to task "+
	//		       r.startuppkt.task.coName);
	//}

	r.qpkt(r.startuppkt);

	if (g.tracing) {
	    System.out.println(coName+": Initialised");
	}

	while (true) {
	    // Start of this server's event loop.

	    // Get a client request packet via gomultievent.
	    // It should be a read, write or die packet.
	    // Bounce and Clock packets belong to worker
	    // coroutines and will delivered automatically
	    // to their coroutines by gomultievent.

	    //if (g.tracing) {
	    //	System.out.println(coName+
	    //			   ": Waiting for a request from a client via gomultievent");
	    //}

	    t.mainco_ready = true;
	    //System.out.println(coName+
	    //		       ": Calling cowait(null)");
	    Pkt pkt = (Pkt) cowait(null);
	    //if (pkt==null) {
	    //	System.out.println(coName+
	    //			   ": cowait returned null");
	    //	continue;
	    //}

	    t.mainco_ready = false;

	    //if (g.tracing) {
	    //	System.out.println(coName+
	    //			   ": Packet received from gomultievent, type="+strn(pkt.type,3));
	    //}

	    switch (pkt.type) {
	    default:
		System.out.println(coName+
				   ": Unexpected packet received from "+
				   pkt.task.coName);
		t.qpkt(pkt);
		continue;

	    case act_read:
	    case act_write:
		{   Pkt p = r.serverq;
		    if (g.tracing) {
			System.out.println(coName+
				   ": Append pkt to end of this server's queue");
		    }
		    pkt.link = null;
		    if (r.serverq==null) {
			// Make a unit list
			r.serverq = pkt;
		    } else {
			// Append pkt to the end of this server's queue
			while (p.link!=null) {
			    p = p.link;
			}
			p.link = pkt;
		    }
		    realdelay(1000);
		    if (g.tracing) {
			System.out.println(coName+
					   ": Calling notifyAll for condition pktcondvar");
			r.pktcondvar.conotifyAll();
		    }
		    continue;
		}

	    case act_die: // From the Controller task.
		// Cause this server to return to DEAD state.

		if (g.tracing) {
		    System.out.println(coName+
				       ": Die packet received");
		}

		r.diepkt = pkt;
		// Release all workers on countcondvar.

		r.countcondvar.conotifyAll();

		// Delete all worker coroutines and the logger.

		//for ( int i=1; i<=g.workmax; i++) {
		//    killco(wrkcov[i]);
		//}
		//killco(loggerco);

		if (g.tracing) {
		    System.out.println(coName+
				       ": Entering single event mode");
		}

		t.multi_done = true;
		cowait(null); // Return to the controller.
		return null;
	    }
	}
    }

    public synchronized Pkt waitforserverpkt() {
	while (r.serverq==null | !dying) {
	    if (g.tracing) {
		System.out.println(coName+
				   ": Waiting for a serverq to contain a packet");
	    }
	    r.pktcondvar.cocondwait();
	}
	if (g.tracing) {
	    System.out.println(coName+
			       ": Dequeueing a packet from serverq");
	    };
	Pkt pkt = r.serverq;
	r.serverq = r.serverq.link;
	pkt.link = null;
	return pkt;
    }
}

//**********************************************************************
//*************************** Loggermainco *****************************
//**********************************************************************

class Loggerco extends Cortn {
    ///coroutine
    // This the logger coroutine of a read or write server.
    // It runs in multi-event mode under the control of
    // gomultievent.
    Server r;
    Pkt diepkt = null;

    public Loggerco(String name, Server r) {
	super(name, r);
	this.r = r; // Allow access to the Server's variables.
    }

    public Object fn(Object x) {
	System.out.println(coName+": Ready ##################################");

	while (true) {
	    // Start of the logger loop.
	    int i = 0; // Count of values received.

	    int a = r.loggerin.coread();
	    if (g.tracing) {
		System.out.println(coName+
				   ": Received a="+a);
	    }
	    i++;

	    // occasionally send a message to the printer task.
	    if ((i % 50) == 0) {
		if (g.tracing) {
		    System.out.println(coName+
				       ": Sending pkt to the Printer task");
		}
		r.sndpkt(new Pkt(null, g.printer, act_print,
			       0,0,
			       r.modech, r.srvno));
		if (g.tracing) {
		    System.out.println(coName+
				       ": pkt returned from the Printer");
		}
	    }

	    // Occasionally the logger delays briefly.
	    if ((i % 7)==0) {
		delayco(2); // 2 msecs
	    }

	    int b = r.loggerin.coread();
	    if (g.tracing) {
		System.out.println(coName+
				   ": Received b="+b);
	    }

	    { int sum = a+b;
	      if (g.tracing) {
		  System.out.println(coName+
				   ": Replying "+sum);
	      }
	      r.loggerout.wrpn(sum);
	      r.loggerout.cowrite(-1);
	    }
	}
    }
}

//**********************************************************************
//*************************** Loggerlock *******************************
//**********************************************************************

class Loggerlock {
    // pkt is the list of packets waiting for the lock.
    Pkt pkt = null;
}

//**********************************************************************
//*************************** Colist *********************************
//**********************************************************************

class Colist {
    // This holds a list coroutines used in Condvar.
    public Colist link;
    public Cortn cptr;

    public Colist(Colist link, Cortn cptr) {
	this.link = link;
	this.cptr = cptr;
    }
}

//**********************************************************************
//*************************** Condvar **********************************
//**********************************************************************

class Condvar {
    Colist list = null;
    Task t;
    String coName;

    public Condvar(String name, Task t) {
	// Create a new condition variable belonging to Server r.
	coName = coName+"condvar";
	this.t = t;
    }

    public synchronized  void cocondwait() {
	// Typical usage: pktcondvar.condwait();
	// Insert a node at the head of list.
	Colist p = new Colist(list, t.currco);
	System.out.println(coName+" Waiting in condwait()");
	t.cowait(null);
    }

    //public synchronized  void waitforserverpkt() {
    //	// Typical usage: pkt=pktcondvar.waitforserverpkt();
    //	while (t.serverq==null) {
    //	    cocondwait();
    //	}
    //}

    public void conotifyAll() {
	// No need to synchronize since only one coroutine of this
	// task can run. ??? flushing to memory ???
	// Typical usage: pkt=pktcondvar.conotifyAll();
	System.out.println(coName+": conotifyAll called");

	// Release all the coroutines waiting on this condition.
	Colist p = list;
	// Clear the list since some may immediately wait on the same
	// condition.
	list = null;
	while (p!=null) {
	    t.callco(p.cptr);
	    p = p.link;
	}
    }
}

//**********************************************************************
//*************************** Workerco *********************************
//**********************************************************************

class Workerco extends Cortn {
    ///coroutine
    // This is the main coroutine of a read or write server worker
    // coroutine.

    Server r;
    int wrkno;
    Pkt diepkt = null;
    Pkt pkt = null;

    public Workerco(String name, Server r) {
	super(name, r);
	this.r = r;
    }

    public Object fn(Object x) {
	// x is the worker number.
	wrkno = ((Integer)x).intValue();

	System.out.println(coName+": Initialised and ready, wrkno="+wrkno);

	// This is the main function of a worker coroutine belonging
	// to a server.

	while (true) {
	    System.out.println(coName+": Waiting for next request pkt");

	    while (r.serverq==null | dying) {
		r.pktcondvar.waitforserverpkt();
	    }

	    if (dying) return null;

	    Pkt pkt = r.serverq;
	    r.serverq = r.serverq.link;
	    pkt.link = null;

	    // Temp fiddle
	    System.out.println(coName+": Temp fiddle #############################");
	    System.out.println(coName+": Got pkt from "+pkt.task.coName);
	    System.out.println(coName+": Returning to pkt to "+pkt.task.coName);
	    pkt.res1 = 1234; // Indicate success.
	    r.qpkt(pkt);
	    // Wait for another request.
	}
    }
}

//**********************************************************************
//**************************** Multiplexor *****************************
//**********************************************************************

class Multiplexor extends Task {
    ///task

    Multiplexor r;         // This is used by the multiplexor
                           // coroutines to access the multiplexor
                           // variables such as mpxrdcov or bufv.

    Pkt startuppkt = null; // This task variable hold the startup
                           // packet. It is returned to the
                           // controller by mpxmainco when
                           // initialisation is complete.

    int mpxno;             // The number of this multiplexor

    int mpxbusycount = 0;  // The number of channel coroutines
                           // that are currently busy (ie not
                           // waiting for requests.

    Pkt diepkt = null;     // This will contain the die packet
                           // when received from the controller.

    Mpxrdco mpxrdcov[] = null; // To hold the channel read coroutines.
    Mpxwrco mpxwrcov[] = null; // To hold the channel write coroutines.
    boolean rdbusyv[]  = null;
    boolean wrbusyv[]  = null;
    Pkt rdwkqv[]       = null;
    Pkt wrwkqv[]       = null;
    Channelbuf bufv[]  = null;

    public Multiplexor(String name, Globals g, int pri) {
	// This constructor is used to create a multiplexor task and
	// its root coroutine.
	super(name, g, pri);
	r = this;
        System.out.println(coName+": Task created");
    }
        
    public Object fn(Object arg) {
	// This is the main function of a multiplexor root coroutine.

        startuppkt = (Pkt) arg; // Used by mpxmainco
	mpxno = startuppkt.arg1;
	//int count = 0;

        //System.out.println(coName+": startup packet received from "+startuppkt.task.coName);

	// Create the multiplexor mainco for gomultievent.

	Mpxmainco mainco = new Mpxmainco(coName+"mainco", r);

	mainco.parent = this; 
	mainco.value = null;
	currco = mainco; 

	//System.out.println(coName+": Starting coroutine "+mainco.coName);
	mainco.start();

	// Wait for it to enter its while(!dying) c = fn(cowait()) loop.
	currcoWait();

	//System.out.println(coName+": Coroutine "+mainco.coName+" created");

	gomultievent(mainco);

	return null;
    }
}

//**********************************************************************
//**************************** Mpxmainco *****************************
//**********************************************************************

class Mpxmainco extends Cortn {
    ///coroutine

    Multiplexor r;
    Pkt diepkt;

    public Mpxmainco(String name, Multiplexor r) {
	// This constructor creates a non-root coroutine belonging to
	// a multiplexor task. The only possible coroutines are channel
	// read and write coroutine.
	super(name, r);
	this.r = r;
    }
        
    public Object fn(Object arg) {
	// This is the main function of a multiplexor mainco
	// called from gomultievent.

        //System.out.println(coName+": Multiplexor's mainco entered");

	// Allocate all the multiplexor vectors.

	r.mpxrdcov = new Mpxrdco[g.chnmax+1];
	r.mpxwrcov = new Mpxwrco[g.chnmax+1];
	r.rdbusyv  = new boolean[g.chnmax+1];
	r.wrbusyv  = new boolean[g.chnmax+1];
	r.rdwkqv   = new Pkt[g.chnmax+1];
	r.wrwkqv   = new Pkt[g.chnmax+1];
	r.bufv     = new Channelbuf[g.chnmax+1];

	for (int chnno=1; chnno<=g.chnmax; chnno++) {
	    r.mpxrdcov[chnno] = null;
	    r.mpxwrcov[chnno] = null;
	    r.rdbusyv[chnno]  = false;
	    r.wrbusyv[chnno]  = false;
	    r.bufv[chnno]     = null;
	}


	// Allocate the channel buffers
	for (int chnno=1; chnno<=g.chnmax; chnno++) {
	    Channelbuf buf = new Channelbuf(g.chnbufsize);
	    r.bufv[chnno] = buf;
	    if (g.tracing) {
		System.out.println(coName+
				   ": Created channel buffer "+strz(chnno,2)+
				   ", size="+g.chnbufsize);
	    }
	}

	// Create the multiplexor read channel coroutines.
	for (int chnno=1; chnno<=g.chnmax; chnno++) {
	    Mpxrdco mpxrdco = new Mpxrdco("M"+strz(r.mpxno,2)+"RC"+strz(chnno,2), r);
	    // Start mpxrdco leaving it susprnded in main loop:
	    // while(!dying) c = fn(cowait());

	    mpxrdco.parent = this;
	    mpxrdco.value = null;
	    t.currco = mpxrdco; 

	    mpxrdco.start();
	    // Wait for it to enter its while(!dying) c = fn(cowait()) loop.
	    currcoWait();

	    // Tell mpxrdco what its channel number is.
	    callco(mpxrdco, new Integer(chnno));

	    // Wait for it to respond.
	    //if (g.tracing) {
	    //    System.out.println(mpxrdco.coName+": Read coroutine started for channel "+chnno);
	    //}
	}

	// Create the multiplexor write channel coroutines.
	for (int chnno=1; chnno<=g.chnmax; chnno++) {
	    Mpxwrco mpxwrco = new Mpxwrco("M"+strz(r.mpxno,2)+"WC"+strz(chnno,2), r);
	    // Start mpxwrco leaving it susprnded in main loop:
	    // while(!dying) c = fn(cowait());

	    mpxwrco.parent = this;
	    mpxwrco.value = (Object)(new Integer(123));
	    t.currco = mpxwrco; 

	    mpxwrco.start();
	    // Wait for it to enter its while(!dying) c = fn(cowait()) loop.
	    currcoWait();

	    // Tell mpxwrco what its channel number is.
	    callco(mpxwrco, new Integer(chnno));
	    //if (g.tracing) {
	    //    System.out.println(mpxwrco.coName+": Write channel coroutine started");
	    //}
	}

	//System.out.println(coName+
	//		   ": Returning the startup packet to task "+
	//		   r.startuppkt.task.coName);
        r.qpkt(r.startuppkt); // Return the startup packet

	if (g.tracing) {
	    //System.out.println(coName+": All read and write channel coroutines ready");
	    System.out.println(r.coName+": Initialised");

	}

        while(true) {
	    // Get the next request from gomultievent.

	    t.mainco_ready = true;
	    // mainco_ready is only true when mainco is waiting for
	    // a read, write or die request.
	    Pkt pkt = (Pkt) cowait(null);

	    t.mainco_ready = false;

	    switch (pkt.type) {
	    default:
		System.out.println(coName+
				   ": Unexpected packet received from "+pkt.task.coName);
		continue;

	    case act_read:
	    {   // Packet arguments:
		// a1:flag ar:clino a3:serno a4:mpxno a5:chnno
		char flag = (char) pkt.arg1;
		int clino = pkt.arg2;
		int serno = pkt.arg3;
		int mpxno = pkt.arg4;
		int chnno = pkt.arg5;
		int data  = pkt.arg6;  // =0 for read requests

		if (g.tracing) {
		    System.out.println(coName+
                               ": Read request received");
		}

		// Insert this packet at the head of the read wkq
		// for this channel.

		pkt.link = r.rdwkqv[chnno];
		r.rdwkqv[chnno] = pkt;

		if (g.tracing) {
		    System.out.println(coName+
                               ": Read request inserted at head of its wkq");
		}

		if (!r.rdbusyv[chnno]) {
		    // Wake up the channel read coroutine
		    // if it is not busy.
		    callco(r.mpxrdcov[chnno], null);
		}

		// Process another read, write or die request
		continue;
	    }

	    case act_write:
	    { // Packet arguments:
		// a1:flag ar:clino a3:serno a4:mpxno a5:chnno
		char flag = (char) pkt.arg1;
		int clino = pkt.arg2;
		int serno = pkt.arg3;
		int mpxno = pkt.arg4;
		int chnno = pkt.arg5;
		int data  = pkt.arg6;

		if (g.tracing) {
		    System.out.println(coName+
                               ": Write request received");
		}

		// Insert this packet at the head of the write wkq
		// for this channel.

		pkt.link = r.wrwkqv[chnno];
		r.wrwkqv[chnno] = pkt;

		if (g.tracing) {
		    System.out.println(coName+
                               ": write request inserted at head of its wkq");
		}

		if (!r.wrbusyv[chnno]) {
		    // Wake up the channel write coroutine
		    // if it is not busy.
		    callco(r.mpxwrcov[chnno], null);
		}

		// Process another read, write or die request
		continue;
	    }

	    case act_die:
		System.out.println(coName+": die pkt received");
		diepkt = pkt;
		break;     // Cause this thread to die
	    }

	    // Reach here if a die packet was received
	    break; // Break out of the while(true) loop
	}

	// Cause this multiplexor to die by returning control
	// to gomultievent with multi_done set to true.

	r.multi_done = true;
	return null;
    }
}

//**********************************************************************
//*************************** Mpxrdco *********************************
//**********************************************************************

class Mpxrdco extends Cortn {
    ///coroutine
    // This models a multiplexor read channel coroutine.

    Channelbuf buf;
    Multiplexor r;

    char flag;
    int clino;
    int serno;
    int mpxno;
    int chnno;
    int data;

    Pkt pkt;

    public Mpxrdco(String name, Multiplexor r) {
	// This constructor creates a non-root read channel coroutine
	// belonging to a multiplexor task.
	super(name, r);
	this.r = r;          // Multiplexor t owns this coroutine and
                             // provides access to variables
                             // such as mpxrcv and bufv.

	//System.out.println(coName+": Multiplexor "+r.coName+" owns this coroutine");
    }

    public Object fn(Object x) {
	// This is the main function of a channel read coroutine

	mpxno = r.mpxno;
	chnno = ((Integer)x).intValue();
	buf = r.bufv[chnno];
	//System.out.println(coName+": Channel read coroutine ready for channel "+chnno);

	r.rdbusyv[chnno] = true; // ONLY = false when waiting to be woken up.

	while (true) {
	    // Start of the main loop for a read coroutine for this channel.

	    // Get the next read packet, waiting if necessary.

	    if (r.rdwkqv[chnno]==null) {
		// There are no packets in the queue for this channel
		// so wait for one
		r.rdbusyv[chnno] = false;
		r.mpxbusycount--;

		if (g.tracing) {
		    System.out.println(coName+": Ready");
		}

		pkt = (Pkt)cowait(null);
		r.rdbusyv[chnno] = true;
		r.mpxbusycount++;
	    } else {
		if (g.tracing) {
		    System.out.println(coName+
				       ": Dequeuing a pkt from "+r.rdwkqv[chnno]);
		};

		// Dequeue the next read packet
		pkt = r.rdwkqv[chnno];
		r.rdwkqv[chnno] = pkt.link;
		pkt.link = null;
	    }

	    // Extract the parameters
	    flag  = (char) pkt.arg1;
	    clino = pkt.arg2;
	    serno = pkt.arg3;
	    data  = pkt.arg6;

	    if (buf.isempty()) {
		// The channel buffer is empty, so return the packet
		// to the read server with an indication of failure.
		if (g.tracing) {
		    System.out.println(coName+
				       ": Returning failed read request to its server");
		}
		pkt.res1 = 0;  // Indicate failure.
		t.qpkt(pkt);
		continue;
	    }

	    data = buf.get();
	    if (g.tracing) {
		System.out.println(coName+
				   ": data "+strz(data,4)+
				   " extracted from the channel buffer");
	    }

	    // Conditionally perform a multiplexor delay.
	    if (flag=='m') {
		if (g.tracing) {
		    System.out.println(coName+
				       ": Channel delay*n");
		};

		delayco(g.delaymsecs);

		if (g.tracing) {
		    System.out.println(coName+
				       ": Channel delay done*n");
		}
	    }

	    // Return the successful read request packet to its server. 
	    if (g.tracing) {
		System.out.println(coName+
				   ": returning successful read packet to its server");
	    }
	    t.qpkt(pkt); // Return the successful read packet to its server.

	    // Process the next read packet, if any.
	}
    }
}

//**********************************************************************
//*************************** Mpxwrco *********************************
//**********************************************************************

class Mpxwrco extends Cortn {
    ///coroutine
    // This is the main coroutine of a read server

    Multiplexor r;
    Channelbuf buf; // 

    char flag;
    int clino;
    int serno;
    int mpxno;
    int chnno;
    int data;

    Pkt pkt;

    public Mpxwrco(String name, Multiplexor r) {
	// This constructor creates a non-root write channel coroutine
	// belonging to a multiplexor task.
	super(name, r);
	this.r = r;
    }

    public Object fn(Object x) {
	// This is the main function of a channel write coroutine

	mpxno = r.mpxno;
	chnno = ((Integer)x).intValue();
	buf = r.bufv[chnno];
	//System.out.println(coName+": Channel write coroutine ready for channel "+chnno);

	r.wrbusyv[chnno] = true; // ONLY = false when waiting to be woken up.

	while (true) {
	    // Start of the main loop for a write coroutine for this channel.

	    // Get the next write packet, waiting if necessary.

	    if (r.wrwkqv[chnno]==null) {
		// There are no packets in the queue for this channel
		// so wait for one
		r.wrbusyv[chnno] = false;
		r.mpxbusycount--;

		if (g.tracing) {
		    System.out.println(coName+": Ready");
		}

		pkt = (Pkt) cowait(null);
		r.wrbusyv[chnno] = true;
		r.mpxbusycount++;
	    } else {

		// Dequeue the next write packet
		pkt = r.wrwkqv[chnno];
		r.wrwkqv[chnno] = pkt.link;
		pkt.link = null;
	    }

	    // Extract the parameters
	    flag  = (char) pkt.arg1;
	    clino = pkt.arg2;
	    serno = pkt.arg3;
	    data  = pkt.arg6;

	    if (buf.isfull()) {
		// The channel buffer is full, so return the packet
		// to the write server with an indication of failure.
		if (g.tracing) {
		    System.out.println(coName+
				       ": Returning failed write request to its server");
		}
		pkt.res1 = 0;  // Indicate failure.
		t.qpkt(pkt);
		continue;
	    }

	    buf.put(data);
	    if (g.tracing) {
		System.out.println(coName+
				   ": data "+strz(data,4)+
				   " put into the channel buffer");
	    }

	    // Conditionally perform a multiplexor delay.
	    if (flag=='m') {
		if (g.tracing) {
		    System.out.println(coName+
				       ": Channel delay*n");
		};

		delayco(g.delaymsecs);

		if (g.tracing) {
		    System.out.println(coName+
				       ": Channel delay done*n");
		}
	    }

	    // Return the successful read request packet to its server. 
	    if (g.tracing) {
		System.out.println(coName+
				   ": returning successful write packet to its server");
	    }

	    t.qpkt(pkt); // Return the successful read packet to its server.

	    // Process the next read packet, if any.
	}
    }
}

//**********************************************************************
//*************************** Channelbuf *******************************
//**********************************************************************

class Channelbuf {
    // This class is used to represent channel buffers.
    // It methods are: isempty, isfull, get and put.
    // These metods are synchonized since different threads may try
    // to access the buffer at the same time.

    int chnbufsize;
    int buf[];
    int p;
    int q;

     public Channelbuf(int size) {
	 // This will construct a channel buffer of given size.
	 this.chnbufsize = size;
	 this.buf = new int[chnbufsize];
	 p=0; // Initially empty.
	 q=0;
    }

    public synchronized boolean isempty() {
	return p==q;
    }

    public synchronized boolean isfull() {
	return (p+1)%chnbufsize == q;
    }

    public synchronized int get() {
	int data = buf[p];
        p = (p+1) % chnbufsize;
	return data;
    }

    public synchronized void put(int data) {
        q = (q+1) % chnbufsize;
	buf[q] = data;
    }

}


//**********************************************************************
//*************************** Rnd **************************************
//**********************************************************************

class Rnd {
     private int seed;

     public Rnd(int a) {
	 seed = a & 0xFFFFFFF | 1; // Ensure seed is not zero
         int k = next(50) + 10;
         for(int i = 1; i<=k; i++) next(1000);
    }

  //public final static int feedback = 0xD008;     // 16 15 13 4  => period 2^16-1
    public final static int feedback = 0x80200003; // 32 22  2 1  => period 2^32-1

    // 1000 0000 0010 0000 0000 0000 0000 0011
    // |           |                        ||
    // |           |                        |1
    // 32          22                       2

    public int next(int max) {
	if ((seed&1)==0) {
	    seed = seed>>>1;
        } else {
            seed = (seed>>>1) ^ feedback;
        }
        return (seed>>>1) % max + 1;
    }
}
