
//############# STILL UNDER DEVELOPMENT ################################
//################ BUT GETTING THERE ###################################

// This is a Java translation of the BCPL version of the
// Thread-Coroutine Benchmark.  See the file ../README

// Implemented by Martin Richards (c) August 2005

//**********************************************************************
//*************************** Tcobench *********************************
//**********************************************************************

public class Tcobench
{
    public static void main(String[] args)
    {
	// Global variables accessible to all tasks and coroutines
	// in the benchmark.
	Globals g = new Globals();

	System.out.println("\nThread and Coroutine Benchmark\n");

	g.rdargs(args);
	g.initstats();

	System.out.print("loopmax        = "); Task.wrn(g.loopmax,3);
	System.out.println(" (k)");
	System.out.print("climax, sermax = "); Task.wrn(g.climax,3);
	System.out.println(" (n)");
	System.out.print("workmax        = "); Task.wrn(g.workmax,3);
	System.out.println(" (w)");
	System.out.print("mpxmax         = "); Task.wrn(g.mpxmax,3);
	System.out.println(" (m)");
	System.out.print("chnmax         = "); Task.wrn(g.chnmax,3);
	System.out.println(" (c)");
	System.out.print("delaymsecs     = "); Task.wrn(g.delaymsecs,3);
	System.out.println(" (d)\n");

        System.out.println("Requests per schedule = "+g.requestvupb);
	System.out.println("Channel buffer size   = "+g.chnbufsize);
	System.out.println("");


	// Possibly test the random number generator.
	// It must produce the same sequence on every system.
        if(g.testno==1)
        {   System.out.println("Testing the random number generator, seed=("+
			       +g.loopmax+", "+g.climax+")\n");
            Rnd r = new Rnd(g.loopmax, g.climax);

	    for (int k=1; k<=200; k++) // Test the random number generator
		{ int val = r.next(9999);
		System.out.print(" ");
		Task.wrz(val, 4);
		if (k % 10 == 0) System.out.println("");
		}
	    System.exit(200);
        }

	// Create the root task
	g.root = new Root("Root", g, Thread.MAX_PRIORITY);
	//if (g.tracing) System.out.println("Root: Task created");

	// Send a startup packet to the root task. It will not be returned.
	// It is unusally sent from one thread to another, both of which
	// think they are the root task.

	g.root.putpkt(new Pkt(null, g.root, 0, 0, 0));

	//System.out.println(g.root.coName+": Wait for the root thread to die");
	try { g.root.join(); }        // Wait for the thread to die
	catch(Exception e) {}
	System.out.println(g.root.coName+": This root coroutine has finished");
    }
}

//**********************************************************************
//**************************** Root ************************************
//**********************************************************************


class Root extends Task {

    public Root(String name, Globals g, int pri) {
	super(name, g, pri);
	startTask();
    }

    public Object fn(Object arg) {
	//if (g.tracing) System.out.println(taskName +": entered fn");

	// Comment out the next line to test the coroutine functions.
	if (g.testno==2)
	{
	    System.out.println("Running the coroutine test");
	    Cotest cotest = new Cotest("Cotest", g, Thread.MAX_PRIORITY);
	    sendpkt(new Pkt(null, cotest, 0, 0, 0, 123));
	    System.exit(201);
	}

	createtasks();

	//realdelay(1234);

	//if (g.tracing)
        //      System.out.println(taskName +
	//			 ": sending startup packet to the controller");
        sendpkt(new Pkt(null, g.controller, 0, 0, 0, 123));
	if (g.tracing)
	          System.out.println(taskName +
				 ": controller returned its startup packet");
	return null;
    }

    public boolean createtasks() {
	int maxpri = Thread.MAX_PRIORITY;
	int minpri = Thread.MIN_PRIORITY;

	// Allocate task vectors
        g.rdclientv    = new Task[g.climax+1];
        g.wrclientv    = new Task[g.climax+1];
        g.rdserverv    = new Task[g.sermax+1];
        g.wrserverv    = new Task[g.sermax+1];
        g.mpxv         = new Task[g.mpxmax+1];

	g.bounce = new Bounce("Bounce", g, minpri+1);
	if (g.tracing)
	    System.out.println("Bounce: Task created");

	g.printer = new Printer("Printer", g, minpri+2);
	if (g.tracing)
	    System.out.println("Printer: Task created");


	for (int clino=1; clino<=g.climax; clino++) {
	    Task task =new Client('R', clino, g, minpri+3);
	    g.rdclientv[clino] = task;
	    if (g.tracing)
		System.out.println(task.taskName+": Task created");
	}

	for (int serno=1; serno<=g.sermax; serno++) {
	    Task task = new Server('R', serno, g, minpri+4);
            g.rdserverv[serno] = task;
	    if (g.tracing)
		System.out.println(task.taskName+": Task created");
	}

	for (int clino=1; clino<=g.climax; clino++) {
	    Task task =new Client('W', clino, g, minpri+5);
	    g.wrclientv[clino] = task;
	    if (g.tracing)
		System.out.println(task.taskName+": Task created");
	}

	for (int serno=1; serno<=g.sermax; serno++) {
	    Task task =new Server('W', serno, g, minpri+6);
            g.wrserverv[serno] = task;
	    if (g.tracing)
		System.out.println(task.taskName+": Task created");
	}

	for (int mpxno=1; mpxno<=g.mpxmax; mpxno++) {
	    Task task = new Mpx(mpxno, g, minpri+7);
            g.mpxv[mpxno] = task;
	    if (g.tracing)
		System.out.println(task.taskName+":  Task created");
	}

        g.controller = new Controller("Controller", g, maxpri);
	if (g.tracing)
	    System.out.println("Controller: Task created");

	if (g.tracing)
	    System.out.println("");

	return true;
    }
}

//**********************************************************************
//************************** Manifests *********************************
//**********************************************************************

interface Manifests {
    // Packet types

    public final static int act_startcontroller = 100;
    public final static int act_startrdclient   = 101;
    public final static int act_startwrclient   = 102;
    public final static int act_startrdserver   = 103;
    public final static int act_startwrserver   = 104;
    public final static int act_startmpx        = 105;
    public final static int act_startbounce     = 106;
    public final static int act_startprinter    = 107;
    public final static int act_bounce          = 108;
    public final static int act_print           = 109;
    public final static int act_clock           = 110;
    public final static int act_read            = 111;
    public final static int act_readdelay       = 112;
    public final static int act_write           = 113;
    public final static int act_writedelay      = 114;
    public final static int act_sync            = 115;
    public final static int act_rddone          = 116;
    public final static int act_wrdone          = 117;
    public final static int act_die             = 118;
    public final static int act_releaserdclient = 119;
    public final static int act_releasewrclient = 120;

}

//**********************************************************************
//*************************** Globals **********************************
//**********************************************************************

class Globals {
    // Global variables and constants accessible to every coroutine of
    // every task.

    // There is one instance of this class and every task can refer to it
    // using g. So the global (shared) variables are normally accessed by
    // g.<name>        eg g.loopmax

    // Global variables that change dynamically must be updated using
    // synchronised methods.

    public int     loopmax;
    public int     climax;
    public int     sermax;
    public int     workmax;
    public int     mpxmax;
    public int     chnmax;
    public int     delaymsecs;
    public int     delayticks;
    public int     testno;
    public boolean tracing;

    // Statistics counters
    public int writecount;
    public int readcount;
    public int taskwaitcount;
    public int changecocount;
    public int waitcount;
    public int notifycount;
    public int inccount;
    public int incwaitcount;
    public int lockcount;
    public int lockwcount;
    public int delaycount;
    public int bouncecount;
    public int printcount;
    public int utilisationv[];

    public int requestvupb;
    public int chnbufsize;

    // Global tasks
    public Task root;
    public Task controller;
    public Task clock;
    public Task bounce;
    public Task printer;

    public Task rdclientv[];
    public Task wrclientv[];
    public Task rdserverv[];
    public Task wrserverv[];
    public Task      mpxv[];

    public void rdargs(String[] args) {
	try {
	    // Default settings
	    loopmax    = 10;
	    climax     = 10;
	    workmax    = 15;
	    mpxmax     = 9;
	    chnmax     = 10;
	    delaymsecs = 500;
	    testno     = 0;
	    tracing    = false;

	    for (int i = 0; i < args.length; i++) {
	        //System.out.println("arg["+i+"] = " + args[i]);
		if (args[i].equals("-k")) {
		    loopmax = Integer.parseInt(args[++i]);
		    continue;
		}
		
		if (args[i].equals("-n")) {
		    climax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-w")) {
		    workmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-m")) {
		    mpxmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-c")) {
		    chnmax = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-d")) {
		    delaymsecs = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-x")) {
		    testno = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-t")) {
		    tracing = true;
                    // Default parameters when tracing is specified.
                    loopmax    =   1;
                    climax     =   2;
                    workmax    =   2;
                    mpxmax     =   2;
                    chnmax     =   2;
                    delaymsecs = 500;
		    continue;
		}
	    }
	} 
	catch (NumberFormatException e) {
	    System.err.println("Integer argument expected");
	}

	//delaymsecs = 0; /////////////////////////////////////////////

	delayticks = Clock.tickspersecond * delaymsecs/1000;

        sermax = climax; // sermax and climax are always equal.

	requestvupb = sermax*mpxmax*chnmax;
	chnbufsize = climax*sermax + 1; // Up to climax*sermax values per buf
    }

    public synchronized void initstats() {
	utilisationv = new int[10];
        for(int i=0; i<=9; i++) utilisationv[i] = 0;
        writecount = 0;
        readcount = 0;
        taskwaitcount = 0;
        changecocount = 0;
        waitcount = 0;
        notifycount = 0;
        inccount = 0;
        incwaitcount = 0;
        lockcount = 0;
        lockwcount = 0;
        delaycount = 0;
        bouncecount = 0;
        printcount = 0;
    }

    public synchronized void incwrite()    { writecount++; }
    public synchronized void incread()     { readcount++; }
    public synchronized void inctaskwait() { taskwaitcount++; }
    public synchronized void incchangeco() { changecocount++; }
    public synchronized void incwait()     { waitcount++; }
    public synchronized void incnotify()   { notifycount++; }
    public synchronized void incinc()      { inccount++; }
    public synchronized void incincwait()  { incwaitcount++; }
    public synchronized void inclock()     { lockcount++; }
    public synchronized void inclockw()    { lockwcount++; }
    public synchronized void incdelay()    { delaycount++; }
    public synchronized void incbounce()   { bouncecount++; }
    public synchronized void incprint()    { printcount++; }

    public synchronized void printstats() {
	System.out.println("\n");
	
	
	System.out.println("words of data sent:               "+writecount);
	System.out.println("words of data received:           "+readcount);
	System.out.println("number of task changes:           "+taskwaitcount);
	System.out.println("number of coroutine changes:      "+changecocount);
	System.out.println("number of calls of wait(..):      "+waitcount);
	System.out.println("number of calls of notify(..):    "+notifycount);
	System.out.println("number of calls of increment(..): "+inccount);
	System.out.println("   increment had to wait:         "+incwaitcount);
	System.out.println("number of calls of lock(..):      "+lockcount);
	System.out.println("   lock had to wait:              "+lockwcount);
	System.out.print  ("number of "); Task.wrn(delaymsecs, 4);
        System.out.println(              " msec delays:       "+delaycount);
	System.out.println("print task counter:               "+printcount);
	System.out.println("bounce task counter:              "+bouncecount);
	System.out.println("");

	int total = 0;
	for(int i = 0; i<=9; i++) total += utilisationv[i];
	if (total==0) total++;

        System.out.println(
          "     Approximate CPU utilisation over "+total+" periods of 100 msecs"
        );
        System.out.println("   0-10% 10-20% 20-30% 30-40% 40-50% 50-60%"+
                           " 60-70% 70-80% 80-90% >90%");
	for(int i = 0; i<=9; i++) {
	    Task.wrn(utilisationv[i], 5);
            System.out.print("  ");
	}
    }
}

//**********************************************************************
//*************************** Pktlist **********************************
//**********************************************************************

class Pktlist {
    // This hold nodes in a list that maps packets to coroutines
    // used in gomultievent.
    public Pktlist link;
    public Pkt pkt;
    public Cortn co;

    public Pktlist(Pktlist link, Pkt pkt, Cortn co) {
	this.link = link;
	this.pkt = pkt;
	this.co = co;
    }
}

//**********************************************************************
//*************************** Colist **********************************
//**********************************************************************

class Colist {
    // This holds nodes in a list that maps packets to coroutines
    // used in gomultievent.
    public Colist link;
    public Cortn co;

    public Colist(Colist link, Cortn co) {
	this.link = link;
	this.co = co;
    }
}

//**********************************************************************
//***************************** Pkt ************************************
//**********************************************************************

class Pkt {
    // Used in Cintpos-style intertask communication
    public Pkt  link;
    public Task task;
    public int  type;
    public int  res1;
    public int  res2;
    public int  arg1;
    public int  arg2;
    public int  arg3;
    public int  arg4;
    public int  arg5;
    public int  arg6;

    public Pkt(Pkt link, Task task, int type, int res1, int res2) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3, int arg4) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
	this.arg4 = arg4;
    }

    public Pkt(Pkt link, Task task, int type, int res1, int res2,
               int arg1, int arg2, int arg3, int arg4, int arg5) {
	this.link = link;
	this.task = task;
	this.type = type;
	this.res1 = res1;
	this.res2 = res2;
	this.arg1 = arg1;
	this.arg2 = arg2;
	this.arg3 = arg3;
	this.arg4 = arg4;
	this.arg5 = arg5;
    }
}

//**********************************************************************
//*************************** Task *********************************
//**********************************************************************

abstract class Task extends Cortn {
    // This provides the variables and methods for tasks and coroutines.

    // Root coroutines extend this class, but non root coroutines
    // just extend Cortn. The t field of Cortn is set to point to the
    // root coroutine of a task to allow access to the task's variables.

    public String taskName;      // The name of the task
    public int pri;              // The priority of the coroutines of
                                 // this task.

    public Pkt wkq;              // The task's work queue
    public boolean taskwaiting;  // True if suspended in taskwait.
    public int result2;          // The second result of some functions, eg
                                 // sendpkt and snpkt

    public Cortn currco;         // The current coroutine

    // Variables for gomultievent
    public Pktlist pktlist;      // The list mapping packets to coroutines
    public boolean multi_done;   // Variables for gomultievent
    public boolean mainco_ready; // True when mainco is ready to receive a
                                 // packet from gomultievent. If false the
                                 // packet is queued.

    public Task(String taskName, Globals g, int pri) {
	super(taskName+"Root", g, pri); // Create and name the root coroutine
	this.taskName = taskName;       // Name the task
    }

    public synchronized void startTask() {
	// Initialise and start the root coroutine of the task
	wkq = null;
	val = null;
	parent = null; // The root coroutine has no parent.
	wakeup = false;
	currco = this;

	taskwaiting = false;
	start();
	taskwaitingWait(); // Wait until the root coroutine enters taskwait
	                   // ie wait for taskwaiting to be set to true

	// The task is now suspended in the taskwait of
	// fn(taskwait()), ie it is waiting for the startup
	// packet.
    }

    public synchronized void taskwaitingWait() {
	// This method is only called from task contructors to
	// ensure that the call of taskwait() in fn(taskwait()) has
	// been entered. It is used by all task constructors so that
	// if Abc is the class for as task, new Abc(..) will not return
	// until the newly created task is suspended in taskwait().

	//lk(this);
	//System.out.println(taskName+": wait for task to call taskwait()");
	int i = 0;
	try {
	    while (!taskwaiting) {
		//System.out.println(coName+
		//           ": taskwaitingWait: calling wait(), i="+(++i));
		//int depth=wul(this);
		wait();
		//wlk(this,depth);
	    }
	    //System.out.println(taskName+
	    //          ": taskwaitingWait taskwaiting is now true, i="+i);
	}
	catch(Exception e) {
	    System.out.println(coName+
			       ": taskwaitingWait: exception e="+e.toString());
	}
	//System.out.println(taskName+": Task ready");
	//ul(this);
    }

    //public synchronized void setcurrco(Cortn co) {
    public void setcurrco(Cortn co) {
	//lk(this);
	//String fname = (currco==null) ? "<null>" : currco.coName;
	//System.out.println(taskName+
	//	             ": setcurrco: changing currco from "+fname+
	//		   " to "+co.coName);
	currco = co;
	//ul(this);
    }

    //public synchronized Cortn getcurrco() {
    public Cortn getcurrco() {
	//lk(this);
	//System.out.println(taskName+
	//                   ": getcurrco: found currco="+currco.coName);
	//ul(this);
	return currco;
    }

    public void setmainco_ready(boolean b) {
	//lk(this);
	//System.out.println(taskName+": ####### setmainco_ready set to "+b);
	//System.out.println(coName+": ####### setmainco_ready set to "+b);
	mainco_ready = b;
	//ul(this);
    }

    //public synchronized boolean getmainco_ready() {
    public boolean getmainco_ready() {
	//lk(this);
	//System.out.println(taskName+": ####### getmainco_ready => "+
	//System.out.println(coName+": ####### getmainco_ready => "+
        //    mainco_ready);
	//ul(this);
	return mainco_ready;
    }

    public synchronized boolean putpkt(Pkt pkt) {
	// This is called in the destination task, pkt.id is already
	// set to the sending task.

	// Append the packet onto the end of this task's wkq, releasing
	// taskwait, if neccessary.
	// It needs to be synchronised since other threads may be doing
	// this at the same time, and since it may call notifyAll.

	//lk(this);

	pkt.link = null; // The pkt will certainly go at the end of wkq.

	if (wkq==null) {
	    wkq = pkt;
	    //System.out.println(taskName+": empty wkq given a pkt");
	    notifyAll();
	} else {
	    // There is at least one packet in wkq.
	    Pkt p = wkq;
	    while(p.link!=null) p = p.link;
	    // p is the last pkt in wkq
	    p.link = pkt;
	    //System.out.println(taskName+": pkt appended to non-empty wkq");
	}
	//prwkq();
	//ul(this);
	//notifyAll();//????????????????
	return true;
    }

    public synchronized Pkt getpkt() {
	//lk(this);
	// Get first packet from wkq, wait if wkq is empty.
	//System.out.println(t.taskName+": getpkt incrementing taskwaitcount");
        g.inctaskwait();

	// Wake up any thread waiting for taskwaiting==true
	//System.out.println(t.taskName+": getpkt setting taskwaiting=true");
	taskwaiting = true;
	notifyAll(); // Wakeup any thread waiting for taskwaiting to be true

	int i=0;
	//System.out.println(taskName+": getpkt entered");
	try {
	    // Wait for a packet to arrive
	    while (wkq==null) {
		//System.out.println(taskName+
		//                   ": getpkt waiting for a packet\n");
		//System.out.println(taskName+
		//               ": getpkt calling wait(), i="+(++i));
		//int depth=wul(this);
		wait();
		//wlk(this,depth);
		//System.out.println(taskName+": getpkt returned from wait()");
	    }
	}
	catch(Exception e) {}
	taskwaiting = false;

	//prwkq();
	Pkt res = wkq; // De-queue the first packet
	wkq = wkq.link;
	res.link = null;

	//String pname = res.task==null ? "<null>" : res.task.taskName;
	//System.out.println(taskName+": getpkt got pkt from "+pname+", i="+i);
	//prwkq();
	//ul(this);
	//System.out.println(taskName+": getpkt => pkt from "+pname);

        return res;
    }

    public synchronized void prwkq() {
	if (wkq==null) {
	    System.out.print(taskName+": wkq is empty");
	} else {
	    Pkt p = wkq;
	    System.out.print(taskName+": wkq pkts from:  ");
	    while (p!=null) {
		String pname = p.task==null ? "<null>" : p.task.taskName;
		System.out.print(" "+pname);
		p = p.link;
	    }
	}
	System.out.println("");
    }
}

//**********************************************************************
//**************************** Cortn ***********************************
//**********************************************************************

abstract class Cortn extends Thread implements Manifests {
/*

This is the class that represents both root and non-root coroutines of
a task. Each coroutine has its own Java thread and all but one must be
suspended (or just about to be) in wait().  The only coroutine permitted
to run is held in currco of the task (which is also the root
coroutine). Every coroutine has a field t that holds a reference to
the coroutine's task. Thus every coroutine can use t.currco to find or
change the current coroutine. Every coroutine also has a field g that
provides access to global variables available to every coroutine of
every task.

A coroutine may hand over control to another coroutine within the task
by the call: callco(co, arg) where co is the target coroutine and arg
is a value to be passed to it. The target's thread should be suspended
in a call of wait() on its own object (co in this case). It can be
released by the call: co.notifyAll() executed in the caller's
thread. The caller should then suspend itself in wait() on its own
object. It is important that the target thread does not resume
execution until after the calling thread is suspended in wait(). This
can be achieved by careful use of locks, as follows.

The target must have called wait() when it owned the lock on its own
object. The caller can only release this waiting thread by calling
notifyAll() when owning the lock on the target object.

Let A and B be objects representing coroutines and Th_A and Th_B be
their associated threads. Let R and ===L(A)=== represent the moments a
thread request a lock and subsequently obtains it. U(A) and U(B)
represent the the moments when locks are released, possibly letting
another thread obtain a lock.  The notations W and ===W(A)===
represents the moments when a thread suspends itself in a wait() call
and its susequent release by another thread calling notifyAll() on
A. Hash signs (#) represent a coroutine running. Dots (.) represent a
coroutine thread waiting either for a lock or to be resumed by
notifyAll. Colons and vertical bars (:, |) represent execution within
the coroutine library routines.  An example of how control can pass
from coroutine A to B in task T and back again using callco in A and
cowait in B is shown diagramatically as follows.

############## The following is all wrong ##############################


          Th_A                             Th_B

            #                                .           ) Coroutine B is
            #                                .           ) suspended in cowait()
            #                                .           ) currently executing
            #                                .           ) wait() waiting for
            #                                .           ) notification that
            #                                .           ) wakeup is true
            #                                .
      [callco(B,x)]                          .           ) Coroutine A now
            |                                .           ) wishes to transfer
     [T.setcurrco(B)]                        .           ) control to B
            R                                .           ) giving it the
            .    ----unlock T---             .           ) value x.
            .   |                            .     
        ===L(T)===                           .           Gain lock on T
        T.currco=B                           .           Set currco
            |                                .
          U(T)-------unlock T-->             .           Unlock T
            |                                .
      [B.unwait(x,A)]                        .           ) Release B giving it
            |                                .           ) a value and parent
            |                                .     
            R                                .     
            .    ----unlock B---             .     
            .   |                            .     
        ===L(B)===                           .           Gain lock on B
            |                                .     
          B.val=x                            .           ) Set B's val,
        B.parent=A                           .           ) parent and wakeup
        B.wakeup=true                        .           ) fields.
            |                                .
     [B.notifyAll()]                         .     
           N(B)----------notify B---------   .
            |                             |  .     
            |                            ===W(B)===      ) B wakes up.
            |                                |
            |                                R           ) Request to regain
            |                                .           ) lock on B
            |                                .
           U(B) ----unlock B--------------   .           ) A releases lock 
            |                             |  .           ) on B
            |                             |  .
      [ret unwait]                       ===L(B)===      ) B gains lock on B








            |                                |
            |                    ---------   R           ) B tests whether
            |                             |  .           )
            |                            ===L(T)===      ) it is the current
            |                                |           )
            |                            co=T.currco     ) coroutine.
            |                                |           )
   [val=waitForWakeup()]         <----------U(T)         )
            |                                |           )
            |                       unless co=B jump-->  )
            |                                |
            |                          [T.currco is B]
            |                                |
            |              <---unlock B-----U(B)
            |                                |
            |                         [result in B.val]  ) Return from
            R                           leave cowait     ) cowait with
            .                                #           ) result x.
            .    --------?                   #
            .   |                       [B running]
        ===L(T)===                           #           ) Coroutine A tests
            |                                #           ) whether it is the
        co=T.currco                          #           ) current coroutine
            |                                #           ) and suspends itself
           U(T)------unlock T->              #           ) if necessary
            |                                #
       if co=A jump -->                      #
            |                                #
          wait()                             #
            |                                #
           U(A)                              #
            W                                #
            .                             cowait(y)      ) Coroutine B wishes
            .                                |           ) to return control
            .                                |           ) to A with value y
            .                                R
            .                    ---------   .
            .                             |  .
            .                            ===L(B)===
            .                                |
            .                                R
            .                    ---------   .
            .                             |  .
            .                            ===L(A)===
            .                                |           ) B set A's
            .                             A.val=y        ) val field.
            .                                |
            .                                R
            .                    ---------   .
            .                             |  .
            .                            ===L(T)===
            .                                |           ) Make A the
            .                            T.currco=A      ) current coroutine
            .                                |
            .               <---unlock T----U(T)
            .                                |
            .    -------notify A------------N(A)         ) B wakes up A
            .   |                            |
        ===W(A)===                           |
            |                                |
            R                                |
            .    ------------unlock A-------U(A)
            .   |                            |
        ===L(A)===                           |
            |                                |
      leave wait()                           |
            |                                |
            R                                R
            .    -------                     .
            .   |                            .
        ===L(T)===                           .          ) A checks that it
            |                                .          ) is the current
        co=T.currco                          .          ) coroutine and
            |                                .          ) waits again if
           U(T)----unlock T-->               .          ) necessary.
            |                                .
   unless co=A jump back                     .
            |                      -------   .
           U(A)------->                   |  .
            |                            ===L(T)===
    return from callco                       |          ) A is now running
            #                            co=T.currco
            #                                |
            #             <--unlock T-------U(T)
            #                                |
            #                          if co=B jump --> ) B suspends itself 
            #                                |          ) after checking that
            #                                W          ) it is not the current
            #                                .          ) coroutine.
            #                                .


Whenever a coroutine is running but not in the coroutine library (the
hashes (#) in the above diagram), t.currco holds a reference to its
object.

Whenever a thread is waiting to be notified (eg in ===W(B)===), there
may be other thread in the objects wait set and hence other calls of
notifyAll on the object. It is thus necessary to check when a wait is
notified that the thread must check that t.currco refers to its
object. If not, it was notified spuriously and must execute wait again.

*/

    public String coName;
    public Globals g;
    public Task t;

    public Cortn parent;      // Either null or the parent coroutine
    public Object val;        // The val passed to this coroutine
                              // when it last regained control
    public boolean wakeup;    // Set true when this coroutine should wake up

    public boolean notdead;   // Set false to delete this coroutine
 
    public int lockdepth=0;   // A debugging aid used by lk, ul, wlk and wuk
    public boolean cowaiting; // Set true when the coroutine is suspended

    public Cortn(String coName, Globals g, int pri) {
	// Initialise and but don't start the root coroutine to
	// of a task. The task fields will be initialised by the
	// task constructor.
        super("T_"+coName);   // Name the thread
	this.coName = coName;
	this.g = g;
	t = (Task)this;       // This is the root coroutine of a task
	t.pri = pri;
	setPriority(pri);

	// The thread will be started by the sub-class after it has
	// initialised its extra variables, if any. When started it
	// will suspend itself in taskwait of fn(taskwait()), ie
	// until it is given the startup packet.
    }

    public Cortn(String coName, Cortn parent) {
	// Create but don't start a non-root coroutine.
        // parent is the creating coroutine and will be
	// the parent when the c=fn(cowait(c)) loop is entered.

        super("T_"+coName);    // Name the thread
	this.coName = coName;  // name this coroutine
	this.parent = parent;  // set the parent field

	// Copy the parent's g and t fields
	g = parent.g;
	t = parent.t;
	setPriority(t.pri);  // Set the thread's priority to that of
	                     // the task.

	// The thread will be started by the sub-class after it has
	// initialised its extra variables, if any. It will immediately
	// enter the c=fn(cowait(c)) loop, and so will suspend itself
	// in cowait(..).
    }

    public synchronized void startCoroutine(Cortn parent) {
	val = null;
	this.parent = parent;
	wakeup = false;
	t.setcurrco(this);
        cowaiting = false;

	start();
	// Wait the new coroutine to suspend itself in
	// the c=f(cowait(c)) loop

	// ie wait for waitForWakeup!=0

	cowaitingWait(); // Wait until the new coroutine enters cowait
	                 // ie in wait() waiting for cowaiting to become true

	parent.wakeup=false; // Since cowait set it to true.

	//System.out.println(coName+
	//		   ": is now suspended in c=fn(cowait(c)) loop\n");
    }

    public synchronized void cowaitingWait() {
	// This method is only called from coroutine contructors to
	// ensure that the call of cowait() in the  c=f(cowait(c)) loop has
	// been entered. It is used by all coroutine constructors so that
	// if Abc is the class for a coroutine, new Abc(..) will not return
	// until the newly created task is suspended in cowait(..).

	//lk(this);
	int i = 0;
	try {
	    while (!cowaiting) {
		//System.out.println(coName+
		//           ": cowaitingWait: calling wait(), i="+(++i));
		//int depth=wul(this);
		wait();
		//wlk(this,depth);
	    }
	    //System.out.println(coName+
	    //          ": cowaitingWait cowaiting is now true, i="+i);
	}
	catch(Exception e) {
	    System.out.println(coName+
			       ": cowaitingWait: exception e="+e.toString());
	}
	//System.out.println(coName+": Coroutine ready");
	//ul(this);
    }



    // lk ul, wlk and wul are for debugging #####################
    public synchronized void lk1(Cortn co) {
	//System.out.println(co.getName()+": "+co.coName+
	//		   " lock "+(++lockdepth));
    }

    public synchronized void ul1(Cortn co) {
	//System.out.println(co.getName()+": "+co.coName+
	//		   " unlock "+(--lockdepth));
    }

    public synchronized void wlk1(Cortn co, int depth) {
	//System.out.println(co.getName()+": "+co.coName+
	//		   " wait-lock "+(lockdepth=depth));
    }

    public synchronized int wul1(Cortn co) {
	int depth = lockdepth;
	//System.out.println(co.getName()+": "+co.coName+
	//		   " wait-unlock "+(lockdepth=0));
	return depth;
    }
    // lk ul, wlk and wul are for debugging #####################

    public void run() {

	//initrun();

	if (parent==null) {
	    // We are a root coroutine, so just call fn(..)
	    //System.out.println(coName+
            //   ": run() calling fn(taskwait())");
	    fn(taskwait());
	    //System.out.println(coName+": run() task dying");
	} else {
	    // We are a non-root coroutine,
	    // so just enter the normal loop
	    Object c = null;
	    //System.out.println(coName+
	    //                   ": run() starting c=fn(cowait(c)) loop");
            notdead = true;
	    while(notdead) c = fn(cowait(c));
	    //System.out.println(coName+": run() coroutine dying");
	}
    }

    // The (abstract) coroutine body
    public abstract Object fn(Object c);


    // Conventional coroutine API

    public Object callco(Cortn target, Object arg) {
	// Transfer control to the target coroutine.
	//System.out.println(coName+": callco calling t.setcurrco, target="+
	//		   target.coName);

	t.setcurrco(target);
	//System.out.println(coName+": callco calling target.unwait(-,-)");
	target.unwait(arg, this);

	// Wait until we are the current coroutine
	//System.out.println(coName+": callco calling waitForWakeup");
	val = waitForWakeup();

	//System.out.print(coName+": callco returning");
	//if(val!=null) {
	//    System.out.println(" value "+val.toString());
	//} else {
	//    System.out.println(" value null");
	//}
	return val;
    }

    public Object resumeco(Cortn target, Object arg) {
	if (target==this) {
	    // The special case of resumeco resuming itself.
	    //System.out.println(coName+": resumeco: resuming itself");
	    val= arg;
	    return arg;
	}
	Cortn p = parent;
	parent = null;

	//System.out.println(coName+": resumeco: calling t.setcurrco, target="+
	//		   target.coName);

	// Transfer control to the target coroutine.
	t.setcurrco(target);

	//System.out.println(coName+": resumeco: calling target.unwait(-,-)");
	target.unwait(arg, p);
	// Wait until we are the current coroutine
	//System.out.println(coName+
	//		   ": resumeco: calling waitForWakeup, wakeup="+wakeup);
	val = waitForWakeup();

	//System.out.print(coName+": resumeco: returning");
	//if(val!=null) {
	//    System.out.println(" value "+val.toString());
	//} else {
	//    System.out.println(" value null");
	//}
	return val;
    }

    public Object cowait(Object arg) {
	Cortn target = parent;
	parent = null;

	if (target == null) { // Safety check
	    System.out.println(coName+": ERROR: cowait but no parent");
	    System.exit(202);
	}

	//System.out.println(coName+": cowait calling t.setcurrco, target="+
	//		   target.coName);
	t.setcurrco(target);

	// Transfer control to the target coroutine.
	target.unwait(arg);

	// Wait until we are the current coroutine
	//System.out.println(coName+": cowait waiting to regain control");
	//System.out.println(coName+": cowait calling waitForWakeup()");

	val = waitForWakeup();

	//System.out.print(coName+": cowait returning");
	//if(val!=null) {
	//    System.out.println(" value "+val.toString());
	//} else {
	//    System.out.println(" value null");
	//}
	return val;
    }

    // Internal support functions

    public synchronized Object waitForWakeup() {
	//lk(this);
        cowaiting = true;
	notifyAll(); // Wakeup any thread waiting for cowaiting to be true

        //System.out.println(coName+": waitForWakeup: currco is "+
	//		   t.getcurrco().coName);

	while (!wakeup) {
	    try {
		//int depth=wul(this);
		wait();
		//wlk(this,depth);
	    }
	    catch(Exception e) {
		System.out.println(coName+
		            ": waitForWakeup: exception e="+e.toString());
	    }
	}
        // wakeup is true so val will have been set and we can return
        // from cowait.
	//System.out.println(coName+": waitForWakeup: setting wakeup=false");
	wakeup=false;
        cowaiting = false;
	t.setcurrco(this);
	//System.out.println(coName+": waitForWakeup: currco now is "+
	//		   t.getcurrco().coName+
	//		   ", i="+i);
	//ul(this);
        return val;
    }

    public synchronized void unwait(Object val) {
	//lk(this);
	// This is used by cowait to transfer control to the parent
	// coroutine without updating its parent field.
	this.val = val;
	//System.out.println(coName+
	//		   ": unwait(-): entered");
	//if(val!=null) {
	//  System.out.println(coName+": this.val set to "+this.val.toString());
	//} else {
	//    System.out.println(coName+": this.val set to null");
	//}
	//System.out.println(coName+": unwait(-): setting wakeup=true");
	wakeup=true;
	//System.out.println(coName+": unwait(-): calling notifyAll()");
	notifyAll();    // Release this objects thread
	//ul(this);
    }

    public synchronized void unwait(Object val, Cortn parent) {
	//lk(this);
	// This is used by callco and resumeco to transfer control
	// to a waiting coroutine, setting its val and parent fields,
	// and updating t.currco.
	this.val = val;
	this.parent = parent;
	//System.out.println(coName+
	//		   ": unwait(-,-): entered, parent="+parent.coName);
	//if(val!=null) {
	//  System.out.println(coName+": this.val set to "+this.val.toString());
	//} else {
	//    System.out.println(coName+": this.val set to null");
	//}

	//System.out.println(coName+": unwait(-,-): setting wakeup=true");
	wakeup=true;

	//System.out.println(coName+": unwait(-,-): calling notifyAll()");
	notifyAll();    // Release this objects thread

	//ul(this);
    }

    public void prwkq() { // For convenience
	t.prwkq();
    }

    public void prclkq() { // For convenience
	g.clock.prwkq();
    }

    public void prpktlist() {
	Pktlist pl = t.pktlist;
	if (pl==null) {
	    System.out.println("pktlist for task "+t.taskName+" is empty");
	} else {
	    System.out.println("pktlist for task "+t.taskName+":");
	    while(pl!=null) {
		Pkt p = pl.pkt;
		String pname = p.task==null ? "<null>" : p.task.taskName;
		System.out.print  ("   pkt from "+pname);
		System.out.println(" for "+pl.co.coName);
		pl = pl.link;
	    }
	}
    }

    public Cortn findpkt(Pkt pkt) {
	// Find the coroutine, if any, that owner the packet
	//prpktlist();

	Pktlist p = t.pktlist;
	//System.out.println(coName+": findpkt: got p");
	if (p==null) {
	    //System.out.print(coName+": findpkt: pkt from "+
	    //	   pkt.task.taskName);
	    //System.out.println(" -- returning null");
	    return null;
	}
	//System.out.println(coName+": findpkt: got p not null");

	if (p.pkt==pkt) {
	    // Found at the head of the list
	    t.pktlist = p.link;
	    p.link = null;
	    //System.out.print(coName+": findpkt: pkt from "+
	    //	   pkt.task.taskName);
	    //System.out.println(" -- returning co="+p.co.coName);
	    return p.co;
	}
	//System.out.println(coName+": findpkt: p.pkt not pkt");

	while (p.link!=null) {
	    //System.out.println(coName+": findpkt: p.link not null");
	    Pktlist q = p.link;
	    if (q.pkt==pkt) {
		// Found in the list
		p.link = q.link; // Remove from list
		p.link = null;
		//System.out.print(coName+": findpkt: pkt from "+
		//	         pkt.task.taskName);
		//System.out.println(" -- returning co="+q.co.coName);
		return q.co;     // and return the coroutine
	    }
            p = p.link;
	}
	//System.out.print(coName+": findpkt: pkt from "+
	//		         pkt.task.taskName);
	//System.out.println(" -- returning null");
	return null;
    }

    public Pkt taskwait() { // For convenience
	//System.out.println(t.taskName+
	//		   ": taskwait waiting for a pkt");
	Pkt pkt = t.getpkt();
	if (pkt==null) {
	    //System.out.println(t.taskName+": taskwait got null pkt");
	    return null;
	}
	//String name = pkt.task==null ? "<null>" : pkt.task.taskName;
	//System.out.println("\n"+t.taskName+
	//		   ": taskwait got pkt from "+name);
	return pkt;
    }

    public boolean qpkt(Pkt pkt) {
        Task dest = pkt.task;
	//System.out.println(t.taskName+
	//		   ": qpkt sending pkt from "+t.taskName+" to "+
	//		   pkt.task.taskName);
        pkt.task = t;  // Fill in the task to return the packet to.
	//if (dest==t) {
	//    System.out.println(t.taskName+
	//		   ": qpkt sending pkt to self!!!!");

	    //System.out.println(t.taskName+
	    //	   ": qpkt NOT calling System.exit(203)");
	//    System.exit(204);
	//}
	//System.out.println(t.taskName+
	//		   ": qpkt sending pkt to "+dest.taskName);
	dest.putpkt(pkt);
	//dest.prwkq();
	//g.clock.prclkq();
        return true;
    }

    public void taskdelay(int ticks) { // Delay in single-event mode
	Pkt pkt = new Pkt(null, g.clock, act_clock, 12, 34, ticks, 1234);
	System.out.println(t.taskName+
			       ": taskdelay, ticks="+
			       ticks);
	sendpkt(pkt);
	//qpkt(pkt);
	//taskwait();
	System.out.println(t.taskName+
			       ": taskdelay returned, ticks="+
			       ticks);
    }

    public void codelay(int ticks) { // Delay in multi-event mode
	Pkt pkt = new Pkt(null, g.clock, act_clock, 0, 0, ticks, 2345);
	sndpkt(pkt);
    }

    public String getconame(Cortn co) {
	if (co==null) {
	    return "<null>";
	} else {
	    return co.coName;
	}
    }

    public int sendpkt(Pkt pkt) { // Sendpkt in single-event mode
	if (! qpkt(pkt)) {
	    System.out.println(t.taskName+
			       ": sendpkt unable to send pkt to "+
			       pkt.task.taskName);
	}
	Pkt rpkt = taskwait();
	if(rpkt!=pkt) {
	    System.out.println(t.taskName+
			       ": sendpkt unexpected packet received from "+
			       rpkt.task.taskName);
	}
	t.result2 = pkt.res2;
	return pkt.res1;
    }

// coread and cowrite provide Occum style channel communication
// used by servers communicating with their logger coroutines.
    public Object coread(Channel chan) {
	Object val;
	//chan.pr(coName+": coread");
	Cortn cptr = chan.cptr;
        if (cptr!=null) {
	    chan.cptr = null;   // Clear the channel word
	    //System.out.println(coName+
	    //	       ": coread: using resumeco to send its cptr to "+
	    //	       cptr.coName+", parent="+getconame(parent));
	    val = resumeco(cptr, this);
	} else {
	    chan.cptr = this;   // Set the channel word to this coroutine
	    //System.out.println(coName+": coread: waiting for data");
	    val = cowait(null);   // Wait for value from cowrite
	}
	if (val==null) {
	    //System.out.println(coName+
	    //	       ": coread: received a value: null, parent="+
	    //	       parent.coName);
	} else {
	    //System.out.println(coName+": coread: received value: "+
	    //	       val.toString()+", parent="+getconame(parent));
	}
	return val;
    }

    public void cowrite(Channel chan, Object val) {
	Cortn cptr = chan.cptr;
	String x = val.toString();
	//chan.pr(coName+": cowrite");
	if(cptr!=null) {
	    chan.cptr = null;  // Clear the channel word
	    //System.out.println(coName+
            //               ": cowrite: sending "+x+" to a waiting coread");
	    callco(cptr, val);
	} else {
	    chan.cptr = this;  // Set the channel word to this coroutine
	    //System.out.println(coName+
            //                   ": cowrite: waiting for a coread to get "+x);
	    Cortn co = (Cortn)cowait(null);
	    //System.out.println(coName+
            //           ": cowrite: coread ready to receive, parent="+
	    //	       getconame(parent));

	    //System.out.println(coName+
            //           ": cowrite: calling callco(..) to enter "+co.coName);

	    callco(co, val);
	    //System.out.println(coName+
	    //	       ": cowrite: returning after value "+x+" sent");
	}
    }

    public int sndpkt(Pkt pkt) { // Sendpkt in multi-event mode
	/*
This function is only used in multi-event mode to send a packet and
await the reply.  It can only be called when running as a non root
coroutine of a task.  A packet-coroutine pair is placed in pktlist
before dispatching the packet (using qpkt) so that when the packet
returns to this task this coroutine can be reactivated.
	*/

	Task dest = pkt.task;

	// Safety check -- sndpkt cannot be called from the root coroutine
	if (parent==null) {
	    System.out.println(coName+
			       ": can't sndpkt from root coroutine");
	    System.exit(205);
	}

	if (dest==this) {
	    System.out.println(coName+
			       ": can't sndpkt to self");
	    System.exit(206);
	}

	// Insert a pkt-cortn pair at the head of pktlist
	//System.out.println(coName+
	//		   ": sndpkt sending pkt to "+dest.coName);
	synchronized(t) {
	t.pktlist = new Pktlist(t.pktlist, pkt, this);
	}
	//System.out.println(t.taskName+": calling prpktlist");
	//prpktlist();
	//System.out.println(t.taskName+": returned from prpktlist");

	//System.out.println(coName+
        //             ": sndpkt calling qpkt with arg1="+pkt.arg1);

	if (! qpkt(pkt)) {
	    System.out.println(coName+": qpkt failed in sndpkt");
	    System.exit(207);
	}

	////////g.incchangeco();
	//System.out.println(coName+
        //      ": sndpkt waiting for the pkt to return from "+dest.taskName);
	Pkt rpkt = (Pkt)cowait(null);
	//System.out.println(coName+
	//		   ": sndpkt got pkt from "+rpkt.task.coName+
	//		   " arg1="+rpkt.arg1);
	//if(rpkt!=null) {
	//    System.out.println(coName+
	//		       ": sndpkt got pkt with type="+rpkt.type);
	//} else {
	//    System.out.println(coName+
	//		       ": sndpkt got pkt=null");
	//}

	if (rpkt!=pkt) {
	    System.out.println(t.taskName+": sndpkt got wrong packet");
	    System.exit(208);
	}

	/////t.result2 = rpkt.res2;
	return rpkt.res1;
    }

    public void gomultievent(Cortn mainco) {

	Pkt queue = null;       // Packets waiting for mainco to become ready.
	t.pktlist = null;
	t.multi_done = false;   // true when its time to return to single
                                // event mode.
        t.setmainco_ready(false); // true when mainco ready to receive a pkt

	// Start up mainco. This will create and start
	// the multi-event worker coroutines.

	g.incchangeco();

	//System.out.println(t.taskName+
	//                   ": gomultievent calling callco(mainco,..)");

	//System.out.println(t.taskName+
	//		   ": gomultievent calling callco(mainco,null)");

	callco(mainco, null); // Initialise mainco

	//System.out.println(t.taskName+
	//		   ": gomultievent returned from callco(mainco,null)");

	while (!t.multi_done) {
	    // Multi-event loop
	    //if (queue!=null) {
	    //System.out.println(t.taskName+": gomultievent queue non-null"+
	    //		   " at start of event loop");
	    //}
	    //System.out.println(t.taskName+": gomultievent calling taskwait");
	    Pkt pkt = taskwait();
	    g.inctaskwait();

	    //System.out.println(t.taskName+
	    //	       ": gomultievent received pkt from "+
	    //	       pkt.task.taskName);

	    //System.out.println(t.taskName+
	    //	       ": gomultievent calling findpkt");

	    Cortn co  = findpkt(pkt);

	    //System.out.println(t.taskName+
	    //	       ": gomultievent returned from findpkt");

	    if (co!=null) {
		//System.out.println(t.taskName+
		//		   ": gomultievent: pkt from "+
		//                  pkt.task.taskName+" in pktlist "+
                //                   "given to "+co.coName);
		g.incchangeco();
		callco(co, pkt);  // Give pkt to its coroutine
	    } else {
		if (t.getmainco_ready()) {
		    //System.out.println(coName+
		    //		       ": gomultievent: giving pkt from "+
                    //                   pkt.task.taskName+
		    //	       " to mainco");

		    g.incchangeco();
		    callco(mainco, pkt); // Give the pkt to mainco
		} else {
		    // Append the packet onto the end of workqueue
		    // and wait for another packet.
		    //System.out.println(t.taskName+
		    //	       ": gomultievent putting pkt from task "+
		    //	       pkt.task.taskName+" in queue");
		    //System.exit(209); ///////////////#########################
		    Pkt p = queue;
		    pkt.link = null;
		    if (p==null) {
			queue = pkt;
			continue;
		    }
		    while (p.link!=null) p = p.link;
		    p.link = pkt;
		    continue;
		}
	    }

            while (queue!=null && t.getmainco_ready()) {
		//System.out.println(t.taskName+
		//		   ": gomultievent: getting pkt from queue");
		pkt = queue;       // De-queue a pending packet
		queue = pkt.link;
		pkt.link = null;
		g.incchangeco();
		callco(mainco, pkt); // Give it to mainco
	    }
	}

	// Return to single-event mode
    }

    public void realdelay (int msecs) {
	try {
	    //System.out.println(coName+": realdelay "+msecs+"\n");
	    sleep(msecs);
	    //System.out.println("\n"+coName+": realdelay "+msecs+ " done\n");
	}
	catch (Exception e) {}
    }

    public void prlockcolist(Lock lock) {
	System.out.print(coName+": Logger lock colist: ");
	Colist p = lock.colist;
	while (p!=null) {
	    System.out.print(" "+p.co.coName);
	    p = p.link;
	}
	System.out.println("");
    }

    public void lock(Lock lock) {
	//lock.colist is the list of coroutines waiting on lock.

	g.inclock();  // Gather statistics

	//System.out.println(coName+": lock(..) entered");

	// Create a new node to append to colist
	Colist node = new Colist(null, this);

	if (lock.colist!=null) {
	    // The lock is currently locked so append an item onto
	    // the end of the lock list and suspend this coroutine.
	    Colist p = lock.colist;
	    while (p.link!=null) p = p.link;
            p.link = node;
	    g.inclockw();  // Gather statistics
	    //if (g.tracing)
	    //System.out.println(coName+": lock(..): Waiting for lock");
	    g.incchangeco();
	    prlockcolist(lock);
	    cowait(null); // Suspend until unlock(..) called
	    //System.out.println(coName+": lock(..): Lock obtained");

	    // We now own the lock and waitlist will be non empty
	} else {
	    // Lock was not locked, so make a unit list indicating
	    // that we have obtained the lock and return from lock.
	    lock.colist = node;
	    //prlockcolist(lock);
	    //System.out.println(coName+": lock(..): Lock obtained");
	}
    }


    public void unlock(Lock lock) {
	//System.out.println(coName+": unlock(..) entered");
	//prlockcolist(lock);
	Colist node = lock.colist;
	if (node==null || node.co!=this) {
	    System.out.println(coName+": Misuse of unlock(..)");
	    return;
	}
	// Remove our node from the colist.
	lock.colist = node.link;

	// Give control to a waiting coroutine, if any.
	if (lock.colist!=null) {
	    // There is a waiting coroutine.
	    Cortn co = node.link.co;
	    //System.out.println(coName+
	    //   ": unlock(..): Lock freed, giving control to a waiting cortn");
	    prlockcolist(lock);
	    g.incchangeco();
	    callco(co, null);
	} else {
	    //System.out.println(coName+
	    //": unlock(..): Lock freed, no waiting coroutines");
	    //prlockcolist(lock);
	}
    }


// Typical usage of wait and notify is:

// while (! <complicated condition> ) cortnwait(countwaitlist);

// When something happens that may change the condition
// cortnnotify(countwaitlist) is called.



    public void cortnwait(Colist waitlist) {
	//waitlist.link = new Colist(waitlist.link, this);
	//g.incwait();    // Gather statistics
	System.out.println(coName+": cortnwait(..): waiting");
	//g.incchangeco();
	cowait(null);   // Suspend until the waiting condition
	//System.out.println(coName+": wait(..): resumed");
    }

    public void cortnnotify(Colist waitlist) {

	// Wakeup all coroutines waiting on the specified condition variable.

	if (waitlist==null) return; // No coroutines to wakeup.

	Colist p = waitlist.link;
	g.incnotify();        // Gather statistics
	waitlist.link = null; // Clear the wait list

	while(p!=null) { // Give control to all the waiting coroutines
	    Cortn co = p.co;
	    p = p.link;
	    System.out.println(coName+
			       ": notify(..) wakeup coroutine "+co.coName);
	    g.incchangeco();
	    callco(co, null);
	}
    }

    public static void wrz(int n, int d) {
        if(n<0) {
	    d--;
            n = -n;
            System.out.print("-");
	}
        if (n<10000000 && d>=8) System.out.print("0");
        if (n<1000000 && d>=7) System.out.print("0");
        if (n<100000 && d>=6) System.out.print("0");
        if (n<10000 && d>=5) System.out.print("0");
        if (n<1000 && d>=4) System.out.print("0");
        if (n<100 && d>=3) System.out.print("0");
        if (n<10 && d>=2) System.out.print("0");
        System.out.print(""+n);
    }

    public static void wrn(int n, int d) {
        if(n<0) d--;
        if (n<10000000 && d>=8) System.out.print(" ");
        if (n<1000000 && d>=7) System.out.print(" ");
        if (n<100000 && d>=6) System.out.print(" ");
        if (n<10000 && d>=5) System.out.print(" ");
        if (n<1000 && d>=4) System.out.print(" ");
        if (n<100 && d>=3) System.out.print(" ");
        if (n<10 && d>=2) System.out.print(" ");
        System.out.print(""+n);
    }

    public void wrtime(String mess) {
	java.util.Date date = new java.util.Date();
	System.out.println(mess+"  "+date);
    }
}


//**********************************************************************
//**************************** Cotest **********************************
//**********************************************************************

class Cotest extends Task {
    // This is the root coroutine of a task to test the functionality
    // java versions of the BCPL coroutine functions: callco, cowait
    // and resumeco.

    public Cortn a_co;
    public Cortn b_co;
    public Cortn c_co;
    public Cortn d_co;


    public Cotest(String name, Globals g, int pri) {
	super(name, g, pri);
	startTask();
    }

    public Object fn(Object arg) {
	//System.out.println(coName+": fn entered");
	//System.out.println(coName+": calling new Ctrlmainco(..)");
	Pkt pkt = (Pkt)arg;

	a_co = new A_co("a_co", this);
	//System.out.println(coName+": a_co created");
	b_co = new B_co("b_co", this);
	//System.out.println(coName+": b_co created");
	c_co = new C_co("c_co", this);
	//System.out.println(coName+": c_co created");
	d_co = new D_co("d_co", this);
	//System.out.println(coName+": d_co created");

	System.out.println("\nTest: root -> a -> root");
	System.out.println("root: calling callco(a_co,  100)");
        int res =  ((Integer)callco(a_co, new Integer(100))).intValue();
	System.out.println("root: callco(a_co,  100) => " + res);


        System.out.println("\nTest: root -> a -> root, " +
                           " ie check: c:=fn(cowait(c)) REPEAT");
        System.out.println("root: calling callco(a_co,  200)");
        res =  ((Integer)callco(a_co, new Integer(200))).intValue();
	System.out.println("root: callco(a_co,  200) => " + res);

	System.out.println("\nTest: root -> b -> a -> b -> root");
	System.out.println("root: calling callco(b_co,  300)");
        res =  ((Integer)callco(b_co, new Integer(300))).intValue();
	System.out.println("root: callco(b_co,  300) => " + res);

	System.out.println("\nTest: root -> b -> a -> b -> root  again");
	System.out.println("root: calling callco(b_co,  400)");
        res =  ((Integer)callco(b_co, new Integer(400))).intValue();
	System.out.println("root: callco(b_co,  400) => " + res);

        System.out.println("\nTest: root -> c -> a -> root," +
                           " ie check resumeco in c_co");
        System.out.println("root: calling callco(c_co,  500)");
        res =  ((Integer)callco(c_co, new Integer(500))).intValue();
	System.out.println("root: callco(c_co,  500) => " + res);

	System.out.println("\nTest: root -> c -> root");
	System.out.println("root: calling callco(c_co,  600)");
        res =  ((Integer)callco(c_co, new Integer(600))).intValue();
	System.out.println("root: callco(c_co,  600) => " + res);

	System.out.println("\nTest: root -> d -> d -> root,"+
			   " ie can resumeco call itself");
	System.out.println("root: calling callco(d_co,  700)");
        res =  ((Integer)callco(d_co, new Integer(700))).intValue();
	System.out.println("root: callco(c_co,  700) => " + res);

	System.out.println("\nEnd of test");

	// Return the startup packet
	qpkt(pkt);
	return null;
    }
}

//**********************************************************************
//***************************** A_co ***********************************
//**********************************************************************

class A_co extends Cortn
{
    Cotest ct;  // A reference to the task variables

    public A_co(String name, Cortn parent) {
	super(name, parent);
	ct = (Cotest)t;

	startCoroutine(parent);
    }

    public Object fn(Object c) {
	//System.out.println(coName+": fn entered");
	int x = ((Integer)c).intValue();
	System.out.println("a_co: entered with value " + x);
	System.out.println("a_co: returning " + (x+10));
	return new Integer(x+10);
    }
}


//**********************************************************************
//***************************** B_co ***********************************
//**********************************************************************

class B_co extends Cortn
{
    Cotest ct;

    public B_co(String name, Cortn parent) {
	super(name, parent);
	ct = (Cotest)t;

	startCoroutine(parent);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("b_co: entered with value " + x);
	System.out.println("b_co: calling callco(a_co, 2000)");
	res = ((Integer) callco(ct.a_co,new Integer(2000))).intValue();
	System.out.println("b_co: callco(a_co, 2000) => " + res);
	System.out.println("b_co: returning " + (x+20));
	return new Integer(x+20);
    }
}


//**********************************************************************
//***************************** C_co ***********************************
//**********************************************************************

class C_co extends Cortn
{
    Cotest ct;

    public C_co(String name, Cortn parent) {
	super(name, parent);
	ct = (Cotest)t;

	startCoroutine(parent);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("c_co: entered with value " + x);
	System.out.println("c_co: calling resumeco(a_co, 3000)");
	res = ((Integer) resumeco(ct.a_co, new Integer(3000))).intValue();
	System.out.println("c_co: resumeco(a_co, 3000) => " + res);
	System.out.println("c_co: returning " + (x+30));
	return new Integer(x+30);
    }
}

//**********************************************************************
//***************************** D_co ***********************************
//**********************************************************************

class D_co extends Cortn
{
    Cotest ct;

    public D_co(String name, Cortn parent) {
	super(name, parent);
	ct = (Cotest)t;

	startCoroutine(parent);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("d_co: entered with value " + x);
	System.out.println("d_co: calling resumeco(d_co, 4000)");
	res = ((Integer) resumeco(ct.d_co, new Integer(4000))).intValue();
	System.out.println("d_co: resumeco(d_co, 4000) => " + res);
	System.out.println("d_co: returning " + (x+40));
	return new Integer(x+40);
    }
}


/*
Cotest should generate the following output:

Test: root -> a -> root
root: calling callco(a_co,  100)
a_co: entered with value 100
a_co: returning 110
root: callco(a_co,  100) => 110

Test: root -> a -> root,  ie check: c:=fn(cowait(c)) REPEAT
root: calling callco(a_co,  200)
a_co: entered with value 200
a_co: returning 210
root: callco(a_co,  200) => 210

Test: root -> b -> a -> b -> root
root: calling callco(b_co,  300)
b_co: entered with value 300
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 320
root: callco(b_co,  300) => 320

Test: root -> b -> a -> b -> root  again
root: calling callco(b_co,  400)
b_co: entered with value 400
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 420
root: callco(b_co,  400) => 420

Test: root -> c -> a -> root, ie check resumeco in c_co
root: calling callco(c_co,  500)
c_co: entered with value 500
c_co: calling resumeco(a_co, 3000)
a_co: entered with value 3000
a_co: returning 3010
root: callco(c_co,  500) => 3010

Test: root -> c -> root
root: calling callco(c_co,  600)
c_co: resumeco(a_co, 3000) => 600
c_co: returning 530
root: callco(c_co,  600) => 530

Test: root -> d -> d -> root, ie can resumeco call itself
root: calling callco(d_co,  700)
d_co: entered with value 700
d_co: calling resumeco(d_co, 4000)
d_co: resumeco called => d_co
d_co: resumeco(d_co, 4000) => 4000
d_co: returning 740
root: callco(c_co,  700) => 740

End of test
*/


//**********************************************************************
//**************************** Channel *********************************
//**********************************************************************

class Channel {
    Cortn cptr;

    public synchronized void pr(String name) {
	if (cptr==null) {
	    System.out.println(name+": channel is idle");
	} else {
	    System.out.println(name+": channel points to "+cptr.coName);
	}
    }
}

//**********************************************************************
//***************************** Lock ***********************************
//**********************************************************************

class Lock {
    Colist colist;

    public Lock() {
	colist = null;
    }
}

//**********************************************************************
//**************************** Client **********************************
//**********************************************************************

class Client extends Task {
    // This class is for read and write client tasks

    int[] requestv;
    int clidelayitem;  // Subscript of requestv of request to
                       // delay in this client.
    int clino;
    char modech;
    Rnd rnd;

    public Client(char modech, int clino, Globals g, int pri) {
	super(""+modech+"C"+(clino/10)+(clino%10), g, pri);
	this.clino = clino;
	this.modech = modech;
	startTask();
	//System.out.println(taskName+": Task created");
    }

    public Object fn(Object arg) {
	//System.out.println(taskName+": root coroutine entered##########");

	// Body of a client task which runs in single event mode.
	// pkt is the startup packet and is either

	//      act_startrdclient  a1:clino

	int checksum  = 0; // Check sum (modulo 1_000_000) of all data
	                   // transferred to or from any server task.
	int datacount = 0; // Count of data values transferred.

	rnd = new Rnd(clino*modech, clino*clino);

	initschedule();

        //System.out.println(coName+": Returning startup packet to controller");

	qpkt((Pkt)arg);  // Return the start up packet to the controller

	// Wait to start the run.
        if (g.tracing)
	    System.out.println(coName+": Waiting to start schedule");

	qpkt(taskwait());

	for (int count = 1; count<=g.loopmax; count++) {
	    // Run the schedule of requests loopmax times

	    if (g.tracing)
		System.out.println(coName+": Starting schedule, count="+count);

	    for (int i = 1; i<=g.requestvupb; i++) {
		int wrd = requestv[i];
		int req = wrd<0 ? -wrd : wrd;
		int serno = req>>16 & 255;
		int mpxno = req>>8  & 255;
		int chnno = req     & 255;

		if (i == clidelayitem && g.delayticks>0) {
		    if (g.tracing) {
			System.out.println(t.taskName+":    Delaying for "+
					   g.delaymsecs +" msecs");
			System.out.println(t.taskName+
					   ":    Calling taskdelay("+
					   g.delayticks+")");

			g.incdelay();
			taskdelay(g.delayticks);
			if (g.tracing) {
			    System.out.println(t.taskName+
                                               ":    Resuming after "+
					       g.delaymsecs+" msecs delay");
			}
		    }
		}

		// Issue the read or write requests
		if (modech=='R') {
		    int act = wrd<0 ? act_readdelay : act_read;
		    char ch = wrd<0 ? 'D' : ' ';
		    if (g.tracing) {
			System.out.print(t.taskName+":  "+ch+" rqst M");
			wrz(mpxno, 2);
			System.out.print("C");
			wrz(chnno, 2);
			System.out.print("->RS");
			wrz(serno, 2);
			System.out.print("->RC");
			wrz(clino, 2);
			System.out.println("");
		    }

		    Pkt rdpkt = new Pkt(null, g.rdserverv[serno], act, 0, 0,
					clino, serno, mpxno, chnno);
		    //System.out.println(t.taskName+":  calling qpkt, target="+
		    //	       rdpkt.task.coName);
		    int data = sendpkt(rdpkt);

		    checksum = (checksum + data) % 1000000;
                    datacount++;
		} else {
		    int act = wrd<0 ? act_writedelay : act_write;
		    char ch = wrd<0 ? 'D' : ' ';
		    //int data = i*100 + clino;    // (Random) data
		    int data = rnd.next(9999); // Random data
		    if (g.tracing) {
			System.out.print(t.taskName+":  "+ch+" ");
			wrz(data, 4);
			System.out.print(" WC");
			wrz(clino, 2);
			System.out.print("->WS");
			wrz(serno, 2);
			System.out.print("->M");
			wrz(mpxno, 2);
			System.out.print("C");
			wrz(chnno, 2);
			System.out.println("");
		    }

		    Pkt wrpkt = new Pkt(null, g.wrserverv[serno], act, 0, 0,
					clino, serno, mpxno, chnno, data);
		    //System.out.println(t.taskName+
                    //                   ":  calling sendpkt, target="+
		    //	                 wrpkt.task.coName);
		    sendpkt(wrpkt);

		    checksum = (checksum + data) % 1000000;
                    datacount++;
		}
	    }

	    System.out.println(t.taskName+
			       ":    Sending sync packets to all its servers");
	    for (int serno = 1; serno<=g.sermax; serno++) {
		Task server = (modech=='R') ? g.rdserverv[serno] :
                                              g.wrserverv[serno];
		Pkt syncpkt = new Pkt(null, server, act_sync,
				      0, 0, clino, serno);
		if (g.tracing) {
		    System.out.print(t.taskName+
                                     ":    Sending sync packet to "+
				     modech+"S"); wrz(serno,2);
		    System.out.println("");

		}
		qpkt(syncpkt);
		taskwait();
	    }
	    System.out.println(t.taskName+":    All sync packets returned");
	}

	if (g.tracing) {
	    System.out.println(t.taskName+":    Finished");
	}
	// Tell the controller that this client has finished
	Pkt donepkt = new Pkt(null, g.controller,
			      ((modech=='R') ? act_rddone : act_wrdone),
			      0, 0, clino, checksum, datacount);

	//if (g.tracing) {
	//    System.out.println(t.taskName+
        //                       ":    Sending done pkt to the controller");
	//}
	qpkt(donepkt);
	taskwait();

	// This task will now commit suicide.
	return null;
    }


    public void initschedule() {
	clidelayitem = 1;  // Subscript of requestv of request to
                           // delay in this client.

	//requestvupb = g.sermax*g.mpxmax*g.chnmax;
	requestv = new int[g.requestvupb+1];

	//if (g.tracing) {
	//    System.out.println(t.taskName+": Started");
	//}

	// Initialise the work schedule requestv
	int pos = 0;

	for (int serno = 1; serno<=g.sermax; serno++) {
	    int p = pos;
	    for (int mpxno = 1; mpxno<=g.mpxmax; mpxno++) {
		for (int chnno = 1; chnno<=g.chnmax; chnno++)
		    requestv[++pos] = serno<<16 | mpxno<<8 | chnno;
	    }
	    if (clino==serno) {
		// Make just one request per schedule a delayed request
		int i = p + rnd.next(g.mpxmax*g.chnmax);
		requestv[i] = -requestv[i];
	    }
	}

    // Randomly permute requestv. The read and write clients
    // have different random permutations.

	//if (false) //***************************************
	    for (int i = g.requestvupb; i>=2; i--) { // Apply random shuffle
		int j = rnd.next(i);                // 1 <= j <= i
		// Swap elements at i and j
		int val = requestv[i];
		requestv[i] = requestv[j];
		requestv[j] = val;
	    }

	do clidelayitem = rnd.next(g.requestvupb); // In range 1..resuestvupb
	while (requestv[clidelayitem]<0);        // but not the delayed request.


	// Possibly print the schedule of work
	if (g.tracing)
	{   System.out.println("\n"+t.taskName+": Schedule of work");
	    for (int i = 1; i<=g.requestvupb; i++) {
		int wrd = requestv[i];
		int req = (wrd<0) ? -wrd : wrd;
		int serno = req>>16 & 255;
		int mpxno = req>>8  & 255;
		int chnno = req     & 255;
		char ch = (wrd<0) ? 'D': (i==clidelayitem) ? 'd': ' ';
      
		System.out.print(" "+ch+"S"); wrz(serno, 2);
		System.out.print("M"); wrz(mpxno, 2);
		System.out.print("C"); wrz(chnno, 2);

		if (i%5 == 0) System.out.println("");
	    }
	    if (g.requestvupb%9 == 0) System.out.println("");
	    System.out.println("");
	}
    }

}

//**********************************************************************
//**************************** Server **********************************
//**********************************************************************

class Server extends Task {

    // This is the class for read and write server tasks

    int serno;            // Number of this server
    char modech;          // 'R' for a read server, 'W' for write
    Pkt diepkt;           // null until the diepkt is received.
    Pkt startuppkt;       // The startup packet.

    Pkt pktqueue;         // Queue of packet waiting for work coroutines
    boolean[] busyv;      // busy flags for the work coroutines
    int busycount;        // Number of work coroutines processing requests.
    Workco[] wrkcov;      // Vector of server work coroutines
    int[] countv;         // A heap holding work coroutine counts.
    int[] indexv;         // The permutation vector
    int[] inversev;       // Inverse of indexv
    int countmin;         // The smallest count in countv, ie countv!(indexv!1)
    int countmax;         // The largest count in countv.
    int maxcountdiff;     // The maximum allowable value of countmax-countmin

    Colist countwaitlist; // The condition variable for condition:
                          //     countmax-countmin < maxcountdiff

    Colist busywaitlist;  // condition variable notified whenever a
                          // work coroutine decrements busycount,
                          // ie when it has just finished processing
                          // a read or write request and is just
                          // about to attempt to increment its count.

    Pkt synclist;         // List of sync packets received by a server
    int synclistlen;      // Length of this servers synclist

    Cortn loggerco;       // The logger coroutine
    Lock loggerlock;      // List of coroutines waiting for the looger

    Channel loggerin;     // Occam style channel for logger input
    Channel loggerout;    // Occam style channel for logger output

    boolean dead;         // Set to TRUE when this server is ready to
                          // return to single event mode and die.
    Rnd rnd;              // For random data to send to the logger

    int checksum;         // The checksum of data sent or received
                          // by this client

    public Server(char modech, int serno, Globals g, int pri) {
	super(""+modech+"S"+(serno/10)+(serno%10), g, pri);
	this.modech = modech;
	this.serno = serno;
	startTask();
    }

    public Object fn(Object pkt) {
	//System.out.println(coName+": fn entered");

	init();

	// The startup packet will only be returned when this server is
	// ready to service requests.
	startuppkt = (Pkt)pkt;

	//System.out.println(taskName+": Creating Servermainco");
	Cortn mainco = new Servermainco(coName+"mainco", this);
	gomultievent(mainco);

	if (g.tracing)
	    System.out.println(taskName+": Dying");
	return null;
    }

    public void init() {
	//System.out.println(t.taskName+": init entered");
	diepkt = null;   // Non null when the die packet is received.

	rnd = new Rnd(serno+modech, serno*13);

	// Allocate the vectors.

	busyv   = new boolean[g.workmax+1]; // Work coroutines are busy flags.
	wrkcov  = new Workco[g.workmax+1];  // Vector of work coroutines.
	countv  = new int[g.workmax+1];     // Vector of counters.
	indexv  = new int[g.workmax+1];     // Permutation vector 
                                            // required to sort countv, ie
                                            // if i<j then 
                                            //    countv[indexv[i]] <=
                                            //               countv[indexv[j]]
	inversev = new int[g.workmax+1];    // The inverse of indexv, ie
                                            // if indexv[i]=j then
                                            //       inversev[j]=i
	// Example:

        // indexv         countv       inversev  ie            1:W5/1  
        // 1: 5           1: 5         1: 4              -------+------
        // 2: 4           2: 1         2: 3             |               |
        // 3: 2           3: 8         3: 5            2:W4/4          3:W2/1
        // 4: 1           4: 4         4: 2          ---+---         ---+
        // 5: 3           5: 1         5: 1         |       |       |
        // 6: 6           6: 2         6: 6        4:W1/5  5:W3/8  6:W6/2

        // When a work coroutine wishes to increment its count, it
        // may have to wait, using wait(countwaitlist), if
        // countmax-countmin would to grow too large. Otherwise it can increment
        // its count now possibly changing countmax or countmin.
        // If countmin is incremented, it should free any waiting coroutines
        // using notify(countwaitlist).

        // To implement this efficiently a binary heap is used with the minimum
        // count value held at index position 1.
        // indexv[1] holds the work coroutine number with the smallest count,
        // and so countmin = countv[indexv[1]].

        // The heap constraint is that for any i in range 1..W
        //      countv[indexv[i]] <= countv[index[2i]],   provided 2i  <=W
        // and  countv[indexv[i]] <= countv[index[2i+1]], provided 2i+1<=W

	for (int i = 0; i<=g.workmax; i++) {
	    busyv[i]    = false;
	    wrkcov[i]   = null;
	    countv[i]   = 0;
	    indexv[i]   = i;
	    inversev[i] = i;
	}

	countmin = 0;
	countmax = 0;
	maxcountdiff  = 16; // maximum allowable value of countmax-countmin

	countwaitlist = null; // Condition: countmax-countmin < maxcountdiff
                              // used in: wait(countwaitlist)
                              // and      notify( countwaitlist)
	wkq = null;           // List of server packet waiting to be given
                              // to work coroutines.
	busywaitlist = null;  // Condition variable notified whenever a
                              // work coroutine decrements busycount,
	                      // ie when it has just finished processing
                              // a read or write request and is just
                              // about to attempt to increment its count.
	busycount  = 0;
	loggerlock = new Lock();   // Initialise the logger mutex

	loggerin  = new Channel(); // Occam style channel for logger input
	loggerout = new Channel(); // Occam style channel for logger output

	synclist    = null;   // List of sync packets received so far
	synclistlen = 0;      // The length of synclist
	dead = false;
        checksum = 0;
	//System.out.println(t.taskName+": returning from init");
    }

/*
  // This is the body of a read or write server task that runs in
  // multi-event mode using gomultievent.

  // pkt is the startup packet of the form:
  //      act_startrdserver   a1:serno
  // or   act_startwrserver   a1:serno

  // This initialises the task as either a read or write server and
  // sets its own identity in id.

  // Later packets are of the form:

  //      act_die         no arguments
  // or   act_read        a1:clino  a2:serno  a3:mpxno  a4:chano
  // or   act_readdelay   a1:clino  a2:serno  a3:mpxno  a4:chano
  // or   act_write       a1:clino  a2:serno  a3:mpxno  a4:chano a5:data
  // or   act_writedelay  a1:clino  a2:serno  a3:mpxno  a4:chano a5:data

  // Read servers only receive act_read, act_readdelay and act_die
  // requests and write servers only receive act_write, act_writedelay
  // and act_die requests.

  // Die requests are sent by the controller to each server when all
  // client tasks have completed their schedules of work.

  // Read and write requests are given to available work coroutines for
  // processing, but if all work coroutines are busy the requests are
  // queued on the end of wkq.

  // When a work coroutine receives an act_read request, it sends it to
  // the appropriate mpx task and waits for the reply. The reply contains
  // the value just received.

  // The work coroutine next obtains exclusive use of the server's
  // logger coroutine, using lock(logger), before generating two random
  // numbers x and y, in the range 1 to 99, and sending the values x+y
  // x-y separately to the logger coroutine using the Occam style channel
  // loggerin.  The logger coroutine deduces the value x from these two
  // values and returns x to the work coroutine encoded as a sequence of
  // 0s and 1s terminated by -1 using the Occam style channel loggerout.
  // The work coroutine checks that the replied value is correct and the
  // releases the logger lock. To test that the locking mechanism works,
  // the logger coroutine occasionally (once every 7 times) sends an
  // act_print packet to the printer task and does not continue until the
  // print packet is returned. This is done between reading x+y and x-y.
  // Sending a packet to the printer task may indirectly cause another
  // work coroutine within this server to gain control and attempt to gain
  // the logger lock and thus become suspended.  The test is designed
  // so that calls of lock almost always succeed without suspension.

  // Each work coroutine maintains a count of how many requests it has
  // processed. The count for the work coroutine numbered wkno is
  // incremented by the call incrementcount(wkno), but there is the
  // constraint that the largest of the counts may not exceed the
  // smallest by more than maxcountdiff. It is thus necessary to
  // maintain these two values countmax and countmin, and for
  // incrementcount to suspend the coroutine if the difference is about
  // to become too large. This is implemented using what is often called
  // a condition variable. Incrementcount computes the new count value
  // and then obeys:

  // WHILE count-countmin > maxcountdiff DO wait(@countwaitlist)

  // to wait until it can be stored in the shared structure containing
  // the work coroutine counts. The structure used is a binary
  // heap (as in heapsort) with the smallest count (countmin) held
  // at subscript position 1. When a count value is incremented the heap
  // may need some rearrangement, and possibly countmin or countmax may
  // have to change. If countmin is incremented, all coroutines
  // waiting on the condition variable must be activated and this is done
  // by notify(@countwaitlist).
  
  // When a work coroutine completes processing a request, it
  // waits until its count-countmin < maxcountdiff before incrementing its
  // count and possibly adjusting indexv and inversev to keep the counts in
  // sorted order. If this increments countmin, it calls notify(@countwaitlist)
  // to activate any mpx coroutines within this server waiting on the
  // condition involving countmin.

  // Finally, if the work queue is non empty the first packet is de-queued
  // and processed, otherwise this work coroutine returns to non busy state
  // waiting for another request from a client or a die request from the
  // controller.

  // An act_readdelay request is processed exactly as above after first
  // suspending the work coroutine for delaymsecs milli-seconds. In the
  // schedule of work to be performed by a client only one involves a delay,
  // and for client i the delay request is only sent to server i and will
  // be processed by just one of server i's work coroutines. All other
  // clients, servers and, indeed, work coroutines should, in principle, be
  // able to make progress.

  // When a readclient completes a schedule of work it send an act_sync
  // request to every server. These are only returned when all other
  // read clients have similarly completed their schedules. All clients
  // then resume their work until they have each performed the schedule
  // the requires number of times.

  // The processing of a write request by a write server is identical to
  // the processing of a read request described above except that the 
  // write client includes a random data data as an extra argumnet in the
  // request. This data is in the range 1 to 9999. As with read servers a
  // check sum of all data transmitted is computed and returned to the
  // controller for checking at the end of the run.  Each write client
  // issues one delayed write request per schedule, and the use of locks,
  // Occam-style channels and condition variables is the same as for read
  // servers.

  // The mpx (multiplexor) task provide the interface between the read
  // and write servers. Each mpx task looks after a number of channels
  // which each have FIFO buffers of data written by write servers but not
  // yet read by read servers. A write request is blocked if its channel
  // buffer is full and a read request is blocked if its buffer is empty.

  // Let use assume there are N read and write clients, N read and write
  // servers each with W work coroutines, and that the are M multiplexor
  // tasks each looking after C channel buffers. There are various
  // possible deadlock worries and we must choose N, W, M and C carefully
  // so that deadlock cannot happen.

  // One possible deadlock senario is when all N write clients are
  // blocked because all the channels they have chosen to write to
  // are full, at exactly the moment when all the read clients are
  // blocked because they have chosen read from channels with empty
  // buffers. The worst case is when all N read clients make read requests
  // from the same channel buffer of the same multiplexor. Deadlock can
  // easily be avoided by ensuring that the write clients cannot block
  // until it has written at least one data value to each channel.

  // Each write client request consists of a tuple (i,s,m,c) which
  // corresponds to write client i sending a write request to server s
  // to be sent to write data into channel c of multiplexor m. These
  // requests are shuffled so that they are performed in random order.
  // The random data is chosen at the time the write client issues a
  // request. Each client has a different random ordering. Just one of
  // these is converted into a delayed write request. Such a request must
  // be of the form (i,i,m,c), so that client i can only cause a delay
  // in server i. This is a timed delay an not a cause of deadlock.

  // The number of tuples in a schedule of work for a particular write
  // client is NxMxC, and so the total amount of data write per schedule
  // by all write clients is NxNxMxC. Assuming all this is all written
  // before any client starts, the same amount of data will be stored in
  // each of the MxC channel buffers. To accommodate this each buffer
  // should have room for NxN data values, so we will choose a channel
  // buffer large enough to hold NxN values. Note that this is slightly
  // over cautious since one of the buffers could contain as little as
  // 1 data value.   

  // The use of lock and unlock in the communication with logger coroutines
  // cannot cause deadlock since there is nothing in the critical section
  // that can block indefinitely.

  // A third possible worry concerns the condition variable and the
  // constraint that countmax-countmin must never exceed maxcountdiff.
  // It is easy to see that such a deadlock cannot happen, since, without
  // loss of generality, N-1 work coroutines have be blocked waiting to
  // increment their counts when the remaining coroutine has a count
  // of zero. This last coroutine cannot be blocked on the condition
  // variable, it cannot be blocked waiting to obtain the logger lock,
  // and it cannot be blocked waiting for data from a channel buffer.
  // It is thus free to run and will, in due course, increment it count
  // (and countmin) and so release the N-1 waiting coroutines. The only
  // necessary requirement is that W be no less than N.

  gomultievent(servermaincofn, 1000)


*/

    public Workco findwkco() {
	for (int i = 1; i<= g.workmax; i++) {
	    // Search for a coroutine with a smallish count near the root
	    // of count values in the binary heap.
	    // int wkno = i;   // Find free worker with smallest wkno (bad)
	    int wkno = inversev[i]; // Find free worker with smallish count
	    if (! busyv[wkno]) return wrkcov[wkno];
	}
	return null; // No work coroutine available.
    }

    public void incrementcount(int wkno) {
    }

    public void incrementcount1(int wkno) {
	int count = countv[wkno] + 1;
	int p, q, minchild;

	g.incinc();

	if (g.tracing) {
	    System.out.println(coName+": trying to increment count="+(count-1));
	    //prcounts();
	}

	// Wait until we are allowed to update our count.
	while (count-countmin > maxcountdiff && false) {
	    if (g.tracing) {
		System.out.println(coName+": waiting to set count to "+
				   count+", countmin="+countmin);
		g.incincwait();
		///////////////////// Problem here ###########################
		cortnwait(countwaitlist);
		if (g.tracing) {
		    System.out.println(coName+
				       ": returned from wait(..) for count to "+
				       count);
		}
	    }
	}

	countv[wkno] = count; // Store the updated count

	p = inversev[wkno];  // Position of this count in indexv

	// Perform the downheap operation.
	while (true) {
	    // We may have to swap with the smaller child
	    q = 2*p;              // Position of left child
	    //System.out.println(coName+
	    //	       ": p="+p+" q="+q+" workmax="+g.workmax);
	    if (q > g.workmax) break;  // This node has no children

	    //System.out.println(coName+
	    //	       ": May have to exchange p="+p+
	    //	       " with smaller child");

	    minchild = countv[indexv[q]];  // count of the left child
	    //System.out.println(coName+": Left child count = "+
	    //	       minchild+" at "+q);
	    if (q < g.workmax) {
		// The node at p does have a right child (q+1)
		int b = countv[indexv[q+1]]; // Right child count
		// Select right child if its count is smaller.
		//System.out.println(coName+
		//	   ": right child count = "+b+
		//	   " at "+(q+1));
		if (b < minchild) { minchild = b; q++; }
	    }
	    // q is now the position of the smaller child
	    // minchild is the count of the smaller child
	    //System.out.println(coName+": minchild="+minchild+
	    //	   " q="+q);

	    if (count <= minchild) break;    // No need to swap with a child

	    // We must swap p with the smaller child q
	    indexv[p] = indexv[q];
	    indexv[q] = wkno;
	    inversev[wkno] = q;
	    inversev[indexv[p]] = p;
	    //System.out.println(coName+
	    //	   ": swapping p="+p+" with q="+q);
	    //System.out.println(coName+
	    //	   ": indexv[p]="+
	    //	   indexv[p]+" with indexv[q]="+
	    //	   indexv[q]);
	    // Now do downheap on the position of the smaller child
	    p = q;
	}

	// We may have to increment countmax
	if (count > countmax) {
	    countmax = count; 
	    if (g.tracing) {
		System.out.println(coName+
				   ": countmax changed to "+
				   countmax);
	    }
	}

	if (p==1) {
	    // The newly increment count is still the minimum so
	    // we must increment countmin and release any
	    // coroutines waiting on the count wait list.
	    countmin = count;
	    if (g.tracing) {
		System.out.println(coName+
				   ": countmin changed to "+
				   countmin);
	    }
	}

	if (g.tracing) {
	    System.out.println(coName+": count now = "+count);
	    //prcounts();
	}

	if (p==1) {
	    // countmin has changed so notify all waiting
	    // coroutines.
	    cortnnotify(countwaitlist);
	    if (g.tracing) {
		System.out.println(coName+": returned from notify");
	    }
	}
    }

    public void prbusy() {
	System.out.print(taskName+": Busy:");
	for (int i = 1; i<=g.workmax; i++) {
	    if (busyv[i]) { System.out.print(" W"); wrz(i,2); }
	}
	System.out.println("");
    }

    public void prcounts() {
	if (g.tracing) {
	    System.out.println(t.taskName+": countmin="+countmin+
			       " countmax="+countmax);
	    for (int p = 1; p<=g.workmax; p++) {
		int wkno = indexv[p];
		System.out.print(" "+taskName+"W"); wrz(wkno,2);
		System.out.print("/"+countv[wkno]);
	    }
	    System.out.println("");

	    System.out.print("countv:    ");
	    for (int p = 1; p<=g.workmax; p++) {
		int i = countv[p];
		System.out.print("   "+p+":"); wrn(i,2);
	    }

	    System.out.println("");
	    System.out.print("indexv:    ");
	    for (int p = 1; p<=g.workmax; p++) {
		int i = indexv[p];
		System.out.print("   "+p+":"); wrn(i,2);
	    }

	    System.out.println("");
	    System.out.print("inversev:  ");
	    for (int p = 1; p<=g.workmax; p++) {
		int i = inversev[p];
		System.out.print("   "+p+":"); wrn(i,2);
	    }
	    System.out.println("");
	}

    }
}


//**********************************************************************
//************************* Servermainco *******************************
//**********************************************************************

class Servermainco extends Cortn {
    // This is the gomultievent main coroutine for each read and write
    // server task.

    public Server st;         // For access to the Server variables

    public char modech;       //) Copies of the server (constant) variables
    public int serno;         //)
    public Cortn loggerco;    //)
    public Workco wrkcov[];   //)

    public Servermainco(String name, Cortn parent) {
	super(name, parent);
	//System.out.println(coName+": Servermainco Coroutine constructed");
	st = (Server)parent;

	modech   = st.modech;
	serno    = st.serno;
	loggerco = st.loggerco;
	wrkcov   = st.wrkcov;

	t.setmainco_ready(false); // Until fully initialised

	//System.out.println(coName+": calling start()");
	startCoroutine(parent);

	//System.out.println(coName+": suspended in c = fn(cowait(c)) loop");
    }


    public Object fn(Object arg) {
	//if (g.tracing)
	//    System.out.println(coName+": Coroutine fn entered");


	// This is the gomultievent main coroutine body of
	// a server task.
	//t.setmainco_ready(false); // During initialisation
	st.pktqueue = null;

	// Create the logger coroutine for this server
	//System.out.println(coName+": creating logger, serno="+serno);
	loggerco = new Loggerco(t.taskName, this);
	//System.out.println(loggerco.coName+": Logger Coroutine created");

	g.incchangeco();
	callco(loggerco, null); // Start the logger coroutine

	//System.out.println(coName+": Creating work coroutines");

	// Create the server work coroutines that will process read and
	// write requests.
	for (int wkno = 1; wkno<=g.workmax; wkno++) {
	    Cortn co = new Workco(st.taskName, this, wkno);
	    wrkcov[wkno] = (Workco)co;
	    //System.out.println(co.coName+": Coroutine created");
	    callco(co, new Integer(wkno));
	}

	if (g.tracing)
	    System.out.println(t.taskName+": Ready");

	//if (g.tracing)
	//    System.out.println(coName+": Returning startup packet");

        qpkt(st.startuppkt); // Return the startup packet

	//System.out.println(coName+": entering server event loop");

	while(!st.dead) {

	    // Start of this server's event loop
	    Workco wkco;
	    //System.out.println(coName+": Server waiting for a packet");

	    // Get a new request from gomultievent
	    t.setmainco_ready(true);
	    g.incchangeco();
	    //System.out.println(coName+": calling cowait in the event loop");
	    Pkt pkt = (Pkt)cowait(null);
	    t.setmainco_ready(false);

	    //System.out.println(coName+": got a packet from "+pkt.task.coName);

	    // This server cannot process another request packet until
	    // a work coroutine is available.

	    wkco = st.findwkco(); // Get a free work coroutine
	    if (wkco==null) {
		// Append the packet onto the end of the list of packets
		// waiting for work coroutines.
		//System.out.println(t.taskName+
		//		   ": Appending a packet onto the end of wkq");
		pkt.link = null;
		if (st.pktqueue==null) {
		    // Form a unit list
		    st.pktqueue = pkt;
		} else {
		    // Append to a non-empty queue
		    Pkt p = st.pktqueue;
		    while (p.link!=null) p = p.link;
		    p.link = pkt;
		}
		continue;
	    }
	
	    //System.out.println(coName+": giving pkt to coroutine "+
	    //	       wkco.coName);
	    g.incchangeco();
	    callco(wkco, pkt); // Give the request to the selected work
	                       // coroutine.
	}

	t.multi_done = true;
	g.incchangeco();
	cowait(null);  // Wait until the contoller deletes this coroutine.

	// This point should not be reached.
	System.out.println(t.taskName+": body: System error");
	return null;
    }
}

//**********************************************************************
//*************************** Workco ***********************************
//**********************************************************************

class Workco extends Cortn {
    // This class is for the work coroutine of a read and write
    // server task.

    Server st;    // For access to the server variables

    char modech;  //) Copies of the server (constant) variables
    int serno;    //)

    int wkno;     // The work coroutine number

    public Workco(String name, Cortn parent, int wkno) {
	super(name+"W"+(wkno/10)+(wkno%10), parent);

	st     = (Server)parent.t;
 	modech = st.modech;
	serno  = st.serno;
	this.wkno   = wkno;

	startCoroutine(parent);

	//System.out.println(coName+": suspended in c = fn(cowait(c)) loop");

    }

    public Object fn(Object arg) {
	// This is the code for read and write server work coroutines

	//if (g.tracing)
	//    System.out.println(coName+": fn entered, parent="+
	//		       getconame(parent));

	if (g.tracing)
	    System.out.println(coName+": ready -- Workco");

	while (st.diepkt==null) {
	    // This is the body of a server work coroutine.
	    // It is only given
	    // read, readdelay, write, writedelay or die packets.

	    // Get the next packet
	    Pkt pkt = st.pktqueue;
	    if (pkt!=null) {
		st.pktqueue = pkt.link;
		pkt.link = null;
		//if (g.tracing)
		//    System.out.println(coName+": packet de-queued from wkq");
	    } else {
		//if (g.tracing)
		//    System.out.println(coName+
		//		       ": calling cowait(...), parent="+
		//		       getconame(parent));
		g.incchangeco();
		pkt = (Pkt)cowait(null);
		//if (g.tracing)
		//    if (pkt==null) {
		//	System.out.println(coName+": null pkt from cowait(.)");
		//    } else {
		//	System.out.println(coName+": packet from cowait(.)");
		//    }
            }

	    int type   = pkt.type;  // act_read,  act_readdelay,
                                    // act_write, act_writedelay,
                                    // act_sync,  act_die 
	    int clino  = pkt.arg1;
	    int serno  = pkt.arg2;
	    int mpxno  = pkt.arg3;
	    int chnno  = pkt.arg4;
	    int data   = pkt.arg5;  // If it is a write or writedelay request

	    //System.out.print(coName+": type="+type+
	    //	     " clino="+clino+" serno="+serno+
	    //	     " mpxno="+mpxno+" chnno="+chnno);
	    //if (modech=='W') System.out.print(" data="+data);
	    //System.out.println("");

	    switch(type) {
	    default:
		System.out.println(coName+": Bad pkt type="+type+" received");
		System.exit(210);
		continue;

	    case act_die:
		// This is always the last packet to be sent to a server.
		//if (g.tracing)
		//    System.out.println("\n"+coName+": Die packet received");
		st.diepkt = pkt;

		// Wait until there are no busy work coroutines
		while (st.busycount>0) cortnwait(st.busywaitlist);

		// The diepkt is now returned to the controller with
		// its res1 field set to the checksum of all data sent
		// or received by this server. This task then deletes itself.

		st.diepkt.res1 = st.checksum;

		//if (g.tracing)
		//    System.out.println(coName+": Giving checksum="+st.checksum+
		//		       " to the controller");
		st.dead = true;
		continue;

	    case act_sync:
		// This is always the last packet of a work schedule
		// sent by a client.
		pkt.link = st.synclist;  // Insert at head of synclist
		st.synclist = pkt;
		st.synclistlen++;

		//if (g.tracing) {
		//    System.out.print("\n"+coName+
		//		     ": Sync packet received from "+
		//		     modech+"C"); wrz(clino,2);
		//    System.out.println(", synclistlen="+st.synclistlen);
		//}

		if (st.synclistlen==g.climax) {
		    // All clients have sent sync packets so release them all.
		    Pkt p = st.synclist;
		    st.synclist = null;
		    st.synclistlen = 0;

		    // Return all sync packets to their clients.
		    if (g.tracing) {
			System.out.println("\n"+coName+
					   ": Returning all sync packets");
		    }

		    while (p!=null) {
			Pkt spkt = p;
			p = p.link;
			spkt.link = null;
			if (g.tracing) {
			    System.out.print("\n"+coName+
					     ": Returning sync packet to "+
					     modech+"C");
                            wrz(spkt.arg1,2);
			    System.out.println("");
			}
			qpkt(spkt);
		    }
		}
		continue;

	    case act_readdelay:
            case act_writedelay:
	    case act_read:
            case act_write:
		break;
	    }

	    // The packet can only be a
	    // read, write, readdelay or writedelay request.

	    st.busyv[wkno] = true;         // This work coroutine is now busy.
	    st.busycount++;
	    if (g.tracing) {
		System.out.println("\n"+coName+
				   ": busycount incremented to "+
				   st.busycount);
		st.prbusy();
	    }

            if ((type==act_readdelay || type==act_writedelay) &&
	       (g.delaymsecs>0)) {
		// Each client sends one delayed request per work schedule.
		// For client i this request is sent to server i, so each
		// server receives just one delayed request during each
		// work cycle. This will delay just one of its work
		// coroutines.

		if (g.tracing) {
		    System.out.print(coName+": Delay "); wrz(data,4);
		    System.out.print(" "+modech+"C"); wrz(clino, 2);
		    System.out.print("->"+modech+"S"); wrz(serno,2);
		    System.out.print("->M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.println(" "+g.delaymsecs+" msecs\n");
		}
		System.out.println(coName+": calling codelay("+
				   g.delaymsecs+")");
		g.incdelay();
		codelay(g.delayticks);

		if (g.tracing) {
		    System.out.print("\n"+coName+": Resumed "); wrz(data,4);
		    System.out.print(" "+modech+"C"); wrz(clino,2);
		    System.out.print("->"+modech+"S"); wrz(serno,2);
		    System.out.print("->M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.println("");
		}
	    }

	    if (modech=='R') {
		// It must be a read or read-delay request.

		// Send the request to a multiplexor
		//if (g.tracing) {
		//    System.out.print(coName+": Rqst M"); wrz(mpxno,2);
		//    System.out.print("C"); wrz(chnno,2);
		//    System.out.print("->RS"); wrz(serno,2);
		//    System.out.print("->RC"); wrz(clino,2);
		//    System.out.println("");
		//}

		//System.out.println(coName+": calling sndpkt");
		data = sndpkt(new Pkt(null, g.mpxv[mpxno], type,
				      0, 0,     clino, serno, mpxno, chnno));

		if (g.tracing) {
		    System.out.print(coName+": "); wrz(data,4);
		    System.out.print(" M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.print("->RS"); wrz(serno,2);
		    System.out.print("->RC"); wrz(clino,2);
		    System.out.println("");
		}

		pkt.res1 = data; // Send the data value to the read client
		qpkt(pkt);       // Return packet to the read client
	    } else {
		// It must be a write or write-delay request

		//qpkt(pkt); // Return the write packet to the write client
		//           // before sending the data to the multiplexor.

		// Then send the request to the specified multiplexor
		if (g.tracing) {
		    System.out.print(coName+": "); wrz(data,4);
		    System.out.print(" WC"); wrz(clino,2);
		    System.out.print("->WS"); wrz(serno,2);
		    System.out.print("->M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.println("");
		}

		sndpkt(new Pkt(null, g.mpxv[mpxno], type,
			       0, 0,
			       clino, serno, mpxno, chnno, data));

		///st.checksum = (st.checksum + data) % 1000000;

		qpkt(pkt); // Return the write packet to the write client
		           // after the data is accepted by the multiplexor.

	    }

	    //******************************************************
	    if (g.tracing)
		System.out.println("\n"+coName+": rqst loggerlock");

	    lock(st.loggerlock);
	    if (g.tracing)
		System.out.println(coName+": got  loggerlock");

	    // Send two messages to the logger
	    int a = st.rnd.next(99);
	    int b = st.rnd.next(99);

	    if (g.tracing) {
		System.out.print(coName+": log "); wrz(a,2);
		System.out.print(" + "); wrz(b,2);
		    System.out.println("");
	    }

	    cowrite(st.loggerin, new Integer(a+b));

	    if (g.tracing) {
		System.out.print(coName+": log "); wrz(a,2);
		System.out.print(" - "); wrz(b,2);
		System.out.println("");
	    }

	    cowrite(st.loggerin, new Integer(a-b));

	    // Check the logger's reply
	    int reply = getloggerval();

	    if (g.tracing) {
		System.out.print(coName+": reply from logger = ");
		wrz(reply,2);
		System.out.println("");
	    }

	    if (a!=reply)
		System.out.println(coName+": Bad logger communication");

	    if (g.tracing) 
		System.out.println(coName+": freeing loggerlock\n");

	    unlock(st.loggerlock);
	    //*******************************************************/

	    // This work coroutine has processed the current request and
	    // returned  the packet to the client, so it can decrement
	    // its busy count.

	    st.busycount--;

	    if (g.tracing)
	    System.out.println(coName+
	    		   ": busycount decremented to "+st.busycount);

	    if (st.busycount==0) cortnnotify(st.busywaitlist);

	    // But it cannot accept another request until it has incremented 
	    // its count. If this would case countmax-countmin to become too
	    // large, the coroutine will wait on the condition variable:
	    // countwaitlist. If it causes countmin to change, it calls
	    // cortnnotify to release all the coroutines waiting in
	    // countwaitlist.

	    st.incrementcount(wkno);

	    // This work coroutine is now ready to accept another request.
	    st.busyv[wkno] = false;

	    if (g.tracing) {
		System.out.println(coName+
                                   ": Now free to accept another request:");
		st.prbusy();
	    }

	    //// Process another request
	}

	qpkt(st.diepkt); // Return the die packet

	//if (g.tracing) {
	//    System.out.println(coName+
	//		       ": Returning from fn()");
	//}

	notdead = false; // Cause the coroutine to commit suicide

	return null;
    }

    public int getloggerval() {
	int res = 0;
	//System.out.println(coName+": getloggerval called");

	while (true) {
	    //System.out.println(coName+": getloggerval calling coread");
	    int dig = ((Integer)coread(st.loggerout)).intValue();
	    //System.out.print(coName+": getloggerval: dig = ");
	    //wrn(dig,2);
	    //System.out.print(" res = ");
	    //wrn(res,2);
	    //System.out.println("");
	    if (dig<0) return res;
	    res += res+dig;
	}
    }
}

//**********************************************************************
//************************** Loggerco **********************************
//**********************************************************************

class Loggerco extends Cortn {
    // This is the logger coroutine for a read or write server

    char modech;
    int serno;
    Server st;

    public Loggerco(String name, Cortn parent) {
	super(name+"Log", parent);
	this.modech = modech;
	this.serno = serno;
	st = (Server)parent.t;

	startCoroutine(parent);

	//System.out.println(coName+": suspended in c = fn(cowait(c)) loop");

    }


    public Object fn(Object arg) {
	int i = 0;
	//System.out.println(coName+": Coroutine fn entered");

	if (g.tracing)
	    System.out.println(coName+": ready");

	while(true) {
	    int x, y;
	    //if (g.tracing)
	    //System.out.println(coName+": calling coread");
	    x = ((Integer)coread(st.loggerin)).intValue();
	    //System.out.println(coName+": logger: received x="+x);

	    i++;
	    //System.out.println(coName+": logger: i="+i);
	    if (i%7==0) {
		if (g.tracing)
		    System.out.println(coName+
				       ": logger sending pkt to printer");
		sndpkt(new Pkt(null, g.printer, act_print, 0, 0,
			       modech, serno));
		if (g.tracing)
		    System.out.println(coName+": pkt returned from printer");
	    }

	    //if (g.tracing)
	    //System.out.println(coName+": calling coread");
	    y = ((Integer)coread(st.loggerin)).intValue();
	    //System.out.println(coName+": logger: received y="+y);

	    int a = (x+y)/2;
	    int b = (x-y)/2;
	    //System.out.println(coName+": logger received x="+x+
	    //	       " y="+y+" replying "+a);
	    wrpn(a);
	    //System.out.println(coName+": logger replying -1");
	    cowrite(st.loggerout, new Integer(-1));
	}
    }

    public void wrpn(int x) {
	if (x!=0) {
	    wrpn(x>>>1);
	    //System.out.println(coName+": logger writing "+(x&1));
	    cowrite(st.loggerout, new Integer(x&1));
	    //System.out.println(coName+": logger written "+(x&1));
	}
    }
}

//**********************************************************************
//***************************** Mpx ************************************
//**********************************************************************

class Mpx extends Task {
    int mpxno;      // Number of this mpx task

    int[][] bufv;     // bufv[i] is the mpx circular buffer for channel i.
                      // These buffers each have climax*sermax+1 elements.
    int[] bufpv;      // bufpv[i] is the subscript into bufv[i] where the next
                      // write data for channel i will be written to.
    int[] bufqv;      // bufqv[i] is the subscript into bufv[i] where the next
                      // data value from channel i will be read from.
                      // If bufpv[i]=bufqv[i], there is no pending write data
                      // within the mpx task for channel i.
    Pkt[] wkqv;       // wkqv[i] is a list of pending mpx packets for channel i.
                      // They are all read packets if the buffer for
                      // channel i is empty, and they are all write packets if
                      // the buffer is full.
    int mpxcount;     // Count of data values transferred through this mpx task.

    Pkt diepkt;

    public Mpx(int mpxno, Globals g, int pri) {
	super("M"+(mpxno/10)+(mpxno%10), g, pri);
	this.mpxno = mpxno;
	startTask();
    }

    public Object fn(Object arg) {
	//System.out.println(coName+": fn entered");

  // This is the body of a mpx task.
  // It runs in multi-event mode but does not use gomultievent
  // since it contains no coroutines.

  // The vectors bufv, bufpv, bufqv and wkqv each have one element
  // per buffer number.

  // bufv!i is the circular buffer (of climax*sermax+1 elements) of
  // pending data to be written by this mpx task for client i.
  // bufpv!i is the next available write position in this buffer.
  // bufqv!i is the position in this buffer of the next value to
  // be read from the buffer. If bufpv!i=bufqv! the circular buffer
  // is empty.

  // wkqv!i is the list of outstanding read packets received for
  // client i. This list can only be non empty when the circular
  // buffer is empty.

  // It processes the following packets:

  // act_startmpx  a1:mpxno

  //   This is the startup packet specifying the mpx task number.
  //   The vectors bufv, bufpv, bufqv and wkqv are allocated and
  //   initialised.

  // act_read       a1:clino, a2:servno, a3:mpxno, a4:chnno.
  // act_readdelay  a1:clino, a2:servno, a3:mpxno, a4:chnno.

  //   The two packets are treated identically by the mpx task.

  //   If the specified buffer is empty, the read packet is appended
  //   to the list of pending packets in wkqv!chnno.

  //   If the specified buffer is non empty, its first data value is
  //   extracted and copied to the res1 field of this read packet which
  //   is then returned to its read server.

  // act_write       a1:clino, a2:serno, a3:mpxno, a4:chnno, a5:data.
  // act_writedelay  a1:clino, a2:serno, a3:mpxno, a4:chnno, a5:data.

  //   If wkqv!chnno is non zero, its first packet is dequeued,
  //   the data copied to its res1 field, and then then both packets
  //   returned to their respective servers.

  //   If wkqv!clino is empty, it data is appended to the end of the
  //   circular buffer and the packet returned to its write server.
  //   The program aborts if the buffer overflows.
  
  // act.die    no arguments
  //   This is sent by the controller when all client tasks have completed
  //   their schedule of work. It causes this mpx task to return all its
  //   work space and commit suicide.

	mpxcount = 0;
	diepkt = null;

	bufv  = new int[g.chnmax+1][];
	bufpv = new int[g.chnmax+1];
	bufqv = new int[g.chnmax+1];
	wkqv  = new Pkt[g.chnmax+1];

	// No requests are currently held on any of this multiplexor's channels.
	for (int chnno = 1; chnno<=g.chnmax; chnno++) {
	    bufpv[chnno] = 0;
	    bufqv[chnno] = 0;
	    wkqv[chnno] = null;
	}

  // Total request per cycle = climax*sermax*mpxmax*chnmax
  // Total number of buffers = mpxmax*chnmax
  // so each buffer must hold upto climax*sermax values

	for (int chnno = 1; chnno<=g.chnmax; chnno++) {
	    int []  buf = new int[g.chnbufsize+1];
	    bufv[chnno] = buf;
	    //System.out.print(t.taskName+": Allocated buffer "+coName+"C");
	    //wrz(chnno,2);
	    //System.out.println("");
	}

	if (g.tracing)
	    System.out.println(t.taskName+":  Ready");

	//if (g.tracing)
	//    System.out.println(t.taskName+":  Returning startup packet");
	qpkt((Pkt)arg); // Return the startup packet

	while(diepkt==null) {
	    // Main event loop of an mpx task

	    //System.out.println(t.taskName+":  Waiting for packet");
	    Pkt pkt = taskwait();
	    int type = pkt.type;
	    //System.out.println(t.taskName+":  Got a packet from "+
	    //	       pkt.task.taskName);

	    g.inctaskwait();

	    switch (type) {
	    default:
		 System.out.println(t.taskName+
				    ": Received unknown packet, type="+type);
		 qpkt(pkt);; // Return this unexpected packet
		 continue;

	    case act_die:
		//System.out.println(t.taskName+": Die packet received");
		diepkt = pkt;  // Return the die packet later
		break;         // and leave the event loop.

	    case act_readdelay:
	    case act_read:   // a1:clino, a2:servno, a3:mpxno, a4:chnno.

		{
		    int clino = pkt.arg1;
		    int serno = pkt.arg2;
		    int chnno = pkt.arg4;
		    int p     = bufpv[chnno];
		    int q     = bufqv[chnno];

		    //System.out.print(t.taskName+":     rqst M");
		    //wrz(mpxno,2);
		    //System.out.print("C"); wrz(chnno,2);
		    //System.out.print("->RS"); wrz(serno,2);
		    //System.out.print("->RC"); wrz(clino,2);
		    //System.out.println(": p="+p+
		    //	       " q="+q+" g.chnbufsize="+g.chnbufsize);

		    if (p==q) {
			// The specified buffer is empty, so append the read
			// packet onto the end of the list of pending read
			// packets in wkqv!chnno.

			Pkt r = wkqv[chnno];

			pkt.link = null;

			if (r==null) {
			    // Make a unit list
			    wkqv[chnno] = pkt;
			} else {
			    // Append to a non empty list
			    while (r.link!=null) r = r.link;
			    r.link = pkt;
			}
			if (g.tracing) {
			    System.out.print(t.taskName+":     rdrq M");
			    wrz(mpxno,2);
			    System.out.print("C"); wrz(chnno,2);
			    System.out.print("->RS"); wrz(pkt.arg2,2);
			    System.out.print("->RC"); wrz(pkt.arg1,2);
			    System.out.println("");

			    prbufs();
			}
		    } else {
			// The circular buffer is non empty, so extract its
			// first data value and copy it to the res1 field of
			// this read packet before returning it to its read
			// server task.

			int [] buf  = bufv[chnno];
			int data = buf[q];

			pkt.res1 = data;         // Copy the value
			bufqv[chnno] = (q+1) % g.chnbufsize;
			if (g.tracing) {
			    System.out.print(t.taskName+":     ");
			    wrz(data,4);
			    System.out.print(" M"); wrz(mpxno,2);
			    System.out.print("C"); wrz(chnno,2);
			    System.out.print("->RS"); wrz(pkt.arg2,2);
			    System.out.print("->RC"); wrz(pkt.arg1,2);
			    System.out.println("");
			}

			//System.out.println(t.taskName+
			//		 ":     returning read packet, target="+
			//		 pkt.task.taskName);

			//System.out.println(t.taskName+
			//		 ":     calling qpkt(pkt), crntask="+
			//		   t.taskName);

			qpkt(pkt); // Return the read packet to its read server
			//System.out.println(t.taskName+
			//			 ":     returned from qpkt");
			mpxcount++; // Data values passed through this mpx task
			if (g.tracing) {
			    if (mpxcount%10 == 0) {
				System.out.print(t.taskName+
						 ":     mpxcount = ");
				wrn(mpxcount, 5);
				System.out.println("");
			    }
			}

			if (wkqv[chnno]!=null) {
			    // If the list of pending packets is non empty,
			    // extract the first one (a write packet) and
			    // copy its data into the now non full buffer,
			    // and return the packet to its write server.
			    pkt = wkqv[chnno]; // Dequeue a pending write packet
			    wkqv[chnno] = pkt.link;
			    pkt.link = null;
			    buf[p] = pkt.arg5; // Copy its data to the buf
			    bufpv[chnno] = (p+1) % g.chnbufsize;
			    if (g.tracing) {
				System.out.print(t.taskName+":     ");
				wrz(pkt.arg5,4);
				System.out.print(" WC"); wrz(pkt.arg1,2);	
				System.out.print("->WS"); wrz(pkt.arg2,2);
				System.out.print("->M"); wrz(mpxno,2);
				System.out.print("C"); wrz(chnno,2);
				System.out.print("");
				prbufs();
			    }
			    qpkt(pkt); // Return the packet to its write server.
			}
		    }
		    continue;
		}

	    case act_writedelay:
	    case act_write: 
		// a1:clino, a2:serno, a3:mpxno, a4:chnno a5:data.

		{
		    int chnno = pkt.arg4;
		    int p     = bufpv[chnno];
		    int np    = (p+1) % g.chnbufsize;
		    int q     = bufqv[chnno];

		    //System.out.print(t.taskName+":     "); wrz(pkt.arg5,4);
		    //System.out.print(" WC"); wrz(pkt.arg1,2);
		    //System.out.print("->WS"); wrz(pkt.arg2,2);
		    //System.out.print("->M"); wrz(mpxno,2);
		    //System.out.print("C"); wrz(chnno,2);
		    //System.out.println(": p="+p+
		    //	       " q="+q+" g.chnbufsize="+g.chnbufsize);

		    if (np==q) {
			// The buffer is full, so append this packet onto
			// the end of wkqv[chnno].
			Pkt r = wkqv[chnno];

			pkt.link = null;

			if (r==null) {
			    // Form a unit list
			    wkqv[chnno] = pkt;
			} else {
			    // Append to a non empty list
			    while (r.link!=null) r = r.link;
			    r.link = pkt;
			    //System.out.println(t.taskName+":     after");
			    //prbufs();
			}

			if (g.tracing) {
			    System.out.print(t.taskName+":     ");
			    wrz(pkt.arg5, 4);
			    System.out.print(" WC"); wrz(pkt.arg1,2);
			    System.out.print("->WS"); wrz(pkt.arg2,2);
			    System.out.print("->M"); wrz(mpxno,2);
			    System.out.print("C"); wrz(chnno,2);
			    System.out.println(" queued");

			    prbufs();
			}
			continue;
		    }

		    if (wkqv[chnno]!=null) {
			int data = pkt.arg5;
			Pkt rpkt = wkqv[chnno];
			int serno = pkt.arg2;

			// wkqv[chnno] is non null, so the buffer must be empty.
			// Dequeue its first packet (a read pkt), copy the data
			// into its res1 field, and return both packets to their
			// respective server tasks.

			wkqv[chnno] = rpkt.link;     // Dequeue a read packet
			rpkt.link = null;
			if (g.tracing) {
			    System.out.print(t.taskName+
					     ":     dequeuing rdrq M");
			    wrz(mpxno,2);
			    System.out.print("C"); wrz(chnno,2);
			    System.out.print("->RS"); wrz(pkt.arg2,2);
			    System.out.print("->RC"); wrz(pkt.arg1,2);
			    System.out.println("");

			    prbufs();
			}

			rpkt.res1 = data;   // Copy the data to the first
                                            // waiting read packet.
			if (g.tracing) {
			    System.out.print(t.taskName+":     ");wrz(data,4);
			    System.out.print(" WC"); wrz(pkt.arg1,2);
			    System.out.print("->WS"); wrz(pkt.arg2,2);
			    System.out.print("->M"); wrz(mpxno,2);
			    System.out.print("C"); wrz(chnno,2);
			    System.out.print("->RS"); wrz(rpkt.arg2,2);
			    System.out.print("->RC"); wrz(rpkt.arg1,2);
			    System.out.println("");
			}

			//System.out.println(t.taskName+
			//	       ":     returning read packet, target="+
			//		   rpkt.task.taskName);
			qpkt(rpkt);            // Return the read packet.
			mpxcount++; // Data values passed throught this mpx task
			if (g.tracing) {
			    if (mpxcount % 10 == 0) {
				System.out.println(t.taskName+
						   ":     mpxcount = ");
				wrn(mpxcount, 5);
				System.out.println("");
			    }
			}
			//System.out.println(t.taskName+
			//	   ":     returning write packet, target="+
			//		   pkt.task.taskName);

			qpkt(pkt);   // Return the write packet.
			continue;
		    }

		    // If wkqv[chnno] is zero and the buffer is not full,
		    // the data is appended onto the end of the buffer
		    // and the packet returned to its write server task.

		    bufv[chnno][p] = pkt.arg5; // Insert data into buffer
		    bufpv[chnno] = np;
		    if (g.tracing) {
			System.out.print(t.taskName+":     ");
			wrz(pkt.arg5,4);
			System.out.print(" WC"); wrz(pkt.arg1,2);
			System.out.print("->WS"); wrz(pkt.arg2,2);
			System.out.print("->M"); wrz(mpxno,2);
			System.out.print("C"); wrz(chnno,2);
			System.out.println("");
			prbufs();
		    }

		    //System.out.println(t.taskName+
		    //	       ":     returning write packet, target="+
		    //	       pkt.task.taskName);

		    qpkt(pkt); // Return the write packet to its server task
		}
	    }
	}

	qpkt(diepkt); // Return the die packet

	if (g.tracing) System.out.println(t.taskName+":     dying");
	return null;
    }


    public synchronized void prbufs() {
	if (g.tracing) {
	    System.out.println(coName+":     Buffers:");
	    for (int chnno = 1; chnno<=g.chnmax; chnno++) {
		int p = bufpv[chnno];
		int q = bufqv[chnno];
		boolean empty = p==q;

		if (!empty) {
		    int[] buf = bufv[chnno];
		    System.out.print("   M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.print(": data: ");

		    while (p!=q) {
			int val = buf[q];
			wrz(val, 4); // data
			System.out.print(" ");
			q = (q+1) % g.chnbufsize;
		    }
		    System.out.println("");
		}

		if (wkqv[chnno]!=null) {
		    Pkt r = wkqv[chnno];
		    System.out.print("   M"); wrz(mpxno,2);
		    System.out.print("C"); wrz(chnno,2);
		    System.out.print(empty ? ":  rdq:" : ":  wrq:");

		    while (r!=null) {
			int type = r.type;
			char ch = 
			    type==act_read  || type==act_readdelay  ? 'R' :
			    type==act_write || type==act_writedelay ? 'W' :
			    '?';
			if(r.link==r) {
			    System.out.println(coName+": r.link==r!!!!");
			    System.exit(211);
			}
			System.out.print(" "+ch+"S");
			wrz(r.arg2, 2); // serno
			if (!empty) {
			    System.out.print("/");
			    wrz(r.arg5, 4);
			}
			r = r.link;
		    }

		    System.out.println("");
		}
	    }
	}

    }
}


//**********************************************************************
//**************************** Clock ***********************************
//**********************************************************************

class Clock extends Task {

    // The clock is less accurate if tickspersecond is > 10
    // under this version of Java
    public final static int tickspersecond = 10;

    public Clock(String name, Globals g, int pri) {
	super(name, g, pri);
	startTask();
    }

    public Object fn(Object pkt) {
        int msecs = 1000/tickspersecond;

        //System.out.println("Clock: entering tick loop");

        while(true)
	{   //msecs = 2000;
	    //System.out.println("Clock: fn: calling delay("+msecs+")");
            realdelay(msecs);
	    //prclkq();
    	    tick();
	}
    }

    public synchronized Pkt getpkt() {
	// Override getpkt in Task since packet sent to the clock
	// are place in the special clock queue (not wkq) and are
	// removed by the tick method. This version of getpkt
	// is only called when fn(taskwait()) is called when the
	// clock task is created.

	//System.out.println(t.taskName+": getpkt setting taskwaiting=true");
	taskwaiting = true;
	notifyAll();  // cause taskwaitingWait() to resume

	return null;
    }

    public synchronized void prwrkq() {
	Pkt p = wkq;
	if (p==null) {
	System.out.println("clock wkq is empty");
	} else {
	    System.out.println("clock wkq:");
	    while (p!=null) {
		String pname = p.task==null ? "<null>" : p.task.taskName;
		System.out.print  ("   res1: "); wrn(p.res1, 3);
		System.out.print  (" arg1: "); wrn(p.arg1, 5);
		System.out.println(" from: "+pname);
		p = p.link;
	    }
	}
    }

    public synchronized boolean putpkt(Pkt pkt) {
	// This clock version override putpkt in class Task

	// This is called in the destination task (the clock), pkt.id is
	// already set to the sending task.

	int ticks = pkt.arg1;

        //System.out.println(t.taskName+": putpkt with delay "+
        //                    ticks+" ticks");

        if (ticks<=0) {
	    // Return the packet immediately
	    System.out.println(
		  "Clock: ticks<=0 so returning packet immediately");
	    if (!currco.qpkt(pkt)) {
		System.out.println("Clock: trouble returning pkt");
		return false;
	    }
	    return true;
	}

	// Insert the packet into the clock queue
        if(wkq==null) {
	    wkq = pkt;
            pkt.link = null;
	    pkt.res1 = ticks;
            return true;
	}

	if (ticks<wkq.res1) {
	    // Insert at the head of the clock queue
	    wkq.res1 -= ticks; // Correct the res1 field of the next packet
	    pkt.res1 = ticks;
	    pkt.link = wkq;
	    wkq = pkt;
	    return true;
	}

	Pkt p = wkq;
	ticks -= p.res1;
	while (true) {
	    Pkt q  = p.link;
	    if (q==null) {
		// No more packets on the queue
		pkt.link = null;
		p.link = pkt;
		pkt.res1 = ticks;
		return true;
	    }

	    int dt = q.res1;
	    if (ticks < dt) {
		pkt.link = q;
		p.link = pkt;
		pkt.res1 = ticks;
		q.res1 -= ticks;
		return true;
	    }
	    ticks -= dt;
	    p = q;
	}
    }

    public synchronized void tick() {
	// This is called by the thread on every clock tick.
	// It is synchronised since other tasks may be inserting
	// packets into the clock queue.


  // Decrement res1 field of leading clock pkt, if any, and
  // if res1 is now <=0 send to its task. Any further clock
  // packets that have res1<=0 should also be released.
	//System.out.println(taskName+": tick: Tick entered");
	//prclkq();

	if (wkq!=null) {
	    int ticks = wkq.res1-1; // Number of ticks to go.
            wkq.res1 = ticks;
	    if (ticks%10==20) {
		//System.out.print(taskName+": tick: Ticks to go:");
		//wrn(ticks, 3);
		//System.out.println("");
	    }
	    // Release all expired clock packets
	    while (wkq!=null && wkq.res1<=0) {
		Pkt pkt = wkq;
		wkq = wkq.link;
		pkt.link = null;
		// Be careful to synchronize on the right task
		//System.out.println(taskName+": tick: returning expired pkt to "+
		//		   pkt.task.taskName);
		if (!currco.qpkt(pkt)) {
		    System.out.println(taskName+
                              ": tick: trouble returning expired pkt");
		}
	    }
	}
    }
}

//**********************************************************************
//**************************** Bounce **********************************
//**********************************************************************

class Bounce extends Task {

    public Bounce(String name, Globals g, int pri) {
	super(name, g, pri);
	startTask();
    }
        
    public Object fn(Object c) {
	// Create the echo coroutine.
	//System.out.println(coName+": creating logger, serno="+serno);
	Cortn echoco = new Echoco(t.taskName, this);
	//System.out.println(loggerco.coName+": Logger Coroutine created");

        //System.out.println(t.taskName+": fn entered");
        Pkt pkt = (Pkt) c;
	int count = 0;

        qpkt(pkt); // Return the startup packet

        while(true) {
	    pkt = taskwait();
	    switch (pkt.type) {
	    default:
		System.out.println(taskName+
				   ": unexpected packet received, type="+
				   pkt.type);
		continue;

	    case act_bounce:
		count++;
		//System.out.println(taskName+": pkt received");
		//realdelay(500);
                for(int i=1; i<=10; i++) callco(echoco, null);

		qpkt(pkt);
		continue;

	    case act_die:
		pkt.res1 = count;
		qpkt(pkt);
		break;     // Cause the thread to die
	    }
	}
    }
}

//**********************************************************************
//*************************** Echoco ***********************************
//**********************************************************************

class Echoco extends Cortn {
    // This is the echo coroutine used in the bounce thread to maintain
    // a reasonably high coroutine change to thread change ration.

    public Echoco(String name, Cortn parent) {
	super(name+"Log", parent);
	startCoroutine(parent);

	//System.out.println(coName+": suspended in c = fn(cowait(c)) loop");
    }

    public Object fn(Object arg) {
	//System.out.println(coName+": Coroutine fn entered");

	if (g.tracing)
	    System.out.println(coName+": ready");

	while(true) {
	    Object x;
	    //if (g.tracing)
	    //System.out.println(coName+": calling cowait");
	    x = cowait(null);
	}
    }
}

//**********************************************************************
//*************************** Printer **********************************
//**********************************************************************

class Printer extends Task {

    public Printer(String name, Globals g, int pri) {
	super(name, g, pri);
	startTask();
    }
        
    public Object fn(Object c) {
        //System.out.println(t.taskName+": fn entered");
        Pkt pkt = (Pkt) c;
	int count = 0;

        qpkt(pkt); // Return the startup packet

        while(true) {
	    pkt = taskwait();
	    switch (pkt.type) {
	    default:
		System.out.println(taskName+
				   ": unexpected packet received, type="+
				   pkt.type);
		continue;

	    case act_print:
		count++;
		if (count%10==0 && g.tracing)
		    System.out.println(taskName+": act_print, count="+count);
		//realdelay(500);
		qpkt(pkt);
		continue;

	    case act_die:
		pkt.res1 = count;
		qpkt(pkt);
		break;     // Cause the thread to die
	    }
	}
    }
}

//**********************************************************************
//************************** Controller ********************************
//**********************************************************************

class Controller extends Task {
    // This class is for the Controller task.

    int rdclientcount;
    int wrclientcount;
    int outstandingpkts; //Number of pkts sent but not received
    int countmax;

    public Controller(String name, Globals g, int pri) {
	super(name, g, pri);
	setmainco_ready(true);
	startTask();
    }

    public Object fn(Object c) {
	//System.out.println(coName+": fn entered");
	//System.out.println(coName+": calling new Ctrlmainco(..)");
	Cortn mainco = new Ctrlmainco("Ctrlmainco", this);

	//System.out.println(coName+": mainco created");

	if (false)
	{   Cotest cotest = new Cotest("Cotest", g, Thread.MAX_PRIORITY);
	    if (g.tracing) System.out.println("Cotest: Task created");
	    sendpkt(new Pkt(null, cotest, 0, 0, 0, 123));
	    System.exit(212);
	}

	//System.out.println(coName+": Calling gomultievent(mainco)");
        gomultievent(mainco);
	return null;
    }
}

//**********************************************************************
//************************** Ctrlmainco ********************************
//**********************************************************************

class Ctrlmainco extends Cortn {
    Controller ct;

    public Ctrlmainco(String name, Cortn parent) {
	super(name, parent);
	ct = (Controller)t;

	//System.out.println(coName+": calling startCoroutine(..)");
	startCoroutine(parent);
    }

    public Object fn(Object arg) {
	realdelay(1000);
	//System.out.println(coName+": fn entered");
	//System.out.println(coName+": entered, parent="+parent.coName);

	ct.rdclientcount = g.climax;
	ct.wrclientcount = g.climax;
	ct.outstandingpkts = 0;

	g.clock = new Clock("Clock", g, Thread.MAX_PRIORITY);
	if (g.tracing) System.out.println(coName+": Clock device created");

        Pkt bouncepkt = new Pkt(null, g.bounce, act_bounce, 0, 0);

        Pkt clockpkt = new Pkt(null, g.clock, act_clock, 0, 0,
			       Clock.tickspersecond/10, 5555);
	//Clock.tickspersecond*1);

	if (g.tracing)
	    System.out.println(coName+": Clock packet period = "+
			       (clockpkt.arg1*1000/10)+" msecs");

        //Pkt printerpkt = new Pkt(null, g.printer, act_print, 0, 0);

	int count = 0;
	int maxcount = 1;

	// Possibly run the clock test
	if (g.testno==3)
	{
	    System.out.println("\nRunning the clock test\n");

	    qpkt(new Pkt(null, g.clock, 0, 0, 0, 10*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0,  3*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0,  2*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0, 18*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0, 11*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0, 14*Clock.tickspersecond));
	    qpkt(new Pkt(null, g.clock, 0, 0, 0, 20*Clock.tickspersecond));

	    while (true) {
		//prclkq();
		Pkt pkt = taskwait();
                int t = pkt.arg1 / Clock.tickspersecond;

		System.out.println("Clock pkt returned, t="+t);
		wrtime("");
		if (t==20) break;
	    }
	    System.exit(213);
	}

	// Possibly run the bounce test 
	if (g.testno==4)
	{   System.out.println("\nRunning the bounce test\n");
	    wrtime("");
	    for (int i = 1; i<=1000000; i++) {
		if (i%100000==0) {
		    System.out.println("Sending bounce packet "+i);
		}
		qpkt(bouncepkt);    //) Takes 49 seconds on 1GHz Pentium III
		taskwait();         //)

		//sendpkt(bouncepkt); //  Takes 51 seconds on 1GHz Pentium III

		//sndpkt(bouncepkt);  //  Takes 64 seconds on 1GHz Pentium III

	    }
	    System.out.println("Bounce test done");
	    wrtime("");
	    System.exit(214);
	}

	System.out.println(coName+": Calibrating the bounce counter");

	t.setmainco_ready(true);

        int loopcount = 1;
	count = 0;

	//System.out.println(coName+": NOT sending clockpkt to the clock");
	//System.out.println(coName+": sending clockpkt to the clock");
	if (!qpkt(clockpkt)) {
	    // Send a clock packet which should return in 100 msecs
	    System.out.println(coName+": qpkt to clock failed");
	    System.exit(215);
	}
        ct.outstandingpkts++;   // Clock pkt is outstanding

	//prclkq();
	qpkt(bouncepkt); // Send the first bounce packet
        ct.outstandingpkts++;   // Bounce pkt is outstanding

	while (ct.outstandingpkts>0) {
	//while (true) {
	    //System.out.println(coName+": waiting for a packet from "+
	    //                    "gomultievent");

	    g.incchangeco();
	    // Get the next packet from gomultievent.
	    t.setmainco_ready(true);
	    Pkt pkt = (Pkt)cowait(null);
	    t.setmainco_ready(false);

	    // It should from either the clock or the bounce task

	    if (pkt==bouncepkt) {
		ct.outstandingpkts--;
		count++;
		if (count%1000==-1) {
		    //System.out.print(coName+
		    //	     ": bounce packet received, count=");
		    //wrn(count, 5);
		    //System.out.println("");
		}

		if (loopcount<10) {
		    if (!qpkt(bouncepkt)) {
			System.out.println("qpkt(bouncepkt) failed");
		    }
		    ct.outstandingpkts++;
		}

		continue;
	    }

	    if (pkt==clockpkt) {
		ct.outstandingpkts--;
		// Ignore first few counts
		if (loopcount>3) {
		    if (count==0) count = 1;
		    if (ct.countmax < count) ct.countmax = count;
		    int u = 1000*(ct.countmax-count)/ct.countmax/101; // 0..9
		    if (u<0 || u>9) {
			System.out.println("Utilisation u="+u+" out of range");
			System.exit(216);
		    }
		    g.utilisationv[u]++;
		    //System.out.print("utilisation = "); wrn(u, 3);
		    //System.out.print("  count = ");     wrn(count, 5);
		    //System.out.print("  countmax = ");  wrn(ct.countmax, 5);
		    //System.out.println("");
		}

		++loopcount;

		if (loopcount<10) {
		    if (!qpkt(clockpkt)) {
			System.out.println("qpkt(clockpkt) failed");
		    }
		    ct.outstandingpkts++;
		}

		count = 0;
		continue;
	    }

	    System.out.println(coName+": Unexpected packet received");
	    System.exit(217);
	}

	//System.out.println("\n"+coName+": outstandingpkts = "+
        //                   ct.outstandingpkts+"\n");
	//System.out.println("\n"+coName+": countmax = "+ct.countmax+"\n");

	//System.exit(218);

	t.setmainco_ready(false);

	// Startup all the mpx tasks
	for (int mpxno = 1; mpxno<=g.mpxmax; mpxno++) {
	    Pkt pkt = new Pkt(null, g.mpxv[mpxno], act_startmpx,
                              0, 0, mpxno);
            sndpkt(pkt);
	}

	// Startup all the read server tasks
	for (int serno = 1; serno<=g.sermax; serno++) {
	    Pkt pkt = new Pkt(null, g.rdserverv[serno], act_startrdserver,
                              0, 0, serno);
            sndpkt(pkt);
	}

	//System.out.println("\nController: Real delay 10000 msecs\n");
	//t.realdelay(10000);
	//System.out.println("\nController: Real delay 10000 msecs done\n");
	//System.exit(219);

	// Startup all the write server tasks
	for (int serno = 1; serno<=g.sermax; serno++) {
	    Pkt pkt = new Pkt(null, g.wrserverv[serno], act_startwrserver,
                              0, 0, serno);
            sndpkt(pkt);
	}

	// Initialise all the read client tasks
	for (int clino = 1; clino<=g.climax; clino++) {
	    Pkt pkt = new Pkt(null, g.rdclientv[clino], act_startrdclient,
                              0, 0, clino);
            sndpkt(pkt);
	}

	// Initialise all the write client tasks
	for (int clino = 1; clino<=g.climax; clino++) {
	    Pkt pkt = new Pkt(null, g.wrclientv[clino], act_startwrclient,
                              0, 0, clino);
            sndpkt(pkt);
	}

	// Each of the above tasks will have returned their startup
	// packets but will have not proceeded (under Tripos) further
	// since the controller runs at higher priority.

	System.out.println(coName+": All tasks initialised\n");
	wrtime("Start  time:");
	//System.exit(220);

	System.out.println("\n"+coName+": Release all read clients");

	// Release all the read client tasks
	for (int clino = 1; clino<=g.climax; clino++) {
	    Pkt pkt = new Pkt(null, g.rdclientv[clino], act_releaserdclient,
                              0, 0);
	    if (g.tracing) {
		//System.out.print("NOT ");
		System.out.print("Releasing RC");
		wrz(clino,2);
		System.out.println("");
	    }
            sndpkt(pkt);
	}

	System.out.println(coName+": Release all write clients\n");

	// Release all the write client tasks
	for (int clino = 1; clino<=g.climax; clino++) {
	    //for (int clino = 2; clino<=2; clino++) {
	    //for (int clino = 1; clino<=1; clino++) {
	    Pkt pkt = new Pkt(null, g.wrclientv[clino], act_releasewrclient,
                              0, 0);
	    if (g.tracing) {
		System.out.print("NOT ");
		System.out.print("Releasing WC"); wrz(clino,2);
		System.out.println("");
	    }
            sndpkt(pkt);
	}

	//System.out.println("\nController: Real delay 11000 msecs\n");
	//t.realdelay(11000);
	//System.out.println("\nController: Real delay 11000 msecs done\n");
	//System.exit(221);


	if (g.tracing)
	    System.out.println(
                    "\nController: Starting the clock and bouncing again\n");

	count = 0;
	//if (g.tracing) {
	//    System.out.println(
	//		       "controller: sending clock packet, arg1="+
	//		       clockpkt.arg1);
	//}
	qpkt(clockpkt);
	ct.outstandingpkts++;
	qpkt(bouncepkt);
	ct.outstandingpkts++;

	t.setmainco_ready(true);

	while (ct.rdclientcount!=0 || ct.wrclientcount!=0 ||
	       ct.outstandingpkts>0) {
	    // This is the start of the main loop in the multi-event main
	    // coroutine of the controller. It receives packets from
	    // gomultievent, provided mainco_ready is TRUE.
	    // The expected packets are:

	    // act_rddone   from read clients
	    // act_wrdone   from write clients
	    // act_clock    from the clock every 1.0 seconds
	    // act_bounce   from the bounce task as fast as they can come

	    //if (g.tracing) {
	    //System.out.println("Controller: rdclientcount="+
	    //			   ct.rdclientcount);
	    //System.out.println("Controller: wrclientcount="+
	    //			   ct.wrclientcount);
	    //System.out.println("Controller: outstandingpkts="+
	    //			   ct.outstandingpkts);
	    //}

	    g.incchangeco();
	    //System.out.println("Controller: calling cowait in main loop");

	    t.setmainco_ready(true); // Should not be neccesary#########

	    Pkt pkt  = (Pkt)cowait(null);  // Get the next packet
	    //System.out.println("Controller: cowait => pkt from "+
	    //	       pkt.task.taskName);

	    int type = pkt.type;

	    t.setmainco_ready(false);

	    //if (g.tracing)
	    //  System.out.println("Controller: type="+pkt.type+
	    //		   " from task "+pkt.task.taskName);

	    switch (type) {
	    default:
		System.out.println("Controller: unexpected packet type "+type+
				   " from task "+pkt.task.taskName);

		// Return this unexpected  packet to its owner.
		qpkt(pkt);
		t.setmainco_ready(true);
		continue;

	    case act_clock:
		{
		    int u;
		    ct.outstandingpkts--;
		    //System.out.println(
                    //    "controller: clock packet received, count="+count);
		    //System.out.println("controller: rdclientcount="+
		    //	       ct.rdclientcount+" wrclientcount="+
		    //	       ct.wrclientcount+" outstandingpkts="+
		    //	       ct.outstandingpkts);

		    if (ct.rdclientcount!=0 || ct.wrclientcount!=0) {
			// Send the packet back to the clock device.
			//if (g.tracing) {
			//    System.out.println(
			//      "controller: sending clock packet, arg1="+
                        //      pkt.arg1);
			//}
			qpkt(pkt);
			ct.outstandingpkts++;
		    }

		    if (count==0) count = 1;
		    if (ct.countmax < count) ct.countmax = count;

		    u = 1000*(ct.countmax-count)/ct.countmax/101;  // 0..9

		    if (u<0 || u>9) {
			System.out.println("Utilisation u="+u+" out of range");
		    }
		    g.utilisationv[u]++;
		    //System.out.print("utilisation = "); wrn(u,3);
		    //System.out.print("  count = "); wrn(count,5);
		    //System.out.print(" countmax = "); wrn(ct.countmax,5);
		    //System.out.println("");

		    count = 0;
		    t.setmainco_ready(true);
		    continue;
		}

	    case act_bounce:
		ct.outstandingpkts--;
		count++;
		if (ct.rdclientcount==0 && ct.wrclientcount==0) break;
		if (count%1000==0) {
		    //System.out.println("Bounce pkt received, count="+count);
		}

		if (ct.rdclientcount!=0 || ct.wrclientcount!=0) {
		    // Send the packet back to the bounce task.
		    qpkt(pkt);
		    ct.outstandingpkts++;
		}
		t.setmainco_ready(true);
		continue;

	    case act_rddone:  // arg1: clino
		{
		    int clino = pkt.arg1;
		    ct.rdclientcount--;
		    g.rdclientv[clino] = null;
		    //if (g.tracing) {
		    //System.out.println("Controller: rdclientcount="+
		    //		   ct.rdclientcount);
		    //}
		    // Return the packet to its read client.
		    qpkt(pkt);
		    t.setmainco_ready(true);
		    continue;
		}

	    case act_wrdone:  // arg1: clino
		{
		    int clino = pkt.arg1;
		    ct.wrclientcount--;
		    g.wrclientv[clino] = null;
		    //if (g.tracing) {
		    //System.out.println("Controller: wrclientcount="+
		    //		   ct.wrclientcount);
		    //}

		    // Return the packet to its write client.
		    qpkt(pkt);
		    t.setmainco_ready(true);
		    continue;
		}
	    } // End of switch
	}

	//System.out.println("\nCalling taskdelay(1000)");
	//taskdelay(1000);
	wrtime("Finish time:");

	// All client tasks have completed their schedules of work.

	if (g.tracing) {
	    System.out.println(t.taskName+
		     ": All clients have finished their schedule of work");
	}

	// Send die packets to the server tasks and recover their checksums
	int rdsum=0, wrsum = 0;

	for (int serno = 1; serno<=g.sermax; serno++) {

	    //if (g.tracing) {
	    //System.out.print(t.taskName+": Sending die packet to RS");
	    //wrz(serno, 2);
	    //System.out.println("");
	    //}
	    int val = sendpkt(new Pkt(null,g.rdserverv[serno],
				       act_die, 0, 0, 0, serno));
	    rdsum = (rdsum+val) % 1000000;
	    //if (g.tracing) {
	    //System.out.print(t.taskName+": Sending die packet to RS");
	    //wrz(serno, 2);
	    //System.out.println("");
	    //}


	    //if (g.tracing) {
	    //System.out.print(t.taskName+": Sending die packet to WS");
	    //wrz(serno, 2);
	    //System.out.println("");
	    //}

	    val = sendpkt(new Pkt(null, g.wrserverv[serno],
				  act_die, 0, 0, 0, serno));
	    wrsum = (wrsum+val) % 1000000;
	}


	if (rdsum==wrsum) {
	    System.out.println("\nController: rdsum=wrsum="+rdsum+"  -- Good");
	} else {
	    System.out.println("\nController: rdsum="+rdsum+
			       " but wrsum="+wrsum);
	}

	// The clients have completed their work.

	// Send die packets to the mpx tasks

	for (int mpxno = 1; mpxno<=g.mpxmax; mpxno++) {
	    //if (g.tracing) {
	    //System.out.print(t.taskName+": Sending die packet to M");
	    //wrz(mpxno, 2);
	    //System.out.println("");
	    //}
	    sendpkt(new Pkt(null, g.mpxv[mpxno], act_die, 0, 0));
	}

	// Kill the bounce task

	//if (g.tracing) {
	//  System.out.println(t.taskName+
	//                     ": Sending die packet to bounce task");
	//}
	g.bouncecount = sendpkt(new Pkt(null, g.bounce,
					act_die, 0, 0));
	//if (g.tracing) {
	//    System.out.println(t.taskName+": bouncecount="+g.bouncecount);
	//}
	g.bounce = null;

	// Kill the printer task

	//if (g.tracing) {
	//    System.out.println(t.taskName+
        //                       ": Sending die packet to printer task");
	//}
	g.printcount = sendpkt(new Pkt(null, g.printer,
				       act_die, 0, 0));
	//if (g.tracing) {
	//    System.out.println(t.taskName+": printcount="+g.printcount);
	//}
	g.printer = null;

	//if (g.tracing) {
	//    System.out.println(t.taskName+": Setting multi_done to true");
	//}

	t.multi_done = true;

	//fin:
	//sys(Sys_inc, @changecocount, 1)
	//cowait(0)
	//sawritef("Controller: this point should not be reached*n")
	//GOTO fin




	g.printstats();
	// The test is now complete
	System.out.println("\nTest completed");
	System.exit(0);

	return null;
    }
}

class Rnd {
     private int seed1;
     private int seed2;

     public Rnd(int a, int b) {
	 seed1 = a & 0xFFFFFFF;
	 seed2 = b & 0xFFFFFFF | 1; // Ensure that they are not both zero
         int k = next(50) + 10;
         for(int i = 1; i<=k; i++) next(1000);
    }

    public int next(int max) {
 	 int val = (seed1 + seed2) & 0xFFFFFFF;
	 seed1 = seed2;
	 seed2 = val;
         return val % max + 1;
    }
}
