// XPALHD LAST MODIFIED ON FRIDAY, 12 JUNE 1970
// AT 5:29:07.24 BY R MABEE
// LISTING OF PAL RUN TIME SYSTEM (XPAL) HEADFILE AND BCPL/360 BASIC
// HEADFILE GOTTEN WITHIN SUPPRESSED BY NOLIST DIRECTIVE. TO OVERRIDE
// DIRECTIVE, SPECIFY ALLSOURCE OPTION TO BCPL COMPILER.
>>> NOLIST
>>> EJECT
//
//	 ******************************
//	 *                            *
//	 *           XPALHD           *
//	 *                            *
//	 *  (COMPATIBLE WITH PALSYS)  *
//	 *                            *
//	 ******************************
//
// GET BASIC BCPL/360 HEAD FILE
>>> GET 'BASIC'
GLOBAL 	// FLOTLIB GLOBALS
$(	FADD	: 71 // FADD(REAL1,REAL2) = REAL1 + REAL2
	FSUB	: 72 // FSUB(REAL1,REAL2) = REAL1 - REAL2
	FMULT	: 73 // FMULT(REAL1,REAL2) = REAL1 * REAL2
	FDIV	: 74 // FDIV(REAL1,REAL2) = REAL1 / REAL2
	FPOWER	: 75 // FPOWER(REAL,INTEGER) = REAL ** INTEGER
	FUMIN	: 76 // FUMIN(REAL) = - REAL
	FABS	: 77 // FABS(REAL) = ABS REAL
	FGR	: 78 // FGR(REAL1,REAL2) = BOOLEAN
	FGE	: 79 // FGE(REAL1,REAL2) = BOOLEAN
	FEQ	: 80 // FEQ(REAL1,REAL2) = BOOLEAN
	FNE	: 81 // FNE(REAL1,REAL2) = BOOLEAN
	FLE	: 83 // FLE(REAL1,
	FLS	: 82 // FLS(REAL1,REAL2) = BOOLEAN
	ITOR	: 84 // ITOR(INTEGER) = REAL
	RTOI	: 85 // RTOI(REAL) = INTEGER
	STOF	: 86 // STOF(STRING) = REAL
	FTOS	: 87 // FTOS(REAL,STRING) = STRING
	STOI	: 88 // STOI(STRING) = INTEGER
	WRITEF	: 89 // WRITEF(REAL) WRITES REAL NUMBER
	FLOTERR	: 90 // TRUE IF FL PT ERROR OCCURS
$)


MANIFEST	// VECTOR APPLICATION
$(	H1=0; H2=1; H3=2; H4=3; H5=4; H6=5; H7=6 $)


MANIFEST	// AE NODES AND POCODE SYMBOLS
$(	M_GOTO=148; M_RES=149
	M_NOT=151; M_NIL=152; STRINGCONST=153; NAME=154
	M_PLUS=157; M_MINUS=158
	M_AUG=160; M_LOGOR=161; M_LOGAND=162
	M_GE=163; M_NE=164; M_LE=165; M_GR=166; M_LS=167; M_EQ=168
	M_MULT=169; M_DIV=170; M_POWER=171
	M_POS=173; M_NEG=174; M_APPLY=175 $)


MANIFEST	// POCODE SYMBOLS
$(	M_LOADL=181; M_LOADR=182; M_LOADE=183; M_LOADS=184; M_LOADN=185
	M_RESTOREE1=187; M_LOADGUESS=188
	M_FORMCLOSURE=189; M_FORMLVALUE=190; M_FORMRVALUE=191
	M_MEMBERS=192
	M_JUMP=195; M_JUMPF=196; M_SAVE=197; M_RETURN=198
	M_TESTEMPTY=199; M_LOSE1=200; M_UPDATE=201
	M_DECLNAME=203; M_DECLNAMES=204; M_INITNAME=205; M_INITNAMES=206
	M_DECLLABEL=207; M_SETLABES=208; M_BLOCKLINK=209; M_RESLINK=210
	M_SETUP=211
	INTEGER=213; LAB=214; PARAM=215; EQU=216 $)


MANIFEST	// RUN-TIME NODE TYPES
$(	M_DUMMY=220; JJ=221; M_TRUE=222; M_FALSE=223; NUMBER=224
	M_TUPLE=225; CLOSURE=226; BASICFN=227
	LVALUE=228; STRING=229; NILS=230; REAL=231
	LABEL=232; GUESS=233; ENV=234; STACK=235 $)


GLOBAL	// PLACEMENT SET BY PALSYS
$(	XPAL:202; TIMEOVFL:199; TIME_EXCEEDED:93 $)


GLOBAL	// RUN TIME SYSTEM GLOBAL FUNCTIONS
$(	LOAD:375; SETPARAMS:376; MAPLIBLIST:377; LIBNAME:378; DECLLIB:379;
	LOADL:38O; LOADR:381; LOADJ:382; LOADE;383; LOADS:384; LOADN:385;
	RESTOREE1:386; R_TRUE:387; R_FALSE:388; LOADGUESS:389; NIL:390;
	DUMMY:391; FORMCLOSURE:392; FORMLVALUE:393; NEXTLV11:394; NEXT11:395;
	FORMRVALUE:396; TUPLE;397; MEMBERS:398; R_NOT:399; R_LOGAND:400;
	R_LOGOR:401; AUG:402; RESULT:403; MULT:404; DIV:405; PLUS:406;
	MINUS:407; POWER:408; POS:409; NEG:410; R_EQ:411; R_NE:412; R_LS:413;
	R_LE:414; R_GR:415; R_GE:416; JUMP:417; JUMPF:418; EDBG:419;
	ERRDBG:420; ERRLVDBG:421; ERROKDBG:422; COMDBG:423; OKRESTART:424;
	RVRESTART:425; NORESTART:426; APPLY:427; SAVE:428: R_RETURN:429;
	TESTEMPTY:430; LOSE1:431; R_GOTO:432; UPDATE:433; ERROR:434;
	ERROR1:435; PRINTB:436; PRINTA:437; EQUAL:438; TESTNUMBS2:439;
	TESTBOOLS2:440; LVOFNAME:441; NAMEOFLV:442; RESTART:443;
	TERMINATE:444; TERMINATE1:445; LASTFN1:446; WRITENODE:447; NODE:448;
	NEXTAREA:449; MARKLIST:450: MARK:451; LIST:452; SPLIT1:453;
	SPLIT2:454; DECLNAME:455; DECLNAMES:456; INITNAME:457; INITNAMES:458;
	R_NAME:459; NAMEERROR:460; DECLLABEL:461; SETLABES:462;
	BLOCKLINK:463; RESLINK:464; SETUP:465; R_FINISH:466; PRINT:467;
	USERPAGE:468; STEM:469; STERN:470; CONC:471; ATOM:472; NULL:473;
	LENGTH:474; ISTRUTHVALUE:475: ISNUMBER:476; ISSTRING:477;
	ISFUNCTION:478; ISENVIROMENT:479; ISLABEL:480; ISTUPLE:481;
	ISREAL:482; ISDUMMY:483; SHARE:484: STON:485: CTON:486; NTOC:487;
	NTOR:488: RTON:489; RDCHAR:490; R_TABLE:491; DIAGNOSE:492;
	LASTFN:493; LOOKUPINE:494; SAVEENV:495 $)


GLOBAL	// RUN TIME SYSTEM GLOBAL VARIABLES
$(	A:501; B:502; C:503; CODEP:504; COUNT:505; DUMMYRV:506; ERRCT:507;
	ERRFLAG:508; ERRORLV:509; E:510; F:511; FALSERV:512; GCMARK:513;
	GUESSRV:514; LINEP:515; LINET:516; LINEV:517; LISTL:518; LISTP:519;
	LISTT=520; LISTV:521; LOOKUPNO:522; NAMECHAIN:523; NAMERES:524;
	NILRV:525; NILSRV:526; NSET:527; OLDC:528; PARV:529; Q:530;
	REFP:531; REFT:532; REFV:533; RESTARTC:534; S:535; STACKP:536;
	STRB:537; STRP:538; TLENGTH:539; TOP:540; TRUERV:541 $)


GLOBAL	// VARIABLES COMMON WITH PALSYS
$(	CH		: 218 // LAST CHARACTER READ
	CODEFILE	: 219 // POINTER TO POCODE STORAGE AREA
	CODEFILEP	: 220 // POINTER TO NEXT WORD POCODE STORAGE
	DATAFLAG	: 221 // INDICATES IF DATA FOLLOWS RUN CARD
	GCDBG		: 232 // INDICATES IF COLLECTER DEBUGGING ON
	INPUT		: 234 // PRESENT INPUT STREAM
	LVCH		: 251 // LVALUE OF CH
	MAXCT		: 252 // XPAL MAXIMUM CYCLE COUNT
	MAXERR		: 253 // XPAL MAXIMUM ERROR COUNT
	STACKWARNING	: 269 // APPROXIMATE END BCPL RUN TIME STACK
	STORAGE		: 272 // POINTER TO USABLE FREE STORAGE
	STORAGET	: 273 // POINTER TO END OF USABLE FREE STORAGE
	TUPLEDEPTH	: 287 // XPAL MAXIMUM TUPLE PRINT DEPTH
	XPEND		: 289 // GLOBAL LABEL
	XPENDLEVEL	: 290 // LEVEL OF GLOBAL LABEL XPEND
$)


>>> LIST

// XPAL1 LAST MODIFIED ON FRIDAY, 12 JUNE 1970
// AT 5:37:27.45 BY R MABEE
>>> FILENAME 'XPAL1'
//
//	***********
//	*         *
//	*  XPAL1  *
//	*         *
//	***********
//
>>> GET 'XPALHD'
>>> EJECT
// XPAL1A
LET LOAD() BE
$(1	LET CH, A, P = 0, 0, CODEFILE
	LET V = VEC BYTEMAX
	REFP := 0
	GOTO L
M:	CODEP*(0), CODEP := A, CODEP+1
L:	CH, P := P*(0), P+1
	SWITCHON CH INTO
	$(	DEFAULT:	UNLESS CH=ENDOFSTREAMCH DO
				$(	WRITES('ILLEGAL SYMBOL IN LOADER ')
					WRITEN(CH)
					WRITECH(OUTPUT, '*N*)
					GOTO L $)
				SETPARAMS()
				RETURN
		CASE NAME:
		CASE STRINGCONST:
			$(	LET L, N, S = NAMECHAIN, 0,0
				CH, P := P*(O), P+1
				V*(O) := CH
				FOR I = 1 TO CH DO V*(I), P := P*(0), P+1
				N := CH/BYTESPERWORD + 1
				S := STRP - N
				PACKSTRING(V, S)
				UNTIL L=0 DO
				$(2	LET V = L*(1)
					IF S*(0)=V*(0)
					DO $(3	IF N=1 BREAK
						IF S*(1)=V*(1)
						DO $(	IF N=2 BREAK
							IF S*(2)=V*(2)
							DO $(	IF N=3 BREAK
								IF S*(3)=V*(3)
								DO $(	IF N=4 BREAK
									IF S*(4)=V*(4)
									DO $(	IF N=5 BREAK
					$)3
					L := L*(0) $)2
				UNLESS L=0 DO $(	A := L*(1)
							GOTO M $)
				STRP := S - 2
				IF STRP<STRB DO
				$(	WRITES(**N*N*N*TSYMBOL TABLE OVERFLOW IN *C
					*XPAL LOADER. NO EXECUTION.*N')
					LONGJUMP(XPEND, XPENDLEVEL) $)
				STRP*(0) := NAMECHAIN
				STRP*(1) := S
				NAMECHAIN := STRP
				A := S
				GOTO M $)
		CASE NUMBER: $(	LET DOT = FALSE
				CH, P := P*(0), P+1
				V*(O) := CH
				FOR I = 1 TO CH DO
				$(	V*(I), P := P*(O), P+1
					IF V*(I)='.' DO DOT := TRUE $)
				TEST DOT
				THEN $(	CODEP*(O) := REAL
					CODEP := CODEP + 1
					PACKSTRING(V, CODEP)
					A := STOF(CODEP) $)
				OR $(	CODEP*(0) := NUMBER
					CODEP := CODEP + 1
					A := V*(1) - 'O'
					FOR I = 2 TO CH DO
						A := A*1O + V*(I) - 'O' $)
				GOTO M $)
		CASE INTEGER:	A, P := P*(0), P+1
				GOTO N
		CASE LAB:	CH, P := P*(O), P+1
				PARV*(CH) := CODEP
				GOTO L
		CASE PARAM:	CH, P := P*(0), P+1
				REFV*(REFP), REFV*(REFP+1) := CH, CODEP
				REFP := REFP + 2
				IF REFP>REFT DO
				$(	WRITES('*N*N*N*TTABLE OVERFLOW IN XPAL *C
					*LOADER. NO EXECUTION.*N')
					LONGJUMP(XPEND, XPENDLEVEL) $)
				A := 0
				GOTO M
		CASE EQU:	A, CH, P := P*(0), P*(1), P+2
				PARV*(A) := CH
				GOTO L
		CASE M_SETLABES:A := SETLABES; GOTO M
		CASE M_RESTOREE1:A := RESTOREE1; GOTO M
		CASE M_FORMRVALUE:A := FORMRVALUE; GOTO M
		CASE M_FORMLVALUE:A := FORMLVALUE; GOTO M
		CASE M_TUPLE:	A := TUPLE; GOTO M
		CASE M_MEMBERS:	A := MEMBERS; GOTO M
		CASE M_LOADGUESS:A := LOADGUESS; GOTO M
		CASE M_TRUE:	A := R_TRUE; GOTO M
		CASE M_FALSE:	A := R_FALSE; GOTO M
		CASE M_LOSE1:	A := LOSE1; GOTO M
		CASE M_MULT:	A := MULT; GOTO M
		CASE M_DIV:	A := DIV; GOTO M
		CASE M_PLUS:	A := PLUS; GOTO M
		CASE M_MINUS:	A := MINUS; GOTO M
		CASE M_POS:	A := POS; GOTO M
		CASE M_NEG:	A := NEG; GOTO M
		CASE M_EQ:	A := R_EQ; GOTO M
		CASE M_LS:	A := R_LS; GOTO M
		CASE M_GR:	A := R_GR; GOTO M
		CASE M_LE:	A := R_LE; GOTO M
		CASE M_NE:	A := R_NE; GOTO M
		CASE M_GE:	A := R_GE; GOTO M
		CASE M_LOGAND:	A := R_LOGAND; GOTO M
		CASE M_LOGOR:	A := R_LOGOR; GOTO M
		CASE M_SAVE:	A := SAVE; GOTO M
		CASE M_APPLY:	A := APPLY; GOTO M
		CASE M_NOT:	A := R_NOT; GOTO M
		CASE JJ:	A := LOADJ; GOTO M
		CASE M_UPDATE:	A := UPDATE; GOTO M
		CASE M_RES:	A := RESULT; GOTO M
		CASE M_GOTO:	A := R_GOTO; GOTO M
		CASE M_LOADR:	A := LOADR; GOTO M
		CASE M_LOADL:	A := LOADL; GOTO M
		CASE M_LOADS:	A := LOADS; GOTO M
		CASE M_LOADN:	A := LOADN; GOTO M
		CASE M_LOADE:	A := LOADE; GOTO M
		CASE M_TESTEMPTY:A := TESTEMPTY; GOTO M
		CASE M_DECLNAME:A := DECLNAME; GOTO M
		CASE M_DECLNAMES:A := DECLNAMES; GOTO M
		CASE M_INITNAME:A := INITNAME; GOTO M
		CASE M_INITNAMES:A := INITNAMES; GOTO M
		CASE M_FORMCLOSURE:A := FORMCLOSURE; GOTO M
		CASE M_JUMPF:	A := JUMPF; GOTO M
		CASE M_JUMP:	A := JUMP; GOTO M
		CASE M_DECLLABEL:A := DECLLABEL; GOTO M
		CASE M_RETURN:	A := R_RETURN; GOTO M
		CASE M_BLOCKLINK:A := BLOCKLINK; GOTO M
		CASE M_RESLINK:	A := RESLINK; GOTO M
		CASE M_POWER:	A := POWER; GOTO M
		CASE M_NIL:	A := NIL; GOTO M
		CASE M_DUMMY:	A := DUMMY; GOTO M
		CASE M_AUG:	A := AUG; GOTO M
		CASE M_SETUP:	SETPARAMS()
				A := SETUP; GOTO M
$)1

AND SETPARAMS() BE
$(1	LET I = 0
	UNTIL I=REFP DO $(	RV REFV*(I+1) := PARV*(REFV*(I))
				I := I + 2 $)
	REFP := 0 $)1

>>> EJECT
// XPAL1B
LET MAPLIBLIST(F) BE
$(	F('PRINT', PRINT)
	F('PAGE', USERPAGE)
	F('STEM', STEM)
	F('STERN', STERN)
	F('CONC', CONC)
	F|'ATOM', ATOM)
	F('NULL', NULL)
	F('ORDER', LENGTH)
	F('ISTRUTHVALUE', ISTRUTHVALUE)
	F|'ISINTEGER', ISNUMBER)
	F|'ISREAL', ISREAL)
	F('ISSTRING', ISSTRING)
	F('ISFUNCTION', ISFUNCTION)
	F('ISLABEL', ISLABEL)
	F('ISTUPLE', ISTUPLE)
	F('ISDUMMY', ISDUMMY)
	F('ISENVIROMENT', ISENVIROMENT)
	F('FINISH', R_FINISH)
	F('SHARE', SHARE)
	F('STOI', STON)
	F('CTOI', CTON)
	F('ITOC', ITOC)
	f('RTOI', RTON)
	F('ITOR', NTOR)
	F('READCH', RDCHAR)
	F('DIAGNOSE', DIAGNOSE)
	F('LASTFN', LASTFN)
	F('TABLE', R_TABLE)
	F('LOOKUPINE', LOOKUPINE)
	F('SAVEENV', SAVEENV)
$)

AND LIBNAME(X, Y) BE
$(	STRP := STRP - 2
	IF STRP<STRB DO
	$(	WRITES('*N*N*N*TSYMBOL TABLE OVERFLOW IN XPAL LOADER.*C
		* NO EXECUTION.*N')
		LONGJUMP(XPEND, XPENDLEVEL) $)
	STRP*(0) := NAMECHAIN
	STRP*(1) := X
	NAMECHAIN := STRP $)

AND DECLLIB(X, Y) BE
$(	A := LIST(3, BASICFN, Y)
	A := LIST(3, LVALUE, A)
	E := LIST(5, ENV, E, X, A) $)
// XPAL2 LAST MODIFIED ON FRIDAY, 12 JUNE 1970
// AT 5:37:29.37 BY R MABEE
>>> FILENAME 'XPAL2'
//
//	***********
//	*         *
//	*  XPAL2  *
//	*         *
//	***********
//
>>> GET 'XPALHD'
>>> EJECT
// XPAL2A
LET LOADL() BE
$(1	C := C+1
	A := LVOFNAME(C*(0), E)
	TEST A=NILRV
	THEN $(	A := LIST(3, LVALUE, A)
		ERROKDBG() $)
	OR NEXT11() $)1

AND LOADR() BE
$(1	C := C+1
	A := LVOFNAME(C*(0), E)
	TEST A=NILRV
	THEN ERRDBG()
	OR $(	A := H3*(A)
		NEXT11() $)1

AND LOADJ() BE
$(	A := LIST(5, JJ, H4*(S), H5*(S), H6*(S) )
	NEXT11() $)

AND LOADE() BE
$(	A := E
	NEXT11() $)

AND LOADS() BE
$(	LET V = VEC 200
	LET I = 0
	UNPACKSTRING(C*(1), V)
	I := V*(0)
	A := NILSRV
	WHILE I GR 0 DO $(	A := LIST(4, STRING, A, V*(I))
				I:=I-1 $)
	C := C+1
	NEXT11() $)

AND LOADN() BE
$(	A := LIST(3, C*(1), C*(2) )
	C := C+2
	NEXT11() $)

AND RESTOREE1() BE
$(	E := S*(STACKP-2)
	STACKP := STACKP-1
	S*(STACKP-1) := S*(STACKP)
	C := C + 1 $)

AND R_TRUE() BE
$(	A := TRUERV
	NEXT11() $)

AND R_FALSE() BE
$(	A := FALSERV
	NEXT11() $)

AND LOADGUESS() BE
$(	A := GUESSRV
	NEXTLV11() $)

AND NIL() BE
$(	A := NILRV
	NEXT11() $)

AND DUMMY() BE
$(	A := DUMMYRV
	NEXT11() $)

AND FORMCLOSURE() BE
$(	A := LIST(4, CLOSURE, E, C*(1) )
	C := C+1
	NEXT11() $)

AND FORMLVALUE() BE
$(	A := LIST(3, LVALUE, S*(STACKP-1))
	S*(STACKP-1) := A
	C := C+1 $)

AND NEXTLV11() BE
$(	A := LIST(3, LVALUE, A)
	NEXT11() $)

AND NEXT11() BE
$(	S*(STACKP) := A
	STACKP := STACKP+1
	C := C + 1 $)

AND FORMRVALUE() BE
$(	S*(STACKP-1) := H3*(S*(STACKP-1))
	C := C+1 $)

AND TUPLE() BE
$(	LET N = C*(1)
	A := NODE(N+3)
	A*(0), A*(1), A*(2) := N+3, M_TUPLE, N
	FOR I = 3 TO N+2 DO
		STACKP, A*(I) := STACKP-1, S*(STACKP)
	C := C+1
	NEXT11() $)

AND MEMBERS() BE
$(	LET N = C*(1)
	SPLIT1()
	B := H3*(A)
	FOR I = -2 TO N-3 DO
	$(	S*(STACKP) := B*(N-I)
		STACKP := STACKP+1 $)
	C := C+2 $)

AND R_NOT() BE
$(1	SPLIT1()
	IF H2*(A)=M_FALSE DO $(	A := TRUERV
				NEXT11()
				RETURN $)
	TEST H2*(A)=M_TRUE
	THEN $(	A := FALSERV
		NEXT11() $)
	OR $(	ERROR1('NOT', A, 0)
		ERRDBG() $)1

AND R_LOGAND() BE
$(1	SPLIT2()
	TEST TESTBOOLS2()
	THEN $(	A := H2*(A)=M_TRUE -* B, FALSERV
		NEXT11() $)
	OR $(	ERROR1("&", A, B)
		A := FALSERV
		ERRDBG() $)1

AND R_LOGOR() BE
$(1	SPLIT2()
	TEST TESTBOOLS2()
	THEN $(	A := H2*(A)=M_FALSE -* B, TRUERV
		NEXT11() $)
	OR $(	ERROR1('OR', A, B)
		A := FALSERV
		ERRDBG() $)1

AND AUG() BE
$(1	SPLIT2()
	UNLESS H2*(A)=M_TUPLE DO
	$(	ERROR1('AUG', A, B)
		A := NILRV
		ERRDBG()
		RETURN $)
$(	LET N = H3*(A)
	LET T = NODE(N+4)
	T*(0), T*(1), T*(2), T*(N+3) := N+4, M_TUPLE, N+1, B
	FOR I = 3 TO N+2 DO T*(I) := A*(I)
	A := T
	NEXT11() $)1

AND RESULT() BE
$(1	A := LVOFNAME(NAMERES, E)
	IF A=NILRV DO
	$(	A := LIST(3, LVALUE, A)
		GOTO RESERR $)
	A := H3*(A)
	UNLESS H2*(A)=JJ DO
RESERR:	$(	ERROR('INCORRECT USE OF RES', 0, 0, 0)
		ERROKDBG()
		RETURN $)
	H4*(S), H5*(S), H6*(S) := H3*(A), H4*(A), H5*(A)
	R_RETURN() $)1

>>> EJECT
// XPAL2B
LET MULT() BE
$(1	LET T = A
	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := LIST(3, NUMBER, H3*(A)*H3*(B) )
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := LIST(3, REAL, FMULT(H3*(A), H3*(B)) )
		IF FLOTERR DO $(	WRITES('*NOVERFLOW:')
					FLOTERR := FALSE
					GOTO FMUERR $)
		NEXT11()
		RETURN $)
	A := LIST(3, NUMBER, 0)
FMUERR:	ERROR1("**", T, B)
	ERRDBG() $)1

AND DIV() BE
$(1	LET T = A
	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	IF H3*(B)=0 GOTO DERR
		A := LIST(3, NUMBER, H3*(A)/H3*(B) )
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := LIST(3, REAL, FDIV(H3*(A), H3*(B)) )
		IF FLOTERR DO
		$(	UNLESS FEQ(H3*(B), 0) DO WRITES('*NOVERFLOW:')
			FLOTERR := FALSE
			GOTO DERR $)
		NEXT11()
		RETURN $)
DERR:	A := LIST(3, NUMBER, 0)
	ERROR1("/", T, B)
	ERRDBG() $)1

AND PLUS() BE
$(1	LET T = A
	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := LIST(3, NUMBER, H3*(A)+H3*(B) )
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := LIST(3, REAL, FADD(H3*(A), H3*(B)) )
		IF FLOTERR DO $(	WRITES('*NOVERFLOW:')
					FLOTERR := FALSE
					GOTO FPERR $)
		NEXT11()
		RETURN $)
	A := LIST(3, NUMBER, 0)
FPERR:	ERROR1("+", T, B)
	ERRDBG() $)1

AND MINUS() BE
$(1	LET T = A
	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := LIST(3, NUMBER, H3*(A)-H3*(B) )
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := LIST(3, REAL, FSUB(H3*(A), H3*(B)) )
		IF FLOTERR DO $(	WRITES('*NOVERFLOW:')
					FLOTERR := FALSE
					GOTO FMERR $)
		NEXT11()
		RETURN $)
	A := LIST(3, NUMBER, 0)
FMERR:	ERROR1("-", T, B)
	ERRDBG() $)1

AND POWER() BE
$(1	LET T = A
	SPLIT2()
	UNLESS H2*(B)=NUMBER GOTO PWERR
	IF H2*(A)=NUMBER DO
	$(	LET BASE, EXP, R = H3*(A), H3*(B), 1
		TEST EXP LE O
		THEN $(	IF BASE=0 GOTO PWERR
			R := ABS BASE = 1 ->
			((-EXP & 1)=0 -> 1, BASE), 0 $)
		OR UNTIL EXP=0 DO
		$(	UNLESS (EXP & 1)=0 DO R := R * BASE
			BASE := BASE * BASE
			EXP := EXP RSHIFT 1 $)
		A := LIST(3, NUMBER, R)
		NEXT11()
		RETURN $)
	IF H2*(A)=REAL DO
	$(	A := LIST(3, REAL, FPOWER(H3*(A), H3*(B)) )
		IF FLOTERR DO $(	WRITES('*NOVERFLOW:')
					FLOTERR := FALSE
					GOTO PWERR $)
		NEXT11()
		RETURN $)
PWERR:	A := LIST(3, NUMBER, 0)
	ERROR1('****', T, B)
	ERRDBG() $)1

AND POS() BE
$(1	SPLIT1()
	TEST H2*(A)=NUMBER LOGOR H2*(A)=REAL
	THEN $(	A := LIST(3, H2*(A), H3*(A) )
		NEXT11() $)
	OR $(	ERROR1("+", A, 0)
		A := LIST(3, NUMBER, 0)
		ERRDBG() $)1

AND NEG() BE
$(1	LET T=A
	SPLIT1()
	IF H2*(A)=NUMBER DO
	$(	A := LIST(3, NUMBER, -H3*(A) )
		NEXT11()
		RETURN $)
	IF H2*(A)=REAL DO
	$(	A := LIST(3, REAL, FUMIN(H3*(A)) ) )
		NEXT11()
		RETURN $)
	A := LIST(3, NUMBER, 0)
	ERROR1("-", T, 0)
	ERRDBG() $)1

AND R_EQ() BE
$(1	LET T=A
	SPLIT2()
	A := EQUAL(A, B) -* TRUERV, FALSERV
	TEST ERRFLAG
	THEN $(	ERROR1('EQ', T, B)
		ERRFLAG := FALSE
		ERRDBG() $)
	OR NEXT11() $)1

AND R_NE() BE
$(1	LET T=A
	SPLIT2()
	A := EQUAL(A, B) -* FALSERV, TRUERV
	TEST ERRFLAG
	THEN $(	ERROR1('NE', T, B)
		A := FALSERV
		ERRFLAG := FALSE
		ERRDBG() $)
	OR NEXT11() $)1

AND R_LS() BE
$(	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := H3*(A) LS H3*(B) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := FLS(H3*(A), H3*(B)) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	ERROR1('LS', A, B)
	A := FALSERV
	ERRDBG() $)

AND R_LE() BE
$(	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := H3*(A) LE H3*(B) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := FLE(H3*(A), H3*(B)) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	ERROR1('LE', A, B)
	A := FALSERV
	ERRDBG() $)

AND R_GE() BE
$(	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := H3*(A) GE H3*(B) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := FGE(H3*(A), H3*(B)) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	ERROR1('GE', A, B)
	A := FALSERV
	ERRDBG() $)

AND R_GR() BE
$(	SPLIT2()
	IF TESTNUMBS2()=NUMBER DO
	$(	A := H3*(A) GR H3*(B) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	IF TESTNUMBS2()=REAL DO
	$(	A := FGR(H3*(A), H3*(B)) -* TRUERV, FALSERV
		NEXT11()
		RETURN $)
	ERROR1('GR', A, B)
	A := FALSERV
	ERRDBG() $)

>>> EJECT
// XPAL2C
LET JUMP() BE $(	C := C*(1) $)

AND JUMPF() BE
$(1	SPLIT1()
	IF H2*(A) = M_FALSE DO
	$(	C := C*(1)
		RETURN $)
	IF H2*(A) = M_TRUE DO
	$(	C := C+2
		RETURN $)
	ERROR('NOT A TRUTHVALUE: ', A, 0, 0)
	C := C*(1) - 1
	EDBG() $)1

AND EDBG() BE
$(1	RESTARTC := C+1
	C := LV RESTART
	A := LIST(3, LVALUE, NILRV)
	COMDBG() $)1

AND ERRDBG() BE
$(	RESTARTC := C+1
	C := LV RVRESTART
	A := LIST(3, LVALUE, A)
	COMDBG() $)

AND ERRLVDBG() BE
$(	A := LIST(3, LVALUE, A)
	ERROKDBG() $)

AND ERROKDBG() BE
$(	RESTARTC := C+1
	C := LV OKRESTART
	COMDBG() $)

AND COMDBG() BE
$(1	H3*(S) := STACKP
	B := NODE(8)
	H1*(B), H2*(B) := 8, STACK
	H4*(B), H5*(B) := RESTARTC, S
	H6*(B), H7*(B) := E, A
	S := B
	B := H3*(ERRORLV)
	STACKP := 7
	ERRCT := ERRCT + 1
	IF ERRCT GE MAXERR DO C := LV NORESTART
	UNLESS H2*(B) = CLOSURE LOGOR H2*(B)=BASICFN DO
	$(	UNLESS ERRCT GE MAXERR DO
		WRITES('EXECUTION RESUMED*N*N')
		RETURN $)
	TEST H2*(B)=CLOSURE
	THEN $(	S*(STACKP) := ERRORLV
		STACKP := STACKP+1
		A := B
		OLDC, C := C, H4*(B) $)
	OR $(	C := C-3
		NIL()
		FORMLVALUE()
		(H3*(B))() $)
	RESTARTC := 0 $)1

AND OKRESTART() BE
$(	A := S*(STACKP-1)
	RESTART()
	S*(STACKP) := A
	STACKP := STACKP+1 $)

AND RVRESTART() BE
$(	A := S*(STACKP-1)
	RESTART()
	S*(STACKP) := H3*(A)
	STACKP := STACKP+1 $)

AND NORESTART() BE
$(	WRITES('*NMAXIMUM NUMBER OF RUN-TIME ERRORS REACHED*N')
	TERMINATE1() $)

AND APPLY() BE
$(1	SPLIT1()
	A := H3*(A)
	SWITCHON H2*(A) INTO
	$(	CASE CLOSURE:
				STACKP := STACKP+1
				OLDC, C := C+1, H4*(A)
				RETURN
		CASE M_TUPLE:
				STACKP, B := STACKP-1, S*(STACKP)
				B := H3*(B)
				UNLESS H2*(B)=NUMBER DO
				$(	ERROR(0, A, ' APPLIED TO ', B)
					UNLESS H3*(A)=0 DO A := H4*(A)
					ERRLVDBG()
					RETURN $)
			$(	LET N = H3*(B)
				TEST 1 LE N LE H3*(A)
				THEN $(	A := A*(N+2)
					NEXT11() $)
				OR $(	ERROR(0, A, ' APPLIED TO ', B)
					UNLESS H3*(A)=0 DO
						TEST N GE 1
						THEN A := A*(H3*(A)+2)
						OR A := H4*(A)
					ERRLVDBG() $)
				RETURN $)
		CASE BASICFN:
				(H3*(A))()
				RETURN
		DEFAULT:	ERROR('ATTEMPT TO APPLY ',A,' TO ',S*(STACKP-1))
				EDBG() $)1

AND SAVE() BE
$(	B := NODE(C*(1)+6)
	H1*(B), H2*(B) := C*(1)+6, STACK
	H3*(S) := STACKP
	H4*(B), H5*(B) := OLDC, S
	H6*(B), H7*(B) := E, S*(STACKP-2)
	E := H3*(A)
	STACKP, S := 7, B
	C := C+2 $)

AND R_RETURN() BE
$(	A := S*(STACKP-1)
	RESTART()
	STACKP := STACKP-1
	S*(STACKP-1) := A $)

AND TESTEMPTY() BE
$(1	SPLIT1()
	TEST H3*(A)=NILRV
	THEN C := C+1
	OR $(	ERROR1('FUNCTION OF NO ARGUMENTS', A, 0)
		EDBG() $)1

AND LOSE1() BE
$(	SPLIT1()
	C := C+1 $)

AND R_GOTO() BE
$(1	SPLIT1()
	UNLESS H2*(A)=LABEL DO
	$(	ERROR('CANNOT GO TO ', A, 0, 0)
		A := DUMMYRV
		ERRDBG()
		RETURN $)
	C, E := H4*(A), H6*(A)
	S := NODE(H3*(A))
	STACKP := 6
	H1*(S), H2*(S) := H3*(A), STACK
	A := H5*(A)
	H4*(S), H5*(S), H6*(S) := H4*(A), H5*(A), H6*(A) $)1

AND UPDATE() BE
$(1	LET N = C*(1)
	SPLIT2()
	TEST N = 1 THEN H3*(B) := A
	OR $(	UNLESS H2*(A) = M_TUPLE & H3*(A) = N DO
		$(	ERROR('CONFORMALITY ERROR IN ASSIGNMENT',0,0,0)
			WRITES('THE VALUE OF THE RHS IS: ')
			PRINTA(A, TUPLEDEPTH)
			WRITECH(OUTPUT, '*N')
			WRITES('THE NUMBER OF VARIABLES ON THE LHS IS: ')
			WRITEN(N)
			WRITECH(OUTPUT, '*N')
			C := C + 1
			A := DUMMYRV
			ERRDBG()
			RETURN $)
		B := H3*(B)
		$(	LET V = VEC 100
			FOR I=3 TO N+2 DO V*(I) := H3*(A*(I))
			FOR I=3 TO N+2 DO H3*(B*(I)) := V*(I) $) $)
	A := DUMMYRV
	C := C+1
	NEXT11() $)1

>>> EJECT
// XPAL2D
MANIFEST $(	LFIELD=$8177777; NDIST=24 $)

LET ERROR(MS1, DB1, MS2, DB2) BE
$(	WRITES('*N*NRUN TIME ERROR: ')
	UNLESS MS1 = 0 DO WRITES(MS1)
	UNLESS DB1 = D DO PRINTA(DB1, TUPLEDEPTH)
	UNLESS MS2 = 0 DO WRITES(MS2)
	UNLESS DB2 = 0 DO PRINTA(DB2, TUPLEDEPTH)
	WRITECH(OUTPUT, '*N') $)

AND ERROR1(OP, ARG1, ARG2) BE
$(	WRITES('*N*NRUN TIME ERROR: ')
	WRITES(OP)
	WRITES(' APPLIED TO ')
	PRINTA(ARG1, TUPLEDEPTH)
	UNLESS ARG2=0 DO
	$(	WRITES(' AND ')
		PRINTA(ARG2, TUPLEDEPTH) $)
	WRITECH(OUTPUT,'*N') $)

AND PRINTB(X) BE
$(1	IF X=0 RETURN
	SWITCHON H2*(X) INTO
	$(	CASE NUMBER:	WRITEN(H3*(X)); RETURN
		CASE REAL:$(	LET V = VEC 3
				FTOS(H3*(X), V)
				WRITES(V)
				RETURN $)
		CASE STRING:	WRITECH(OUTPUT, H4*(X))
				PRINTB(H3*(X))
		CASE NILS:	RETURN
		CASE M_TUPLE:$(	LET N = H3*(X)
				IF N = 0 DO $(	WRITES('NIL')
						RETURN $)
				IF LV X GR STACKWARNING DO
				$(	WRITES('( ETC )')
					RETURN $)
				WRITECH(OUTPUT, '(')
				FOR I = 3 TO N+1 DO
				$(	PRINTB(X*(I))
					WRITES(', ') $)
				PRINTB(X*(N+2))
				WRITECH(OUTPUT, ')')
				RETURN $)
		CASE M_TRUE:	WRITES('TRUE'); RETURN
		CASE M_FALSE:	WRITES('FALSE'); RETURN
		CASE LVALUE:	PRINTB(H3*(X)); RETURN
		CASE CLOSURE:
		CASE BASICFN:	WRITES('$FUNCTION$'); RETURN
		CASE LABEL:	WRITES('$LABEL$'); RETURN
		CASE JJ:	WRITES('$ENVIRONMENT$'); RETURN
		CASE M_DUMMY:	WRITES('$DUMMY$'); RETURN
		DEFAULT:	WRITES('$$$') $)1

AND PRINTA(X, N) BE
$(1	IF X=0 RETURN
	IF N LE 0 DO $(	WRITES(' ETC '); RETURN $)
	SWITCHON H2*(X) INTO
	$(	CASE STRING:
		CASE NILS:	WRITECH(OUTPUT, '*'')
				PRINTB(X)
				WRITECH(OUTPUT, '*'')
				RETURN
		CASE M_TUPLE:$(	LET M = H3*(X)
				IF M=0 DO $(	WRITES(' NIL ')
						RETURN $)
				WRITECH(OUTPUT, '(')
				FOR I = 3 TO M+1 DO
				$(	PRINTA(X*(I), N-1)
					WRITECH(OUTPUT, ',') $)
				PRINTA(X*(M+2), N-1)
				WRITECH(OUTPUT, ')')
				RETURN $)
		CASE LVALUE:	PRINTA(H3*(X), N)
				RETURN
		DEFAULT:	WRITECH(OUTPUT, ' ')
				PRINTB(X)
				WRITECH(OUTPUT, ' ')
				RETURN $)1

AND EQUAL(A,B) = VALOF
$(	LET BTAG = H2*(B)
	SWITCHON BTAG INTO
	$(1	CASE M_TRUE:
		CASE M_FALSE:
		CASE NUMBER:
		CASE REAL:
		CASE STRING:
		CASE NILS:	SWITCHON H2*(A) INTO
	$(	CASE M_TRUE:	IF BTAG=M_TRUE RESULTIS TRUE
				RESULTIS FALSE
		CASE M_FALSE:	IF BTAG=M_FALSE RESULTIS TRUE
				RESULTIS FALSE
		CASE NUMBER:	IF BTAG=NUMBER & H3*(A)=H3*(B) DO
					RESULTIS TRUE
				RESULTIS FALSE
		CASE REAL:	IF BTAG=REAL & H3*(A)=H3*(B) DO
					RESULTIS TRUE
				RESULTIS FALSE
		CASE STRING:	IF BTAG=STRING & H4*(A)=H4*(B) DO
					RESULTIS EQUAL(H3*(A),H3*(B))
				RESULTIS FALSE
		CASE NILS:	IF BTAG=NILS RESULTIS TRUE
				RESULTIS FALSE
	$)1
	ERRFLAG := TRUE
	RESULTIS FALSE $)

AND TESTNUMBS2() = H2*(A)=NUMBER & H2*(B)=NUMBER -* NUMBER,
		   H2*(A)=REAL & H2*(B)=REAL -* REAL,
		   M_FALSE
AND TESTBOOLS2() = ( H2*(A)=M_TRUE LOGOR H2*(A)=M_FALSE ) LOGAND
		   ( H2*(B)=M_TRUE LOGOR H2*(B)=M_FALSE )
AND LVOFNAME(N, P) = VALOF
$(	H3*(LOOKUPNO) := H3*(LOOKUPNO) + 1
	UNTIL P = 0 DO
	$(	IF H4*(P) = N RESULTIS H5*(P)
		P := H3*(P) $)
	UNLESS N=NAMERES DO
		ERROR('UNDECLARED NAME ', 0, N, 0)
	RESULTIS NILRV $)

AND NAMEOFLV(L, P) = VALOF
$(	UNTIL P=0 DO
	$(	IF H5*(P)=L RESULTIS H4*(P)
		P := H3*(P) $)
	RESULTIS 0 $)

AND RESTART() BE
$(	C, B, E := H4*(S), H5*(S), H6*(S)
	S := NODE(H1*(B) & LFIELD)
	STACKP := H3*(B)
	FOR I = 0 TO STACKP-1 DO
		S*(I) := B*(I)
$)

AND TERMINATE() BE
$(	LISTT := LISTT + 6 // CREATE EXTRA SPACE FOR FINAL DIAGNOSE
	DIAGNOSE()
	TERMINATE1() $)

AND TERMINATE1() BE
$(	CONTROL(OUTPUT, 2)
	WRITEN(H3*(LOOKUPNO))
	WRITES(' LOOKUPS *T')
	WRITEN(COUNT)
	WRITES(' CYCLES*N')
	GCMARK := GCMARK RSHIFT 16
	WRITEN(GCMARK)
	WRITES(' GARBAGE COLLECTIONS*N')
	LONGJUMP(XPEND, XPENDLEVEL) $)

AND LASTFN1(P) = VALOF
$(1	LET NAME, ARG = 0, 0
	LET Y, N = 0, 0
	IF H6*(Q)=0 RESULTIS FALSE
	$(	Y := H5*(Q)
		N := H3*(Y)
		TEST N>6
		THEN $(2	NAME := Y*(N-1)
				UNLESS NAME=NILRV DO
				$(	NAME == NAMEOFLV(NAME, H6*(Q))
					IF NAME=O DO NAME := 'ANONYMOUS'
					ARG := Y*(N-2) $)2
		OR NAME := NILRV
		Q := Y
		IF P=0 RESULTIS TRUE
		IF H6*(Q)=0 RESULTIS FALSE $)
	REPEATWHILE NAME=NILRV
	WRITES('AT THIS TIME, THE FUNCTION BEING EXECUTED IS: ')
	WRITES(NAME)
	WRITES('*NTHE ARGUMENT TO WHICH IT IS BEING APPLIED IS: ')
	PRINTA(ARG, TUPLEDEPTH)
	WRITECH(OUTPUT, '*N')
	RESULTIS TRUE $)1

AND WRITENODE(N) BE
$(	WRITEN(N RSHIFT NDIST)
	WRITECH(OUTPUT, '*T')
	WRITES(H4*(A))
	WRITECH(OUTPUT, '*T')
	PRINTA(H5*(A), TUPLEDEPTH)
	WRITECH(OUTPUT, '*N') $)

>>> EJECT
// XPAL2E
MANIFEST $(	LFIELD=$8177777; MFIELD=$877600000; GC1=$8200000 $)

LET NODE(N) = VALOF
$(	IF LISTP+N GE LISTL DO NEXTAREA(N)
	LISTP := LISTP+N
	RESULTIS LISTP-N $)

AND NEXTAREA(N) BE
$(1	LET B = FALSE
	IF GCDBG DO WRITES('*N*NNEXTAREA RECLAIMATION PHASE*N')
	$(	UNLESS LISTP=LISTL DO H1*(LISTP) := LISTL - LISTP
		IF LISTL=LISTT DO
		$(	IF B DO
			$(	WRITES('*N*NRUN TIME SPACE EXHAUSTED*N')
				TERMINATE() $)
			MARK()
			IF GCDBG DO WRITES('*NMARKLIST PREFORMED*N')
			LISTL, B := LISTV, TRUE $)
		H1*(LISTT) := 0
		WHILE ( H1*(LISTL) & MFIELD ) = GCMARK DO
			LISTL := LISTL + ( H1*(LISTL) & LFIELD )
		LISTP := LISTL
		H1*(LISTT) := GCMARK
		UNTIL ( H1*(LISTL) & MFIELD ) = GCMARK DO
			LISTL := LISTL + ( H1*(LISTL) & LFIELD )
		IF GCDBG DO $(	WRITES('*S*S'); WRITEN(LISTL-LISTP) $)
	$) REPEATWHILE LISTP+N GE LISTL
	IF GCDBG DO WRITES('*S*N')
	RETURN $)1

AND MARKLIST(X) BE
$(1  L:	IF LV X GR STACKWARNING DO
	$(	WRITES('*N*NMAXIMUM NODE DEPTH EXCEEDED*N')
		TERMINATE() $)
	IF X=0 RETURN
	IF ( H1*(X) & MFIELD ) = GCMARK RETURN
	H1*(X) := H1*(X) & LFIELD LOGOR GCMARK
	SWITCHON H2*(X) INTO
	$(	DEFAULT:	WRITES('*N*NMARKLIST ERROR*N')
				WRITEX(X); WRITES(' H1*(X)='); WRITEX(H1*(X))
				WRITES(' NODE TYPE IS '); WRITEN(H2*(X))
				WRITES('*S*N')
				RETURN
		CASE M_TUPLE:	FOR I = 1 TO H3*(X) DO
					MARKLIST(X*(I+2))
				RETURN
		CASE ENV:	MARKLIST(H5*(X))
				X := (H3*(X))
				GOTO L
		CASE STACK:	FOR I = 4 TO H3*(X)-1 DO
					MARKLIST(X*(I))
				RETURN
		CASE JJ:	MARKLIST(H5*(X))
				X := (H4*(X))
				GOTO L
		CASE LABEL:	MARKLIST(H6*(X))
				X := (H5*(X))
				GOTO L
		CASE LVALUE:CASE CLOSURE:CASE STRING:
				X := (H3*(X))
				GOTO L
		CASE NUMBER:CASE M_TRUE:CASE M_FALSE:CASE M_NIL:
		CASE NILS:CASE BASICFN:CASE GUESS:
		CASE M_DUMMY:CASE REAL:
				RETURN $)1

AND MARK() BE
$(	GCMARK := GCMARK + GC1
	NSET := FALSE
	IF ( GCMARK & MFIELD ) = 0 DO
	$(	WRITES('*N*NMAXIMUM NUMBER OF ')
		WRITES('GARBAGE COLLECTIONS PERFORMED*N')
		TERMINATE() $)
	MARKLIST(E)
	H3*(S) := STACKP
	MARKLIST(S)
	MARKLIST(A)
	MARKLIST(B)
	RETURN $)

AND LIST(N, A, B, C, D, E, F) = VALOF
$(1	F := LV N
	$(	LET P = NODE(N)
		SWITCHON N INTO
		$(	CASE 7:		P*(6) := F
			CASE 6:		P*(5) := E
			CASE 5:		P*(4) := D
			CASE 4:		P*(3) := C
			CASE 3:		P*(2) := B
			CASE 2:		P*(1) := A
			CASE 1:		P*(0) := N $)
		F := 0
		RESULTIS P $)1

>>> EJECT
// XPAL2F
MANIFEST $(	LFIELD=$8177777 $)

LET SPLIT1() BE
$(	STACKP, A := STACKP-1, S*(STACKP) $)

AND SPLIT2() BE
$(	STACKP, A, B := STACKP-2, S*(STACKP+1), S*(STACKP) $)

AND DECLNAME() BE
$(	E := LIST(5, ENV, E, C*(1), S*(STACKP-1))
	STACKP := STACKP-1
	C := C + 2 $)

AND DECLNAMES() BE
$(	LET N = C*(1)
	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=M_TUPLE & H3*(A)=N DO
	$(	ERROR('CONFORMALITY ERROR IN DEFINITION', 0, 0, 0)
		NAMEERROR(N,1)
		RETURN $)
	FOR I = 2 TO N+1 DO R_NAME(I,1)
	C := C+2+N $)

AND INITNAME() BE
$(	STACKP := STACKP-1
	R_NAME(1,7)
	C := C+2 $)

AND INITNAMES() BE
$(	LET N = C*(1)
	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=M_TUPLE & H3*(A)=N DO
	$(	ERROR('CONFORMALITY ERROR IN RECURSIVE DEFINITION',0,0,0)
		NAMEERROR(N,4)
		RETURN $)
	FOR I = 2 TO N+1 DO R_NAME(I,4)
	C := C+2+N $)

AND R_NAME(I,P) BE
$(1	TEST P LE 3
	THEN E := LIST(5, ENV, E, C*(I),
			P=1 -* A*(I+1), LIST(3, LVALUE, (P=2 -* A, NILRV)) )
	OR $(	B := LVOFNAME(C*(I), E)
		IF B=NILRV DO B := LIST(3, LVALUE, B)
		SWITCHON P INTO
		$(	CASE 4:	H3*(B) := H3*(A*(I+1)); RETURN
			CASE 5:	H3*(B) := A; RETURN
			CASE 6:	H3*(B) := NILRV; RETURN
			CASE 7:	H3*(B) := H3*(S*(STACKP)); RETURN $)1

AND NAMEERROR(N,P) BE
$(1	WRITES('THE NAMES BEING DECLARED ARE:*N')
	FOR I = 2 TO N+1 DO
	$(	WRITES(C*(I))
		WRITECH(OUTPUT, '*N') $)
	WRITES('THE VALUE(S) PROVIDED ARE: ')
	PRINTA(A, TUPLEDEPTH)
	WRTTECH(OUTPUT, '*N')
	TEST H2*(A)=M_TUPLE
	THEN $(	LET M=N
		IF M>H3*(A) DO M := H3*(A)
		FOR I = 2 TO M+1 DO R_NAME(I,P)
		FOR I = M+2 TO N+1 DO R_NAME(I,P+2) $)
	OR $(	R_NAME(2,P+1)
		FOR I = 3 TO N+1 DO R_NAME(I,P+2) $)
	C := C+N+1
	EDBG() $)1

AND DECLLABEL() BE
$(	A := LIST(6, STACK, 6, H4*(S), H5*(S), H6*(S))
	A := LIST(6, LABEL* H1*(S)&LFIELD, C*(2), A, E)
	A := LIST(3, LVALUE, A)
	E := LIST(5, ENV, E, C*(1), A)
	C := C + 3 $)

AND SETLABES() BE
$(	A := E
	FOR I = 1 TO C*(1) DO
	$(	H6*(H3*(H5*(A))) := E
		A := H3*(A) $)
	C := C + 2 $)

AND BLOCKLINK() BE
$(	S*(STACKP) := NILRV
	STACKP := STACKP+1
	OLDC := C*(1)
	A := LIST(3, LVALUE, E)
	C := C+2 $)

AND RESLINK() BE
$(	S*(STACKP) := LIST(3, LVALUE, NILRV)
	STACKP := STACKP+1
	BLOCKLINK() $)

AND SETUP() BE
$(	OLDC := LV R_FINISH
	S := LIST(5, STACK, 4, DUMMYRV, 0)
	A := LIST(3, LVALUE, E)
	E := 0
	STACKP := 5
	SAVE()
	SPLIT1() $)


// XPAL3 LAST MODIFIED ON FRIDAY, 12 JUNE 1970
// AT 5:37:38.68 BY R MABEE
>>> FILENAME 'XPAL3'
//
//	***********
//	*         *
//	*  XPAL3  *
//	*         *
//	***********
//
>>> GET 'XPALHD'
>>> EJECT
// XPAL3A
LET R_FINISH() BE
$(	WRITES('*N*NEXECUTION FINISHED*N')
	TERMINATE1() $)

AND PRINT() BE
$(	SPLIT1()
	PRINTB(A)
	A := DUMMYRV
	NEXTLV11() $)

AND USERPAGE() BE
$(	SPLIT1()
	CONTROL(OUTPUT, -1)
	A := DUMMYRV
	NEXTLV11() $)

AND STEM() BE
$(	SPLIT1(); B := H3*(A)
	A := NILSRV
	UNLESS H2*(B)=STRING DO
	$(	ERROR1('STEM', B, 0)
		ERRLVDBG()
		RETURN $)
	A := LIST(4, STRING, A, H4*(B) )
	NEXTLV11() $)

AND STERN() BE
$(	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=STRING DO
	$(	ERROR1('STERN', A, 0)
		A := NILSRV
		ERRLVDBG()
		RETURN $)
	A := H3*(A)
	NEXTLV11() $)

AND CONC() BE
$(1	A := H3*(S*(STACKP-1))
	UNLESS H2*(A)=M_TUPLE & H3*(A)=2 DO
CONCERR:$(	ERROR1('CONC', A, 0)
		SPLIT1()
		A := NILSRV
		ERRLVDBG()
		RETURN $)
$(	LET X, Y = H2*(H3*(H4*(A))), H2*(H3*(H5*(A)))
	UNLESS ( X=STRING LOGOR X=NILS ) &
	       ( Y=STRING LOGOR Y=NILS ) GOTO CONCERR
$(	LET V = VEC 512
	B, X := H3*(H4*(A)), 1
	UNTIL H2*(B) = NILS DO
	$(	V*(X) := H4*(B)
		B := H3*(B)
		X := X+1 $)
	IF X=1 DO
	$(	B := H3*(H5*(A))
		SPLIT1()
		A := B
		NEXTLV11()
		RETURN $)
	B := LIST(4, STRING, 0, V*(I))
	A := B
	FOR I = 2 TO X-1 DO
	$(	H3*(A) := LIST(4, STRING, 0, V*(I))
		A := H3*(A) $)
	H3*(A) := H3*(H5*(H3*(S*(STACKP-1))))
	SPLIT1()
	A := B
	NEXTLV11() $)1

AND ATOM() BE
$(	SPLIT1()
	SWITCHON H2*(H3*(A)) INTO
	$(	CASE M_TRUE:
		CASE M_FALSE:
		CASE NUMBER:
		CASE REAL:
		CASE STRING:
		CASE NILS:	A := TRUERV
				NEXTLV11()
				RETURN $)
	A := FALSERV
	NEXTLV11() $)

AND NULL() BE
$(	SPLIT1()
	A := H2*(H3*(A))=M_TUPLE & H3*(H3*(A))=O -* TRUERV, FALSERV
	NEXTLV11() $)

AND LENGTH() BE
$(	SPLIT1()
	UNLESS H2*(H3*(A))=M_TUPLE DO
	$(	ERROR1('ORDER', A, 0)
		A := LIST(3, NUMBER, 0)
		ERRLVDBG()
		RETURN $)
	A := LIST(3, NUMBER, H3*(H3*(A)) )
	NEXTLV11() $)

AND ISTRUTHVALUE() BE
$(	SPLIT1()
	SWITCHON H2*(H3*(A)) INTO
	$(	CASE M_TRUE:
		CASE M_FALSE:	A := TRUERV
				NEXTLV11()
				RETURN $)
	A := FALSERV
	NEXTLV11() $)

AND ISNUMBER() BE
$(	SPLIT1()
	A := H2*(H3*(A))=NUMBER -* TRUERV, FALSERV
	NEXTLV11() $)

AND ISSTRING() BE
$(	SPLIT1()
	SWITCHON H2*(H3*(A)) INTO
	$(	CASE STRING:
		CASE NILS:	A := TRUERV
				NEXTLV11()
				RETURN $)
	A := FALSERV
	NEXTLV11() $)

AND ISFUNCTION() BE
$(	SPLIT1()
	SWITCHON H2*(H3*(A)) INTO
	$(	CASE CLOSURE:
		CASE BASICFN:	A := TRUERV
				NEXTLV11()
				RETURN $)
	A := FALSERV
	NEXTLV11() $)

AND ISENVIRONMENT() BE
$(	SPLIT1()
	A := H2*(H3*(A))=JJ -* TRUERV, FALSERV
	NEXTLV11() $)

AND ISLABEL() BE
$(	SPLIT1()
	A := H2*(H3*(A))=LABEL -* TRUERV, FALSERV
	NEXTLV11() $)

AND ISTUPLE() BE
$(	SPLIT1()
	A := H2*(H3*(A))=M_TUPLE -* TRUERV, FALSERV
	NEXTLV11() $)

AND ISREAL() BE
$(	SPLIT1()
	A := H2*(H3*(A))=REAL -* TRUERV, FALSERV
	NEXTLV11() $)

AND ISDUMMY() BE
$(	SPLIT1()
	A := H2*(H3*(A))=M_DUMMY -* TRUERV, FALSERV
	NEXTLV11() $)

AND SHARE() BE
$(	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=M_TUPLE & H3*(A)=2 DO
	$(	ERROR1('SHARE', A, 0)
		A := FALSERV
		ERRLVDBG()
		RETURN $)
	A := H4*(A)=H5*(A) -* TRUERV, FALSERV
	NEXTLV11() $)

>>> EJECT
// XPAL3B
MANIFEST $(	NFIELD=$867700000000; N1=$8100000000 $)

LET STON() BE
$(1	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=STRING DO
	$(	ERROR1('STOI', A, 0)
		A := LIST(3, NUMBER, 0)
		ERRLVDBG()
		RETURN $)
$(	LET B = 0
	WHILE H2*(A)=STRING DO
	$(	B := B*10 + H4*(A) - '0'
		A := H3*(A) $)
	A := LIST(3, NUMBER, B)
	NEXTLV11() $)1

AND CTON() BE
$(	SPLIT1()
	A := H3*(A)
	UNLESS H2*(A)=STRING LOGAND H2*(H3*(A))=NILS DO
	$(	ERROR1('CTOI', A, 0)
		A := LIST(3, NUMBER, 0)
		ERRLVDBG()
		RETURN $)
	A := LIST(3, NUMBER, H4*(A) )
	NEXTLV11() $)

AND NTOC() BE
$(	SPLIT1()
	A := H3*(A)
	UNLESS H2*(A)=NUMBER LOGAND H3*(A) LS 256 LOGAND H3*(A) GE 0
	DO
	$(	ERROR1('ITOC', A, 0)
		A := NILSRV
		ERRLVDBG()
		RETURN $)
	A := LIST(4, STRING, NILSRV, H3*(A) )
	NEXTLV11() $)

AND NTOR() BE
$(	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=NUMBER DO
	$(	ERROR1('ITOR', A, 0)
		A := LIST(3, REAL, 0)
		ERRLVDBG()
		RETURN $)
	A := LIST(3, REAL, ITOR(H3*(A)) )
	NEXTLV11() $)

AND RTON() BE
$(	SPLIT1(); A := H3*(A)
	UNLESS H2*(A)=REAL DO
	$(	ERROR1('RTOI', A, 0)
		A := LIST(3, NUMBER, 0)
		ERRLVDBG()
		RETURN $)
	A := LIST(3, NUMBER, RTOI(H3*(A)) )
	NEXTLV11() $)

AND RDCHAR() BE
$(	SPLIT1()
	A := LIST(2, NILS)
	IF LINEP>LINET DO
	$(2	UNLESS DATAFLAG GOTO ENDDATA
		IF CH='#' DO
			TEST DATAFLAG
			THEN $(	DATAFLAG := FALSE
				NEXTLV11() // VALUE OF NILS INDICATES EOD
				RETURN $)
			OR
ENDDATA:		$(	WRITES('*NEND OF DATA FILE ENCOUNTERED*N*N')
				TERMINATE1() $)
		LINET := LINEV
		LINET*(0) := CH
		UNTIL CH='*N' DO
		$(	READCH(INPUT, LVCH)
			LINET := LINET + 1
			LINET*(0) := CH $)
		READCH(INPUT, LVCH)
		LINEP := LINEV $)2
	A := LIST(4, STRING, A, LINEP*(O) )
	LINEP := LINEP + 1
	NEXTLV11() $)

AND R_TABLE() BE
$(1	SPLIT1(); A := H3*(A)
	UNLESS H2*(A) = M_TUPLE & H3*(A) = 2 DO
TABLERR:$(	ERROR1('TABLE', A, 0)
		A := NILRV
		ERRLVDBG()
		RETURN $)
$(	LET N = H3*(H4*(A))
	UNLESS H2*(N) = NUMBER GOTO TABLERR
	N := H3*(N)
	B := H3*(H5*(A))
	A := NODE(N+3)
	A*(0), A*(1), A*(2) := N+3, M_TUPLE, N
	FOR I = 3 TO N+2 DO
		A*(I) := LIST(3, LVALUE, B)
	NEXTLV11() $)1

AND DIAGNOSE() BE
$(1	LET N, I = 0, 1000
	A := S*(STACKP-1)
	S*(STACKP-1) := LIST(3, LVALUE, DUMMYRV) // RETURN VALUE
					//REPLACES ARGUMENT ON STACK
	C := C+1
	IF H2*(H3*(A))=NUMBER DO I := H3*(H3*(A))
	ERRORLV := LIST(3, LVALUE, LIST(3, BASICFN, LASTFN) )
	IF NSET DO	// 2 SUCCESSIVE EXECUTIONS OF DIAGNOSE REQUIRE
			// AN INTERVENING MARKING PHASE
	$(	MARK()
		LISTL := LISTV $)	// TAKE ADVANTAGE OF THE EXTRA
					// MARKING PHASE
	NSET := TRUE
	CONTROL(OUTPUT, -1)
	WRITES('THE CURRENT ENVIRONMENT IS:*N*N')
	A := E
	Q := S
	IF H4*(S)=RESTARTC // TRUE IFF CALL IS FROM COMDBG
	DO LASTFN1(0) // PEEL OFF TOP STACK NODE
L:	WRITES('*TVARIABLE*TRVALUE*N*N')
	WHILE H4*(A) NE 0 DO
	$(2	LET M = H1*(A) LOGAND NFIELD
		TEST M NE 0
		THEN $(	WRITENODE(M)
			WRITES('ETC*N')
			BREAK $)
		OR $(	N := N+N1
			H1*(A) := H1*(A) LOGOR N
			WRITENODE(N)
			A := H3*(A) $)2
	I := I-1
	A := H6*(Q)
	CONTROL(OUTPUT, 3)
	UNLESS LASTFN1(1) DO
FINI:	$(	CONTROL(OUTPUT, -1)
		RETURN $)
	IF I LE 0 GOTO FINI
	WRITES('*N*NTHE ENVIRONMENT IN WHICH ')
	WRITES('THE ABOVE APPLICATION TAKES PLACE IS:*N*N')
	GOTO L $)1

AND LASTFN() BE
$(	S*(STACKP-1) := LIST(3, LVALUE, DUMMYRV) // RETURN VALUE
	// REPLACES ARGUMENT ON STACK
	C := C+1
	CONTROL(OUTPUT, 2)
	Q := S
	IF H4*(S)=RESTARTC // TRUE IFF CALL IS FROM COMDBG
		DO LASTFN1(0) // PEEL OFF TOP STACK NODE
	UNLESS LASTFN1(1) DO
		WRITES('ERROR OCCURRED IN OUTER LEVEL OF PROGRAM*N')
	CONTROL(OUTPUT, 3) $)

AND LOOKUPINE() BE
$(1	SPLIT1(); A := H3*(A)
	UNLESS H2*(A) = M_TUPLE & H3*(A) = 2 DO
LERR:	$(	ERROR1('LOOKUPINE', A, 0)
		A := NILRV
		ERRLVDBG()
		RETURN $)
$(	LET X, I, L = H3*(H5*(A)), 1, NAMECHAIN
	LET VP = VEC 10
	LET V = VEC 40
	B := H3*(H4*(A))
	UNLESS H2*(B)=STRING & H2*(X)=JJ GOTO LERR
	WHILE H2*(B)=STRING DO
	$(	V*(I) := H4*(B)
		B := H3*(B)
		I := I+1 $)
	V*(0) := I-1
	PACKSTRING(V, VP)
	I := ( I-1 ) /BYTESPERWORD + 1
	UNTIL L=0 DO
	$(2	LET V = L*(1)
		IF VP*(O)=V*(0)
		DO $(3	IF I=1 BREAK
			IF VP*(1)=V*(1)
			DO $(	IF I=2 BREAK
				IF VP*(2)=V*(2)
				DO $(	IF I=3 BREAK
					IF VP*(3)=V*(3)
					DO $(	IF I=4 BREAK
						IF VP*(4)=V*(4)
						DO $(	IF I=5 BREAK $)3
		L := L*(0) $)2
	TEST L=0 THEN I := VP
	OR I := L*(1)
	A := LVOFNAME(I, H5*(X))
	TEST A=NILRV
	THEN ERRLVDBG()
	OR NEXT11() $)1

AND SAVEENV() BE
$(	SPLIT1()
	A := LIST(5, JJ, H4*(S), H5*(S), H6*(S) )
	NEXTLV11() $)

