// This is a program to generate data for CDs to demonstrate
// that the human ear is non linear, ie it can hear sounds that
// have no spectral energy.

SECTION "mkcdab"

GET "libhdr"

MANIFEST { 
mono=1; stereo=2
}

GLOBAL
{ sysout:ug
  wavout
  genfn
  genco           // The generation coroutine
  funa
  funb

  mode             // mono or stereo
  bits_per_sample  // 16 or 8
  sample_rate      // 44100, 22050  or 11025
  secs             // eg 60 ie 1 minute
  samples
  bytes_per_sample
  bytes_per_second
  data_bytes
}

LET start() = VALOF
{ LET args = VEC 50
  LET riffhdr = VEC 10
  LET toname = "cda.wav"
  LET freq = 20_000
  LET amplitude = 5000

  sysout := output()
  genco := 0

  IF rdargs("FREQ/N,AMP/N,SECS/N,TO/K,A/S,B/S", args, 50)=0 DO
  { writes("Bad arguments for MKCDAB*n")
    RESULTIS 20
  }

  secs:=60             // Default is 1 minute
  genfn := funa

  IF args!0 DO freq      := !(args!0)  // FREQ
  IF args!1 DO amplitude := !(args!1)  // AMP
  IF args!2 DO secs      := !(args!2)  // SECS
  IF args!3 DO toname    := args!3     // TO
  IF args!4 DO genfn     := funa       // A
  IF args!5 DO genfn     := funb       // B

  mode := mono           // or stereo
  bits_per_sample := 16  // or 8
  sample_rate := 44100   // or 22050  or 11025
  samples := sample_rate*secs & -16
  bytes_per_sample := bits_per_sample/8 * mode
  bytes_per_second := sample_rate * bytes_per_sample
  data_bytes :=  samples * bytes_per_sample

writef("start: freq=%n amplitude=%n*n", freq, amplitude)
  genco := initco(genfn, 500, freq, amplitude)

  UNLESS genco DO
  { writef("Unable to create genco*n")
    GOTO fin
  }

  writef("Data_bytes = %n*n", data_bytes)

  wavout := findoutput(toname)

  UNLESS wavout DO
  { writef("Unable to open file %s*n", toname)
    RESULTIS 20
  }

  riffhdr!0  := #x46464952     // R I F F
  riffhdr!1  := data_bytes+36  // size
  riffhdr!2  := #x45564157     // W A V E
  riffhdr!3  := #x20746D66     // f m t
  riffhdr!4  := 16             //
  riffhdr!5  := mode<<16 | 1   // 
  riffhdr!6  := sample_rate    // samples per second
  riffhdr!7  := bytes_per_second
  riffhdr!8  := bits_per_sample<<16 | bytes_per_sample
  riffhdr!9  := #x61746164     // d a t a
  riffhdr!10 := data_bytes
   
  selectoutput(wavout)
  FOR i = 0 TO 43 DO wrch(riffhdr%i)

  FOR i = 1 TO samples DO wr2(callco(genco))

  endwrite()
  selectoutput(sysout)
  writef("File %s written*n", toname)

fin:
  IF genco DO deleteco(genco)
  RESULTIS 0   
}

AND funa(args) = VALOF
// This is the body of a coroutine to generate a square wave
// of given frequency and amplitude.
{ LET freq = args!0
  LET amp  = args!1
  LET x    = 0
  LET xmax = sample_rate/2  // Typically 44100/2

writef("funa: freq=%n amp=%n*n", freq, amp)
  { // Calculate and return next sample
    x := x + freq
    IF x>xmax DO x := x - sample_rate
    cowait(x>=0 -> amp, -amp)     
  } REPEAT

}

AND funb(args) = VALOF
// This is the body of a coroutine to generate a square wave
// of given frequency and amplitude.
{ LET freq = args!0 + 440
  LET amp  = args!1
  LET x    = 0
  LET xmax = sample_rate/2  // Typically 44100/2

  { // Calculate and return next sample
    x := x + freq
    IF x>xmax DO x := x - sample_rate
    cowait(x>=0 -> amp, -amp)     
  } REPEAT

}

AND wr2(val) BE { wrch(val); wrch(val>>8)  }





