GET "libhdr"

GLOBAL {
  toname:ug
  tostream
  stdin
  stdout
  rate
  samples
  freqtab
}

LET start() = VALOF
{ LET argv = VEC 50

  UNLESS rdargs("rate/n,to/k,samples/n/n", argv, 50) DO
  { writef("Bad arguments for upbfreq*n")
    RESULTIS 0
  }

  stdin := input()
  stdout := output()
  
  rate := 44100
  toname := 0
  tostream := 0
  samples := 1024

  IF argv!0 DO rate := !(argv!0)     // rate/n
  IF argv!1 DO toname := argv!1      // to/k
  IF argv!2 DO samples := !(argv!2)  // samples/n

  IF toname DO
  { tostream := findoutput(toname)
    UNLESS tostream DO
    { writef("Trouble with file: %s*n", toname)
      GOTO fin
    }
    selectoutput(tostream)
  }
    
  setfreqtab()

  { LET freq = rate * 1000 / samples // Fundamental frequency
    writef("*nFFT frequencies assuming %n samples at sample rate %n*n*n",
           samples, rate)
    FOR i = 1 TO 128 DO
    {  LET f = i*freq
       writef("%i3 %10.3d: ", i, f) 
       wrnotes(f, f+freq)
       newline()
    }
  }

fin:
  IF tostream UNLESS tostream=stdout DO endstream(tostream)
  RESULTIS 0
}

AND setfreqtab() BE
{ // Set freqtab so that freqtab!n = 1000 * the note frequency
  // where n is the MIDI note number. n=60 for middle C (C4).

  freqtab := TABLE
     8_176,   8_662,   9_178,   9_723,  10_301,  10_914, //   0 -c.. -b
    11_563,  12_250,  12_979,  13_750,  14_568,  15_434,

    16_352,  17_324,  18_355,  19_446,  20_602,  21_827, //  12 0c .. 0b
    23_125,  24_500,  25_957,  27_500,  29_136,  30_868,

    32_703,  34_648,  36_709,  38_891,  41_204,  43_654, //  24 1c .. 1b
    46_250,  49_000,  51_914,  55_000,  58_271,  61_736,
  
    65_406,  69_296,  73_417,  77_782,  82_407,  87_308, //  36 2c .. b2
    92_499,  97_999, 103_827, 110_000, 116_541, 123_471,

   130_812, 138_592, 146_833, 155_564, 164_814, 174_615, //  48 3c .. 3b
   184_998, 195_998, 207_653, 220_000, 233_082, 246_942,

   261_623, 277_183, 293_665, 311_127, 329_628, 349_229, //  60 4c .. 4b
   369_995, 391_996, 415_305, 440_000, 466_164, 493_884,

   523_245, 554_366, 587_330, 622_254, 659_255, 698_457, //  72 5c .. 5b
   739_989, 783_991, 830_610, 880_000, 932_328, 987_767,

  1046_489,1108_731,1174_659,1244_508,1318_510,1396_913, //  84 6c .. 6b
  1479_978,1567_982,1661_219,1760_000,1864_655,1975_533,

  2092_978,2217_461,2349_318,2489_016,2637_020,2793_826, //  96 7c .. 7b
  2959_955,3135_963,3322_438,3520_000,3729_310,3951_066,

  4185_955,4434_922,       0,       0,       0,       0, // 108 8c .. 8b
         0,       0,       0,       0,       0,       0,

         0,       0,       0,       0,       0,       0, // 120 9c .. 9g
         0,       0,      -1

//writef("freqtab=%n*n", freqtab)
  // Check the table
  checktab( 98, 2349_318)
  checktab( 99, 2489_016)
  checktab(100, 2637_020)
  checktab(101, 2793_826)
  checktab(102, 2959_955)
  checktab(103, 3135_963)
  checktab(104, 3322_438)
  checktab(105, 3520_000)
  checktab(106, 3729_310)
  checktab(107, 3951_066)
  checktab(108, 4185_955)
  checktab(109, 4434_922)
}

AND checktab(n, f) BE WHILE n>=0 DO
  { UNLESS freqtab!n = f DO
    { writef("note=%i3 change %8.3d to %8.3d*n", n, freqtab!n, f)
      abort(1000)
    }
    n, f := n-12, (f+1)/2
  }

AND note2str(n, str) = VALOF
{ // Convert a midi note number to a string (in str)
  // returning str as result.
  // eg note2str(61, str) => "4C#"
  LET oct = n/12 - 1 // 60 to 71 are in octave 4
  LET s = VALOF SWITCHON n MOD 12 INTO
  { DEFAULT: RESULTIS "??"
    CASE  0: RESULTIS "C "
    CASE  1: RESULTIS "C#"
    CASE  2: RESULTIS "D "
    CASE  3: RESULTIS "Eb"
    CASE  4: RESULTIS "E "
    CASE  5: RESULTIS "F "
    CASE  6: RESULTIS "F#"
    CASE  7: RESULTIS "G "
    CASE  8: RESULTIS "G#"
    CASE  9: RESULTIS "A "
    CASE 10: RESULTIS "Bb"
    CASE 11: RESULTIS "B "
  }
  str%0 := 3
  str%1 := oct>=0 -> oct + '0', '-'
  str%2 := s%1
  str%3 := s%2
  RESULTIS str
}

AND wrnotes(f1, f2) BE
{ LET count = 0
  LET str = VEC 5
  FOR note = 0 TO 127 DO
  { LET freq = freqtab!note
    UNLESS f1<=freq<f2 LOOP
    note2str(note, str)
    IF count & count MOD 4 = 0 DO writes("*n                ")
    count := count+1
    writef(" %10.3d=%s", freq, str)
  }
}
