GET "libhdr"

GLOBAL {
  count:ug
  detv
}

LET start() = VALOF
{ LET argv = VEC 50
  LET buf = VEC 100
  LET wavstr = 0
  LET v = VEC 100
  LET datafile = "junk.wav"
  detv := v

  writef("Reading file %s*n", datafile)

  wavstr := findinput(datafile)
  UNLESS wavstr DO
  { writef("Trouble with file %s*n", datafile)
    RESULTIS 0
  }

  FOR i = 0 TO 100 DO detv!i := 0
  detv!1 := createco(notedetector, 500)
  callco(detv!1, 440_000) // A above middle C

  selectinput(wavstr)
  readwords(buf, 40) // Skip over the start of the file

  count := 0

  { LET n = readwords(buf, 100)
    UNLESS n BREAK
    FOR i = 0 TO n-1 DO
    { //IF i MOD 5 = 0 DO newline()
      //writef(" %x8", buf!i)
      //IF i MOD 3 = 0 DO
         // Sign extend the sample
         sample((buf!i<<16) / #x10000)
    }
    //newline()
    //abort(1000)
  } REPEAT
  endstream(wavstr)
  RESULTIS 0
}

AND sample(x) BE
{ LET a = (40000+x)/1000
  LET samplesPerBar = 44100*60 /(160*4)
  IF count MOD samplesPerBar = 0 DO
    writef("*nBar %n*n", count/samplesPerBar+1)
  count := count+1
  writef(" %i6", x)
  FOR i = 1 TO a DO wrch(' ')
  writes("#*n")
  IF count MOD 50 = 0 DO abort(1000)
  //a := callco(detv!1, x)
}

AND notedetector() BE
{ // This runs as a coroutine it is successively
  // given samples and returns the amplitude of
  // the note it is looking for. The frequency x 1000
  // of its note is given as the first value.
  LET f1000 = cowait() // Get its frequency
  LET cycles = 10  // Test amplitude for 10 cycles
  LET samplesPerCycle = 44100*1000/f1000
  LET amp = 0 // Latest amplitude
  writef("freq=%7.3  samplesPerCycle=%n*n",
         f1000, samplesPerCycle)

  { LET x = cowait()
    amp := x
  } REPEAT
}
