/*
This is a program to create a demo .bmp file
using 8-bit pixels asn 256 colours.

Implemented by Martin Richards (c) January 2009

Usage

mkbmp "xsize/n,ysize/n,xres/n,yres/n,to/k"

xsize     Bitmap width in pixels,           default: 128
ysize     Bitmap height in pixels,          default: 256
xres      X resolution in pixels per meter, default:  500
yres      Y resolution in pixels per meter, default: 1000
to        The desination file name,         default: demo.bmp
*/

SECTION "mkbmp"

GET "libhdr"

GLOBAL {
  xsize: ug
  ysize
  xres
  yres
  filename
  stdout
  tostream
  hdrsize
  infohdrsize
  paletsize
  pixeldatasize
  dataoffset
  colourtab
}

LET start() = VALOF
{
  LET argv = VEC 50
  LET ctab = VEC 256
  colourtab := ctab

  stdout := output()
  tostream := 0

  UNLESS rdargs("XSIZE/N,YSIZE/N,XRES/N,YRES/N,TO/K", argv, 50) DO
  { writef("")
    RESULTIS 0
  }

  xsize := 0
  ysize := 0
  xres := 1000   // Pixel/meter
  yres := 1000   // Pixel/meter
  filename := "demo.bmp"

  IF argv!0 DO xsize := !(argv!0)  // XSIZE/N
  IF argv!1 DO ysize := !(argv!1)  // YSIZE/N
  IF argv!2 DO xres  := !(argv!2)  // XRES/N
  IF argv!3 DO yres  := !(argv!3)  // YRES/N
  IF argv!4 DO filename := argv!4  // TO/K

  IF xsize<=0 DO xsize := 128
  IF ysize<=0 DO ysize := 256

  writef("*nWriting BMP file with xsize=%n ysize=%n to %s*n",
          xsize, ysize, filename)
  writef("X resolution = %n pixels per meter*n", xres)
  writef("Y resolution = %n pixels per meter*n", yres)

  tostream := findoutput(filename)
  UNLESS tostream DO
  { writef("Unable to create file %s*n", filename)
    RESULTIS 0
  }

  initcolourtab()

  selectoutput(tostream)

  hdrsize  := 14                          // File header
  infohdrsize := 40                       // Info header with colour table
  paletsize := 4*256                      // Info header with colour table
  pixeldatasize := ysize * ((xsize+3)&-4) // Pixel data size
  dataoffset := hdrsize + infohdrsize + paletsize

  wrbmphdr(hdrsize + infohdrsize + pixeldatasize)
  wrbmpinfohdr()
  wrbitmap()

  IF tostream DO endstream(tostream)
  selectoutput(stdout)
  RESULTIS 0
}

AND wrbmphdr(filesize) BE
{ wr1('B'); wr1('M') // "BM"
  wr4(filesize)      // File size in bytes
  wr4(0)             // Unused
  wr4(dataoffset)    // File offset of pixel data
}

AND wrbmpinfohdr() BE
{ wr4(40)             // Size of info header = 40
  wr4(xsize)          // Bitmap width
  wr4(ysize)          // Bitmap height
  wr2(1)              // Number of planes = 1
  wr2(8)              // 8 bits per pixel
  wr4(0)              // No compression
  wr4(pixeldatasize)  // Size of image
  wr4(xres)           // Horizontal resolution in pixels per meter
  wr4(yres)           // Vertical   resolution in pixels per meter
  wr4(256)            // Number of colours actually used
  wr4(0)              // All colours are important
  FOR i = 0 TO 255 DO // The colour table
    wr4(colourtab!i)
}

AND wrbitmap() BE
{ LET rowlen = (xsize+3) & -4
  FOR y = 0 TO ysize-1 DO
  { LET col = y
    FOR x = 0 TO xsize-1 DO wr1((col + x) & 255)
    FOR x = xsize TO rowlen-1 DO wr1(0) // Padding up to 32-bit boundary
  }
  //FOR i = 1 TO 4 DO wr1(7)
}

AND initcolourtab() BE
{ LET colours = TABLE
        10,
        255<<16 | 255<<8 | 255,  // White
        125<<16 | 125<<8 | 125,  // Grey
        255<<16 |   0<<8 | 255,  // Violet
          0<<16 |   0<<8 | 255,  // Blue
          0<<16 | 255<<8 |   0,  // Green
        255<<16 | 255<<8 |   0,  // Yellow
        255<<16 | 148<<8 |   0,  // Orange
        255<<16 |   0<<8 |   0,  // Red
         60<<16 |   0<<8 |   0,  // Brown
          0<<16 |   0<<8 |   0   // Black

  FOR i = 1 TO colours!0-1 DO
  { LET n = colours!0
    LET p = (256*(i-1))/(n-1)
    LET q = (256*i)/(n-1)
    LET c1, c2 = colours!i, colours!(i+1)
    LET r1, g1, b1 = c1>>16&255, c1>>8&255, c1&255
    LET r2, g2, b2 = c2>>16&255, c2>>8&255, c2&255
//sawritef("i=%i2 p=%i3  q=%i3  c1=%x6 c2=%x6*b*n", i, p, q, c1, c2)
    FOR t = p TO q DO
    { LET r = (r1*(q-t)+r2*(t-p))/(q-p)
      LET g = (g1*(q-t)+g2*(t-p))/(q-p)
      LET b = (b1*(q-t)+b2*(t-p))/(q-p)
      colourtab!t := r<<16 | g<<8 | b
      //sawritef("%i3: %x6*n", t, colourtab!t)
    }
    //sawritef("*n")
    //abort(1000)
  }
//sawritef("*nColout table*n")
  //FOR i = 0 TO 256 DO
  //{ IF i MOD 8 = 0 DO sawrch('*n')
  //  sawritef(" %x6", colourtab!i)
  //}
  //sawrch('*n')    
}

AND wr1(b) BE
{ binwrch(b)
}

AND wr2(h) BE
{ binwrch( h      & 255)
  binwrch((h>> 8) & 255)
}

AND wr4(h) BE
{ binwrch( h      & 255)
  binwrch((h>> 8) & 255)
  binwrch((h>>16) & 255)
  binwrch((h>>24) & 255)
}
