GET "libhdr"

GLOBAL {
  stdin:ug // Standard input
  stdout   // Standard output
  toname   // name of output file
  tostream // Output stream for .wav recording
  micname  // Microphone device descriptor
  mic_fd   // Microphone file descriptor
  format   // 16 = S16_LE
  channels // 1=mono 2=stereo
  rate     // Sample rate
  buf      // Buffer for input samples 
  secs     // Recording time in seconds
  sample_count
}

MANIFEST {
  bufsize = 4096/4
  bufbytes = bufsize * bytesperword
}

LET wr2(a) BE
{ binwrch(a&255)
  binwrch(a>>8)
}

AND wr4(a) BE
{ wr2(a)
  wr2(a>>16)
}

LET start() = VALOF
{ LET argv = VEC 50

  stdin := input()
  stdout := output()

  toname := "junk.wav"
  tostream := 0
  micname := "/dev/dsp1"  // Samson C01U USB Condenser microphone
  mic_fd := -1

  format := 16  // S16_LE
  channels := 1 // Mono
  rate := 44100 // Samples per second
  buf := getvec(bufsize-1)
  secs := 20
  sample_count := 0

  UNLESS rdargs("secs/n,from,to/k,rate/n,mono/s,stereo/s", argv, 50) DO
  { writef("Bad args for recmic*n")
    GOTO fin
  }

  IF argv!0 DO secs := !(argv!0)   // secs
  IF argv!1 DO micname := argv!1   // from
  IF argv!2 DO toname := argv!2    // to
  IF argv!3 DO rate := !(argv!3)   // rate
  IF argv!4 DO channels := 1       // mono
  IF argv!5 DO channels := 2       // stereo

  writef("Recording for %n secs from device %s to file %s rate %n in %s*n",
          secs, micname, toname, rate, channels=2 -> "stereo", "mono")

  writef("sys(Sys_sound, 0,...) => %n*n", sys(Sys_sound, 0, 11, 22, 33, 44))

  UNLESS sys(Sys_sound, 0, 11, 22, 33, 44) DO
  { writef("Sound not available*n")
    RESULTIS 0
  }

  writef("Trying to open device %s*n", micname)

  mic_fd := sys(Sys_sound, 1, micname, format, channels, rate)

  IF mic_fd=-1 DO
  { writef("Trouble with microphone device %s*n", micname)
    GOTO fin
  }
  writef("mic_fd = %n*n", mic_fd)


  IF toname DO
  { tostream := findoutput(toname)
    UNLESS tostream DO
    { writef("Trouble with file: %s*n", toname)
      GOTO fin
    }
  }

  IF tostream DO
  { selectoutput(tostream)
    writes("RIFF")        //  0: R I F F
    wr4(36+0)             //  4: size of this file - 8
    writes("WAVE")        //  8: W A V E
    writes("fmt ")        // 12: f m t
    wr4(format)           // 16: fmt subchunk size is 16
    wr2(1)                // 20: 1 = linear quantisation
    wr2(channels)         // 22: 1 = mono, 2=stereo
    wr4(rate)             // 24: samples per second
    wr4(rate*channels*16)        // 28: bytes per second
    wr2(2*channels)       // 32: bits/8 * mode  = 1, 2 or 4
    wr2(16  )             // 34: bits per sample  = 8 or 16
    writes("data")        // 36: d a t a
    wr4(-1)               // 40: number of bytes of data or -1
  }

  FOR i = 1 TO secs DO
  { // Record one second's worth of data
    LET count = rate*2 // Bytes per sec, assume 16-bit mono samples
    WHILE count>0 DO
    { LET bytes = count>bufbytes -> bufbytes, count
      LET len = sys(Sys_sound, 2, mic_fd, buf, bytes, 0)
      //sawritef("len=%n*n", len)
      //abort(1000)
      //FOR i = 0 TO bufsize-1 IF sample_count>0 DO
      //{ LET w = buf!i
      //  LET a = (w << 16) / #x1_0000
      //  LET b = w / #x1_0000
      //  IF i MOD 8 = 0 DO newline()
      //  writef(" %i6 %i6", a, b)
      //  sample_count := sample_count-1
      //}
      //newline()
      IF len>0 DO writewords(buf, len/4-1)
      count := count - len
    }
    sawritef("Recorded %i2 seconds out of %i2*n", i, secs)
  }

fin:
  IF mic_fd>0 DO
  { writef("Closing mic_fd*n")

    mic_fd := sys(Sys_sound, 3, mic_fd, 0, 0, 0)

    writef("return code = %n*n", mic_fd)
  }
  IF tostream DO endstream(tostream)
  RESULTIS 0
}
