/*
This program is designed to generate .wav data files
for recogs to analyse.

Initially it will just generate a sum of square waves of
varying frequencies.

Written by Martin Richards (c) September 2007
*/


GET "libhdr"

GLOBAL {
  stdin:ug   // Standard input
  stdout     // Standard output
  toname     // name of output file
  tostream   // Output stream for .wav recording
  fromname   // Microphone device descriptor
  fromstream // Microphone file descriptor
  format     // 16 = S16_LE
  channels   // 1=mono 2=stereo
  rate       // Sample rate
  secs       // Number of seconds to generate
  sample_count
}

MANIFEST {
  bufsize = 1024
  bufbytes = bufsize * bytesperword
}

LET wr2(a) BE
{ binwrch(a&255)
  binwrch(a>>8)
}

AND wr4(a) BE
{ wr2(a)
  wr2(a>>16)
}

LET start() = VALOF
{ LET argv = VEC 50

  stdin := input()
  stdout := output()

  toname := "junk.wav"
  fromstream := 0
  fromname := 0
  format := 16  // S16_LE
  channels := 1 // Mono
  rate := 44100 // Samples per second
  buf := getvec(bufsize-1)
  secs := 10
  sample_count := rate*channels*secs

  UNLESS rdargs("secs/n,from,to/k,rate/n,mono/s,stereo/s", argv, 50) DO
  { writef("Bad args for recmic*n")
    GOTO fin
  }

  IF argv!0 DO secs := !(argv!0)   // secs
  IF argv!1 DO fromname := argv!1  // from
  IF argv!2 DO toname := argv!2    // to
  IF argv!3 DO rate := !(argv!3)   // rate
  IF argv!4 DO channels := 1       // mono
  IF argv!5 DO channels := 2       // stereo

  sample_count := rate*channels*secs

  writef("Generating %n secs of data to file %s rate %n in %s*n",
          secs, fromname, toname, rate, channels=2 -> "stereo", "mono")

  IF toname DO
  { tostream := findoutput(toname)
    UNLESS tostream DO
    { writef("Trouble with file: %s*n", toname)
      GOTO fin
    }
  }

  IF tostream DO
  { selectoutput(tostream)
    writes("RIFF")        //  0: R I F F
    wr4(36+0)             //  4: size of this file - 8
    writes("WAVE")        //  8: W A V E
    writes("fmt ")        // 12: f m t
    wr4(format)           // 16: fmt subchunk size is 16
    wr2(1)                // 20: 1 = linear quantisation
    wr2(channels)         // 22: 1 = mono, 2=stereo
    wr4(rate)             // 24: samples per second
    wr4(rate*channels*16)        // 28: bytes per second
    wr2(2*channels)       // 32: bits/8 * mode  = 1, 2 or 4
    wr2(16  )             // 34: bits per sample  = 8 or 16
    writes("data")        // 36: d a t a
    //wr4(byte_rate * 1)    // 40: number of bytes of data or zero
    wr4(-1)               // 40: number of bytes of data or -1
  }


fin:
  IF tostream DO endstream(tostream)
  RESULTIS 0
}
