// Test program generating .au format data
// default: 16-bit, mono, rate 44100, to /dev/audio

GET "libhdr"

LET start() = VALOF
{ LET argv = VEC 50
  LET tofile = "/dev/audio"
  LET tostr = 0
  LET bits = 16
  LET rate = 44100
  LET msecs = 5000
  LET channels = 1

  UNLESS rdargs("bits/n,rate/n,msecs/n,to/k,mono/s,stereo/s", argv, 50) DO
  { writef("Bad arguments for genau*n")
    RESULTIS 0
  }

  IF argv!0 DO bits := !(argv!0)
  IF argv!1 DO rate := !(argv!1)
  IF argv!2 DO msecs := !(argv!2)
  IF argv!3 DO tofile := argv!3
  IF argv!4 DO channels := 1
  IF argv!5 DO channels := 2

  writef("Generating %n msecs of au data to %s, *
         *%n-bits, channels=%n, rate=%n*n",
          msecs, tofile, bits, channels, rate)

  tostr := findoutput(tofile)
  UNLESS tostr DO
  { writef("trouble with file %s*n", tofile)
    RESULTIS 0
  }
  selectoutput(tostr)

  genheader(bits, rate, msecs, channels)
  genau(bits, rate, msecs, channels)

  IF tofile DO endwrite()
  RESULTIS 0
}

AND genheader(bits, rate, msecs, channels) BE
{ wr32(#x2e736e64)   // .snd
  wr32(24)           // Offset of first data byte
  wr32(-1)           // Data size, -1 if unknown
  wr32(bits=8->2, 3) // Encoding
  wr32(rate)         // Sample rate
}

AND genau(bits, rate, msecs, channels) BE
{
}

AND wr32(w) BE
{ binwrch((@w)%0)
  binwrch((@w)%1)
  binwrch((@w)%2)
  binwrch((@w)%3)
}

AND wr16(w) BE
{ binwrch((@w)%0)
  binwrch((@w)%1)
}

AND wr8(w) BE
{ binwrch(w)
}

