SECTION "genwav"

GET "libhdr"
GET "sndlib.h"

MANIFEST { 
  steps_per_sec = 100_000
}



GLOBAL
{
  sysout:ug
  delayline
  delaylineupb
  sqgenco
  sqgenfn
  pipeco
  pipefn
  sineco
  sinefn
  crochetsteps
  notesteps
  notepitch
}

LET start() = VALOF
{ LET lib, rc = 0, 0
  LET argv = VEC 50

  rate := 44100
  mode := mono
  bits := 16

  delaylineupb := #x3FFF  // ie 16383 or about 1/3 sec

  sysout := output()
  wavout := 0
  delayline := 0
  sqgenco := 0
  pipeco := 0
  sineco := 0

  IF rdargs("TO/K", argv, 50)=0 DO
  { writes("Bad arguments for GENWAV*n")
    rc := 20
    GOTO fin
  }

  UNLESS argv!0 DO argv!0 := "junk.wav"

  lib := globin(loadseg("sndlib"))
  UNLESS lib DO
  { writef("Unable to load sndlib*n")
    RESULTIS 20
  }

  UNLESS initsnd(argv!0) DO
  { writef("Unable to open sound file %s*n", argv!0)
    rc := 20
    GOTO fin
  }

  delayline := getvec(delaylineupb)
  UNLESS delayline DO
  { writef("Unable to allocate delayline, upb=%n*n", delaylineupb)
    rc := 20
    GOTO fin
  }

  // Create a square wave generator
  sqgenco := createco(sqgenfn, 1000)

  // Create the pipe wave generator
  pipeco := createco(pipefn, 1000)

  // Create the pipe wave generator
  sineco := createco(sinefn, 1000)

  //count := calibrate()
  genwav()

fin:
  endsnd()
  unloadseg(lib)

  IF delayline DO freevec(delayline)
  IF sqgenco   DO deleteco(sqgenco)

  selectoutput(sysout)
  //writef("*n*nFrequency = %6.1d*n*n", count)
  writef("File %s written*n", argv!0)

  RESULTIS rc 
}

AND calibrate() = VALOF
{ // Generate a sine wave for ten seconds counting the number of times
  // it changes from positive to negative, and print in form dddd.d
  LET count = 0
  LET prev = 0
  FOR i = 1 TO 10 DO          // 10 seconds
  { FOR j = 1 TO steps_per_sec DO   // 100000 steps per second
    { LET sample = callco(sineco)
      IF prev>=0 & sample<0 DO count := count+1
      prev := sample
    }
  }
  RESULTIS count
}

AND genwav() BE
{ // Play a tune
  LET tune = TABLE
       crochet, c4, d4, e4, f4, g4, g4, 0,
       quaver, a4, b4, c5, a4,
       minim, g4, crochet, f4, f4, e4, e4, d4, d4, minim, c4,
       crochet, g4, quaver, g4, g4, crochet, a4, a4, g4, g4, minim, f4,
       0

  LET i = 0
  crochetsteps := steps_per_sec*60/240
  notesteps := crochetsteps

  { LET op = tune!i
//sawritef("op=%n*n", op)
    i := i+1
    SWITCHON op INTO
    { DEFAULT:
        // Play note
sawritef("play note with pitch %i2 steps %n*n", op, notesteps)
        notepitch := op
        playnote(notesteps)
//abort(1111)
        LOOP

      CASE 0:
sawritef("End of tune*n")
        BREAK

      CASE breve:          notesteps := crochetsteps * 4; LOOP
      CASE minim:          notesteps := crochetsteps * 2; LOOP
      CASE crochet:        notesteps := crochetsteps;     LOOP
      CASE quaver:         notesteps := crochetsteps / 2; LOOP
      CASE semiquaver:     notesteps := crochetsteps / 4; LOOP
      CASE demisemiquaver: notesteps := crochetsteps / 8; LOOP
    }
  } REPEAT
}


AND playnote(steps) BE
{ LET a = 0

  FOR j = 1 TO steps DO
  { LET rawsample = callco(sineco)
    STATIC { sampno=0 }
    //sawritef("getting raw sample %7i: %12.9d*n", j, rawsample)
    a := a - rate
    IF a < 0 DO
    { // Write out the sample after applying a simple
      // volume envelope.
      LET vol = 1000
      IF j < steps/4 DO
        vol := 1000 * 4*j/steps
      IF j > steps/2 DO
        vol := 1000 * (steps - j) * 2 / steps

      a := a + steps_per_sec
      sampno := sampno+1
      //sawritef("writing sample %7i:  %8.6d*n", sampno, rawsample/1000)
      wrsample(rawsample/700 * vol / 1000, 0)
//abort(1000)
    }
  }
}

AND sqgenfn(x) = VALOF
{ LET amplitude = 1000
  LET pitch = 440_000  // Milli-cycles per sec
  

  { FOR f = 200 TO 100 BY -1 FOR rep = 1 TO 5 DO
    { FOR i = 1 TO f DO cowait( amplitude)
      FOR i = 1 TO f DO cowait(-amplitude)
    }
  } REPEAT
}

AND pipefn() = VALOF
{ LET p = delaylineupb // Position of next sample
  LET x = 10000
  FOR i = 0 TO delaylineupb DO delayline!i := 0
  
  { LET p1 = (p+(delaylineupb-450)) REM delaylineupb
    x := x + callco(sineco)/100 + 4
    x := x + muldiv(delayline!p1, 500, 1000)
    IF x<-30000 DO x := -30000
    IF x> 30000 DO x :=  30000
    delayline!p := x
    p := (p+1) & delaylineupb
    cowait(x)
  } REPEAT
}

AND sinefn(x) = VALOF
// Generate sine wave samples of amplitude 1_000_000_000
// at  a rate of samples_per_sec (=100_000) samples per second
// with a frequence corressponding to the given note number.
{ LET x = 1_000_000_000
  LET xdot = 0
  LET xdotdot = 0
  // The following table gives the value of w in the simple
  // harmonic motion equation: x'' + w*w*x = 0 for each note
  // in the range a0 to c7.
  LET tab = TABLE 
  //  a         bes       b         c         des       d
  //  ees       e         f         ges       g         aes 
    54_654,   57_906,   61_344,   64_985,   68_855,   72_946, //  0   27.50
    77_279,   81_866,   86_736,   91_903,   97_366,  103_146, //  6   38.89

   109_285,  115_785,  122_679,  129_970,  137_699,  145_884, // 12   55.00
   154_545,  163_744,  173_482,  183_794,  194_721,  206_304, // 18   77.78

   218_564,  231_558,  245_327,  259_910,  275_369,  291_740, // 24  110.00
   309_086,  327_465,  346_936,  367_579,  389_436,  412_583, // 30  155.56

   437_121,  463_108,  490_646,  519_833,  550_728,  583_471, // 36  220.00
   618_182,  654_937,  693_879,  735_124,  778_854,  825_145, // 42  311.13

   874_217,  926_189,  981_260, 1039_610, 1101_433, 1166_911, // 48  440.00
  1236_282, 1309_803, 1387_672, 1470_167, 1557_567, 1650_167, // 54  622.25

  1748_266, 1850_213, 1966_275, 2078_936, 2202_510, 2333_424, // 60  880.00
  2472_110, 2619_022, 2774_655, 2939_540, 3114_188, 3299_210, // 66 1244.51

  3495_194, 3702_808, 3922_697, 4155_623, 4402_348, 4663_669, // 72 1760.00
  4940_440, 5233_551, 5543_986, 5872_725, 6220_820, 6589_435, // 78 2489.02

  6979_705, 7392_892, 7830_308, 8293_305, 8783_340, 9301_945, // 84 3520.00
  9850_667,10431_203,11045_270,11499_362,12381_329,13107_145  // 90 4978.03

  LET w = tab!a4

// Code to calibrate the table

  sawrch('*n')

  IF FALSE DO // Comment out this line to calibrate
  FOR i = 0 TO 95 DO
  { LET cycles = 0
    LET w = tab!i
    // The note frequency table
    LET ftab = TABLE
        27_50,   29_14,   30_87,   32_70,   34_65,   36_71,
        38_89,   41_20,   43_65,   46_25,   49_00,   51_91,

        55_00,   58_27,   61_74,   65_41,   69_30,   73_42,
        77_78,   82_41,   87_31,   92_50,   98_00,  103_83,

       110_00,  116_54,  123_47,  130_81,  138_59,  146_83,
       155_56,  164_81,  174_61,  185_00,  196_00,  207_65,

       220_00,  233_08,  246_94,  261_63,  277_18,  293_66,
       311_13,  329_63,  349_23,  369_99,  392_00,  415_30,

       440_00,  466_16,  493_88,  523_25,  554_37,  587_33,
       622_25,  659_26,  698_46,  739_99,  783_99,  830_61,

       880_00,  932_33,  987_77, 1046_50, 1108_73, 1174_66,
      1244_51, 1318_51, 1396_91, 1479_98, 1567_98, 1661_22,

      1760_00, 1864_66, 1975_53, 2093_00, 2217_46, 2349_32,
      2489_02, 2637_02, 2793_83, 2959_96, 3135_96, 3322_44,

      3520_00, 3729_31, 3951_07, 4186_01, 4434_92, 4698_64,
      4978_03, 5274_04, 5587_65, 5919_91, 6271_93, 6644_88

    //FOR j = -10 TO +10 DO
    FOR j = 0 TO 0 DO
    { LET w1 = w+j
      LET w2 = muldiv(w1, w1, 1_000_000)
      cycles := 0
      x := 1_000_000_000
      xdot := 0
      xdotdot := 0

      // Generate samples for 100 seconds
      FOR i = 1 TO steps_per_sec*100 DO
      { xdotdot := -muldiv(x, w2, 1_000_000_000)
        IF xdot>0 & xdot+xdotdot<=0 DO cycles := cycles+1
        xdot := xdot + xdotdot
        x := x + xdot
      }

      IF j=0 DO sawrch('*n')

      sawritef("%i2: w=%i9 w2=%i9 %7.2d / %7.2d*n",
                i, w1, w2, cycles, ftab!i)

      IF j=0 DO sawrch('*n')
    }
    sawrch('*n')
  }

  x := 1_000_000_000
  xdot := 0
  xdotdot := 0

  WHILE TRUE DO
    //sawritef("*nNote %i2 w=%i7*n", i, tab!i)
    //abort(1000)
    FOR j = 1 TO notesteps DO
    { LET neww = notepitch<0 -> 0, tab!notepitch
      LET w2 = ?
      // Only change w when sign of xdot changes
      UNLESS w=neww UNLESS (xdot>0)=(xdot+xdotdot>0) DO
      { LET dw = neww - w
        //UNLESS -10 <= dw <= 10 DO dw := dw/10
        w := w + dw
        w2 := muldiv(w, w, 1_000_000)

        //sawritef("Changing w to %11i*n", w)
        //abort(2222)
        IF -999_000_000 <= x <= 999_000_000 DO
        { // Amplitude not great enough so give the wave
          // a nudge proportional to xdotdot.
          xdot := xdot + xdotdot*3
          //sawritef("Amplitude nudge, xdot=%12.9d*n", xdot)
          //abort(3333)
        }
      }
      xdotdot := -muldiv(x, w2, 1_000_000_000)
      //sawritef("x=%12.9d  w2=%12.9d  xdotdot=%12.9d*n", x, w2, xdotdot)
      xdot := xdot + xdotdot
      // Ensure x remains between -1_000_000_000 and 1_000_000_000 by
      // reducing xdot if the limit is being approached too rapidly.
      { LET p = x + 2*xdot
        UNLESS -1_000_000_000 <= p <= 1_000_000_000 DO
        { TEST p > 0
          THEN xdot := (1_000_000_000 - x)/2 
          ELSE xdot := (-x - 1_000_000_000)/2 
          //sawritef("p=%12.9d, reducing xdot to %12.9d, x=%12.9d*n", p, xdot, x)
          //abort(4444)
        }
      }
      x := x + xdot
      //sawritef("x=%12.9d  xdot=%12.9d  xdotdot=%12.9d*n", x, xdot, xdotdot)
//abort(1000)
      cowait(x)
    }
  }
}

